<?php
class SalespricinggroupController extends Controller

{

        public function accessRules() {

            return array(

                array('allow', // allow all users to perform 'index' and 'view' actions

                  'actions' => array('login', 'error', 'logout'),

                  'users' => array('*'),

                  ),

                array('allow', // allow authenticated user to perform 'create' and 'update' actions

                  'actions' => array('Index','GetSalesPriceList','uploadstock','UploadInventoryExcel','SaveSalesPricingGroup','Upload','Disable',
                      'ChangeSalespriceGroupName','DownloadSalesPriceList',
                      'UploadStockBrandClass', 'DownloadSalesPriceBrandClassList','SaveSalesPricingGroupBrandClass',
                      'DeletePricingGroup','DefaultpricingGroup','DownloadCashCreditPriceList','UploadPriceList','SavePricingGroup','GetPriceGroupNameList','EditPriceList','EditPrice','SavePriceDetails','DownloadPriceList'),

                  'expression' => '$user->isMember()',

                  ),

                array('deny', // deny all users

                  'users' => array('*'),

                  ),

                );

        }

	public function actionIndex()
	{
		$this->render('index');

	}
	
	public function actionGetSalesPriceList()
{
    $model = new PricingGroup();
    $draw     = $_POST['draw'];
    $offset = $_POST['start'];
    $limit  = $_POST['length'];

    $columns = array(
        0 => 'pricing_group',
        1 => 'description',
        2 => 'price_list_file_name',
    );

    $filterColumn = $columns[$_POST['order'][0]['column']];
    $filterOrder  = $_POST['order'][0]['dir'];
    $orderBy   = $filterColumn." ".$filterOrder;

    $condition = "1=1";
    if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
    {
        $searchString = $_POST['search']['value'];
        $condition .= " AND (pricing_group LIKE '%".$searchString."%' 
                        OR description LIKE '%".$searchString."%' 
                        OR price_list_file_name LIKE '%".$searchString."%')";
    }

    $count = $model->count(array('condition'=>$condition));
    $model = $model->findAll(array(
        'condition'=>$condition,
        'limit'=>$limit,
        'offset'=>$offset,
        'order'=>$orderBy
    ));

    $recordsTotal = $count;
    $recordsFiltered = $count;

    $data['draw'] = $draw;
    $data['recordsTotal'] = $recordsTotal;
    $data['recordsFiltered'] = $recordsFiltered;

    $rowData = array();
    $m = 1;
    foreach ($model as $row) {
        $rowData[] = array(
            $m,
            $row['pricing_group'],
            $row['description'],
            $row['price_list_file_name'],
            $row['default_pricing_group'],
            array('id' => $row['id'], 'code'=>$row['pricing_group'], 'status' => $row->isActive)
        );
        $m++;
    }

    $data['data'] = $rowData;
    echo json_encode($data);
}

    
    public function actionUploadStock() {
            $this->render('upload_stock');
    }
    
        
    
    public function readCSV($csvFile) {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            if ($contents[1] == "")
                $contents = explode(';', $contents[0]);
            $line_of_text[] = $contents;
            //print_r($line_of_text);
            //die();
        }
        fclose($file_handle);
        return $line_of_text;
    }
    
    
   
    public function actionUploadStockBrandClass() {
    	$model = new PricingGroup();
    	$id = (int) Yii::app()->request->getParam('id');
    	if($id>0){
    		$model=$model->findByPk($id);
    	}
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);
        $this->render('upload_stock_brand_class',array('model'=>$model));
    }
    
    public function actionDownloadSalesPriceBrandClassList() {
    	//$filename = Yii::app()->getBaseUrl(true) . 'pricelistfiles/SALES_PRICE_LIST.csv';
    	$data = array();
    
    	$data[0][0] = 'Product';
    	$data[0][1] = 'Sales Price';
    	
    	$export_file_name="SALES_PRICE_BRANDCLASS.csv";
    	$this->array_to_csv_download($data, // this array is going to be the second row
    			$export_file_name
    	);
    
    }
    
    
    public function actionSaveSalesPricingGroupBrandClass()
    {
    	$modelPricingGroup    = new PricingGroup();
    	$model          = new PriceGroupProductRelation();
    	
    	
    	if((int) $_POST['PricingGroup']['id'] > 0){
    		$sales_price_group_id = $_POST['PricingGroup']['id'];
    		$modelPricingGroup = $modelPricingGroup->findByPk((int) $_POST['PricingGroup']['id']);
    		$modelPricingGroup->updated_by = Yii::app()->user->id;
    		$modelPricingGroup->updated_datetime = date("Y-m-d h:i:s");
    		
    		$sales_pricing_group_details = $model->find(array('condition'=>'price_group_id='.$sales_price_group_id));
    		
    		if(!empty($sales_pricing_group_details)){
    			$model->deleteAll(array('condition' => 'price_group_id=' . $sales_price_group_id));
    		}
    	}
    	else{
    	    $modelPricingGroup->created_by = Yii::app()->user->id;
    		$modelPricingGroup->created_datetime = date("Y-m-d h:i:s");
    		
    	}
    	
    	$price_list_file_name = $_POST['PricingGroup']['price_list_file_name'];
    	
    	$modelPricingGroup->attributes                  = $_POST['PricingGroup'];
    	$modelPricingGroup->pricing_group               = $_POST['PricingGroup']['pricing_group'];
    	$modelPricingGroup->description                 = $_POST['PricingGroup']['description'];
    	$modelPricingGroup->default_pricing_group       = $_POST['PricingGroup']['default_pricing_group'];
    	$modelPricingGroup->price_list_file_name        = $price_list_file_name;
        if ($_POST['PricingGroup']['default_pricing_group'] == "Y") {
    PricingGroup::model()->updateAll(
        array('default_pricing_group' => 'N'),
        'default_pricing_group = "Y"'
    );
}
$modelPricingGroup->default_pricing_group = $_POST['PricingGroup']['default_pricing_group'];
    	
    	
    	if($modelPricingGroup->validate()){
    	
	    	$modelPricingGroup->save();
	    	
	    	if($price_list_file_name!=""){
	    	
	    	$pricing_list = $this->readCSV("uploads/pricelist/" . $price_list_file_name);
	    	$jsonData = array();
	    	foreach (array_slice($pricing_list, 1) as $i => $eachItem) {
	    		 
	    		$part_number = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[0]), '"'));
	    		 
	    		$brand_class = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[1]), '"'));
	    
	    		if (strlen($part_number) > 0) {
	    
	    			$sales_rate 								= 0;
	    			
	    			if(isset($eachItem[2]) && $eachItem[2]!="" && $eachItem[2]!=0)
	    			{
	    				$sales_rate = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[2]), '"'));
	    			}
	    			
	    			$product_model = Store::model()->find('LTRIM(RTRIM(part_number))="' . $part_number . '"');
	    			
	    			// $brand_class_id = $product_model->brand_class_id;
	    			
	    			if(!empty($product_model) > 0)
	    			{
                                    $model = new PriceGroupProductRelation();

                                    $model->id = 0;
                                    $model->price_group_id 	= $modelPricingGroup->id;
                                    $model->store_id 		= $product_model->id;
                                    //$model->part_number 	= $part_number;
                                    // $model->pricing_product_class_id         = $brand_class_id;
                                    $model->rate                = $sales_rate;
                                    $model->created_by = Yii::app()->user->id;
                                    $model->created_datetime = date("Y-m-d h:i:s");  					
	    	
		    
                                    $model->save(false);
                                    $jsonData['msg'][]= "Item " . $eachItem[0] . " price found and added!";
		    
		    			}
		    			else
		    			{
		    					$jsonData['msg'][]= "Item " . $eachItem[0] . " not found!";
		    			}
		    				
		    		}
		    	}
	    	}
	    	$jsonData['errors']=[];
	    	if(count($jsonData['msg']) > 0 && $jsonData['msg'][0]!="")
	    	{
	    		$jsonData['errors'][]="Please add the following part number into inventory <br>".implode("<br>", $jsonData['msg']);
	    	}
	    	
	    	$jsonData['model'] = $modelPricingGroup;
	    	$jsonData['status'] = "success";
	    	
	    	echo CJSON::encode($jsonData);
    	}
    	else
        {
                        $error = CActiveForm::validate($modelPricingGroup, '', false);
                        if ($error != '[]')
		               echo $error;
        }
    	
    
    	
    }
    
    
    
    
    
    public function actionSaveSalesPricingGroupBrandClassOld() {
    	
        $model= new SalesPriceGroupBrandorclassMaster();
        if(isset($_POST['SalesPriceGroupBrandorclassMaster'])){
            $model->attributes = $_POST['SalesPriceGroupBrandorclassMaster'];
            $model->pricing_group_description = $_POST['SalesPriceGroupBrandorclassMaster']['pricing_group_description'];
            if($model->validate()){
            
        
                $file_name   = $_POST['SalesPriceGroupBrandorclassMaster']['document'];

                $from_file = $this->readCSV("upload/pricelist/".$file_name);
                $jsonData = array();
                foreach (array_slice($from_file, 1) as $i => $eachItem) {

                    $product_name   = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[0]), '"'));
                    $description    = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[1]), '"'));
                    $brand_name     = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[2]), '"'));
                    $unit_name      = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[3]), '"'));
                    $tax_name       = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[4]), '"'));
                    $rate           = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[5]), '"'));
                    $pricing_group  = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[6]), '"'));
                    $weight         = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[7]), '"'));
                    $volume         = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[8]), '"'));
                    $coo             = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[9]), '"'));
                    $re_order_level  = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[10]), '"'));
                    $re_order_lot    = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[11]), '"'));
                    $hsir_code       = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[12]), '"'));                
                    $bno             = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[13]), '"'));
                    $notes           = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[14]), '"'));                
                    $warehouse_name  = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[15]), '"'));
                    $rack            = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[16]), '"'));
                    $bin             = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[17]), '"'));
                    $qty             = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[18]), '"'));
                    $generic_name    = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[19]), '"'));

                    /**********   find Generic ******************************/

                    $model_generic  = new MasGeneric();
                    if (strlen($generic_name) > 0) {
                
                        $generic_count = $model_generic->count(array('condition' => 'generic_name="'.$generic_name.'"'));
                        if($generic_count>0){
                            $model_generic = $model_generic->find('generic_name="'.$generic_name.'"');
                            $generic_id    = $model_generic->id;
                        }
                        else{
                            $model_generic->generic_name  = $tax_name;
                            $model_generic->generic_description  = "";   
                            $model_generic->is_Active  = "Y";                    
                            $model_generic->created_by  = Yii::app()->user->id;;
                            $model_generic->updated_by  = "";
                            $model_generic->created_date_time  = date('Y-m-d h:i:s');
                            $model_generic->save(false);
                            $generic_id    = $model_generic->id;
                        }
                
                    }
              
                    /**********   end generic ******************************/

                    /**********   find Tax ******************************/
              
                    $model_tax  = new MasInvTax();
                    if (strlen($tax_name) > 0) {
                
                        $tax_count = $model_tax->count(array('condition' => 'tax_code="'.$tax_name.'"'));
                        if($tax_count>0){
                            $model_tax = $model_tax->find('tax_code="'.$tax_name.'"');
                            $tax_id    = $model_tax->id;
                        }
                        else{
                            $model_tax->tax_code  = $tax_name;
                            $model_tax->percentage  = "0";   
                            $model_tax->isActive  = "Y";                    
                            $model_tax->created_by  = Yii::app()->user->id;;
                            $model_tax->updated_by  = "";
                            $model_tax->created_datetime  = date('Y-m-d h:i:s');
                            $model_tax->save(false);
                            $tax_id    = $model_tax->id;
                        }

                    }
              
              /**********   end Tax ******************************/
              
              /**********   find Unit ******************************/
              
              $model_unit  = new Unit();
              if (strlen($unit_name) > 0) {
                
                $unit_count = $model_unit->count(array('condition' => 'unit_name="'.$unit_name.'"'));
                if($unit_count>0){
                    $model_unit = $model_unit->find('unit_name="'.$unit_name.'"');
                    $unit_id    = $model_unit->id;
                }
                else{
                    $model_unit->unit_name  = $brand_name;
                    $model_unit->symbol  = "";   
                    $model_unit->unit_type  = "1";  
                    $model_unit->isActive  = "Y";                    
                    $model_unit->created_by  = Yii::app()->user->id;;
                    $model_unit->updated_by  = "";
                    $model_unit->created_datetime  = date('Y-m-d h:i:s');
                    $model_unit->save(false);
                    $unit_id    = $model_unit->id;
                }
                
              }
              
              /**********   end Unit ******************************/
              
              /**********   find brand / class ******************************/
              
              $model_brand  = new BrandClass();
              if (strlen($brand_name) > 0) {
                
                $brand_count = $model_brand->count(array('condition' => 'brand_class_name="'.$brand_name.'"'));
                if($brand_count>0){
                    $model_brand = $model_brand->find('brand_class_name="'.$brand_name.'"');
                    $brand_id    = $model_brand->id;
                }
                else{
                    $model_brand->brand_class_name  = $brand_name;
                    $model_brand->description  = "";                    
                    $model_brand->created_by  = Yii::app()->user->id;
                    $model_brand->updated_by  = "";
                    $model_brand->created_date_time  = date('Y-m-d h:i:s');
                    $model_brand->save(false);
                    $brand_id    = $model_brand->id;
                }
                
              }
              
              /**********   end brandclass ******************************/
              
              
              /**********   find warehouse ******************************/
              
              
              
              /**********   end warehouse ******************************/
              
              //$description
            if (strlen($product_name) > 0 AND strlen($description) > 0) {
                
                
                
              
              $model_store   = new Store();
              $product_count = $model_store->count(array('condition' => 'part_number="'.$product_name.'"'));
              
              
              if($product_count>0){
                
                    $model_store = $model_store->find('part_number="'.$product_name.'"');
                   
                    $model_store = $model_store->findByPk($model_store->id);
                   // $old_qty = $model_store->total_quantity;
                    
              }
              
              $model_store->part_number     = $product_name;
              $model_store->generic_name    = $generic_id;
              $model_store->description     = $description;
              $model_store->brand_class_id  = $brand_id;
              $model_store->unit_id         = $unit_id;
              $model_store->tax_code        = $tax_id;
              $model_store->weight          = $weight;
              $model_store->volume          = $volume;
              
              $model_store->re_order_level  = $re_order_level;
              $model_store->re_order_lot    = $re_order_lot;              
              $model_store->hsir_code       = $hsir_code;
              $model_store->notes           = $notes;
              $model_store->inventory_item_type  = "1";
              $model_store->created_date_time    = date('Y-m-d h:i:s');
              $model_store->created_by           = Yii::app()->user->id;;              
              
              if($product_count<1){
                $model_store->total_quantity  = $qty;
              }
              
              //$new_store_qty                = $old_qty+$qty;              
              
                    
              $model_store->save(false);
                
                
                
              $product_id  = $model_store->id;
                     
                      
                      
                                                         
              if (strlen($warehouse_name) > 0) {
                
                
                $model_warehouse1         = MasInventoryWarehouse::model()->find("isBaseWareHouse='Y'");
                $default_ware_house_id     = $model_warehouse1->id;
              
                $warehouse_count = MasInventoryWarehouse::model()->count('warehouse_name="'.$warehouse_name.'"');
                
                if($warehouse_count>0){
                    $model_warehouse = MasInventoryWarehouse::model()->find('warehouse_name="'.$warehouse_name.'"');
                    $warehouse_id    = $model_warehouse->id;
                }
                else{
                    
                    $warehouse_id    = $default_ware_house_id;
                }                
              } 
              
                      
            /*******************   update in product location *************************/
            
           if($product_id > 0){
            
                $opening_bal_count = OpeningBalance::model()->count('product_id="'.$product_id.'"');
                if($opening_bal_count>0){
                }
                else{
                    $opening_balance_model = new OpeningBalance;
                    $opening_balance_model->product_id=$product_id;
                    $opening_balance_model->opening_quantity=$qty;
                    $opening_balance_model->save(false);
                }
            
                $product       = Store::model()->findbyPk($product_id);
                $old_total_qty = Yii::app()->db->createCommand('SELECT SUM(quantity) FROM  crm_product_location WHERE stock_id='.$product_id.' ')->queryScalar();
            
                    if($product_count == 0 AND $warehouse_id >0 ){
                        $newloc1 = new ProductLocation;
                        $newloc1->stock_id = $product_id;
                        $newloc1->warehouse_id = $default_ware_house_id;
                        $newloc1->rack = "";
                        $newloc1->bin = "";
                        $newloc1->quantity = 0;
                        $newloc1->save(false);
                   }
                   
                   if($warehouse_id<1){                
                        $warehouse_id  = $default_ware_house_id;
                   }
                    
                   $con = 'stock_id='. $product_id;                   
                   if($warehouse_id > 0)
                       $con .= ' AND warehouse_id='.$warehouse_id;
                   if($rack > 0)
                       $con .= ' AND rack='.$rack;
                   if($bin > 0)
                       $con .= ' AND bin='.$bin;
                       
                   $productlocation = ProductLocation::model()->find(array('condition' => $con));
                   if( $productlocation->id > 0){
                            $loc = ProductLocation::model()->findByPk($productlocation->id);
                            $old = $loc->quantity;
                            $loc->quantity = $old+$qty;
                            $loc->save(false);
                    }else{
                        $newloc = new ProductLocation;
                        $newloc->stock_id = $product_id;
                        $newloc->warehouse_id = $warehouse_id;
                        $newloc->rack = $rack;
                        $newloc->bin = $bin;
                        $newloc->quantity = $qty;
                        $newloc->save(false);
                    }  
                    
               }
               // die(); 
            }
               else
               {
                    $jsonData['errors'][] = "(Error on line no" . ($i + 1) . ") : is not found";
               }
             }
             $jsonData['model'] = $model;
             $jsonData['status'] = "success";
              echo CJSON::encode($jsonData);
        }else{
            $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
        
        }     
             
        }else{
            $jsonData['status'] = "fail";
             echo CJSON::encode($jsonData);
        }      
            
    }
    public function actionChangeSalespriceGroupName()
    {
    	$model = SalesPriceGroupName::model()->findAll();
    	 
    	$this->render('change_sales_price_group_name',array('model'=>$model));
    }
    
    public function actionDeletePricingGroup()
    {
    	$id = $_POST['id'];
        $model = PricingGroup::model()->findByPk($id);
        $model_relation          = new PriceGroupProductRelation();
        $mod_salesgrp=CustomerPricingGroup::model()->findAll(array('condition'=>'pricing_group_id='.$id));
        if (!empty($model)&&(empty($mod_salesgrp))) {
            $model_relation->deleteAll(array('condition' => 'price_group_id=' . $id));
            $model->isActive = "N";
            $model->save(false);
            echo "success";
        } else {
            echo "fail";
        }
    }
    
    public function actionDefaultpricingGroup()
    {
        $id = $_POST['id'];
        SalesPriceGroupName::model()->updateAll(array('default_pricing_group' =>"N"));
        SalesPriceGroupName::model()->updateByPk($id, array('default_pricing_group' =>"Y"));
        $jsonData['status'] = "success";
        echo CJSON::encode($jsonData);
    }   
    
    public function actionDownloadSalesPriceList() {
    	
    	$data = array();
    	
    	
    	
    	$model = new SalesPriceGroupName();
    	
    	$arr_sales_price_group = $model->findAll();
    	$data = array();
    	
    
    	$data[0][0] = 'Product';
    	$data[0][1] = "Sales Price";
    	
    
    	$export_file_name="SALES_PRICE_LIST.csv";
    	$this->array_to_csv_download($data, // this array is going to be the second row
    			$export_file_name
    	);
    
    }
    
     public function actionDownloadCashCreditPriceList() {
        $type_id = (int) Yii::app()->request->getParam('type_id'); 
    	$data = array();
    	$data[0][0] = 'Product';
    	if($type_id==1){
    	    $data[0][1] = "Cash Price";
    	    $export_file_name="CASH_PRICE_LIST.csv";
    	}
    	else{
    	    $data[0][1] = "Credit Price";
    	    $export_file_name="CREDIT_PRICE_LIST.csv";
    	}
    
    	
    	$this->array_to_csv_download($data, // this array is going to be the second row
    			$export_file_name
    	);
    
    }
     
    
        public function actionSaveSalesPricingGroup()
    {
    	 
    	$price_list_file_name = $_POST['SalesPriceGroup']['sales_price_group_file_name'];
    
    	$pricing_list = $this->readCSV("upload/pricelist/" . $price_list_file_name);
    	$jsonData = array();
    	$arr_part_number=array();
    	$arr_price_updated_part_number=array();
    	foreach (array_slice($pricing_list, 1) as $i => $eachItem) {
    		 
    		$part_number = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[0]), '"'));
    		if (strlen($part_number) > 0) {
    
    
    			$base_sales_price = 0;
    			if(isset($eachItem[1]) && $eachItem[1]!="" && $eachItem[1]!=0)
    			{
    				$base_sales_price = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[1]), '"'));
    			}
    
    
    			$price1 = 0;
    			if(isset($eachItem[2]) && $eachItem[2]!="" && $eachItem[2]!=0)
    			{
    				$price1 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[2]), '"'));
    			}
    
    			$price2 = 0;
    			if(isset($eachItem[3]) && $eachItem[3]!="" && $eachItem[3]!=0)
    			{
    				$price2 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[3]), '"'));
    			}
    
    			$price3 = 0;
    			if(isset($eachItem[4]) && $eachItem[4]!="" && $eachItem[4]!=0)
    			{
    				$price3 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[4]), '"'));
    			}
    
    			$price4 = 0;
    			if(isset($eachItem[5]) && $eachItem[5]!="" && $eachItem[5]!=0)
    			{
    				$price4 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[5]), '"'));
    			}
    
    			$price5 = 0;
    			if(isset($eachItem[6]) && $eachItem[6]!="" && $eachItem[6]!=0)
    			{
    				$price5 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[6]), '"'));
    			}
    
    			$price6 = 0;
    			if(isset($eachItem[7]) && $eachItem[7]!="" && $eachItem[7]!=0)
    			{
    				$price6 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[7]), '"'));
    			}
    
    			$price7 = 0;
    			if(isset($eachItem[8]) && $eachItem[8]!="" && $eachItem[8]!=0)
    			{
    				$price7 = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[8]), '"'));
    			}
   
    			
    			$product_model = Store::model()->find(array('condition'=>'LTRIM(RTRIM(part_number))="'.$part_number . '"'));

    		
    			$model= new SalesPriceGroup();  
    		
    			if(!empty($product_model->id)){
    				$arr_sales_price_group = SalesPriceGroup::model()->find(array('condition'=>'product_id='.$product_model->id));
    					
    				$model->id = 0;
    				if(count($arr_sales_price_group) > 0){
    					$model->id 		= 	$arr_sales_price_group->id;
    					$model			=	$model->findByPk($arr_sales_price_group->id);
    
    					$model->product_id 								= $product_model->id;
    					if($base_sales_price>0)
    					{
    						$model->base_sales_price 					= $base_sales_price;
    					}
    					if($price1 > 0)
    					{
    						$model->sales_price1 						= $price1;
    					}
    					if($price2 > 0)
    					{
    						$model->sales_price2 						= $price2;
    					}
    					if($price3 > 0)
    					{
    						$model->sales_price3 						= $price3;
    					}
    					if($price4 > 0)
    					{
    						$model->sales_price4 						= $price4;
    					}
    					if($price5 > 0)
    					{
    						$model->sales_price5 						= $price5;
    					}
    					if($price6 > 0)
    					{
    						$model->sales_price6 						= $price6;
    					}
    					if($price7 > 0)
    					{
    						$model->sales_price7 						= $price7;
    					}
    
    					$model->sales_price_group_file_name 		= $price_list_file_name;   	   						
    					$model->uploaded_by 						= Yii::app()->user->id;
    					$model->uploaded_date 						= date('Y-m-d h:i:s');    
    					$model->save();
    
    				}
    				else
    				{
    					$model->product_id 							= $product_model->id;
    					$model->base_sales_price 					= $base_sales_price;
    					$model->sales_price1 						= $price1;
    					$model->sales_price2 						= $price2;
    					$model->sales_price3 						= $price3;
    					$model->sales_price4 						= $price4;
    					$model->sales_price5 						= $price5;
    					$model->sales_price6 						= $price6;
    					$model->sales_price7 						= $price7;
    					$model->sales_price_group_file_name 		= $price_list_file_name;
    					$model->uploaded_by 						= Yii::app()->user->id;
    					$model->uploaded_date 						= date('Y-m-d h:i:s');
    						
    						
    				
    						
    					$model->save();
    				}
    				
    					$arr_price_updated_part_number[] = $part_number;
    			}
    			else
    			{
    			    $arr_part_number[] = $part_number;
    			}
 	
 	
    		}
    	}
    	$jsonData['errors']=array();
    	if(count($arr_part_number) > 0 && $arr_part_number!="")
    	{
    		$jsonData['errors']=ltrim("Please add the following part number into inventory <br>".implode(",", $arr_part_number),",");
    	}
    	
    	$jsonData['msg']=array();
    	if(count($arr_price_updated_part_number) > 0 && $arr_price_updated_part_number!="")
    	{
    		$jsonData['msg']=ltrim("The following part number(s) <br>".implode(",", $arr_price_updated_part_number)." sales price found and updated!",",");
    	}
    	$jsonData['model'] = $model;
    	$jsonData['status'] = "success";
    
    	echo CJSON::encode($jsonData);
    }
    
    public function actionUploadPriceList(){
        
        $model=new SalesPriceGroupName();
        $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
        
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('upload_price_list', array('model' => $model), false, false);
        
    }
    
     public function actionEditPriceList(){
        $model=new SalesPriceGroupName();
        $modelSalesPriceGroup=new SalesPriceGroup();
        $modelCustomer = new Customer();
        $id = (int) Yii::app()->request->getParam('id');
        $condition = ' pricing_group_id="'.$id.'"';
            if($id>0){
                $model=$model->findByPk($id);
                $modelSalesPriceGroup = $modelSalesPriceGroup->findAll(array('condition' => $condition));
                $modelCustomer = $modelCustomer->findAll(array('condition'=>'isActive="Y" AND default_pricing_group_id='.$id));
            }
       
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('edit_price_list', array('modelSalesPriceGroup' => $modelSalesPriceGroup,'model' => $model,'modelCustomer'=>$modelCustomer), false, false);
        
    }
    public function actionEditPrice(){
        
        $model=new SalesPriceGroup();
        $id = (int) Yii::app()->request->getParam('id');
        if($id>0){
                $model=$model->findByPk($id);
            }
        
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('edit_each_price_list', array('model' => $model), false, false);
        
    }
    
    public function actionSavePricingGroup()
    {
        
        
        //save sales price
        if (is_array($_POST['SalesPriceGroup'])) {
                foreach ($_POST['SalesPriceGroup'] as $i => $items) {
                        if ($items['id'] > 0) {
                            $modelSalesPriceGroup[$i] = SalesPriceGroup::model()->findByPK($items['id']);
                        } else {
                            $modelSalesPriceGroup[$i] = new SalesPriceGroup();
                        }
                        
                        $modelSalesPriceGroup[$i]->attributes = $items;
                        $modelSalesPriceGroup[$i]->product_name  = $items['product_name'];
                        $modelSalesPriceGroup[$i]->sales_price = $items['sales_price'];
                       
                       
                       
                }
             
        
          if (!empty($modelSalesPriceGroup)) {
                    foreach ($modelSalesPriceGroup as $each) {
                        $each->save();
                    }
                    // $jsonData['status'] = 'success';
                     
                }
                }
        
        
        
             if (isset($_POST['SalesPriceGroupName']))
            {
            $price_list_file_name   = $_POST['SalesPriceGroupName']['pricing_group_file_name'];
           // echo $price_list_file_name;exit;
            $pricing_group_name     = $_POST['SalesPriceGroupName']['pricing_group_name'];
            $modelSalesPriceGroupName = new SalesPriceGroupName();
            
            $id = (int) @$_POST['SalesPriceGroupName']['id'];

            if ($id > 0) {
                // Try to load existing record
                $modelSalesPriceGroupName = SalesPriceGroupName::model()->findByPk($id);
                if ($modelSalesPriceGroupName === null) {
                    // If not found, create new
                    $modelSalesPriceGroupName = new SalesPriceGroupName();
                    $modelSalesPriceGroupName->uploaded_by      = Yii::app()->user->id;
                    $modelSalesPriceGroupName->upload_date_time = date('Y-m-d H:i:s');
                } else {
                    // Existing record: update only
                    $modelSalesPriceGroupName->updated_by       = Yii::app()->user->id;
                    $modelSalesPriceGroupName->updated_date_time = date('Y-m-d H:i:s');
                }
            } else {
                // Always new record
                // $modelSalesPriceGroupName = new SalesPriceGroupName();
                $modelSalesPriceGroupName->uploaded_by      = Yii::app()->user->id;
                $modelSalesPriceGroupName->upload_date_time = date('Y-m-d H:i:s');
            }

            // Common fields (always update)
            $modelSalesPriceGroupName->pricing_group_file_name = $price_list_file_name;
            $modelSalesPriceGroupName->pricing_group_name      = $pricing_group_name;

            $modelSalesPriceGroupName->save(false);

        	
            
            
            
            
            
            
        	$pricing_list = $this->readCSV("upload/pricelist/" . $price_list_file_name);
        	$jsonData = array();
        	$arr_part_number=array();
        	$arr_price_updated_part_number=array();
        	foreach (array_slice($pricing_list, 1) as $i => $eachItem) {
        		$part_number = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[0]), '"'));
                        //echo $part_number;exit;
        		if (strlen($part_number) > 0) {
        
        
        			$sales_price = 0;
        			if(isset($eachItem[1]) && $eachItem[1]!="" && $eachItem[1]!=0)
        			{
        			$sales_price = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $eachItem[1]), '"'));
        			}
        		
        			$product_model = Store::model()->find(array('condition'=>' inventory_item_type=1 and LTRIM(RTRIM(part_number))="'.$part_number . '"'));
    
        			$model= new SalesPriceGroup();  
                               
        		
        	if(!empty($product_model->id)){
                $con_price_group = 'product_id="'.$product_model->id.'" and pricing_group_id="'.$modelSalesPriceGroupName->id.'" ';
                
                
                
        	$arr_sales_price_group = SalesPriceGroup::model()->find(array('condition'=> $con_price_group));
        				
        				$model->id = 0;
        				if (!empty($arr_sales_price_group)) {
    $model->id = $arr_sales_price_group->id;
    $model = $model->findByPk($arr_sales_price_group->id);

    $model->product_id  = $product_model->id;
    $model->sales_price = $sales_price; // <-- update sales price here
    $model->updated_by  = Yii::app()->user->id;
    $model->updated_date_time = date('Y-m-d H:i:s');

    $model->save(false);
} else {
    $model->product_id         = $product_model->id;
    $model->product_name       = trim($product_model->part_number);
    $model->pricing_group_id   = $modelSalesPriceGroupName->id;
    $model->sales_price        = $sales_price;
    $model->created_by         = Yii::app()->user->id;
    $model->created_date_time  = date('Y-m-d H:i:s');
    $model->save(false);
}

        				
        					$arr_price_updated_part_number[] = $part_number; 
        			}
        			else
        			{
        			    $arr_part_number[] = $part_number;
        			}
     	
     	
        		}
        	}
        	
        	
        	
        	$jsonData['errors']=array();
        	if(count($arr_part_number) > 0 && $arr_part_number!="")
        	{
        		$jsonData['errors']=ltrim("Please add the following part number into inventory <br>".implode(",", $arr_part_number),",");
        	}
        	
        	$jsonData['msg']=array();
        	if(count($arr_price_updated_part_number) > 0 && $arr_price_updated_part_number!="")
        	{
        		$jsonData['msg']=ltrim("The following part number(s) <br>".implode(",", $arr_price_updated_part_number)." sales price found and updated!",",");
        	}
        	$jsonData['model'] = $model;
        	$jsonData['status'] = "success";
        
        	echo CJSON::encode($jsonData);
    	
    }
    }
    
  public function actionGetPriceGroupNameList()
        {
                $model=new SalesPriceGroupName();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name

                   0 =>'id',
                   1 =>'pricing_group_name',
                   2 => 'pricing_group_file_name'
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = ' 1=1 ';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                 $condition ="  (pricing_group_name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;
               
                foreach ($model as $row)
                {
                     $div = '';
                //$div .= ' <button title="Edit" class="btn btn-primary btn-xs" onclick="loadPopupModal(\'salespricinggroup/UploadPriceList&id=' . $row['id'] . '\',\' Edit \',\'lg\')"><i class="fa fa-edit"></i></button>';
              if (isset(Yii::app()->user->havePermissionOn['change_upload_sales_pricing_group_edit']) || Yii::app()->user->authorised_user == 1) {

                $div .= ' <button title="Edit Price" class="btn btn-primary btn-xs" onclick="loadPopupModal(\'salespricinggroup/EditPriceList&id=' . $row['id'] . '\',\' Edit Price \',\'lg\')"><i class="fa fa-edit"></i></button>';
              }
                $div .= ' <a href ="'.Yii::app()->createUrl("/salespricinggroup/DownloadPriceList").'&filename='.$row['pricing_group_file_name'].' " class="btn btn-primary btn-xs"><i class="fa fa-download" title="Download"></i></a>';
                   
                       $rowData[]=array(
                        $m,
                        $row['pricing_group_name'],
                        $row['pricing_group_file_name'].'&nbsp;'.'',
                        date("d-m-Y H:i A", strtotime($row['upload_date_time'])),
                        ($row['updated_date_time'] && $row['updated_date_time'] != "0000-00-00 00:00:00")
                            ? date("d-m-Y H:i A", strtotime($row['updated_date_time']))
                            : '',
                        '<div class="btn-wrap text-center">'.$div.'</div>',
                        array('id' => $row['id'],'code'=>$row['pricing_group_name'], 'status' => 'Y')
                    );

                
                    $m++;
                    
                }
                

                $data['data'] = $rowData;
                echo json_encode($data);
        }  
    
  public function actionSavePriceDetails() {
        $model = new SalesPriceGroup();
        $other = array();
        
        
        if (is_array($_POST['SalesPriceGroup'])) {
                foreach ($_POST['SalesPriceGroup'] as $i => $items) {
                        if ($items['id'] > 0) {
                            $modelSalesPriceGroup[$i] = SalesPriceGroup::model()->findByPK($items['id']);
                        } else {
                            $modelSalesPriceGroup[$i] = new SalesPriceGroup();
                        }
                        
                        $modelSalesPriceGroup[$i]->attributes = $items;
                        $modelSalesPriceGroup[$i]->product_name  = $items['product_name'];
                        $modelSalesPriceGroup[$i]->sales_price = $items['sales_price'];
                       
                       
                       
                }
            } 
        
          if (!empty($modelSalesPriceGroup)) {
                    foreach ($modelSalesPriceGroup as $each) {
                        $each->save();
                    }
                     $jsonData['status'] = 'success';
                      echo CJSON::encode($jsonData);
                }   

    }  
    
    
    public function actionDownloadPriceList(){
        $filename= Yii::app()->request->getparam('filename'); 
       
        $path = Yii::getPathOfAlias('webroot')."/upload/pricelist/".$filename;
        if(!empty($path)){ 
                header("Content-type:application/force-download"); //for txt file
                header('Content-Disposition: attachment; filename="'.basename($path).'"'); 
                header('Content-Length: ' . filesize($path));
                readfile($path);
                Yii::app()->end();
        }
        
    }  

    public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new SalesPriceGroup();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
    
    
    
    
}