<?php

class QualityCheckController extends Controller {

    public $layout = 'layout';

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'Savematerial', 'UploadDocuments', 'GetMaterialRequestList', 'GetbinsWithitems'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {

        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionCreate() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new PurchasingMaterialreceipt();
        if ($id > 0)
            $model = $model->findByPk($id);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model));
    }

    public function actionGetMaterialRequestList() {


        $model = new PurchasingMaterialreceipt();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];

        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.po_id',
            2 => 't.file_id',
            3 => 'vendor_details.vendor_name',
            4 => 't.qcchecked',
            5 => 't.mrv_receipt_date',
            6 => 'file.current_process_status',
            7 => 't.id',
            8 => 't.id',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = "(qcchecked='N' OR is_convertable='Y') and purchaseorder.service_invoice!='Y'";
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "purchaseorder.service_invoice!='Y' AND (t.po_id LIKE '%" . $searchString . "%' OR  t.file_id LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR vendor_details.vendor_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('file', 'vendor_details', 'purchaseorder')->count(array('condition' => $condition));
        $model = $model->with('file', 'vendor_details', 'purchaseorder')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $i = 1;
        foreach ($model as $row) {
            $req_date = date("d/m/Y", strtotime($row->mrv_receipt_date));
            if ($row['qcchecked'] == 'N') {
                $quality_control_status = "Not Done";
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["purchase_qc_edit"])) {
                    $edit = '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'qualitycheck/create&id=' . $row['id'] . '&file_id=' . $row['file_id'] . '\',\' Material Receipt No - ' . $row['id'] . '\',\'xl\')" title="Quality Check/Receive items"><i class="fa fa-pencil" aria-hidden="true"></i></i></button>';
                }
            } else {
                $quality_control_status = "Completed";
                $edit = '';

                if ($row['is_convertable'] == 'Y') {
                    if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["purchase_qc_convert"])) {
                        $edit .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'purchaseinvoice/create&mr_id=' . $row['id'] . '&file_id=' . $row['file_id'] . '\',\' File No - ' . $row['file_id'] . '\',\'xl\');" title="Convert to Invoice" class="btn btn-primary btn-xs" ><i class="fa fa-retweet" aria-hidden="true"></i></i></button>';
                    }
                }
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["purchase_material_print"]))
                $edit .= ' <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=materialreceipt/Print&id=' . $row['id'] . '&type=qc"><i class="fa fa-file-pdf-o"></i></a>';
            /* if($row['file']['current_process_status'] == 'P_O'){
              $status  = 'Purchase Order';
              }else if($row['file']['current_process_status'] == 'M_R'){
              $status  = 'Material Reciept';
              }else if($row['file']['current_process_status'] == 'Q_C'){
              $status  = 'Quality Checked';
              }else if($row['file']['current_process_status'] == 'P_I' && $row['is_convertable'] == 'N'){
              $status  = 'Purchase Invoice';
              }else if($row['file']['current_process_status'] == 'P_I' && $row['is_convertable'] == 'Y'){
              $status  = 'Purchase Invoice (Partial)';
              } */
            if ($row['qcchecked'] == 'N') {
                $status = 'Material Reciept';
            } else if ($row['qcchecked'] == 'Y' && $row['is_convertable'] == 'Y') {
                $status = 'Quality Checked';
            } else if ($row['qcchecked'] == 'Y' && $row['is_convertable'] == 'N') {
                $status = 'Purchase Invoice';
            }
            $rowData[] = array($i, $row['file_id'], $row['po_id'], $row['id'], $row['vendor_details']['vendor_name'], $quality_control_status, $req_date, $status, $row['qcchecked'], $row['is_convertable'], $row['posted']);
            $i++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }


    public function actionPrintQCReportPDF() {
        $model = new PurchasingOrder();
        $id = Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = PurchasingOrder::model()->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.reports.pdf.order_list_individual', array('model' => $model, 'id' => $id, 'title' => $title), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionSavematerial() {

        $modelMaterial = new PurchasingMaterialreceipt();
        $qccheckedQuantity = array();
        $other = array();
        $valid = true;
        if (isset($_POST['PurchasingMaterialreceipt'])) {

            //aaded by priya 0n 11.9.24 check stocklockflag
            $modelCompanySettings = new MasCompanySettings();
            $condition = 'crm_company_id = ' . (int) Yii::app()->user->master_user_company_id;
            $modelCompanySettings = $modelCompanySettings->find(array('condition'=>$condition));    
            $stock_lock_flag =$modelCompanySettings->stock_lock_flag;
            if($stock_lock_flag=="N"){
            /////////////

            if ((int) $_POST['PurchasingMaterialreceipt']['id'] > 0) {
                $modelMaterial = $modelMaterial->findByPK($_POST['PurchasingMaterialreceipt']['id']);

                

                if ($modelMaterial->qcchecked == 'Y') {

                    $valid = false;
                    $other[] = "Quality Check already done";
                } else {
                    $modelMaterial->scenario = 'update';
                    $modelMaterial->qc_check_notes = $_POST['PurchasingMaterialreceipt']['qc_check_notes'];
                    $modelMaterial->updated_by = Yii::app()->user->id;
                    $modelMaterial->updated_datetime = date('Y-m-d h:i:s');
                    $modelMaterial->qcchecked = 'Y';
                    $modelMaterial->stock_updated = 'Y';
                    $modelMaterial->qc_check_date = date('Y-m-d');
                    if ($_POST['PurchasingMaterialreceipt']['qc_check_date'] != '00/00/0000' && $_POST['PurchasingMaterialreceipt']['qc_check_date'] != '') {
                        $modelMaterial->qc_check_date = str_replace('/', '-', $_POST['PurchasingMaterialreceipt']['qc_check_date']);
                        $modelMaterial->qc_check_date = date("Y-m-d", strtotime($modelMaterial->qc_check_date));
                    }
                    $valid = $modelMaterial->validate();
                }
            }
            if (is_array($_POST['StockLedger'])) {
                foreach ($_POST['StockLedger'] as $i => $item) {

                    $qccheckedQuantity[$item['header_item_id']] = (float) $qccheckedQuantity[$item['header_item_id']] + (float) $item['quantity'];

                    if ($item['product_id'] > 0 && $item['quantity'] > 0 && $item['inventory_item_type'] == 1) {


                        $prod_model = Store::model()->findByPk($item['product_id']);
                        $modelStockLedger[$i] = new StockLedger;
                        $modelStockLedger[$i]->attributes = $_POST['StockLedger'][$i];
                        $modelStockLedger[$i]->file_id = $item['file_id'];
                        $modelStockLedger[$i]->header_id = $item['header_id'];
                        $modelStockLedger[$i]->header_item_id = $item['header_item_id'];
                        $modelStockLedger[$i]->customer_vendor_id = $item['customer_vendor_id'];
                        $modelStockLedger[$i]->customer_vendor_name = $item['customer_vendor_name'];
                        $modelStockLedger[$i]->product_id = $item['product_id'];
                        $modelStockLedger[$i]->product_name = $item['product_name'];
                        $modelStockLedger[$i]->product_description = $item['product_description'];
                        $modelStockLedger[$i]->brand_id = $item['brand_id'];
                        $modelStockLedger[$i]->brand_name = $item['brand_name'];
                        $modelStockLedger[$i]->warehouse_id = $item['warehouse_id'];
                        $modelStockLedger[$i]->rack_id = $item['rack_id'];
                        $modelStockLedger[$i]->bin_id = $item['bin_id'];
                        $modelStockLedger[$i]->batch_no = $item['batch_no'];
                        $modelStockLedger[$i]->batch_date = $modelMaterial->qc_check_date;
                        $modelStockLedger[$i]->serial_no = trim($item['serial_no']);
                        $modelStockLedger[$i]->quantity = $item['quantity'];
                        $modelStockLedger[$i]->transaction_from = $item['transaction_from'];
                        $modelStockLedger[$i]->transaction_type = $item['transaction_type'];
                        $modelStockLedger[$i]->unit_name = $item['unit_name'];
                        $modelStockLedger[$i]->unit_id = $item['unit_id'];
                        $modelStockLedger[$i]->unit_factor = $item['unit_factor'];
                        /* if($item['unit_id']>0){
                          $modelStockLedger[$i]->unit_factor =UnitOfMeasurement::model()->findByPk((int)$item['unit_id'])->factor;
                          } */
                      //  $modelStockLedger[$i]->cost_price = $item['cost_price'];
                        $modelStockLedger[$i]->cost_price = $item['buying_price'] ; // changed by habeeb due to purchase LC
                        $modelStockLedger[$i]->sales_price = $item['sales_price'];
                        //$modelStockLedger[$i]->transaction_date = date('Y-m-d');
                        $modelStockLedger[$i]->transaction_date = $modelMaterial->qc_check_date;

                        $modelStockLedger[$i]->created_by = Yii::app()->user->id;
                        $modelStockLedger[$i]->created_date = date('Y-m-d h:i:s');
                        $modelStockLedger[$i]->stock_updated = "N";
                        // new column added.
                        $modelStockLedger[$i]->buying_price = $item['buying_price'];

                        if ($item['manufacturing_date'] != '00/00/0000' AND $item['manufacturing_date'] != '01/01/1970' AND $item['manufacturing_date'] != '') {
                            $mf_date = str_replace('/', '-', $item['manufacturing_date']);
                            $modelStockLedger[$i]->manufacturing_date = date("Y-m-d", strtotime($mf_date));
                        } else {
                            $modelStockLedger[$i]->manufacturing_date = "0000-00-00";
                        }
                        if ($item['expiry_date'] != '00/00/0000' AND $item['expiry_date'] != '01/01/1970' AND $item['expiry_date'] != '') {
                            $expiry_date = str_replace('/', '-', $item['expiry_date']);
                            $modelStockLedger[$i]->expiry_date = date("Y-m-d", strtotime($expiry_date));
                        } else {
                            $modelStockLedger[$i]->expiry_date = "0000-00-00";
                        }
                        if (!empty($item['serial_no'])) {

                            $checkItemSerialNo = $total_available_product = StockLedger::model()->find(array('select' => 'sum(quantity) as quantity', 'condition' => 'serial_no="' . trim($item['serial_no']) . '" AND product_id="' . $item['product_id'] . '"'))->quantity;
                            if ($checkItemSerialNo > 0) {
                                $valid = false;
                                $repeated_item = Store::model()->findByPk($item['product_id'])->part_number;
                                $other[] = "$repeated_item : Serial No (" . $item['serial_no'] . ") Already Exist";
                            }
                        }
                        if ($prod_model->have_expiry_date == 'Y') {
                            if ($item['batch_no'] == '') {
                                $valid = false;
                                $other[] = "Please enter Batchno for " . $prod_model->part_number;
                            }
                            if ($item['expiry_date'] == '') {
                                $valid = false;
                                $other[] = "Please enter Expiry Date for " . $prod_model->part_number;
                            }
                        }
                        $valid = $modelStockLedger[$i]->validate() && $valid;
                    }
                }
            }
            if ($valid) {
                echo CJSON::encode(array('status' => 'success'));

                $modelMaterial->save();
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'QUALITY_CHECK',
                        Yii::app()->user->id,
                        'UPDATED',
                        " MTRL ID - {$modelMaterial->id} for Quality Check "
                );
                // end audit log
                $damageFlag = false;
                foreach ($qccheckedQuantity as $key => $each) {
                    $itemModel = PurchasingMaterialreceiptItem::model()->findBypk($key);
                    if ((float) $itemModel->received_quantity != (float) $each)
                        $damageFlag = true;
                    $itemModel->damaged_quantity = (float) $itemModel->received_quantity - (float) $each;
                    $itemModel->qc_checked_quantity = (float) $itemModel->received_quantity - (float) $itemModel->damaged_quantity;
                    $itemModel->update();
                }
                if (!empty($modelStockLedger)) {
                    foreach ($modelStockLedger as $eachItem) {
                        if (empty($eachItem->batch_no)) {
                            $eachItem->batch_no = 'QC-' . date('dmY') . '-' . $modelMaterial->id;
                        }
                        if ((int) $eachItem->warehouse_id > 0) {
                            $eachItem->warehouse_name = MasInventoryWarehouse::getWarehouseName($eachItem->warehouse_id);
                        }
                        if ((int) $eachItem->rack_id > 0) {
                            $eachItem->rack_name = MasInvRack::getRackName($eachItem->rack_id);
                        }
                        if ((int) $eachItem->bin_id > 0) {
                            $eachItem->bin_name = MasInvBin::getBinName($eachItem->bin_id);
                        }
                        $eachItem->save(false);
                        $item_id = $eachItem->header_item_id;

                        $product_id = $eachItem->product_id;

                        $sql = "select SUM(quantity * unit_factor) from erp_stock_ledger WHERE product_id = $product_id ";
                        $total_qty = Yii::app()->db->createCommand($sql)->queryScalar();

                        $sql = "select SUM(quantity * unit_factor * cost_price)  from erp_stock_ledger WHERE product_id = $product_id ";
                        $total_cost = Yii::app()->db->createCommand($sql)->queryScalar();

                    }
                }
                if ($modelMaterial->file_id > 0)
                    MasterFile::model()->updateByPk($modelMaterial->file_id, array('current_process_status' => "Q_C"));
                if ($damageFlag)
                    PurchasingOrder::model()->updateBypk($modelMaterial->po_id, array('completed' => 'P', 'convert_status' => 'Y'));
                /* $model_mail_setting=Notification::model()->find(array('condition' => 'event_id="16"'));
                  Yii::import('application.controllers.front.MasternotificationController');
                  if($model_mail_setting->mail_required=='Y'){
                  MasternotificationController::sendmail(16,$modelMaterial->id);
                  }
                  if($model_mail_setting->notification_required=='Y'){
                  MasternotificationController::sendnotification(16,$modelMaterial->id);
                  }
                  if($model_mail_setting->sms_required=='Y'){
                  MasternotificationController::sendsms(16,$modelMaterial->id);
                  } */
            } else {

                $error2 = array();
                $error4 = array();
                $error1 = json_decode(CActiveForm::validate($modelMaterial, '', false), true);
                if (!empty($modelStockLedger))
                    $error2 = json_decode(CActiveForm::validateTabular($modelStockLedger, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error4, $other));
                if ($error != '[]' || $error != '')
                    echo $error;
            }

        }else{
            echo CJSON::encode( array( 'error' => ' Transactions are already locked!' ));
           }
        }
    }

    public function actionGetbinsWithitems() {
        $modelitems = $_POST['model'];
        $modelitems = new $modelitems;
        $row_id = $_POST['row_id'];
        $id = (int) $_POST['id'];
        //echo CHtml::activedropDownList($field_id,'',MasInvBin::getBins_rackwise($id), array('data-label'=>'Bin <span style="color:red;">*<span> '));
        echo CHtml::activedropdownlist($modelitems, "[" . $row_id . "]bin_id", MasInvBin::getBins_rackwise($id), array('class' => 'qty go', 'prompt' => 'select'));
    }

}
