<?php

class ProjectController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','GetProjectList','Create','SaveProject','DeleteProject','GetProject', 'Disable'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $this->render('index');
    }
    
    public function actionGetProjectList()
    {
    	
        $model=new Project();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
        // datatable column index  => database column name
        /*0 =>'id',
        1 =>'project_name',
        3 =>'location',
        4 =>'project_date',
        5 =>'manager_name'*/
        
        0 =>'id',
        1 =>'t.id',
        2 =>'project_name',
        3 =>'location',
        4 =>'project_date',
        5 =>'manager_name'
        
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = 't.isActive= "Y" ';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = $_POST['search']['value'];
            $condition =" (id LIKE '%".$searchString."%' OR project_name LIKE '%".$searchString."%')";
        }
        $count  =   $model->count(array('condition'=>$condition));
        $model  =   $model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $rowData[]=array($m,$row['id'],$row['project_name'],$row['location'],date("d/m/Y",strtotime($row['project_date'])),$row['manager_name'] , array('id' => $row->id, 'status' => $row->isActive));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);   
    }

    public function actionCreate()
    {
        $model=new Project();
        $id = (int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
     Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);   
    $this->render('create', array('model' => $model), false, true);
    }

    public function actionSaveProject()
    {
    $model = new Project();
        if (isset($_POST['Project']))
        { 
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time =date('Y-m-d h:i:s');
            
            if ((int) @$_POST['Project']['id'] > 0)
            {   $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time =date('Y-m-d h:i:s');
                $id= (int) @$_POST['Project']['id'];
                $model=$model->findByPk($id);
                $audit_type = 'UPDATED';
            }else{
                $audit_type = 'CREATED';
            }
            $model->attributes=$_POST['Project'];
            if(isset($_POST['Project']['project_date']) && $_POST['Project']['project_date']!=""){

                $project_date = str_replace('/', '-', $_POST['Project']['project_date']);

                $model->project_date = date("Y-m-d", strtotime($project_date));

            }
            if($model->save())
            {
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'PROJECTS',
                    Yii::app()->user->id,
                    $audit_type,
                    " with project number: - {$model->id}  "
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['project-form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            }
            else
            {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
            echo $error;
            }
        }
    }

    public function actionDeleteProject()
    {
        $id = $_POST['id'];
        $model=new Project();
        $model->deleteByPk($id);
         // inserting to audit log
         AuditLog::saveAuditLogs(
            'PROJECTS',
            Yii::app()->user->id,
            'DELETED',
            " with project number: - {$id}  "
        );
        // end audit log
        echo "success";
    }
    
    public function actionGetProject() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'project_title LIKE "%' . $searchTerm . '%"';
        $model = new Project();
        $model = $model->findAll(array('select' => 't.id,t.project_title', 'condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['p_value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->project_title;
           
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
            public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new Project();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }

}