<?php

class ProbabilityController extends Controller
{
//	public function actionIndex()
//	{
//		$this->render('index');
//	}

        public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                  'actions' => array('login', 'error', 'logout'),
                  'users' => array('*'),
                  ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                  'actions' => array('Index','Create','GetProbabilityList','SaveProbability','DeleteProbability','DirectAdd','Blockprobability','UnBlockprobability'),
                  'expression' => '$user->isMember()',
                  ),
                array('deny', // deny all users
                  'users' => array('*'),
                  ),
                );
        }
	public function actionIndex()
	{
                
		$this->render('index');
	}

	// Uncomment the following methods and override them if needed
	
	public function filters()
        {
            return array(
                'accessControl', // perform access control for CRUD operations
                );
        }
        public function actionGetProbabilityList()
        {
                $model=new MasProbability();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'id',
                   1 =>'probability',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = '1=1';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition =" (probability LIKE '%".$searchString."%' )";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $div = '';
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["sales_master_probability_edit"])){
                        $div .=   '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'probability/create&id='.$row['id'].'\',\'Edit Probability\',\'lg\')"><i class="fa fa-pencil"></i></button>';
                    }
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["sales_master_probabilities_delete"])){
                      //  $div .=  ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteProbability('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                    }

                    if(isset(Yii::app()->user->havePermissionOn['sales_master_probability_disable']) ||  Yii::app()->user->authorised_user == 1)
                    {

                      if ($row->isActive == "Y") 
                      {
                        $div .= ' <a href ="javascript:void(0);" class="btn btn-success btn-xs" onclick="disableprobability(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
                      }
                      if ($row->isActive == 'N') 
                      {
                            $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="enableprobability(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
                      }            
                    
                    }
                    $rowData[]=array($m,
                        $row['probability'].'% Probability',
                        '<div class="btn-wrap">'.$div.'</div>',
                        $row['isDefault'],
                        $row['isActive'],
                      );
                    $m++;
                }
//              
                $data['data'] = $rowData;
                echo json_encode($data);
        }
         public function actionCreate()
        {
            $model=new MasProbability();
             $id = (int) Yii::app()->request->getParam('id');
            if($id>0){
                $model=$model->findByPk($id);
            }
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('create', array('model' => $model), false, true);
        }
  
  
        public function actionSaveProbability()
        {
            $model = new MasProbability();
            if (isset($_POST['MasProbability']))
            {
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime =date('Y-m-d h:i:s');
    		
    		if ((int) @$_POST['MasProbability']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_datetime =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['MasProbability']['id'];
                    $model=$model->findByPk($id);  
                    $audit_type = 'UPDATED';     
                }else{
                  $audit_type = 'CREATED';
                }
              
                if($_POST['MasProbability']['isDefault'] == "Y"){
                	MasProbability::model()->updateAll(array( 'isDefault' => 'N' ), 'isDefault = "Y"' );
                }
                $model->attributes=$_POST['MasProbability'];
                if($model->save())
                {
                        // inserting to audit log
                        AuditLog::saveAuditLogs(
                          'PROBABILITIES',
                          Yii::app()->user->id,
                          $audit_type,
                          " with probability : - {$model->probability} %  "
                      );
                      // end audit log
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['probability_form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                      //  $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }

            }
        }
        public function actionDeleteProbability()
    {
		$id = $_POST['id'];
                $model=new MasProbability();
                $del = $model->findByPk($id);
                $model->deleteByPk($id);
                // inserting to audit log
                AuditLog::saveAuditLogs(
                  'PROBABILITIES',
                  Yii::app()->user->id,
                  'DELETED',
                  " with probability : - {$del->probability} %  "
              );
              // end audit log
                echo "success";
    }
    public function actionDirectAdd(){
           $from = $_POST['from'];
           $name = $_POST['name'];
           if($name != ''){
               $modelProbability = new MasProbability;
               $modelProbability->created_by = Yii::app()->user->id;
               $modelProbability->created_datetime =date('Y-m-d h:i:s');   
               $modelProbability->probability = $name;
               $modelProbability->save(false);
           }
           $data  =  MasProbability::getProbability();
           if($from == 'quote'){
               $model = new Quotes;
               $field_name = 'probability';
           }
           $model->$field_name = $modelProbability->id;
           $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Probability'));  
           $status=array("status" =>"success","drop" => $drop);    
           echo CJSON::encode($status);
            
         }
        
        
	// Uncomment the following methods and override them if needed
	/*
	public function filters()
	{
		// return the filter configuration for this controller, e.g.:
		return array(
			'inlineFilterName',
			array(
				'class'=>'path.to.FilterClass',
				'propertyName'=>'propertyValue',
			),
		);
	}

	public function actions()
	{
		// return external action classes, e.g.:
		return array(
			'action1'=>'path.to.ActionClass',
			'action2'=>array(
				'class'=>'path.to.AnotherActionClass',
				'propertyName'=>'propertyValue',
			),
		);
	}
	*/


  public function actionBlockprobability() {
    $id = $_POST['id'];
    if ($id > 0) {
      MasProbability::model()->updateByPK($id, array('isActive' => "N"));
      // inserting to audit log
      $model=new MasProbability();
      $upt = $model->findByPk($id); // audit log changes
      AuditLog::saveAuditLogs(
          'PROBABILITIES',
          Yii::app()->user->id,
          'BLOCKED',
          " with name: - {$upt->probability} %  "
      );
     // end audit log
        $status['status'] = 'success';
    } else {
        $status['status'] = 'error';
    }
    echo CJSON::encode($status);
}

public function actionUnBlockprobability() {
    $id = $_POST['id'];
    if ($id > 0) {
      MasProbability::model()->updateByPK($id, array('isActive' => "Y"));
       // inserting to audit log
       $model=new MasProbability();
       $upt = $model->findByPk($id); // audit log changes
       AuditLog::saveAuditLogs(
           'PROBABILITIES',
           Yii::app()->user->id,
           'UNBLOCKED',
           " with name: - {$upt->probability} %  "
       );
      // end audit log
        $status['status'] = 'success';
    } else {
        $status['status'] = 'error';
    }
    echo CJSON::encode($status);
}

}