<?php

class PricelistController extends Controller
{

    
        public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','Delete','Save','GetList','GetProducts'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
         }
    
        public function filters()
        {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
         }
         
        public function actionGetList()
         {
 
                $model=new PriceList();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                    0 => 't.id',
                    1 => 'product.part_number',
                    2 => 'brand.product_class',
                    3 => 't.price',
                    4 => 't.id'
                 
                 );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOsrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and (product.part_number LIKE '%".$searchString."%' OR product.description LIKE '%".$searchString."%' OR brand.product_class LIKE '%".$searchString."%')";
                }
                $count = $model->with('product','brand')->count(array('condition'=>$condition));
                $model=$model->with('product','brand')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $i => $row)
                {
                    $button_string="";
//                    if(isset(Yii::app()->user->havePermissionOn['bank_edit']) ||  Yii::app()->user->authorised_user == 1)
//                    {
                        $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'pricelist/create&id='.$row['id'].'\',\'Edit Price \',\'lg\')"><i class="fa fa-edit"></i></button>';
//                    }
//                    if(isset(Yii::app()->user->havePermissionOn['bank_delete']) ||  Yii::app()->user->authorised_user == 1)
//                    {
                      //  $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deletelist('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
//                    }
                    $rowData[]=array(($i+1),$row['product']['part_number'],$row['brand']['product_class'],$row['price'],'<div class="text-center">'.$button_string.'</div>');
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new PriceList(); 
        $id = (int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create', array('model' => $model), false, true);
    }
    public function actionSave()
        {
            $model = new PriceList();
            if (isset($_POST['PriceList']))
            {
                if ((int) @$_POST['PriceList']['id'] > 0)
                {
                    $id= (int) @$_POST['PriceList']['id'];
                    $model=$model->findByPk($id); 
                    $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time =date('Y-m-d h:i:s');
                }else{
                    $model->created_by = Yii::app()->user->id;
                    $model->created_date_time =date('Y-m-d h:i:s');
                }
                $model->attributes=$_POST['PriceList'];
                if($model->save())
                {       
                        
                        $jsonData['status'] = 'success';
                        echo CJSON::encode($jsonData);
                     
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }
               

            }
        }
        public function actionDelete()
    {
		$id = $_POST['id'];
//                $model_c = Customer::model()->findAll(array('condition'=>'customer_bank_id='.$id.''));
//                $model_v = Vendor::model()->findAll(array('condition'=>'vendor_bank_name='.$id.''));
//                if(empty($model_c) && empty($model_v)){
                        $model=new PriceList();
                        $model->deleteByPk((int)$id);
                        echo "success";
//                }
//                else{
//                      echo "fail";
//                }
              
    }
    public function actionDirectAdd(){
           $from = $_POST['from'];
           $name = $_POST['name'];
           $status =  array();
           $drop = '';
           if($name != ''){
               $modelBank = new PriceList;
               $modelBank->bank_name = $name;
               if($modelBank->save()){
                    $status['status']= "success";
                    $data  = PriceList::getBanks();
                    if($from == 'vendor'){
                        $model = new Vendor;
                        $field_name = 'vendor_bank_name';
                    }
                    $model->$field_name = $modelBank->id;
                    $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Bank'));  
                    $status['drop']= $drop;
                    echo CJSON::encode($status); 
               }else{
                    $error = CActiveForm::validate($modelBank, '', false);
                        if ($error != '[]')
		               echo $error;
               }
           }
        }
        public function actionGetProducts() {
            $from = $_GET['frm'];
            $searchTerm = $_GET['term'];
            $condition = 'part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%"';
            $model = new Store();
            $model = $model->with('tax')->findAll(array('select' => 'id,part_number,description,unit_id,brand_class_id', 'condition' => $condition));
            $i = 0;
            foreach ($model as $eachModel) {
                $data[$i]['value'] = $eachModel->id;
                $data[$i]['label'] = $eachModel->part_number;
                $data[$i]['part_number'] = $eachModel->part_number;
                $data[$i]['description'] = $eachModel->description;
                $data[$i]['unit_id'] = $eachModel->unit->id;
                $data[$i]['unit_name'] = $eachModel->unit->symbol;
                $data[$i]['tax_code'] = $eachModel->tax;            
                $data[$i]['part_no'] = $eachModel->part_number;
                $data[$i]['other'] = $eachModel->brand_class_id;
                $data[$i]['description'] = $eachModel->brand_detail->product_class;
                $i++;
            }
            echo CJSON::encode($data);
            Yii::app()->end();
    }
        
        
  
}