<?php

class MessagingController extends Controller
{
    public $layout = 'layout';
    public function accessRules() {
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                        'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover'),
                        'users' => array('*'),
                ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                        'actions' => array('Index','Create','Sendmessages','GetSendMessages',
                            'orderdetails','sendmessage','GetMessages','Details','savedetails','GetPoNo'
                                ),
                        'expression' => '$user->isMember()',

                ),

                array('deny', // deny all users

                                'users' => array('*'),
                ),
            );
    }
    public function filters() {
            return array('accessControl'); // perform access control for CRUD operations
    }



public function actionGetMessages()
    {



            $model=new Messaging();
            $draw   = $_POST['draw'];
            $offset = $_POST['start'];
            $limit  = $_POST['length'];
            $columns = array(
                            // datatable column index  => database column name

                           
                            0=>'t.id',
                           
            );
$user_id=Yii::app()->user->id;
//echo $user_id;exit;
            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder  = $_POST['order'][0]['dir'];
            $orderBy      = $filterColumn." ".$filterOrder;
            $condition = 't.message_to='.$user_id.' AND t.received= "N"';
            //$condition = 't.message_to='.$user_id;
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $condition="t.id LIKE '%".$searchString."%' OR user_from.first_name LIKE '%".$searchString."%' OR t.comments LIKE '%".$searchString."%'  ";
          
         // $condition="file_no LIKE '%".$searchString."%'";
        }
            //$condition  = '1=1';
           
            $count = $model->with('user_from')->count(array('condition'=>$condition));
            $model = $model->with('user_from')->findAll(array('condition'=>$condition));

            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData=array();
            foreach ($model as $row)
            {
              $userr=User::model()->findbypk($row['message_from']);
               $name=$userr->first_name." ".$userr->last_name;
               // $userrclosed=User::model()->findbypk($row['closed_by']);
             // print_r($name);
                if($row['type'] == PO)
                {
                    $orderr=Purchase;
                }elseif($row['type'] == SO)
                {
                    $orderr=Sales;
                }else
                {
                    $orderr=Others;
                }
              
                         
                $rowData[]=array($row['id'],$name,$orderr,date("d/m/Y h:i a", strtotime($row['send_datetime'])),$row['comments'],array('id' => $row['id'],'order_id' => $row['order_id']));



            }
            $data['data'] = $rowData;

            echo json_encode($data);

    }
    public function actionIndex()
    {      
        
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }
    /*
     * function to getlist for lead datatable
     * modified by jisha on 17-9-18. 
     */
     
    
     public function actionorderdetails() {
       
         $model = new PurchasingOrder();
         $po_no = Yii::app()->request->getParam('po_no');
          $order_typee = Yii::app()->request->getParam('type');
          $ref_no = Yii::app()->request->getParam('ref_no');
     //   echo $po_no;exit;
         
              $modeldetails = new Messaging();
              //print_r($modeldetails);
          
          if($order_typee == 'PO'){
         if($po_no>0){
             $model=PurchasingOrder::model()->findbypk($po_no);
             //print_r($model);exit;
            
              $modeldetails = new Messaging();
             
             $vendor=$model['vendor_id'];
             $vendordetails=Vendor::model()->findbypk($vendor);
             $v_name=$vendordetails['vendor_name'];
             $address=$model['shipping_address'];
            // echo 'ok'. $v_name;
         }
          }else if($order_typee == "SO"){
              
               $model=Order::model()->findbypk($po_no);
            $modeldetails = new Messaging();
           
               $vendor=$model['customer_id'];
                $vendordetails=Customer::model()->findbypk($vendor);
             $v_name=$vendordetails['customer_name'];
                $address=$model['billing_address'];
            // echo 'ok'. $v_name;
          }
          else if($order_typee == "OT"){
              $po_no  = $ref_no;
          }
          
		 
	
	
	 Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
	
		$this->render('message_view',array('address'=>$address,'v_name'=>$v_name,'model'=>$model,'po_no'=>$po_no ,'order_typee' =>$order_typee,'modeldetails' =>$modeldetails));
        
       
    }
    
    public function actionsendmessage() {
         date_default_timezone_set("Asia/Dubai");
    $user=$_POST['user'];
    //print_r($user);
    $typee  = $_POST['order_typee'];
    $order_number  = $_POST['new_po_no'];
    $sender  =Yii::app()->user->id;
    $send_time  = date("Y-m-d H:i:s");
    $comments =$_POST['Messaging']['comments'];
    $received = N;
    //   = $_POST['user'];
      
   $valid = true;
   $otherarray = array();
  
    foreach($user as $i => $val ){
        $model[$i] = new Messaging;
        $model[$i]->message_from=$sender;
        $model[$i]->type=$typee;
        $model[$i]->send_datetime=$send_time;
        $model[$i]->comments=$comments;
        $model[$i]->received =$received;
        $model[$i]->message_to=$val;
         $model[$i]->order_id=$order_number;
        $valid = $valid && $model[$i]->validate();
    }
    if(empty($model)){
        $otherarray[] = 'Please select atleat one user';
        $valid = false;
    }
          
 
 
    if ($valid) {    
        if( is_array($model) ){
            foreach($model as $each ){
                $each->save(false);
            }
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);    
    }
    else {
        $error2 = array();
        $error1 = json_decode(CActiveForm::validate($model, '', false), true);
        $error = CJSON::encode(array_merge_recursive($error1, $error2,$otherarray));
        if ($error != '[]')
            echo $error;
    }
}




    public function actionCreate()
    {
         

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false,'jquery-2.1.4.min.js' => false);
        $this->render('create');
    }

    
    public function actionGetPoNo() {
        
        
        $searchTerm = $_GET['term'];
         $searchType = $_GET['search_type'];
         $condition  = 'id  LIKE "%' . $searchTerm . '%"'; 
         if($searchType == 'PO'){
             
             $model = new PurchasingOrder();
                $model = $model->findAll(array('select' => 'id', 'condition' => $condition));
                $i = 0;
                foreach ($model as $eachModel) {
                    $data[$i]['value'] = $eachModel->id;
                    $i++;
                }
             }
             else{
                 $model = new Order();
                $model = $model->findAll(array('select' => 'id', 'condition' => $condition));
                $i = 0;
                foreach ($model as $eachModel) {
                    $data[$i]['value'] = $eachModel->id;
                    $i++;
                }
             }
        
        
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    
     public function actionSendmessages()
    {      
       
        
        //Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('messages');
    }
    
    
public function actionGetSendMessages()
    {



            $model=new Messaging();
            $draw   = $_POST['draw'];
            $offset = $_POST['start'];
            $limit  = $_POST['length'];
            $columns = array(
                            // datatable column index  => database column name

                           
                            0=>'t.id',
                           
            );
$user_id=Yii::app()->user->id;
//echo $user_id;exit;
            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder  = $_POST['order'][0]['dir'];
            $orderBy      = $filterColumn." ".$filterOrder;
            $condition = 't.message_from='.$user_id.' AND t.received= "N"';
           // $condition = 't.message_from='.$user_id;
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
          $searchString = $_POST['search']['value'];
          $condition="t.id LIKE '%".$searchString."%' OR user_id.first_name LIKE '%".$searchString."%' OR t.comments LIKE '%".$searchString."%'  ";
         // $condition = 't.message_from='.$user_id.' AND t.received= "N"';
         // $condition="file_no LIKE '%".$searchString."%'";
        }
            //$condition  = '1=1';
           
            $count = $model->with('user_id')->count(array('condition'=>$condition));
            $model = $model->with('user_id')->findAll(array('condition'=>$condition));

            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData=array();
            foreach ($model as $row)
            {
              $userr=User::model()->findbypk($row['message_to']);
               $name=$userr->first_name." ".$userr->last_name;
               // $userrclosed=User::model()->findbypk($row['closed_by']);
             // print_r($name);
                if($row['type'] == PO)
                {
                    $orderr=Purchase;
                }elseif($row['type'] == SO)
                {
                    $orderr=Sales;
                }else
                {
                    $orderr=Others;
                }
              $received=$row['received'];
              if($received == Y){
                  $receiveddate=date("d/m/Y h:i a", strtotime($row['received_datetime']));
                  
              }else
              {
               $receiveddate="Not Received" ;
              }
                         
                $rowData[]=array($row['id'],$name,$orderr,date("d/m/Y h:i a", strtotime($row['send_datetime'])),$row['comments'],$receiveddate,array('id' => $row['id'],'order_id' => $row['order_id']));



            }
            $data['data'] = $rowData;

            echo json_encode($data);

    }
    
     public function actionDetails()
    {
          $id = (int) Yii::app()->request->getParam('id');
       
       
        $modeldetails=new Messaging();
         $modeldetailsHistory= Messaging::model()->findAll(array('condition'=>'id='.$id,'order'=>'id DESC'));
          $model=PurchasingOrder::model()->findbypk($orderid);
       // $history= TrackingFile::model()->findAll(array('condition'=>'id='.$id));
        date_default_timezone_set("Asia/Dubai");
        $user  =Yii::app()->user->id;
        Messaging::model()->updateAll(array('received'=>'Y','received_datetime'=>date('Y-m-d H:i:s')),"id=".$id);

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false,'jquery-2.1.4.min.js' => false);
        $this->render('message_details', array('model' => $model,'modeldetails'=>$modeldetails,'id' => $id,'modeldetailsHistory'=>$modeldetailsHistory));
    }
   
}