<?php

class MasterlabourhoursController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'DeleteShift', 'Save', 'GetList', 'Getcurrency', 'UnBlockmasterlabourhours','Blockmasterlabourhours'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }

    public function actionGetList() {
          /* code added by Rahul v s
         * 04-05-2022
         * Fetch Data from erp_master_labour_hours
         */
        $model = new MasterLabourHours();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'task_duration_type',
            2 => 'task_duration',
            3 => 'task_duration_hour',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (task_duration_type LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $durationtype = array(1 => '1 Year', 2 => '1 Month', 3 => '1 Day', 4 => '1 Hour');
            $div = "";
           // if ($row->task_duration_type != 1) {
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["projects_mas_labour_hours_edit"])) {
                    $div = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'Masterlabourhours/create&id=' . $row['id'] . '\',\'Edit Labour Hour   \',\'lg\')"><i class="fa fa-edit"></i></button>';
                }
           // }

           if(isset(Yii::app()->user->havePermissionOn['projects_mas_labour_hours_disable']) ||  Yii::app()->user->authorised_user == 1)
                {

                  if ($row->isActive == "Y") 
                  {
                    $div .= ' <a href ="javascript:void(0);" class="btn btn-success btn-xs" onclick="disablemasterlabourhours(' . $row['id'] . ')"><i class="fa fa-toggle-on"></i></a>';
                  }
                  if ($row->isActive == 'N') 
                  {
                        $div .= ' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" onclick="enablemasterlabourhours(' . $row['id'] . ')"><i class="fa fa-ban"></i></a>';
                  }            
                
                }

            
            $rowData[] = array($m, 
            $durationtype[$row->task_duration_type], 
            $row['task_duration'],
             $row['task_duration_hour'], 
             '<div class="btn-wrap">' . $div . '</div>',
             $row['isActive'],
            
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasterLabourHours();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }


        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);

        $this->renderPartial('create', array('model' => $model), false, true);
    }

    public function actionSave() 
    {
        /* code added by Rahul v s
         * 04-05-2022
         * Add or update  Data from erp_master_labour_hours
         */
        $model = new MasterLabourHours;
        if (isset($_POST['MasterLabourHours'])) {
            if ((int) @$_POST['MasterLabourHours']['id'] > 0) {
                $model->id = (int) $_POST['MasterLabourHours']['id'];
                $model = $model->findByPK($model->id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->attributes = $_POST['MasterLabourHours'];
            if ($model->validate()) {
                $model->save();


                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
        Yii::app()->end();
    }


    public function actionBlockmasterlabourhours() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasterLabourHours::model()->updateByPK($id, array('isActive' => "N"));
             // inserting to audit log
             $model=new MasterLabourHours();
             $upt = $model->findByPk($id); // audit log changes
             AuditLog::saveAuditLogs(
                 'LABOURHOURS',
                 Yii::app()->user->id,
                 'BLOCKED',
                 " with name: - {$upt->task_duration_type}  "
             );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }

    public function actionUnBlockmasterlabourhours() {
        $id = $_POST['id'];
        if ($id > 0) {
            MasterLabourHours::model()->updateByPK($id, array('isActive' => "Y"));
             // inserting to audit log
             $model=new MasterLabourHours();
             $upt = $model->findByPk($id); // audit log changes
             AuditLog::saveAuditLogs(
                 'LABOURHOURS',
                 Yii::app()->user->id,
                 'UNBLOCKED',
                 " with name: - {$upt->task_duration_type}  "
             );
            // end audit log
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }


}
