<?php

class MastercompanyController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'SaveCompany', 'UploadProfilePhoto', 'CreateBankDetails', 'BankDetailsSave', 'GetBankDetailsList', 'DeleteBankDetails','CreateOwnerBankDetails'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionCreate() {
        $model = new MasCompany();
        $id = (int) Yii::app()->request->getParam('id');
        $id = 1;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }

        $modelCountry = MasCountry::model()->findAll();
        $countryList = CHtml::listData($modelCountry, 'id', 'country_name');
        
        
        $modelCurrency = MasCurrency::model()->findAll();
        $currencyList = CHtml::listData($modelCurrency, 'id', 'currency');
        
        

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false,'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('company-form', array('model' => $model, 'countryList' => $countryList, 'currencyList' => $currencyList), false, true);
    }

    public function actionSaveCompany() {
        $model = new MasCompany();
        /*         * ********** START Code for Save ************** */
        if (isset($_POST['MasCompany'])) {
            if ((int) @$_POST['MasCompany']['id'] > 0) {
                $model->id = (int) $_POST['MasCompany']['id'];
                $model = $model->findByPK($model->id);
                $model->crm_user_id = Yii::app()->user->id;
            } else {
                
            }
            $model->attributes = $_POST['MasCompany'];
            $model->company_logo = $_POST['Icon']['file'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['company-form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    
    public function actionCreateBankDetails(){
        
        $model = new OwnerBankDetails();
        //for country dropdown
        $modelCountry = MasCurrency::model()->findAll();
        $countryList = CHtml::listData($modelCountry, 'id', 'currency');
        
        //for bank dropdown
        $modelBank = MasBank::model()->findAll();
        $bankList = CHtml::listData($modelBank, 'id', 'bank_name');
        
        $id = (int) Yii::app()->request->getParam('id');
        
        if( $id > 0 ){
                $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false,'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('company_bank_details_form', array('model' => $model, 'currencyList' => $countryList, 'bankLIst' => $bankList), false, true);
    }
    
    public function actionBankDetailsSave(){
        
        $model=new OwnerBankDetails();
        
    	/************ START Code for Save ***************/
    	if (isset($_POST['OwnerBankDetails'])) {
    		
    		if ((int) @$_POST['OwnerBankDetails']['id'] > 0) {
                        $model->id = (int) $_POST['OwnerBankDetails']['id'];
                        $model = $model->findByPK($model->id);
                }else{
                }
                
            $model->attributes=$_POST['OwnerBankDetails'];
            if ($model->save())
                {
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['company_bank_details_form'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }

        }
        
    }
    
    public function actionGetBankDetailsList(){
        
        
        $model=new OwnerBankDetails();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'bank_account_name',
                   1 =>'bank_id',
                   2 =>'currency_id',
                   3 =>'bank_branch',
                   4 =>'bank_ac_no',
                   5 =>'bank_tax_id',
                   6 =>'bank_iban',
                   7 =>'bank_swift',
                   8 =>'bank_ifsc',
                   9 =>'bank_others',
                 
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition.=" and (bank_account_name LIKE '%".$searchString."%')";
                }
                $count = $model->with('bank')->count(array('condition'=>$condition));
                $model=$model->with('bank')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $rowData[]=array($m,$row['bank']['bank_name'],$row['bank_branch'],$row['bank_account_name'],$row['bank_ac_no'],$row['bank_ifsc'],$row['bank_tax_id'],$row['bank_swift'],$row['bank_iban'],
              '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'Mastercompany/CreateBankDetails&id='.$row['id'].'\',\'Edit Bank\',\'lg\');return false;"><i class="fa fa-pencil"></i></button> '
             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteBankDetails('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
        
    }
    
    
    public function actionDeleteBankDetails(){
     
        	$id = $_POST['id'];
                $model=new OwnerBankDetails();
                $model->deleteByPk($id);
                echo "success";
        
    }
    public function actionindex() {
        $model = new MasCompany();
        $id = (int) Yii::app()->request->getParam('id');
        $id = 1;
        if ($id > 0) {
            $model = $model->findByPk($id);
        }

        $modelCountry = MasCountry::model()->findAll();
        $countryList = CHtml::listData($modelCountry, 'id', 'country_name');
        
        
        $modelCurrency = MasCurrency::model()->findAll();
        $currencyList = CHtml::listData($modelCurrency, 'id', 'currency');
        
        

        //Yii::app()->clientScript->scriptMap = array('*jquery.js' => true, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false,'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('index', array('model' => $model, 'countryList' => $countryList, 'currencyList' => $currencyList), false, true);
    }
    public function actionCreateOwnerBankDetails(){
        
    $model = new MasCompanyBankDetails();
        //for country dropdown
        $modelCountry = MasCurrency::model()->findAll();
        $countryList = CHtml::listData($modelCountry, 'id', 'currency');
        
        //for bank dropdown
        $modelBank = MasBank::model()->findAll();
        $bankList = CHtml::listData($modelBank, 'id', 'bank_name');
        
        $id = (int) Yii::app()->request->getParam('id');
        
        if( $id > 0 ){
                $model = $model->findByPk($id);
        }
        
        $this->render('company_bank_details_form', array('model' => $model, 'currencyList' => $countryList, 'bankLIst' => $bankList), false, true);
    }
}
