<?php

class MasnotificationController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetNotificationList', 'Save', 'Delete', 'DirectAdd'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {

        $this->render('index');
    }

    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetNotificationList() {
        $model = new MasNotification();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'isActive',
            1 => 'notification_type',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1'; // 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition.=" and (notification_type LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
            if (Yii::app()->user->authorised_user == 1 ) {
                $div .= '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'Masnotification/create&id=' . $row['id'] . '\',\'Edit Notification Type\',\'lg\')"><i class="fa fa-pencil"></i></button>';
            }
            if (Yii::app()->user->authorised_user == 1 ) {
                $div .= '&nbsp;<a href ="#" class="btn btn-danger btn-xs" onclick="deleteNotification(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>';
            }
            $rowData[] = array($m, $row['notification_type'], '<div class="btn-wrap text-center">' . $div . '</div>');

            $m++;
        }


        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasNotification();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model), false, false);
    }

    public function actionSave() {
	
        $model = new MasNotification();
       
        if (isset($_POST['MasNotification'])) {
           
		 //  var_dump('ddddddd');
		  // die();

            if ((int) @$_POST['MasNotification']['id'] > 0) {
  
            
                $id = (int) @$_POST['MasNotification']['id'];
                $model = $model->findByPk($id);
               $notification = $model->findByPk($model->id);
            }
            $model->attributes = $_POST['MasNotification'];
            $model->notification_type = $_POST['MasNotification']['notification_type'];
            $model->isActive = $_POST['MasNotification']['isActive'];
           
            if ($model->save()) {

                    $jsonData['status'] = 'success';
             
                    echo CJSON::encode($jsonData);           
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }


    public function actionDelete() {

        $id = Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = new MasNotification();
            $model = $model->findByPk($id);
            $model->delete();
        }
    }

}
