<?php

class MasdocumenttypeController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveDocumenttype', 'Disable'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['mas_doc_type_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['mas_doc_type_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
    }

    // Uncomment the following methods and override them if needed

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
        $model = new MasDocumentType();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'document_type',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        // $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = " (document_type LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'document_type ASC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';
           
            $rowData[] = array($m,
                $row['document_type'],
                $row['isDefault'],               
                array('id' => $row['id'],'code'=>$row['document_type'], 'status' => $row->isActive),);

            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasDocumentType();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('document_type_form', array('model' => $model), false, false);
    }

    public function actionSaveDocumenttype() {
        $model = new MasDocumentType();
        if (isset($_POST['MasDocumentType'])) {
            
            if ((int) @$_POST['MasDocumentType']['id'] > 0) {
                
                $id = (int) @$_POST['MasDocumentType']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';  
            }else{
                $audit_type = 'CREATED';
            }
            if($_POST['MasDocumentType']['isDefault'] == "Y"){
                MasDocumentType::model()->updateAll(array( 'isDefault' => 'N' ), 'isDefault = "Y"' );
            }
            $model->isDefault = $_POST['MasDocumentType']['isDefault'];
            $model->attributes = $_POST['MasDocumentType'];
            $model->document_type = $_POST['MasDocumentType']['document_type'];
            if ($model->save()) {
                // inserting to audit log
				 AuditLog::saveAuditLogs(
                    'DOCUMENT_TYPE',
                    Yii::app()->user->id,
                    $audit_type,
                    " with type : - {$_POST['MasDocumentType']['document_type']}"
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['document_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
        public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasDocumentType();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
   
}
