<?php

class MasdocumentController extends Controller {

//	public function actionIndex()
//	{
//		$this->render('index');
//	}

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'deleteDocument', 'SaveDocument', 'GetList', 'DirectAdd' , 'Disable'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }

    public function actionGetList() {

        $model = new MasDocument();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'document_name',
            1 => 'renewal_remainder',
            2 => 'master_type',
            3 => 'document_type',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (document_name LIKE '%" . $searchString . "%' OR renewal_remainder LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            if ($row['id'] != '1') {
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_doc_type_edit']) || Yii::app()->user->authorised_user == 1) {
                    $button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'masdocument/create&id=' . $row['id'] . '\',\'Edit Document  \',\'md\')"><i class="fa fa-edit"></i></button>';
                }
                if (isset(Yii::app()->user->haveHrPermissionOn['hr_master_doc_type_delete']) || Yii::app()->user->authorised_user == 1) {
                    $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>';
                }
            }
            $type = "";
            $master_type =array('1'=>'Employee','2'=>'Company','3'=>'Vendor','4'=>'Partner');
            if ($row['document_type'] == '1') {
                $type = "With Date";
            } else if ($row['document_type'] == '2') {
                $type = "Without Date";
            }
            $rowData[] = array($m, $row['document_name'], $row['renewal_remainder'], $master_type[$row['master_type']],$type, array('id' => $row['id'], 'status' => $row->isActive));
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new MasDocument();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }


        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('document_form', array('model' => $model), false, true);
    }

    public function actionSaveDocument() {
        $model = new MasDocument();
        if (isset($_POST['MasDocument'])) {
            if ((int) @$_POST['MasDocument']['id'] > 0) {
                $id = (int) @$_POST['MasDocument']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['MasDocument'];
            $model->isActive = "Y";
            if ($model->save()) {
                //Updating Document Table
                if($model->document_type==1 && $model->master_type==1){
                   $model_documents= EmployeeDocuments::model()->findAll(array('condition' => 'document_id="'.$model->id.'"')); 
                   foreach ($model_documents as $key => $value) {
                       if($value->validate_till_date!='' && $value->validate_till_date!='0000-00-00'){
                            $remainder_date=$model->renewal_remainder;
                            $renew_on= date('Y-m-d', strtotime("-$remainder_date days", strtotime($value->validate_till_date)));      
                            EmployeeDocuments::model()->updateByPK($value->id, array('renew_on' => $renew_on));
                       }
                   }
                }
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'DOCUMENT', Yii::app()->user->id, $audit_type, " with name: - {$model->document_name}  "
                );
                // end audit log 
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actiondeleteDocument() {

        $id = $_POST['id'];
        if ($id > 0) {

            $model = new MasDocument();
            $del = $model->findByPk($id);
            $model->deleteByPk($id);
            // inserting to audit log
            AuditLog::saveAuditLogs(
                    'DOCUMENT', Yii::app()->user->id, 'DELETED', " with name: - {$del->document_name}  "
            );
            // end audit log 
            echo "success";
        } else {
            echo "fail";
        }
    }
        public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasDocument();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}
