<?php

class MascompanylevelController extends Controller
{
	 public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetCompanyLevelList',
                    'Create', 'GetCompanyLevelLis', 'DeleteCompanyLevel', 'SaveCompanyLevel', ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {

        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $this->render('index', array(), false, true);
    }

    public function actionCreate() {
       $model = new MasCompanyLevel();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model, 'id' => $id), false, true);
    }

  
    
    public function actionGetCompanyLevelList() {

        $model = new MasCompanyLevel();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(
            // datatable column index  => database column name

            
            0 => 'level_name',
        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = 't.isActive="Y"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition.=" AND (level_name LIKE '%" . $searchString . "%')";
        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_CompanyLevel_edit"])) {
                // $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'CompanyLevel/create&id='.$row['id'].'\',\'Edit User Group\',\'lg\')"><i class="fa fa-pencil"></i></button> ';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["admin_CompanyLevel_delete"])) {
                // $div .= '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteCompanyLevel('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
            }
            $rowData[] = array(
                $row['level_name'],
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'], 'code' => $row['level_name']));

            $m++;
        }


//      foreach ($model as $row)
//
//      {
//
//
//
//          $rowData[]=array($row['level_name'],'<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'CompanyLevel/create&id='.$row['id'].'\',\'Edit User Group\',\'lg\')"><i class="fa fa-pencil"></i></button> '
//             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteCompanyLevel('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
//                    $m++;
//
//      }

        $data['data'] = $rowData;

        echo json_encode($data);
    }

    public function actionDeleteCompanyLevel() {
        $id = $_POST['id'];
        $model = new MasCompanyLevel();
        $del = $model->findByPk($id);
        $model->deleteByPk($id);
        // inserting to audit log
        AuditLog::saveAuditLogs(
            'USER_GROUPS',
            Yii::app()->user->id,
            'DELETED',
            " with groupname: - {$del->level_name}  ",
            "",
            ""
        );
        echo "success";
    }

    public function actionSaveCompanyLevel() {

        $model = new MasCompanyLevel();
        /*         * ********** START Code for Save ************** */
        if (isset($_POST['MasCompanyLevel'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            if ((int) @$_POST['MasCompanyLevel']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $model->id = (int) $_POST['MasCompanyLevel']['id'];
                $model = $model->findByPK($model->id);
                $audit_type = 'UPDATED';
            }else{
                $audit_type = 'CREATED';
            }
           $model->attributes = $_POST['MasCompanyLevel'];

		$allPermissions = [];


		
		if (isset($_POST['MasCompanyLevel']['permissions'])) {
		  $permissions = $_POST['MasCompanyLevel']['permissions']; // this should contain your radio selection
		  $model->permissions = json_encode($permissions);
		} 


            if ($model->save()) {
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'MAS_COMPANY_LEVELS',
                    Yii::app()->user->id,
                    $audit_type,
                    " with levelname: - {$model->level_name}  ",
                    "",
                    ""
                );
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionhrcreate() {

        $model = new MasCompanyLevel();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('hr_CompanyLevel_form', array('model' => $model, 'id' => $id), false, true);
    }

    public function actionSaveHRCompanyLevel() {
        $model = new MasCompanyLevel();
        /*         * ********** START Code for Save ************** */
        if (isset($_POST['MasCompanyLevel'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            if ((int) @$_POST['MasCompanyLevel']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $model->id = (int) $_POST['MasCompanyLevel']['id'];
                $model = $model->findByPK($model->id);
                $model->scenario = 'update';
            }else {
                $model->scenario = 'add';
            }
            $model->level_name =$_POST['MasCompanyLevel']['level_name'];
            $allPermissions = array();
            foreach ($_POST['MasCompanyLevel']['permissions'] as $eachPermissionArray) {
                if (is_array($eachPermissionArray)) {
                    foreach ($eachPermissionArray as $eachPermission) {
                        $allPermissions[$eachPermission] = 1;
                    }
                }
            }
            $model->hr_permissions = json_encode($allPermissions);
            if(isset($_POST['MasCompanyLevel']['snapshot_tab_permission']) && count($_POST['MasCompanyLevel']['snapshot_tab_permission']) > 0){               
                $model->snapshot_tab_permission = implode(',',$_POST['MasCompanyLevel']['snapshot_tab_permission']);
            }else{
                $model->snapshot_tab_permission = "";
            }
            if(isset($_POST['MasCompanyLevel']['personal_tab_permission']) && count($_POST['MasCompanyLevel']['personal_tab_permission']) > 0){               
                $model->personal_tab_permission = implode(',',$_POST['MasCompanyLevel']['personal_tab_permission']);
            }else{
                $model->personal_tab_permission = "";
            }
            if(isset($_POST['MasCompanyLevel']['nominee_tab_permission']) && count($_POST['MasCompanyLevel']['nominee_tab_permission']) > 0){               
                $model->nominee_tab_permission = implode(',',$_POST['MasCompanyLevel']['nominee_tab_permission']);
            }else{
                $model->nominee_tab_permission = "";
            }
           if(isset($_POST['MasCompanyLevel']['contact_tab_permission']) && count($_POST['MasCompanyLevel']['contact_tab_permission']) > 0){               
                $model->contact_tab_permission = implode(',',$_POST['MasCompanyLevel']['contact_tab_permission']);
            }else{
                $model->contact_tab_permission = "";
            }
            if(isset($_POST['MasCompanyLevel']['document_tab_permission']) && count($_POST['MasCompanyLevel']['document_tab_permission']) > 0){               
                $model->document_tab_permission = implode(',',$_POST['MasCompanyLevel']['document_tab_permission']);
            }else{
                $model->document_tab_permission = "";
            }
            if(isset($_POST['MasCompanyLevel']['assets_tab_permission']) && count($_POST['MasCompanyLevel']['assets_tab_permission']) > 0){               
                $model->assets_tab_permission = implode(',',$_POST['MasCompanyLevel']['assets_tab_permission']);
            }else{
                $model->assets_tab_permission = "";
            }
            if(isset($_POST['MasCompanyLevel']['salary_tab_permission']) && count($_POST['MasCompanyLevel']['salary_tab_permission']) > 0){               
                $model->salary_tab_permission = implode(',',$_POST['MasCompanyLevel']['salary_tab_permission']);
            }else{
                $model->salary_tab_permission = "";
            } 
            if(isset($_POST['MasCompanyLevel']['loan_tab_permission']) && count($_POST['MasCompanyLevel']['loan_tab_permission']) > 0){               
                $model->loan_tab_permission = implode(',',$_POST['MasCompanyLevel']['loan_tab_permission']);
            }else{
                $model->loan_tab_permission = "";
            }
            if(isset($_POST['MasCompanyLevel']['bank_tab_permission']) && count($_POST['MasCompanyLevel']['bank_tab_permission']) > 0){               
                $model->bank_tab_permission = implode(',',$_POST['MasCompanyLevel']['bank_tab_permission']);
            }else{
                $model->bank_tab_permission = "";
            }
            if(isset($_POST['MasCompanyLevel']['eos_tab_permission']) && count($_POST['MasCompanyLevel']['eos_tab_permission']) > 0){               
                $model->eos_tab_permission = implode(',',$_POST['MasCompanyLevel']['eos_tab_permission']);
            }else{
                $model->eos_tab_permission = "";
            }
             if(isset($_POST['MasCompanyLevel']['other_tab_permission']) && count($_POST['MasCompanyLevel']['other_tab_permission']) > 0){               
                $model->other_tab_permission = implode(',',$_POST['MasCompanyLevel']['other_tab_permission']);
            }else{
                $model->other_tab_permission = "";
            }
             if(isset($_POST['MasCompanyLevel']['inout_doc_tab_permission']) && count($_POST['MasCompanyLevel']['inout_doc_tab_permission']) > 0){               
                $model->inout_doc_tab_permission = implode(',',$_POST['MasCompanyLevel']['inout_doc_tab_permission']);
            }else{
                $model->inout_doc_tab_permission = "";
            }
             if(isset($_POST['MasCompanyLevel']['issue_doc_tab_permission']) && count($_POST['MasCompanyLevel']['issue_doc_tab_permission']) > 0){               
                $model->issue_doc_tab_permission = implode(',',$_POST['MasCompanyLevel']['issue_doc_tab_permission']);
            }else{
                $model->issue_doc_tab_permission = "";
            }
            if(isset($_POST['MasCompanyLevel']['training_tab_permission']) && count($_POST['MasCompanyLevel']['training_tab_permission']) > 0){               
                $model->training_tab_permission = implode(',',$_POST['MasCompanyLevel']['training_tab_permission']);
            }else{
                $model->training_tab_permission = "";
            }
            if(isset($_POST['MasCompanyLevel']['notes_tab_permission']) && count($_POST['MasCompanyLevel']['notes_tab_permission']) > 0){               
                $model->notes_tab_permission = implode(',',$_POST['MasCompanyLevel']['notes_tab_permission']);
            }else{
                $model->notes_tab_permission = "";
            }
            if(isset($_POST['MasCompanyLevel']['leave_tab_permission']) && count($_POST['MasCompanyLevel']['leave_tab_permission']) > 0){               
                $model->leave_tab_permission = implode(',',$_POST['MasCompanyLevel']['leave_tab_permission']);
            }else{
                $model->leave_tab_permission = "";
            }
            if(isset($_POST['MasCompanyLevel']['level_tab_permission']) && count($_POST['MasCompanyLevel']['level_tab_permission']) > 0){               
                $model->level_tab_permission = implode(',',$_POST['MasCompanyLevel']['level_tab_permission']);
            }else{
                $model->level_tab_permission = "";
            }
            if(isset($_POST['MasCompanyLevel']['qualification_tab_permission']) && count($_POST['MasCompanyLevel']['qualification_tab_permission']) > 0){               
                $model->qualification_tab_permission = implode(',',$_POST['MasCompanyLevel']['qualification_tab_permission']);
            }else{
                $model->qualification_tab_permission = "";
            }
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    
    public function actionCopyCompanyLevel() {

        $model = new MasCompanyLevel();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('CompanyLevel_copy_form', array('model' => $model, 'id' => $id,'type' => 'Copy'), false, true);
    }

    public function actionSaveCopyCompanyLevel() {
        
        $model = new MasCompanyLevel();
        $type = $_POST['type'];
        if (isset($_POST['MasCompanyLevel'])) {
            $id=$_POST['MasCompanyLevel']['id'];
            if($type=="Copy"){
              $id=0;
            }
            
           
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            if ($id > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $model->id = (int) $_POST['MasCompanyLevel']['id'];
                $model = $model->findByPK($model->id);
                $audit_type = 'UPDATED';
            }else{
                $audit_type = 'CREATED';
                $model->hr_permissions ='{}';
            }
            $model->attributes = $_POST['MasCompanyLevel'];
            $model->level_name = $_POST['MasCompanyLevel']['level_name'];
            $model->qtn_approval_val_limit = $_POST['MasCompanyLevel']['qtn_approval_val_limit'];
            $model->order_approval_val_limit = $_POST['MasCompanyLevel']['order_approval_val_limit'];
            $model->purchase_order_approval_val_limit = $_POST['MasCompanyLevel']['purchase_order_approval_val_limit'];
            $model->min_profit_percentage = $_POST['MasCompanyLevel']['min_profit_percentage'];
            $allPermissions = array();
            foreach ($_POST['MasCompanyLevel']['permissions'] as $eachPermissionArray) {
                if (is_array($eachPermissionArray)) {
                    foreach ($eachPermissionArray as $eachPermission) {
                        $allPermissions[$eachPermission] = 1;
                    }
                }
            }
            $model->permissions = json_encode($allPermissions);
            if ($model->save()) {
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'USER_GROUPS',
                    Yii::app()->user->id,
                    $audit_type,
                    " with groupname: - {$model->level_name}  ",
                    "",
                    ""
                );
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

}
