<?php

class MasInventoryTypeController extends Controller
{

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','Create', 'GetList', 'SaveInventoryType', 'Disable'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
    {
        $this->render('inventory_type_index');
    }

    // Uncomment the following methods and override them if needed

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList()
    {
        $model = new MasInventoryType();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];

        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'type_name',

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
      //  $condition = 't.isActive="Y"';
        
         $condition = '1=1';
        
        
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (type_name LIKE '%" . $searchString . "%' OR type_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $div = '';

       

            $rowData[] = array(
                $m,
                $row['type_name'],
                '<div class="btn-wrap text-center">' . $div . '</div>',
                array('id' => $row['id'], 'description' => $row['type_name'], 'status' => $row->isActive),
            );

            $m++;
        }


        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
      
        $model = new MasInventoryType();
        
         
           
        $id = (int)Yii::app()->request->getParam('id');
        
           
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
       
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('inventory_type_form', array('model' => $model), false, false);
    }

    public function actionSaveInventoryType()
    {
        $model = new MasInventoryType();

        if (isset($_POST['MasInventoryType'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d h:i:s');
            if ((int)@$_POST['MasInventoryType']['id'] > 0) {

                $id = (int)@$_POST['MasInventoryType']['id'];
                $model = $model->findByPk($id);

                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('Y-m-d h:i:s');

                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
            }
            $model->attributes = $_POST['MasInventoryType'];

            $model->type_name = $_POST['MasInventoryType']['type_name'];


            if ($model->save()) {


                //inserting to audit log

                AuditLog::saveAuditLogs(
                    'MasInventoryType',
                    Yii::app()->user->id,
                    $audit_type,
                    " with id : - {$model->id}"
                );
                // end audit log


                $jsonData['status'] = 'success';
              //  $jsonData['frm'] = $_POST['type_form'];
              //  $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }




    public function actionDisable()
    {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasInventoryType();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y") ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}
