<?php

class ManagementinfoController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails', 'LoadPurchase', 'LoadInventory',
                    'loadhr', 'deadstock', 'loadothers', 'LoadFinance', 'TopTenCustomer', 'TopTenVendor', 'TopTenItem','GetExpiredProducts'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'loadsales'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionLoadsales() {
        $this->render('sales');
    }

    public function actionLoadPurchase() {
        $this->render('purchase');
    }

    public function actionLoadInventory() {
        $this->render('inventory');
    }

    public function actionloadhr() {
        $this->render('hr');
    }

    public function actiondeadstock() {
        $this->renderPartial('inventory_death_stock', $_POST);
    }

    public function actionloadothers() {
        $this->renderPartial('others');
    }

    public function actionLoadFinance() {
        $this->renderPartial('finance');
    }

    public function actionTopTenCustomer() {
        $this->renderPartial('current_year_top_customer', $_POST);
    }

    public function actionTopTenVendor() {
        $this->renderPartial('current_year_top_vendor', $_POST);
    }
    public function actionTopTenItem(){
        $this->renderPartial('current_year_top_item', $_POST);
    }
    public function actionGetExpiredProducts(){
         $this->renderPartial('inventory_monthly_expired_item', $_POST);
    }
    

}
