<?php

class InvoiceController extends Controller
{


    public $layout = 'layout';
    public $title = "Invoice";

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'PrintInvoiceReportPDF',
                    'GetInvoiceList',
                    'Create',
                    'createInvoice',
                    'SaveInvoice',
                    'UploadDocumentInv',
                    'GetDocumentList',
                    'DeleteDocument',
                    'SetFile',
                    'GetFileDetails',
                    'PrintInvoiceReportWoHPDF',
                    'GetFiles',
                    'Getfileno',
                    'GetInvoiceDetails',
                    'PrintVatInvoiceReportPDF',
                    'PrintInvoiceReportPDF_other',
                    'Getunitdrop',
                    'View',
                    'Documentupload',
                    'PrintPos',
                    'ExchangeInvoice',
                    'SaveExchange',
                    'GetunitRate',
                    'changepaymentterm',
                    'Savepaymentterm',
                    'test',
                    'Getinvoicedetails',
                    'AddPayments',
                    'SaveInvoicePayments',
                    'getinvoiceCount',
                    'CreateadvanceInvoice',
                    'saveadvanceinvoice'

                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }


    public function filters()
    {
        return array('accessControl'); // perform access control for CRUD operations
    }


    public function actionIndex()
    {
        $frm = (int) Yii::app()->request->getParam('frm');

        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn['sales_menu_view']) &&
                isset(Yii::app()->user->havePermissionOn['invoice_view']) &&
                Yii::app()->user->havePermissionOn['sales_menu_view'] &&
                Yii::app()->user->havePermissionOn['invoice_view']
            )
        ) {
            $this->render('index', array('frm' => $frm));
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }

    public function actionGetInvoiceList()
    {
        $model = new Invoice();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $frm = $_POST['frm'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.id',
            2 => 't.order_id',
            3 => 't.invoice_date',
            4 => 'customer.customer_name',
            5 => 'leadowner.first_name',
            6 => 't.total_tax_amount',
            7 => 't.currency_id',
            8 => 't.grand_total',
            9 => 't.total_tax_amount',
            10 => 't.received_cash_amount',
            11 => 't.received_card_amount',
            12 => 't.receipt_type',
            13 => 't.id',
            14 => 't.id',
            15 => 't.id',
            16 => 't.created_datetime'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';

        if (!isset(Yii::app()->user->havePermissionOn["invoice_view_all"]) && Yii::app()->user->level > 3) {
            $condition .= ' AND (t.lead_owner_id= "' . Yii::app()->user->id . '" OR file.lead_owner_id="' . Yii::app()->user->id . '")';
        } else {
            $condition = 't.isActive="Y" AND t.lead_owner_id= "' . Yii::app()->user->id . '"';
        }
        //user_level=3 means branch head. SO need to see all items in branch--added on 24/01/23 --start
        if (!isset(Yii::app()->user->havePermissionOn["invoice_view_all"]) && Yii::app()->user->level == 3) {
            $condition .= ' AND (t.warehouse_id= "' . Yii::app()->user->user_warehouse_id . '")';
        }
        if ($_POST['invoice_date_from'] != '' && $_POST['invoice_date_to'] != '') {
            $invoice_start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['invoice_date_from'])));
            $invoice_end_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['invoice_date_to'])));
            $condition .= ' AND (invoice_date>="' . $invoice_start_date . '" AND invoice_date<="' . $invoice_end_date . '")';
        }

        if ($_POST['invoice_type'] != '') {
            $condition .= ' AND posted="' . $_POST['invoice_type'] . '"';
        }
        if ($_POST['warehouse_id'] != '') {
            $condition .= ' AND t.warehouse_id="' . $_POST['warehouse_id'] . '"';
        }

        if ($_POST['invoice_lead_owner'] != '') {
            $condition .= ' AND t.lead_owner_id="' . $_POST['invoice_lead_owner'] . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND ( t.invoice_no LIKE '%" . $searchString . "%'  OR customer.customer_name LIKE '%" . $searchString . "%' OR file.file_title LIKE '%" . $searchString . "%' OR t.file_id LIKE '%" . $searchString . "%' OR t.order_id LIKE '%" . $searchString . "%' OR invoice_status LIKE '%" . $searchString . "%')";
        }

        $count = $model->with('customer', 'file', 'leadowner', 'currencyname', 'warehouse')->count(array('condition' => $condition));
        $model = $model->with('customer', 'file', 'leadowner', 'warehouse')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $status = '';
        foreach ($model as $row) {
            $div = '';
            $balance = 0.00;
            $creditnote = Creditnote::model()->find(array('condition' => 'invoice_id = ' . $row['id']));
            ($creditnote->id > 0) ? $cn_state = 'Credit Note' : $cn_state = 'Invoice';
            //Max invoice id
            $model_max_invoice = Invoice::model()->find(array('select' => 'max(id) as id', 'condition' => 'order_id ="' . $row['order_id'] . '"'));
            $show_invoice_cancel = 'N';

            if ($model_max_invoice->id == $row['id']) {
                $show_invoice_cancel = 'Y';
            }

            $rowData[] = array(
                $row['file_id'],
                $row['invoice_no'],
                $row['order_id'],
                date("d/m/Y", strtotime($row['invoice_date'])),
                $row['customer']['customer_name'],
                $row['leadowner']['fullName'],
                $row['currency']['currency_code'],
                Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'], ""),
                Yii::app()->numberFormatter->formatCurrency($row['grand_total'], ""),
                Yii::app()->numberFormatter->formatCurrency(($row['grand_total'] * $row['exchange_rate']), ""),
                $cn_state,//$row->created_user,
                array(
                    'id' => $row['id'],
                    'customer_id' => $row['customer_id'],
                    'warehouse_name' => $row['warehouse']['warehouse_name'],
                    'is_direct_invoice' => $row['is_direct_invoice'],
                    'invoice_status' => $row['invoice_status'],
                    'posted' => $row['posted'],
                    'show_invoice_cancel' => $show_invoice_cancel,
                    'project_id' => $row['project_id'],
                    'created_by' => $row['created_by'],
                )
            );
        }


        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetfileno()
    {
        $searchTerm = trim($_GET['term']);
        $condition = 'ready_to_invoice = "Y" AND invoiced="N" AND status!="CN" AND ( file_id LIKE "%' . $searchTerm . '%" OR id LIKE "%' . $searchTerm . '%" OR order_id LIKE "%' . $searchTerm . '%") ';
        $model = DeliveryNote::model()->findAll(array('condition' => $condition, 'limit' => 200));
        foreach ($model as $i => $eachModel) {
            $data[$i]['value'] = $eachModel->file_id;
            $data[$i]['label'] = 'File : ' . $eachModel->file_id . ' DNote :' . $eachModel->id . ' Order : ' . $eachModel->order_id;
            $data[$i]['address'] = $eachModel->billing_address;
            $data[$i]['currency'] = $eachModel->order->currencyname->currency;
            $data[$i]['currency_id'] = $eachModel->order->currencyname->id;
            $data[$i]['exchangerate'] = $eachModel->order->currencyname->exchange_rate;
            $data[$i]['payment_term'] = $eachModel->order->payment_terms;
            $data[$i]['customer_id'] = $eachModel->customer_id;
            $data[$i]['customer_name'] = $eachModel->customer->customer_name;
            $data[$i]['contact_id'] = $eachModel->contact_id;
            $data[$i]['contact_name'] = $eachModel->order->customercontact->person_name;
            $data[$i]['customer_name'] = $eachModel->customer->customer_name;
            $data[$i]['sales_group'] = $eachModel->order->sales_group;
            $data[$i]['orderid'] = $eachModel->order_id;
            $data[$i]['other'] = $eachModel->order->paymentTerm->payment_terms;
            $data[$i]['msg'] = $eachModel->customer->lead_owner_id;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionGetunitdrop()
    {
        $row = $_POST['row_field'];
        $product = $_POST['product_id'];
        $type = $_POST['type'];
        $selling_price = $_POST['selling_price'];
        $drop = array();
        $modelInvItem = new InvoiceItem;
        $modUOM = new UnitOfMeasurement();
        if ((int) $product > 0) {
            $arr_uom = $modUOM->getSecondaryBaseUnitWithName((int) $product);
            $modelInvItem->unit_id = $arr_uom->id;
            $drop['drop'] = CHtml::activedropdownlist($modelInvItem, "[" . $row . "]unit_id", $modUOM->getUnits((int) $product), array('class' => 'unit go', 'onchange' => 'checkUnitItem(this.id);'));
            if (!empty($arr_uom)) {
                $drop['factor'] = $arr_uom->factor;
                $drop['selling_price'] = ($selling_price * $arr_uom->factor);
            } else {
                $drop['factor'] = 1;
                $drop['selling_price'] = $selling_price;
            }
        }
        echo CJSON::encode($drop);
    }

    public function actionGetunitRate()
    {
        $product_id = (int) $_POST['product_id'];
        $unit_id = (int) $_POST['unit'];
        $selling_price = $_POST['selling_price'];
        $drop = array();
        if ($product_id > 0) {
            $arr_price_list = SalesPriceGroup::model()->find(array('condition' => 'product_id=' . $product_id));
            $arr_uom = UnitOfMeasurement::model()->findByPK($unit_id);

            /* $pricing_condition = 'product_id=' . $product_id . ' AND uom_id=' . (int) $unit_id;
              $arr_price_list = SalesPriceGroup::model()->find(array('condition' => $pricing_condition)); */

            $drop['factor'] = $arr_uom->factor;
            if (!empty($arr_price_list->sales_price) && (int) $arr_price_list->sales_price > 0) {
                $drop['selling_price'] = number_format(($arr_price_list->sales_price), 2);
            } else {
                $drop['selling_price'] = 0.00;
            }
        }
        echo CJSON::encode($drop);
    }

    public function actionSaveInvoice()
    {

        $valid = true;
        $valid1 = true;

        if (isset($_POST['Invoice'])) {

            $modelCompanySettings = new MasCompanySettings();
            $condition = 'crm_company_id = ' . (int) Yii::app()->user->master_user_company_id;
            $modelCompanySettings = $modelCompanySettings->find(array('condition' => $condition));
            $stock_lock_flag = $modelCompanySettings->stock_lock_flag;
            if ($stock_lock_flag == "N") {

                $modelInvoice = new Invoice;
                $others = array();
                $update = 0;
                $warehouse_id = (int) Yii::app()->user->getState('user_warehouse_id');

                if ((int) $_POST['Invoice']['id'] > 0) {
                    $modelInvoice = $modelInvoice->findByPK($_POST['Invoice']['id']);
                    $modelInvoice->updated_by = Yii::app()->user->id;
                    $modelInvoice->updated_datetime = date('Y-m-d H:i:s');
                    $update = 1;
                } else {
                    $modelInvoice->created_by = Yii::app()->user->id;
                    $modelInvoice->created_datetime = date('Y-m-d H:i:s');
                    $update = 0;
                }
                $modelInvoice->attributes = $_POST['Invoice'];
                if ($_POST['Invoice']['invoice_date'] != '00/00/0000') {
                    $modelInvoice->invoice_date = str_replace('/', '-', $_POST['Invoice']['invoice_date']);
                    $modelInvoice->invoice_date = date("Y-m-d", strtotime($modelInvoice->invoice_date));
                } else {
                    $modelInvoice->invoice_date = '';
                }
                $grand_total = $total_vat_amount = 0;
                if ($update == 0) {
                    $modelInvoice->grand_total = 0;
                    $modelInvoice->file_id = 0;
                }

                //$modelInvoice->order_id = 0;
                $modelInvoice->terms_and_conditions = $_POST['Invoice']['terms_and_conditions'];
                //code added by abin on 24-01-2024 to get the quotes id
                $modelInvoice->quotes_id = $_POST['Invoice']['quotes_id'];
                $modelInvoice->order_id = $_POST['Invoice']['order_id'];
                $modelInvoice->payment_terms_id = $_POST['Invoice']['payment_terms'];
                $modelInvoice->invoice_type = $_POST['Invoice']['invoice_type'];
                $modelInvoice->currency_id = $_POST['Invoice']['currency_id'];
                $modelInvoice->remarks = $_POST['Invoice']['remarks'];
                $modelInvoice->billing_address = $_POST['Invoice']['billing_address'];
                $modelInvoice->invoice_status = $_POST['Invoice']['invoice_status'];
                $modelInvoice->added_from = 'W';
                $modelInvoice->is_direct_invoice = 'N';
                $modelInvoice->warehouse_id = $warehouse_id;
                $modelInvoice->payment_terms_id = (int) $_POST['Invoice']['payment_terms_id'];
                $modelInvoice->terms_id = (int) $_POST['Invoice']['terms_id'];
                $modelInvoice->terms_and_conditions = $_POST['Invoice']['terms_and_conditions'];
                $modelInvoice->project_id = (int) $_POST['Invoice']['project_id'];
                $modelInvoice->lead_owner_id = (int) $_POST['Invoice']['lead_owner_id'];
                $modelInvoice->contact_id = (int) $_POST['Invoice']['contact_id'];
                if ((int) $_POST['Invoice']['order_id'] <= 0) {
                    $modelInvoice->is_direct_invoice = 'Y';
                }

                //code added by mereena on 12/01/2024
                $modelInvoice->total_discount_percentage = $_POST['Invoice']['total_discount_percentage'];
                $modelInvoice->total_discount_amount = $_POST['Invoice']['total_discount_amount'];

                /* if ((int)$modelInvoice->project_classification_id <=0) {
              $others[] = 'Project Classification cannot be blank!!';
              $valid1 = false;
              } */

                //$modelInvoice->contract_id = (int) $_POST['Invoice']['contract_id'];

                $valid = $modelInvoice->validate();

                //   ---------------------AccAuditClose check------------------------------------

                $invoice_datex = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['Invoice']['invoice_date'])));

                $modelAccAuditClose = new AccAuditClose();
                $existing_date = strtotime($modelAccAuditClose->lastCloseddate());
                $invoice_date = strtotime($invoice_datex);
                if ($invoice_date <= $existing_date) {
                    $valid = false;
                    $others[] = ' Given Invoice date must be Greater than Audit Close Date :-' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';
                }
                //   --------------------//-AccAuditClose check------------------------------------


                $total_net_amount = 0;
                $groups = array();
                if (is_array($_POST['InvoiceItem'])) {
                    foreach ($_POST['InvoiceItem'] as $i => $item) {
                        if ($item['product_id'] != '') {
                            $modelInvoiceItems[$i] = new InvoiceItem;
                            if ($item['id'] > 0) {
                                $modelInvoiceItems[$i] = $modelInvoiceItems[$i]->findByPk($item['id']);
                                $modelInvoiceItems[$i]->updated_by = (int) $_POST['Invoice']['created_by'];
                                $modelInvoiceItems[$i]->updated_datetime = date('Y-m-d H:i:s');
                            } else {
                                $modelInvoiceItems[$i]->created_by = (int) $_POST['Invoice']['created_by'];
                                $modelInvoiceItems[$i]->created_datetime = date('Y-m-d H:i:s');
                            }
                            $modelInvoiceItems[$i]->attributes = $item;
                            $modelInvoiceItems[$i]->invoice_id = 0;
                            if ((float) $item['rate'] <= 0) {
                                $others[] = 'Rate should be greater than zero';
                                $valid = false;
                            }
                            $modelUOM = UnitOfMeasurement::model()->findByPk((int) $item['unit_id']);
                            $item_actual_rate = $item['actual_rate'];
                            if (isset($modelUOM->factor) && (int) $modelUOM->factor > 0 && (int) $item_actual_rate > 0) {
                                $item_actual_rate = ($item['actual_rate'] * $modelUOM->factor);
                            }
                            if (!isset(Yii::app()->user->havePermissionOn['edit_selling_price'])) {
                                if ((float) $item['rate'] < (float) $item_actual_rate) {
                                    $others[] = 'Rate should be greater than or equal to ' . (float) $item_actual_rate . ' [' . $item['part_no'] . ']';
                                    $valid = false;
                                }
                            }
                            //if ((int) $item['quantity'] <= 0) {
                            if ($item['quantity'] <= 0) {
                                $others[] = 'Quantity should be greater than zero';
                                $valid = false;
                            }
                            $modelInvoiceItems[$i]->description = $item['description'];
                            //code added by abin on 24-01-2024 
                            $modelInvoiceItems[$i]->quotes_item_id = $item['quotes_item_id'];
                            $modelInvoiceItems[$i]->order_item_id = $item['order_item_id'];

                            $modelInvoiceItems[$i]->amount = $item['rate'] * $item['quantity'];

                            $discount_amount = 0;
                            /* if((int)$item['deduction_percentage']>0){
                          $discount_amount =  ($item['rate'] * $item['quantity'])*((int)$item['deduction_percentage']/100);
                          } */
                            if ((int) $item['deduction_amount'] > 0) {
                                $modelInvoiceItems[$i]->deduction_amount = $item['deduction_amount'];
                                $modelInvoiceItems[$i]->deduction_percentage = ($item['deduction_amount'] * 100) / ($item['rate'] * $item['quantity']);
                            } else {
                                $modelInvoiceItems[$i]->deduction_amount = $discount_amount;
                            }
                            $modelInvoiceItems[$i]->net_amount = ((float) $item['rate'] * (float) $item['quantity']) - (float) $item['deduction_amount'];
                            $modelInvoiceItems[$i]->unit_id = $item['unit_id'];
                            $store = new Store();
                            $store = $store->findByPk((int) $item['product_id']);
                            $modelInvoiceItems[$i]->cost_rate = $store->rate;
                            $modelInvoiceItems[$i]->brand_class_id = $store->brand_class_id;
                            $modelInvoiceItems[$i]->product_generic_name = $store->generic_id;
                            $modelInvoiceItems[$i]->picked_qty = $item['quantity'];
                            $total_net_amount += $item['net_amount'];
                            $grand_total += $item['net_amount'] + $item['tax_vat_amount'];
                            $total_vat_amount += $item['tax_vat_amount'];
                            $valid = $modelInvoiceItems[$i]->validate() && $valid;

                            /* check whether product in user warehouse stock */
                            $modelUOM = UnitOfMeasurement::model()->findByPk((int) $item['unit_id']);
                            $key = $item['product_id'];
                            if (!array_key_exists($key, $groups)) {
                                if ($item['quantity'] && $modelUOM->factor) {
                                    $qty = $item['quantity'] * $modelUOM->factor;
                                }
                                $groups[$key] = array(
                                    'id' => $item['product_id'],
                                    'quantity' => $qty,
                                    'unit_id' => $item['unit_id']
                                );
                            } else {
                                $groups[$key]['quantity'] = $groups[$key]['quantity'] + ($item['quantity'] * $modelUOM->factor);
                            }
                            /* check whether product in user warehouse stock */
                        }
                    }
                }



                $modwarehouse = new MasInventoryWarehouse();
                $warehouse_name = $modwarehouse->getWarehouseName((int) $warehouse_id);
                // if (!empty($groups)) {
                if (!empty($groups) && $modelInvoice->is_direct_invoice == 'Y') {
                    foreach ($groups as $key => $eachProduct) {
                        $availble_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty FROM `erp_stock_ledger` WHERE product_id=' . $eachProduct['id'] . ' AND warehouse_id=' . (int) $warehouse_id)->queryScalar();
                        $store = new Store();
                        $store = $store->findByPk((int) $eachProduct['id']);
                        $modelUOM = new UnitOfMeasurement();
                        $base_unit_name = $modelUOM->getBaseunitname((int) $eachProduct['id']);
                        // $store->inventory_item_type 2 is service items.
                        if ($eachProduct['quantity'] > $availble_qty && $store->inventory_item_type != 2) {
                            $others[] = $store['part_number'] . ' maximum sellable qty : ' . number_format($availble_qty, 2) . ' ' . $base_unit_name;
                            $valid = false;
                        }
                    }
                }

                if ($valid && !empty($modelInvoiceItems) && $valid1) {

                    $modelCompanySettings = new MasCompanySettings();
                    $modelCompanySettings = $modelCompanySettings->find(array('condition' => 'crm_company_id=' . (int) Yii::app()->user->master_user_company_id));


                    //code added by mereena on 11/11/2022 to get current series no
                    $modelWarehouse = new MasInventoryWarehouse();

                    $modelMaster = MasterFile::model()->findByPk($_POST['Invoice']['file_id']);
                    if (empty($modelMaster)) {
                        $modelMaster = new MasterFile();
                        $modelMaster->customer_id = $_POST['Invoice']['customer_id'];
                        $modelMaster->start_from = "I";

                        $modelMaster->crm_user_id = (int) $_POST['Invoice']['created_by'];
                        $modelMaster->lead_owner_id = (int) $_POST['Invoice']['created_by'];
                        $modelMaster->file_title = "";
                        $modelMaster->is_approved = "Y";
                        $modelMaster->approved_by = (int) $_POST['Invoice']['created_by'];
                        $modelMaster->date_of_approval = date('Y-m-d');
                        $modelMaster->created_by = (int) $_POST['Invoice']['created_by'];
                        $modelMaster->created_datetime = date('Y-m-d H:i');
                    }
                    $modelMaster->current_process_status = "I";
                    $modelMaster->updated_by = (int) $_POST['Invoice']['created_by'];
                    $modelMaster->updated_datetime = date('Y-m-d H:i');
                    $modelMaster->save(false);
                    $modelMaster->refresh();
                    $file_id = (int) $modelMaster->id;
                    $modelInvoice->file_id = $file_id;
                    $modelInvoice->save();

                    if (!empty($modelInvoiceItems)) {
                        foreach ($modelInvoiceItems as $eachItem) {
                            $eachItem->invoice_id = $modelInvoice->id;
                            $eachItem->save(false);

                            if ($modelInvoice->order_id <= 0) {
                                //StockLedger    
                                $modelStockLedger = new StockLedger();
                                $modelStockLedger->file_id = $file_id;
                                $modelStockLedger->header_id = $modelInvoice->id;
                                $modelStockLedger->header_item_id = (int) $eachItem->id;
                                $modelStockLedger->customer_vendor_id = $modelInvoice->customer_id;
                                $modelStockLedger->customer_vendor_name = $_POST['Invoice']['customer_name'];
                                $modelStockLedger->product_id = $eachItem->product_id;
                                $modelStockLedger->product_name = $eachItem->product->part_number;
                                $modelStockLedger->product_description = $eachItem->product->description;
                                $modelStockLedger->brand_id = $eachItem->product->brand_class_id;
                                $modelStockLedger->brand_name = $eachItem->product->brand_detail->brand_name;
                                // $modelStockLedger->warehouse_id = $warehouse_id;
                                // $modelStockLedger->warehouse_name = $warehouse_name;
                                $modelRack = new MasInvRack();
                                $modelStockLedger->rack_id = $modelRack->getDefaultRackId();
                                $modelStockLedger->rack_name = $modelRack->getRackName((int) $modelStockLedger->rack_id);
                                $modelBin = new MasInvBin();
                                $modelStockLedger->bin_id = $modelBin->getDefaultBinId();
                                $modelStockLedger->bin_name = $modelBin->getBinName((int) $modelStockLedger->bin_id);
                                $modelStockLedger->unit_id = $eachItem->unit_id;
                                $modelStockLedger->unit_name = $modelUOM->name;
                                $modelStockLedger->unit_factor = $modelUOM->factor;
                                $modelStockLedger->quantity = -1 * $eachItem->quantity;
                                $modelStockLedger->available_status = 'U';
                                $modelStockLedger->buying_price = 0;
                                $modelStockLedger->batch_no = '';
                                $modelStockLedger->serial_no = '';
                                $modelStockLedger->manufacturing_date = '0000-00-00';
                                $modelStockLedger->expiry_date = '0000-00-00';
                                $modelStockLedger->cost_price = $eachItem->product->rate;
                                $modelStockLedger->sales_price = $eachItem->rate * $modelUOM->factor;
                                $modelStockLedger->transaction_date = $modelInvoice['invoice_date'];
                                $modelStockLedger->transaction_from = 'INVOICE';
                                $modelStockLedger->transaction_type = "OUT";
                                $modelStockLedger->stock_updated = 'Y';
                                $modelStockLedger->created_by = (int) Yii::app()->user->id;
                                $modelStockLedger->created_date = date("Y-m-d H:i:s");
                                $modelStockLedger->save(false);
                            }
                        }
                    }


                    $commision_amount = 0;
                    $commision_percentage = 0;
                    if (isset($modelCompanySettings->calculate_commission) && $modelCompanySettings->calculate_commission == 'Y' && (int) $_POST['Invoice']['created_by'] > 0) {

                        $created_by = (int) $_POST['Invoice']['created_by'];
                        $modelUser = new User();
                        $modelUser = $modelUser->findByPk($created_by);
                        $commision_percentage = (float) $modelUser->commission;
                        $commision_amount = 0;
                        if ((int) $commision_percentage > 0) {
                            $commision_amount = ($grand_total * $commision_percentage) / 100;
                        }
                    }

                    //check setting for invoice no generation

                    $invoice_no = $modelInvoice->id;


                    //end



                    $modelInvoice->updateByPk($modelInvoice->id, array('invoice_no' => $invoice_no, 'file_id' => $file_id, 'total_tax_amount' => $total_vat_amount, 'net_amount' => $total_net_amount, 'grand_total' => $grand_total/*, 'commision_percentage' => $commision_percentage, 'commision_amount' => $commision_amount*/));

                    $modelStockLedger = new StockLedger();
                    $modelStockLedger->updateAll(array('reference_id' => $modelInvoice->id, 'reference_no' => $invoice_no), 'header_id IN("' . $_POST['Invoice']['delivery_ids'] . '")');

                    if ((int) $modelInvoice->id > 0) {
                        AuditLog::saveAuditLogs(
                            'INVOICE',
                            Yii::app()->user->id,
                            'CREATED',
                            " with id: - {$modelInvoice->id}  "
                        );
                        // end audit log
                    }
                    // -------------------------------------
                    /*      Yii::import('application.modules.accounts.controllers.PostingController');
                    $from = 'directsales';
                    PostingController::DirectPostSales((int)$modelInvoice->id, $from, $_POST['AccVoucherItems']);
                     */

                    // ---------------------------------------------------------------


                    $jsonData['status'] = 'success';
                    $jsonData['invoice_id'] = $modelInvoice->id;
                    echo CJSON::encode($jsonData);
                } else {
                    $error1 = array();
                    $error2 = array();
                    $error1 = json_decode(CActiveForm::validate($modelInvoice, '', false), true);
                    if (!empty($modelInvoiceItems[0]->product_id)) {
                        $error2 = json_decode(CActiveForm::validateTabular($modelInvoiceItems, '', false), true);
                    } else {
                        $error2[] = "Please add atleast one line item";
                    }

                    $error = CJSON::encode(array_merge_recursive($error1, $error2, $others));

                    if ($error != '[]') {
                        echo $error;
                    }
                }
            } else {
                echo CJSON::encode(array('error' => ' Transactions are already locked!'));
            }
        } else {
            echo 'error';
        }
    }

    public function actionSetFile($file_id = 0)
    {
        Yii::app()->session['file_id'] = ($file_id == 0) ? (int) Yii::app()->request->getParam('file_id') : $file_id;
        if (isset($_POST['needed_model'])) {
            $jsonData = $this->getFileDetails(Yii::app()->session['file_id'], $_POST['needed_model']);
            echo CJSON::encode($jsonData);
        }
    }

    public function actionCreate()
    {


        $model = new Invoice();
        $id = Yii::app()->request->getParam('id');
        $order_id = (int) Yii::app()->request->getParam('order_id');
        $file_id = (int) Yii::app()->request->getParam('file_id');
        $type = Yii::app()->request->getParam('type');
        $modelItems = array(new InvoiceItem);
        $modelInvItem = new InvoiceItem;
        $receipt_list = array(new AccVoucherItems);
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelItems = $modelInvItem->model()->findAll(array('condition' => 'invoice_id="' . $id . '"'));
            if (empty($modelItems)) {
                $modelItems = array(new InvoiceItem());
            }

            $condition = 'parent.is_posted="Y" AND t.amount != 0 AND parent.voucher_type=8 AND parent.transaction_id ="' . $id . '"   ';
            $modelAccVoucherItems = new AccVoucherItems();
            $receipt_list = $modelAccVoucherItems->with('parent')->findAll(array('condition' => $condition, 'order' => 't.id  ASC'));


            if (empty($receipt_list)) {
                $receipt_list = array(new AccVoucherItems);
            }
        }

        if ($order_id > 0) { //convert from quote to order
            $modelorder = Order::model()->findByPK($order_id);
            $modelmasterfile = MasterFile::model()->findByPk($file_id);
            $model->file_id = $modelorder->file_id;
            $model->customer_id = $modelorder->file->customer_id;
            $model->order_id = $modelorder->id;
            $order_date = $modelorder->order_date;
            $order_date = date("d/m/Y", strtotime($order_date));
            $model->order_date = $order_date;
            $model->billing_address = $modelorder->billing_address;
            $model->shipping_address = $modelorder->shipping_address;
            $model->contact_id = $modelorder->contact_id;
            $model->sales_group = $modelorder->sales_group;
            $model->notes = $modelorder->notes;
            $model->terms_and_conditions = $modelorder->terms_and_conditions;
            $model->reference = $modelorder->lpo;
            $model->others = $modelorder->others;
            $model->ticket_id = $modelorder->ticket_id;
            $model->currency = $modelorder->currency;
            $model->exchange_rate = $modelorder->exchange_rate;
            $model->payment_terms_id = $modelorder->payment_terms;
            $model->remarks = $modelorder->remarks;
            $model->terms_id = $modelorder->terms_id;
            $model->project_id = $modelorder->project_classification_id;
            $model->contract_id = $modelorder->contract_id;
            $model->inco_term_id = $modelorder->inco_term_id;
            $model->total_discount_percentage = $modelorder->total_discount_percentage;
            $model->total_discount_amount = $modelorder->total_discount_amount;
            $modelItems = OrderItem::model()->findAll(array('condition' => 'order_id=' . $modelorder->id));
            $invs = Invoice::model()->with('items')->findAll(array('condition' => 'file_id=' . $modelorder->file_id, 'order' => 'items.id ASC'));
            foreach ($modelItems as $i => $eachItem) {
                $modelInvoiceItems[$i] = new InvoiceItem;
                $modelInvoiceItems[$i]->product_id = $eachItem->product_id;
                $modelInvoiceItems[$i]->description = $eachItem->description;
                $modelInvoiceItems[$i]->quantity = $eachItem->quantity;
                $modelInvoiceItems[$i]->rate = $eachItem->rate;
                $modelInvoiceItems[$i]->unit_id = $eachItem->unit_id;
                $modelInvoiceItems[$i]->amount = $eachItem->amount;
                $modelInvoiceItems[$i]->addition_percentage = $eachItem->addition_percentage;
                $modelInvoiceItems[$i]->addition_amount = $eachItem->addition_amount;
                $modelInvoiceItems[$i]->deduction_percentage = $eachItem->deduction_percentage;
                $modelInvoiceItems[$i]->deduction_amount = $eachItem->deduction_amount;
                $modelInvoiceItems[$i]->net_amount = $eachItem->net_amount;
                $modelInvoiceItems[$i]->tax_vat_percentage = $eachItem->tax_vat_percentage;
                $modelInvoiceItems[$i]->tax_vat_amount = $eachItem->tax_vat_amount;
                $modelInvoiceItems[$i]->net_per_item = $eachItem->net_amount / $eachItem->quantity;

                foreach ($invs as $eachInvItems) {
                    if ($eachInvItems->items[$i]->product_id == $eachItem->product_id) {
                        $modelInvoiceItems[$i]->quantity = $modelInvoiceItems[$i]->quantity - $eachInvItems->items[$i]->quantity;
                        $modelInvoiceItems[$i]->amount = $modelInvoiceItems[$i]->quantity * $modelInvoiceItems[$i]->rate;
                        $modelInvoiceItems[$i]->net_amount = $modelInvoiceItems[$i]->amount + $modelInvoiceItems[$i]->addition_amount - $modelInvoiceItems[$i]->deduction_amount;
                    }
                }
            }
            $modelItems = $modelInvoiceItems;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model, 'modelInvoiceItems' => $modelItems, 'type' => $type, 'receipt_list' => $receipt_list));
    }

    public function actionGetDocumentList()
    {
        $model = new Document();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.document_name',
            2 => 't.created_by',
            3 => 't.created_datetime',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" and t.file_id = "' . $_POST['file_id'] . '" and uploaded_from = "I"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (document_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));
            if (isset(Yii::app()->user->havePermissionOn['invoice_document']) || Yii::app()->user->authorised_user == 1) {
                $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a> &nbsp;';
            }
            $button_string .= '<a href ="' . Yii::app()->createUrl('lead/downloaddocument&id=' . $row['id']) . '" class=" btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';
            $rowData[] = array($m, $row['document_name'], $model2->username, date("d/m/Y h:m:s", strtotime($row['created_datetime'])), '<div class="btn-wrap text-center">' . $button_string . '</div>');

            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionDeleteDocument()
    {
        $id = $_POST['id'];
        $modelDocument = new Document();
        $model_doc = Document::model()->findbyPK($id);
        $document_details = explode(',', $model_doc->document_name);
        foreach ($document_details as $value) {
            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $value;
            unlink($path);
        }
        $modelDocument->deleteByPk($id);
        echo "success";
    }

    public function actionPrintInvoiceReportPDF()
    {
        $model = new Invoice();
        $id = Yii::app()->request->getParam('id');
        $model_Invoice = Invoice::model()->findByPk($id);
        $c_id = Yii::app()->request->getParam('c_id');
        $frm = Yii::app()->request->getParam('frm');
        $barcode = Yii::app()->request->getParam('barcode');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        if ($model_Invoice->invoice_status == 'C') {
            $mPDF1->SetWatermarkText('CANCELLED');
            $mPDF1->showWatermarkText = true;
        }

        /* $mPDF1->SetWatermarkImage('images/watermark.jpg');
          $mPDF1->showWatermarkImage = true; */
        if ($id > 0)
            $model = Invoice::model()->findByPk($id);
        $page_title = $id . '-I-' . $model->customer->customer_name . '.pdf';

        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        if ($frm == 'tax') { //new invoice for ace//part number
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.invoice_list_individual_tax', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title, 'barcode' => $barcode, 'mpdf' => $mPDF1), true));
        } else {
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.invoice_list_individual', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title, 'barcode' => $barcode, 'mpdf' => $mPDF1), true));
        }

        $mPDF1->Output($page_title, 'I');
    }

    function decimalHours($time)
    {
        $hms = explode(":", $time);
        return round($hms[0] + ($hms[1] / 60) + ($hms[2] / 3600), 2);
    }

    public function actionGetinvoicedetails()
    {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];

        $warehouse_id = (int) Yii::app()->user->getState('user_warehouse_id');
        if ((int) Yii::app()->user->authorised_user != 1 && $warehouse_id > 0) {
            $condition = 'invoice_status="Y" AND warehouse_id=' . Yii::app()->user->user_warehouse_id;
        } else {
            $condition = 'invoice_status="Y"';
        }

        $condition = 'invoice_no like "%' . $searchTerm . '%" or file_id like "%' . $searchTerm . '%"';

        // $model = Invoice::model()->findAll(array('condition' =>$condition));

        $modelinvoice = new Invoice();
        $model = $modelinvoice->findAll(array('select' => 't.currency_id,t.invoice_no,t.id,t.file_id', 'condition' => $condition, 'limit' => 200));

        $i = 0;
        $data = array();
        foreach ($model as $eachModel) {
            $data[$i]['label'] = $eachModel->file_id . ' : ' . $eachModel->invoice_no;
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['file_id'] = $eachModel->file_id;
            $data[$i]['invoice_id'] = $eachModel->id;

            $i++;
        }

        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actioncreateInvoice()
    {
        $model = new Invoice();
        $id = (int) Yii::app()->request->getParam('id');
        $delivery_id = (int) Yii::app()->request->getParam('delivery_id');
        $file_id = (int) Yii::app()->request->getParam('file_id');
        $modelItems = array(new InvoiceItem);
        $grand_total_old = 0;
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelOrderItems = InvoiceItem::model()->findAll(array('condition' => 'invoice_id="' . $id . '"'));
            if (empty($modelOrderItems)) {
                $modelOrderItems = array(new InvoiceItem);
            }
        }
        if ($delivery_id > 0) {
            $modelorder = DeliveryNote::model()->findByPK($delivery_id);
            $model->file_id = $modelorder->file_id;
            //CODE ADDED BY ABIN ON 24/01/2024 
            $model->quotes_id = $modelorder->quotes_id;
            $model->customer_id = $modelorder->customer_id;
            $model->order_id = $modelorder->order_id;
            $model->delivery_ids = $modelorder->id;
            $model->billing_address = $modelorder->billing_address;
            $model->contact_id = $modelorder->contact_id;
            $model->sales_group_id = $modelorder->order->sales_group_id;
            $order_date = $modelorder->order->order_date;
            $order_date = date("d/m/Y", strtotime($order_date));
            //$model->order_date = $order_date;
            $SQL = "select SUM(net_amount) as net from  erp_order_item WHERE order_id =" . $modelorder->order->id;
            $arr_sum_amount1 = Yii::app()->db->createCommand($SQL)->queryAll();
            $grand_total_old = $arr_sum_amount1[0]['net'];
            $model->notes = $modelorder->notes;
            $model->reference = $modelorder->lpo;
            $model->lead_owner_id = Order::model()->findBypk($modelorder->order_id)->lead_owner_id;
            $model->currency_id = $modelorder->order->currency_id;
            $model->exchange_rate = (float) $modelorder->order->exchange_rate;
            $model->payment_terms_id = $modelorder->order->payment_terms_id;
            $model->remarks = $modelorder->remarks;
            $model->terms_and_conditions = Order::model()->findBypk($modelorder->order_id)->terms_and_conditions;//$modelorder->terms_and_conditions;
            $model->terms_id = $modelorder->terms_id;
            $model->total_tax_amount = $modelorder->order->total_tax_amount;
            $model->invoice_type = $modelorder->order->invoice_type_id;
            $model->project_id = $modelorder->order->project_id;


            //code added by mereena on 13/11/2023
            $model->total_discount_percentage = $modelorder->order->total_discount_percentage;
            $model->total_discount_amount = $modelorder->order->total_discount_amount;

            // $modelItems=DeliveryNoteItem::model()->findAll(array('condition'=>'delivery_note_id='.$modelorder->id,'order' => 'id ASC'));
            $modelItems = Order::model()->findbyPk($modelorder->order->id);


            foreach ($modelItems->items as $i => $eachItem) {
                $delivery = DeliveryNoteItem::model()->find(array('condition' => 'order_item_id = ' . $eachItem->id . ' AND delivery_note_id=' . $delivery_id));
                //          if ($delivery->picked_qty > 0 || $delivery->picked_bonus_qty > 0 || $eachItem->product->inventory_item_type == 2) {
                if ($delivery->picked_qty > 0 || $eachItem->product->inventory_item_type == 2) {

                    $modelInvoiceItems[$i] = new InvoiceItem;
                    $modelInvoiceItems[$i]->product_id = $eachItem->product_id;
                    $modelInvoiceItems[$i]->quotes_item_id = $eachItem->quotes_item_id;
                    $modelInvoiceItems[$i]->order_item_id = $eachItem->id;
                    $modelInvoiceItems[$i]->description = $eachItem->description;
                    $modelInvoiceItems[$i]->quantity = $delivery->picked_qty;
                    /*if ($eachItem->product->inventory_item_type == 2)
                        $modelInvoiceItems[$i]->quantity = 1;*/
                    $modelInvoiceItems[$i]->unit_id = $eachItem->product->unit_id;
                    $modelInvoiceItems[$i]->rate = $eachItem->rate;
                    $modelInvoiceItems[$i]->amount = $delivery->picked_qty * $eachItem->rate;
                    if (strpos($eachItem->addition_percentage, '%') !== false) {
                        $modelInvoiceItems[$i]->addition_percentage = $eachItem->addition_percentage;
                    } else {
                        if ($eachItem->quantity > 0 && $eachItem->addition_percentage > 0) {
                            $modelInvoiceItems[$i]->addition_percentage = ($eachItem->addition_percentage / $eachItem->quantity) * $delivery->picked_qty;
                        }
                    }
                    if ($eachItem->quantity > 0) {
                        $modelInvoiceItems[$i]->addition_amount = ($eachItem->addition_amount / $eachItem->quantity) * $delivery->picked_qty;
                    } else {
                        $modelInvoiceItems[$i]->addition_amount = ($eachItem->addition_amount) * $delivery->picked_qty;
                    }
                    if (strpos($eachItem->deduction_percentage, '%') !== false) {
                        $modelInvoiceItems[$i]->deduction_percentage = $eachItem->deduction_percentage;
                    } else {
                        if ($eachItem->quantity > 0 && $eachItem->deduction_percentage > 0) {
                            $modelInvoiceItems[$i]->deduction_percentage = ($eachItem->deduction_percentage / $eachItem->quantity) * $delivery->picked_qty;
                        }
                    }
                    if ($eachItem->quantity > 0) {
                        $modelInvoiceItems[$i]->deduction_amount = ($eachItem->deduction_amount / $eachItem->quantity) * $delivery->picked_qty;
                    } else {
                        $modelInvoiceItems[$i]->deduction_amount = ($eachItem->deduction_amount) * $delivery->picked_qty;
                    }
                    $modelInvoiceItems[$i]->net_amount = ($modelInvoiceItems[$i]->quantity * $modelInvoiceItems[$i]->rate) + $modelInvoiceItems[$i]->addition_amount - $modelInvoiceItems[$i]->deduction_amount;
                    $eachItem->tax_vat_percentage = $eachItem->product->tax->percentage;
                    $modelInvoiceItems[$i]->tax_vat_percentage = $eachItem->tax_vat_percentage;
                    $modelInvoiceItems[$i]->tax_vat_amount = ((($delivery->picked_qty * $eachItem->rate) + $eachItem->addition_amount - $eachItem->deduction_amount) * $eachItem->tax_vat_percentage) / 100;
                }
            }
            $modelAdd = OrderAddition::model()->findAll(array('condition' => 'order_id=' . $modelorder->order_id));
            if (empty($modelAdd)) {
                $modelAdd = array(new OrderAddition);
            }
            $modelDed = OrderDeduction::model()->findAll(array('condition' => 'order_id=' . $modelorder->order_id));
            if (empty($modelDed)) {
                $modelDed = array(new OrderDeduction);
            }
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array(
            'model' => $model,
            'file_id' => $model->file_id,
            'modelInvoiceItems' => $modelInvoiceItems,
            'modelAdd' => $modelAdd,
            'modelDed' => $modelDed,
            'grand_total_old' => $grand_total_old,
            'delivery_id' => $delivery_id
        ));


    }


    public function actionAddPayments()
    {

        $invoice_id = Yii::app()->request->getParam('id');
        $file_id = (int) Yii::app()->request->getParam('file_id');
        if ((int) $invoice_id > 0) {
            $modelInvoice = new Invoice();
            $modelInvoice = $modelInvoice->findByPk($invoice_id);


            $condition = 't.amount != 0 AND parent.voucher_type = 8 AND parent.transaction_id = ' . $invoice_id . ' AND t.payment_mode_id > 0';
            $modelAccVoucherItems = new AccVoucherItems();
            $receipt_list = $modelAccVoucherItems->with('parent', 'paymentmode')->findAll(array(
                'condition' => $condition,
                'order' => 't.id ASC',
            ));
            if (empty($receipt_list)) {
                $receipt_list = array(new AccVoucherItems);
            }
        }



        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('add_invoice_payments', array('modelInvoice' => $modelInvoice, 'receipt_list' => $receipt_list));
    }

    public function actionSaveInvoicePayments()
    {

        $invoice_id = $_POST['Invoice']['id'];
        $customer_id = $_POST['Invoice']['customer_id'];

        $modelInvoicePayments = $other = [];
        $valid = true;
        $modelInvoice = new Invoice();
        $modelInvoice = $modelInvoice->findByPk($invoice_id);
        if ($modelInvoice->posted == 'N') {
            if ($modelInvoice->payment_complete_status == 'N') {

                if ((is_array($_POST['InvoicePayments']))) {

                    $total_amount = 0;
                    foreach ($_POST['InvoicePayments'] as $i => $item) {
                        $modelInvoicePayments[$i] = new InvoicePayments();
                        if ((int) $item['id'] > 0) {
                            $modelInvoicePayments[$i] = $modelInvoicePayments[$i]->findByPk($item['id']);
                            $modelInvoicePayments[$i]->updated_by = Yii::app()->user->id;
                            $modelInvoicePayments[$i]->updated_datetime = date('Y-m-d h:i:s');
                        } else {
                            $modelInvoicePayments[$i]->created_by = Yii::app()->user->id;
                            $modelInvoicePayments[$i]->created_datetime = date('Y-m-d h:i:s');
                        }
                        $modelInvoicePayments[$i]->invoice_id = $invoice_id;
                        $modelInvoicePayments[$i]->customer_id = $customer_id;
                        $modelInvoicePayments[$i]->attributes = $item;
                        if ($item['cheque_date'] != '00/00/0000') {
                            $modelInvoicePayments[$i]->cheque_date = date("Y-m-d", strtotime(str_replace('/', '-', $item['cheque_date'])));
                        } else {
                            $modelInvoicePayments[$i]->cheque_date = '';
                        }

                        $modelAccPaymentMode = AccPaymentMode::model()->findByPk($item['payment_type_id']);
                        if ($modelAccPaymentMode) {
                            $name = $modelAccPaymentMode->mode;
                            $fieldsToCheck = [
                                'Bank Name' => ['status' => $modelAccPaymentMode->bank_name, 'value' => $item['bank_name']],
                                'Card No' => ['status' => $modelAccPaymentMode->card_no, 'value' => $item['card_no']],
                                'Cheque No' => ['status' => $modelAccPaymentMode->cheque_no, 'value' => $item['cheque_no']],
                                'Cheque Date' => ['status' => $modelAccPaymentMode->cheque_date, 'value' => $item['cheque_date']],
                                'Reference No' => ['status' => $modelAccPaymentMode->reference_no, 'value' => $item['reference_no']],
                            ];

                            foreach ($fieldsToCheck as $fieldName => $fieldData) {
                                if ($fieldData['status'] == "Y" && empty($fieldData['value'])) {
                                    $valid = false;
                                    $other[] = "$fieldName cannot be blank for payment type $name.";
                                }
                            }
                        } else {
                            $valid = false;
                            $other[] = "Invalid payment type selected.";
                        }
                        if ((float) $item['amount'] > 0) {
                            $total_amount += $item['amount'];
                        }
                        $valid = $valid && $modelInvoicePayments[$i]->validate();
                    }
                }
                if ((float) $total_amount !== (float) round($modelInvoice->grand_total, 2)) {
                    $valid = false;
                    $other[] = 'Payments Total Must Be Equal To Invoice Amount';
                }
            } else {
                $valid = false;
                $other[] = 'Payment Completed';
            }
        } else {
            $valid = false;
            $other[] = 'Posted To Accounts';
        }



        if ($valid) {
            // InvoicePayments::model()->deleteAll('invoice_id=:refer_id', array(':refer_id' => $invoice_id));
            if (!empty($modelInvoicePayments)) {
                foreach ($modelInvoicePayments as $eachModel) {
                    $eachModel->save(false);
                }
            }
            $modelInvoice = new Invoice();
            $modelInvoice->updateByPk($invoice_id, array('payment_complete_status' => 'Y'));
            /////////////////post to accounts ---start//////////////////
            /* Yii::import('application.modules.accounts.controllers.PostingController');
              $from = 'sales';
              PostingController::DirectPost((int)$invoice_id, $from); */
            ///////////////////post to accounts --end///////////////////////
            $jsonData['status'] = 'success';
            $jsonData['id'] = $invoice_id;
            echo CJSON::encode($jsonData);
        } else {
            $error1 = array();
            $error2 = [];
            if ($modelInvoice->payment_complete_status == 'N') {
                if (!empty($modelInvoicePayments)) {
                    $error2 = json_decode(CActiveForm::validateTabular($modelInvoicePayments, '', false), true);
                } else {
                    $error2[] = "Please add atleast one line item";
                }
            }
            $error = CJSON::encode(array_merge_recursive($error1, $error2, $other));
            if ($error != '[]') {
                echo $error;
            }
        }
    }
    public function actionGetinvoiceCount()
    {
        $filter = Yii::app()->request->getPost('filter');

        $model = new Invoice();

        $qty = 0;
        $total = 0;
        $extra_years = [];
        $current_year = date('Y');

        // Helper function to get date range for filter and year offset
        $getDateRange = function ($filter, $yearOffset = 0) {
            $targetDate = strtotime("-{$yearOffset} year");
            $year = date('Y', $targetDate);

            switch ($filter) {
                case 'today':
                    $date = date('Y-m-d', $targetDate);
                    return [$date, $date, $year];

                case 'yesterday':
                    $date = date('Y-m-d', strtotime('-1 day', $targetDate));
                    return [$date, $date, $year];

                case 'this_month':
                    $month = date('m');
                    $start = "{$year}-{$month}-01";
                    $end = date('Y-m-t', strtotime($start));
                    return [$start, $end, $year];

                case 'this_year':
                    return ["{$year}-01-01", "{$year}-12-31", $year];

                case 'this_week':
                    $monday = date('Y-m-d', strtotime("monday this week", $targetDate));
                    $sunday = date('Y-m-d', strtotime("sunday this week", $targetDate));
                    return [$monday, $sunday, $year];

                case 'last_week':
                    $monday = date('Y-m-d', strtotime("monday last week", $targetDate));
                    $sunday = date('Y-m-d', strtotime("sunday last week", $targetDate));
                    return [$monday, $sunday, $year];

                case 'quarterly':
                    $month = date('n', $targetDate); // 1-12
                    if ($month >= 1 && $month <= 3) {
                        $start = "$year-01-01";
                        $end = "$year-03-31";
                    } elseif ($month >= 4 && $month <= 6) {
                        $start = "$year-04-01";
                        $end = "$year-06-30";
                    } elseif ($month >= 7 && $month <= 9) {
                        $start = "$year-07-01";
                        $end = "$year-09-30";
                    } else {
                        $start = "$year-10-01";
                        $end = "$year-12-31";
                    }
                    return [$start, $end, $year];

                default:
                    return [null, null, null];
            }
        };

        // Step 1: Get current period range
        list($startDate, $endDate, $current_year) = $getDateRange($filter, 0);

        if (!$startDate || !$endDate) {
            echo CJSON::encode(['status' => 'error', 'message' => 'Invalid filter']);
            Yii::app()->end();
        }

        // Step 2: Fetch current data
        $condition = 'invoice_date >= :startDate AND invoice_date <= :endDate';
        $params = [':startDate' => $startDate, ':endDate' => $endDate];

        if (!(Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["invoice_view_all"])) {
            $condition .= ' AND t.lead_owner_id = :leadOwnerId';
            $params[':leadOwnerId'] = Yii::app()->user->id;
        }

        $invoices = $model->findAll($condition, $params);
        $qty = count($invoices);
        foreach ($invoices as $row) {
            $total += $row->grand_total * $row->exchange_rate;
        }

        // Step 3: Fetch previous 2 years
        for ($i = 1; $i <= 2; $i++) {
            list($prevStart, $prevEnd, $yearLabel) = $getDateRange($filter, $i);

            $conditionPrev = 'invoice_date >= :startDate AND invoice_date <= :endDate';
            $paramsPrev = [':startDate' => $prevStart, ':endDate' => $prevEnd];

            if (!(Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["invoice_view_all"])) {
                $conditionPrev .= ' AND t.lead_owner_id = :leadOwnerId';
                $paramsPrev[':leadOwnerId'] = Yii::app()->user->id;
            }

            $prevInvoices = $model->findAll($conditionPrev, $paramsPrev);
            $prevQty = count($prevInvoices);
            $prevTotal = 0;

            foreach ($prevInvoices as $row) {
                $prevTotal += $row->grand_total * $row->exchange_rate;
            }

            $extra_years[] = [
                'year' => $yearLabel,
                'qty' => $prevQty,
                'total' => $prevTotal,
                'date' => in_array($filter, ['today', 'yesterday'])
                    ? date('d-m-Y', strtotime($prevStart))
                    : null,
            ];
        }

        // Final output
        echo CJSON::encode([
            'status' => 'success',
            'data' => [
                'qty' => $qty,
                'total' => $total,
                'current_period' => in_array($filter, ['today', 'yesterday'])
                    ? date('d-m-Y', strtotime($startDate))
                    : $current_year,
                'previous_years' => $extra_years,
            ]
        ]);
        Yii::app()->end();
    }

    public function actionUploadDocumentInv()
    {
        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $folder = Yii::getPathOfAlias('webroot') . '/' . $_GET['folder'] . '/'; // target folder
        $allowedExtensions = array("jpg", "png", "doc", "docx", "xls", "xlsx", "pdf", "bmp", "jpeg");
        $sizeLimit = 1 * 1024 * 1024; // 1MB limit

        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);

        if ($result['success']) {
            $originalFile = $result['filename'];
            $extension = pathinfo($originalFile, PATHINFO_EXTENSION);
            $datePrefix = date('Y-m-d') . '-';

            $newFileName = $datePrefix . $originalFile;
            $oldPath = $folder . $originalFile;
            $newPath = $folder . $newFileName;

            if (file_exists($oldPath)) {
                rename($oldPath, $newPath);
            }

            $result['filename'] = $newFileName;
            $result['fileType'] = strtolower($extension);
        }

        echo htmlspecialchars(json_encode($result), ENT_NOQUOTES);
    }
    public function actionCreateadvanceInvoice()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $model_invoice = new Invoice();
        $modelInvoiceItems = array(new InvoiceItem());
        $model = Order::model()->findByPk($id);
        $model_order_items = OrderItem::model()->findAll(array('condition' => 'order_id="' . $id . '"', 'order' => 'id ASC'));
        $invoice_type = $model->invoice_type_id;
        $model_invoice_type = MasInvoiceType::model()->findByPk($invoice_type);
        $tax_percentage = 0;
        if ($model_invoice_type->tax == 'Y') {
            $tax_percentage = $model_order_items[0]->tax_vat_percentage;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create_invoice_advance', array('model' => $model, 'model_invoice' => $model_invoice, 'modelInvoiceItems' => $modelInvoiceItems, 'model_order_items' => $model_order_items, 'tax_percentage' => $tax_percentage));
    }
    public function actionSaveadvanceInvoice()
    {
        $others = array();
        if (isset($_POST['Invoice'])) {
            $modelInvoice = new Invoice;
            $modelInvoice->attributes = $_POST['Invoice'];
            $modelInvoice->customer_id = $_POST['Invoice']['customer_id'];
            $modelInvoice->contact_id = $_POST['Invoice']['contact_id'];
            $modelInvoice->order_id = $_POST['Invoice']['order_id'];
            $modelInvoice->delivery_ids = "";
            $modelInvoice->invoice_date = (count(explode('/', $_POST['Invoice']['invoice_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['Invoice']['invoice_date']))) : date('Y-m-d');
            $modelInvoice->remarks = $_POST['Invoice']['remarks'];
            $modelInvoice->notes = $_POST['Invoice']['notes'];
            $modelInvoice->notes = $_POST['Invoice']['notes'];
            $modelInvoice->terms_and_conditions = $_POST['Invoice']['terms_and_conditions'];
            $modelInvoice->billing_address = $_POST['Invoice']['billing_address'];
            $modelInvoice->created_by = Yii::app()->user->id;
            $modelInvoice->created_datetime = date('Y-m-d H:i:s');
            $modelInvoice->project_id = 0;

            $valid = $modelInvoice->validate();
            //Invoice Item

            $grand_total = 0;
            foreach ($_POST['InvoiceItem'] as $i => $item) {
                $modelItem[$i] = new InvoiceItem;
                $modelItem[$i]->attributes = $item;
                $store = new Store();
                $store = $store->findByPk((int) $item['product_id']);
                $modelItem[$i]->brand_class_id = $store->brand_class_id;
                $modelItem[$i]->product_generic_name = $store->generic_id;
                $modelItem[$i]->cost_rate = $store->rate;
                $modelItem[$i]->picked_qty = $item['quantity'];
                $modelItem[$i]->unit_id = $item['unit_id'];
                $modelItem[$i]->created_by = Yii::app()->user->id;
                $modelItem[$i]->created_datetime = date('Y-m-d H:i:s');
                $valid = $modelItem[$i]->validate() && $valid;
            }


            if ($valid) {
                $modelInvoice->is_direct_invoice = 'Y';
                $modelInvoice->advance_invoice = 'Y';
                $modelInvoice->save();
                //Invoice Item
                $total_vat_amount = $total_net_amount = $grand_total = 0;
                foreach ($modelItem as $eachItem) {
                    $eachItem->invoice_id = $modelInvoice->id;
                    $eachItem->save(false);
                    $total_vat_amount += (float) $eachItem['tax_vat_amount'];
                    $total_net_amount += (float) $eachItem['net_amount'];
                    $grand_total += (float) $eachItem['net_amount'] + (float) $eachItem['tax_vat_amount'];
                }


                $invoice_no = $modelInvoice->id;
                $modelInvoice->updateByPk($modelInvoice->id, array('invoice_no' => $invoice_no, 'total_tax_amount' => $total_vat_amount, 'net_amount' => $total_net_amount, 'grand_total' => $grand_total));


                //Audit Log
                AuditLog::saveAuditLogs(
                    'ADVANCE_INVOICE',
                    Yii::app()->user->id,
                    'CREATED',
                    " with ID: - {$modelInvoice->id}  "
                );
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error1 = array();
                $error2 = array();
                $error1 = json_decode(CActiveForm::validate($modelInvoice, '', false), true);
                if (!empty($modelItem[0]->product_id)) {
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                } else {
                    $error2[] = "Please add atleast one line Service Item";
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $others));

                if ($error != '[]') {
                    echo $error;
                }
            }
        }
    }



}
