<?php

class InventoryuploadController extends Controller
{



    public function accessRules()
    {

        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'DownloadInventoryListFormat',
                    'SaveUploadInventoryList',
                    'upload',
                    'DownloadErrorCsv',
                    'uploadStock'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users$model
                'users' => array('*'),
            ),
        );
    }

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex()
    {
        $model = new Store();
        $inventory_item_type = (int) Yii::app()->request->getParam('inventory_item_type');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('upload_index', array('model' => $model, 'inventory_item_type' => $inventory_item_type), false, false);
    }


    public function actionDownloadInventoryListFormat()
    {
        $filename = 'inventoryupload_list.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        //  echo "Part No,Bar Code,Description,Brand,Category,Unit,Kitchen Location,Sales Price,Quantity,Unit Price\n";
        echo "Part No,Description,Unit,Quantity,Unit Price\n";
        Yii::app()->end();
    }
    public function actionSaveUploadInventoryList()
    {
        $file_name = Yii::app()->request->getParam('filename');

        $inventory_item_type = Yii::app()->request->getParam('inventory_item_type');

        $url = Yii::app()->basePath . '/../upload/inventoryuploadlist_csv/' . $file_name;
        $inventory_list = $this->readInventoryListCSV("upload/inventoryuploadlist_csv/" . $file_name);
        $error_url = Yii::app()->basePath . '/../upload/inventoryuploadlist_csv/error/' . $file_name;

        $error_list = [];
        $error_occurred = false;
        $hasQuantityGreaterThanZero = false;  // Flag to check if any row has quantity > 0

        // Read the header row separately to preserve it in the log
        $header = array_shift($inventory_list); // Remove the first line (header)

        // Validate each row and check for errors
        foreach ($inventory_list as $index => $data) {
            if (!empty($data)) {
                $log_remarks = [];
                $line_number = $index + 2; // Adjust for the header row

                // Validate each field and append to log_remarks if invalid

                $partNumber  = $this->sanitizeData($data[0]);
                $description = $this->sanitizeData($data[1]);
                $unit        = $this->sanitizeData($data[2]);
                $quantity    = $this->sanitizeNmber($data[3]);
                $unit_price  = $this->sanitizeNmber($data[4]);


                $model_store = Store::model()->findByAttributes(['part_number' => $partNumber]);




                if (empty($model_store)) {
                    $have_item = 'N';
                    // Validate and prepare log remarks for this row
                    $log_remarks = $this->validateAndPrepareLog($data, $log_remarks, $have_item);
                } else {
                    $have_item = 'Y';
                    $log_remarks = $this->validateAndPrepareLog($data, $log_remarks, $have_item);
                }


                // If there are any errors, mark the row as failed and record the errors
                if (!empty($log_remarks)) {
                    $error_occurred = true;
                    $error_list[$line_number] = [
                        'part_number' => $data[0],
                        'description' => $data[1],
                        'unit'        => $data[2],
                        'quantity'    => $data[3],
                        'unit_price'  => $data[4],
                        'log_remarks' => implode(" | ", $log_remarks), // Store log remarks here
                    ];
                } else {
                    // No errors, so the log_remarks field is empty
                    $error_list[$line_number] = [
                        'part_number' => $data[0],
                        'description' => $data[1],
                        'unit'        => $data[2],
                        'quantity'    => $data[3],
                        'unit_price'  => $data[4],
                        'log_remarks' => '', // No errors, so leave it empty
                    ];
                    $quantity            = $this->sanitizeNmber($data[3]);

                    //if ((float)$quantity != 0) {
                        if ((float)$quantity > 0) {
                        $hasQuantityGreaterThanZero = true;
                    }
                }
            }
        }

        // If any errors occurred, write to error log and stop saving
        if ($error_occurred) {
            $file_error = fopen($error_url, "w+");

            // Add headers to the CSV file
            $headers = ['Part No', 'Description', 'Unit', 'Quantity', 'Unit Price', 'Log Remarks'];

            fputcsv($file_error, $headers);

            // Add each line from the original CSV, including rows with no errors
            foreach ($error_list as $error_detail) {
                $line = [
                    $error_detail['part_number'],
                    $error_detail['description'],
                    $error_detail['unit'],
                    $error_detail['quantity'],
                    $error_detail['unit_price'],
                    $error_detail['log_remarks'], // Include log remarks, empty if no error
                ];
                fputcsv($file_error, $line);
            }
            fclose($file_error);

            $jsonData['error_url'] = $error_url;
            $jsonData['filename'] = $file_name;
            $jsonData['link'] = CHtml::link('Download Log', array('inventoryupload/DownloadErrorCsv', 'id' => $file_name), array(
                'target' => '_blank',
                'style' => '
                    display: inline-block; border: 2px solid #ff4d4f; padding: 5px 15px;border-radius: -3px;font-size: 12px;
                    font-weight: bold; background: #ff4d4f; color: #fff;text-decoration: none;text-align: center; margin-bottom: 10px;'
            )) . '</div>
            <div style="
                font-size: 12px;
                font-weight: bold;
                color: #ff4d4f;
                margin-top: 10px;
            ">
                Data updation failed. Please see this file.
            </div>';
            echo json_encode($jsonData);

            return; // Return to stop further execution
        }

        // Process and save valid rows if no errors occurred
        $sql = "TRUNCATE TABLE `temp_inventory_uploaded_list`";
        Yii::app()->db->createCommand($sql)->execute();

        foreach ($inventory_list as $data) {
            if (!empty($data)) {

                $partNumber      = $this->sanitizeData($data[0]);
                $description     = $this->sanitizeData($data[1]);
                $unit            = $this->sanitizeData($data[2]);
                $quantity        = $this->sanitizeNmber($data[3]);
                $unit_price      = $this->sanitizeNmber($data[4]);
                $warehouse_name  = MasInventoryWarehouse::model()->findByAttributes(['isBaseWareHouse' => "Y"])->warehouse_name;
                $warehouse_id    = MasInventoryWarehouse::model()->findByAttributes(['isBaseWareHouse' => "Y"])->id;
                $kitchen_id      = 0;
                $unit_id         =  $this->findIdByCondition(Unit::model(), 'unit_name', $unit);
                $model_store     = Store::model()->findByAttributes(['part_number' => $partNumber]);


                $sql = "SELECT id as uom_id  FROM `erp_unit_of_measurement` WHERE `product_id` = '" . $model_store->id . "' AND unit_id = '" . $unit_id . "'";
                $command_acc = Yii::app()->db->createCommand($sql);
                $umo_detls = $command_acc->queryAll();
                $uom_id          =   $umo_detls[0]['uom_id'];

                // Prepare the base data for the query   
                $params_insert = [
                    ':product_id' => $model_store->id,
                    ':item_code' => $model_store->part_number,
                    ':item' => $model_store->description,
                    ':quantity' => $quantity,
                    ':unit_price' => $unit_price,
                    ':created_by' => Yii::app()->user->id,
                    ':created_date_time' => date('Y-m-d H:i:s'),
                    ':category_name' => '',
                    ':brand_name' => '',
                    ':kitchen_location' => $kitchen_id,
                    ':branch' => $warehouse_name,
                    ':warehouse_id' => $warehouse_id,
                    ':unit_name' => $unit,
                    ':unit_id'   => $unit_id,
                    ':uom_id'   => $uom_id,
                ];
                $this->InsertTempInventoryData($params_insert);
            }
        }

        // ----------------------------------------------
        if ($hasQuantityGreaterThanZero) {
            $jsonData = array();
            $jsonData['error_url'] = $error_url;
            $jsonData['filename'] = $file_name;
            $remainingCount = Yii::app()->db->createCommand("SELECT COUNT(*) FROM temp_inventory_uploaded_list WHERE quantity != 0 AND stock_updated='N' ")->queryScalar();
            $jsonData['upload_count'] = $remainingCount;

            $jsonData['link'] = CHtml::link('Upload Stock', '#', array(
                'style' => 'display: inline-block; border: 2px solid #ff4d4f; padding: 5px 15px; border-radius: -3px; font-size: 12px;
                            font-weight: bold; background: #ff4d4f; color: #fff; text-decoration: none; text-align: center; margin-bottom: 10px;',
                'id' => 'upload-stock-btn', // Set the ID for the button to target it with JavaScript
                'onclick' => 'uploadStockData(); return false;', // Trigger the JavaScript function when clicked
            ));


            // Send JSON response
            echo json_encode($jsonData);
        } else {
            echo CJSON::encode(['status' => 'success', 'message' => 'Data uploaded successfully.']);
        }
        // ----------------------------------------------
    }



    private function validateAndPrepareLog($data, &$error_list, $have_item)
    {
        $log_remarks = [];
        $partNumber = $this->sanitizeData($data[0]);
        $description = $this->sanitizeData($data[1]);
        $unit = $this->sanitizeData($data[2]);
        $quantity = $this->sanitizeNmber($data[3]);
        $unit_price = $this->sanitizeNmber($data[4]);

        /*  if ($have_item == 'N') {  } else {  } */

        if (empty(trim($partNumber))) {
            $log_remarks[] = "Error: Product Name is Empty.";
        } else {
            $model_store = Store::model()->findByAttributes(['part_number' => $partNumber]);
            if (empty($model_store)) {
                $log_remarks[] = "Error: Product Not Found.";
            }
        }

        if (empty(trim($unit))) {
            $log_remarks[] = "Error: Unit Name is Empty.";
        } else {
            $unit_id = $this->findIdByCondition(Unit::model(), 'unit_name', $unit);
            if ($unit_id === 0) {
                $log_remarks[] = "Error: Unit Not Found.";
            }
        }
        if ((int)$unit_id > 0 && $model_store->id > 0) {
            $sql = "SELECT id as uom_id  FROM `erp_unit_of_measurement` WHERE `product_id` = '" . $model_store->id . "' AND unit_id = '" . $unit_id . "'";
            $command_acc = Yii::app()->db->createCommand($sql);
            $umo_detls = $command_acc->queryAll();
            if ((int)$umo_detls[0]['uom_id'] <= 0) {
                $log_remarks[] = "Error: Unit Not In UOM Table.";
            }
        }

        if (abs($quantity) < 0) {
            $log_remarks[] = "Error: Quantity is Empty.";
        }
        // if (abs($unit_price) <= 0) {
        //     $log_remarks[] = "Error: Unit Price is Empty.";
        // }
        return $log_remarks;
    }


    private function sanitizeData($data)
    {
        // Remove commas and trim any extra spaces
        return !empty($data) ? trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data), '"')) : '';
    }
    private function sanitizeNmber($data)
    {
        // Remove commas and trim any extra spaces
        $sanitizedData = !empty($data) ? trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data), '"')) : '';
        // Remove commas and convert to float
        $sanitizedData = str_replace(',', '', $sanitizedData);

        // Return as a float
        return is_numeric($sanitizedData) ? (float)$sanitizedData : 0.0;
    }






    private function findOrCreateMater($model, $field, $value)
    {
        $condition = "{$field} = :value";
        $result = $model->find(array(
            'select' => 'id',
            'condition' => $condition,
            'params' => array(':value' => trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $value), '"')))
        ));

        if ($result) {
            return $result->id;
        }

        // If not found, create a new entry
        $newMaster = new $model();
        $newMaster->{$field} = trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $value), '"'));
        $newMaster->created_by = Yii::app()->user->id;

        $className = get_class($model); // Check the class name to handle specific models

        if ($className === 'MasGeneric') {
            $newMaster->created_date_time = date('Y-m-d H:i:s');
            $newMaster->generic_description = trim(string: trim(iconv('UTF-8', 'ASCII//TRANSLIT', $value), '"'));
        } elseif ($className === 'Unit') {
            $newMaster->symbol = trim(string: trim(iconv('UTF-8', 'ASCII//TRANSLIT', $value), '"'));
            $newMaster->created_datetime = date('Y-m-d H:i:s');
        } else {
            $newMaster->created_datetime = date('Y-m-d H:i:s');
        }

        if ($newMaster->save(false)) {
            return $newMaster->id;
        }

        // If save fails, return null
        return null;
    }

    private function InsertTempInventoryData($params_insert)
    {

        $insertSql = "
                INSERT INTO temp_inventory_uploaded_list 
                (product_id, item_code, item, quantity, unit_price, created_by, created_date_time, category_name,brand_name,branch,kitchen_location,warehouse_id, unit_name,unit_id,uom_id)
                VALUES
                (:product_id, :item_code, :item, :quantity, :unit_price, :created_by, :created_date_time, :category_name,:brand_name,:branch,:kitchen_location,:warehouse_id, :unit_name,:unit_id,:uom_id)";
        Yii::app()->db->createCommand($insertSql)->execute($params_insert);
    }



    // Method to save errors to a CSV file

    public function actionDownloadErrorCsv()
    {
        $file_name = $event_id = Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../upload/inventoryuploadlist_csv/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }


    private function findIdByCondition($model, $field, $value)
    {
        $condition = "{$field} = :value";
        $result = $model->find(array(
            'select' => 'id',
            'condition' => $condition,
            'params' => array(':value' => trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $value), '"')))
        ));
        return $result ? $result->id : 0;
    }

    public function readInventoryListCSV($csvFile)
    {
        $file_handle = fopen($csvFile, 'r');
        $line_of_text = [];
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            if ($contents) {
                $line_of_text[] = $contents;
            }
        }
        fclose($file_handle);
        return $line_of_text;
    }


    public function actionUpload($folder = null)
    {

        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';

        // make the directory to store the pic:

        if (!is_dir($folder)) {

            mkdir($folder, 0777, TRUE);

            //chmod($folder, 0755);
        }

        $allowedExtensions = array();

        $sizeLimit = 2 * 1024 * 1024; // maximum file size in bytes

        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);

        $result = $uploader->handleUpload($folder);

        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);

        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);

        $fileName = $result['filename']; //GETTING FILE NAME

        echo $return; // it's array
    }



    public function actionUploadStock()
    {
        $sql = "SELECT * FROM temp_inventory_uploaded_list WHERE quantity > 0 AND stock_updated='N' LIMIT 100";
        $command = Yii::app()->db->createCommand($sql);
        $list = $command->queryAll();

        $sql_issue = "SELECT * FROM temp_inventory_uploaded_list WHERE quantity < 0 AND stock_updated='N' LIMIT 100";
        $command_issue = Yii::app()->db->createCommand($sql_issue);
        $list_issue = $command_issue->queryAll(); // Goods Issue

        if (!empty($list) || !empty($list_issue)) {
            $other = array();
            $valid = true;
            if (!empty($list)) {
                $model = new InventoryGoodsReceipt();
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
               // $model->receipt_type = 'N'; //$_POST['InventoryGoodsReceipt']['receipt_type'];
                $model->goods_receipt_date = date('Y-m-d');
                $model->reference = 'Added From Inventory Upload';
                $model->warehouse_id = $list[0]['warehouse_id'];

                $valid = $model->validate() && $valid;
                $model_items = [];
                foreach ($list as $k => $rowItem) {
                    $product = Store::model()->findByPk($rowItem['product_id']);
                    $model_item                    = new InventoryGoodsReceiptItem();
                    $model_item->created_by        = Yii::app()->user->id;
                    $model_item->created_date_time = date('Y-m-d h:i:s');
                    $model_item->product_id        = $rowItem['product_id'];
                    $model_item->product_name      = $product['part_number'];
                    $model_item->description       = $product['description'];
                    $model_item->picked_qty        = $rowItem['quantity'];
                    $model_item->unit              = $rowItem['uom_id'];
                    $model_item->rate              = $rowItem['unit_price'];
                    $valid = $model_item->validate() && $valid;
                    $model_items[] = $model_item;
                }
            }

            if (!empty($list_issue)) {
                $modelIssue = new InventoryGoodsIssue();
                $modelIssue->created_by = Yii::app()->user->id;
                $modelIssue->created_date_time = date('Y-m-d h:i:s');
                $modelIssue->issue_type = 'N';
                $modelIssue->goods_issue_date = date('Y-m-d');
                $modelIssue->reference = 'Added From Inventory Upload';
                $modelIssue->warehouse_id = $list_issue[0]['warehouse_id'];
                $modelIssue->ledger_id = 0;
                $modelIssue->subledger_id = 0;

                $valid = $modelIssue->validate() && $valid;
                $model_items_issue = [];
                foreach ($list_issue as $k => $rowItemIssue) {
                    $product = Store::model()->findByPk($rowItemIssue['product_id']);
                    $model_issue_item                    = new InventoryGoodsIssueItem();
                    $model_issue_item->created_by        = Yii::app()->user->id;
                    $model_issue_item->created_date_time = date('Y-m-d h:i:s');
                    $model_issue_item->product_id        = $rowItemIssue['product_id'];
                    $model_issue_item->product_name      = $product['part_number'];
                    $model_issue_item->description       = $product['description'];
                    $model_issue_item->picked_qty        = Abs($rowItemIssue['quantity']);
                    $model_issue_item->unit              = $rowItemIssue['uom_id'];
                    $model_issue_item->rate              =  $product['rate']; //$rowItemIssue['unit_price'];
                    $valid = $model_issue_item->validate() && $valid;
                    $model_items_issue[] = $model_issue_item;
                }
            }
            if ($valid) {
                if (!empty($list)) {
                    $model->stock_updated = 'Y';
                    $model->save(false);


                    // Audit Log
                    AuditLog::saveAuditLogs(
                        'RECEIPTS',
                        Yii::app()->user->id,
                        'CREATED',
                        " with Checkin No: - {$model->id}"
                    );

                    $modelRack         = new MasInvRack();
                    $modelBin          = new MasInvBin();
                    $modelMasInvBrand = new MasInvBrand();
                    $modelUOM          = new UnitOfMeasurement();
                    $warehouse_id = 0;
                    if ((int)$model->warehouse_id > 0) {
                        $warehouse_id = $model->warehouse_id;
                    }

                    /* else {
                    $warehouse_id = (int) Yii::app()->user->getState('user_warehouse_id');
                }*/

                    $warehouse_name = '';
                    if ($warehouse_id > 0) {
                        $modwarehouse = new MasInventoryWarehouse();
                        $warehouse_name = $modwarehouse->getWarehouseName($warehouse_id);
                    }
                    $modelCustomer     = new Customer();
                    $modelcustomer_name = '';
                    if ((int)$model->customer_id > 0) {
                        $modelcustomer_name = $modelCustomer->findByPk($model->customer_id)->customer_name;
                    }

                    foreach ($list as  $rowItem) {
                        $sqlupdate = "UPDATE `temp_inventory_uploaded_list` 
                                    SET `stock_updated` = 'Y' 
                                    WHERE `id` = :id";
                        Yii::app()->db->createCommand($sqlupdate)->bindParam(':id', $rowItem['id'], PDO::PARAM_INT)->execute();
                    }


                    foreach ($model_items as $item) {
                        $item->inventory_goods_receipt_id = $model->id;
                        $item->save(false);
                        $modelUOM = $modelUOM->findByPk((int) $item->unit);
                        $modelbrandname = '';
                        if ((int)$item->product->brand_class_id > 0) {
                            $modelbrandname = $modelMasInvBrand->findByPk($item->product->brand_class_id)->brand_name;
                        }
                        // ----------------------------------------------------------------
                        $arr_product_details = Store::model()->findbyPk($item->product_id);
                        $existing_store_rate = $arr_product_details->rate;
                        $rate = $existing_store_rate;
                        $existing_qty = $arr_product_details->totalQuantity;

                        $new_cost_price = $item->rate * $item->picked_qty;
                        $new_cost_price = round($new_cost_price, 6);

                        $quantity_with_unit_factor = $item->picked_qty * $modelUOM->factor;
                        $variance_value = ($quantity_with_unit_factor > 0) ? $new_cost_price / $quantity_with_unit_factor : 0;
                        $variance_value = round($variance_value, 6);
                        $cost_with_variance = $variance_value;

                        $cur_total = $cost_with_variance * $quantity_with_unit_factor;
                        $existing_amount = $rate * $existing_qty;
                        $total_quantity = $existing_qty + $quantity_with_unit_factor;
                        $total_amount = $existing_amount + $cur_total;
                        $new_amount = ($total_quantity > 0) ? $total_amount / $total_quantity : $existing_store_rate;
                        $new_amount = round($new_amount, 6);


                        Store::model()->updateByPk($item->product_id, array('rate' => $new_amount));
                        // ----------------------------------------------------------------
                        $modelStockLedger                                = new StockLedger();
                        $modelStockLedger->brand_id                      = $item->product->brand_class_id;
                        $modelStockLedger->brand_name                    = $modelbrandname;
                        $modelStockLedger->customer_vendor_id            = $model->customer_id;
                        $modelStockLedger->customer_vendor_name          = $modelcustomer_name;
                        $modelStockLedger->file_id                       = $model->file_id;
                        $modelStockLedger->header_id                     = $model->id;
                        $modelStockLedger->header_item_id                = $item->id;
                        $modelStockLedger->product_id                    = $item->product_id;
                        $modelStockLedger->product_name                  = $item->product->part_number;
                        $modelStockLedger->product_description           = $item->product->description;
                        $modelStockLedger->warehouse_id                  = (int)$warehouse_id;
                        $modelStockLedger->warehouse_name                = $warehouse_name;
                        $modelStockLedger->rack_id                       = $modelRack->getDefaultRackId();
                        $modelStockLedger->rack_name                     = $modelRack->getRackName((int)$modelStockLedger->rack_id);
                        $modelStockLedger->bin_id                        = $modelBin->getDefaultBinId();
                        $modelStockLedger->bin_name                      = $modelBin->getBinName((int)$modelStockLedger->bin_id);
                        $modelStockLedger->unit_id                       = $item->unit;
                        $modelStockLedger->unit_name                     = $modelUOM->name;
                        $modelStockLedger->unit_factor                   = $modelUOM->factor;
                        $modelStockLedger->quantity                      = $item->picked_qty;
                        $modelStockLedger->available_status              = 'A';
                        $modelStockLedger->buying_price                  = $item->rate / $modelUOM->factor;
                        $modelStockLedger->batch_no                      = '';
                        $modelStockLedger->serial_no                     = ''; 
                        $modelStockLedger->manufacturing_date            = '0000-00-00';
                        $modelStockLedger->expiry_date                   = '0000-00-00';
                        $modelStockLedger->cost_price                    = $new_amount;
                        $modelStockLedger->sales_price                   = 0;
                        $modelStockLedger->transaction_date              = date('Y-m-d');
                        $modelStockLedger->transaction_from              = 'INVENTORY_GOODS_RECEIPT'; //when goods receipt -- item returned
                        $modelStockLedger->transaction_type              = "IN";
                        $modelStockLedger->stock_updated                 =  'Y';
                        $modelStockLedger->created_by                    = (int) Yii::app()->user->id;
                        $modelStockLedger->created_date                  = date("Y-m-d H:i:s");
                        $modelStockLedger->save(false);
                    }

                    // echo CJSON::encode(['status' => 'success', 'message' => 'Stock uploaded successfully.']);
                    // return;



                }

                ////////////////////////////////////////////////////////////////////////
                if (!empty($list_issue)) {
                    $modelIssue->stock_updated = 'N';
                    $modelIssue->save(false);


                    // Audit Log
                    AuditLog::saveAuditLogs(
                        'ISSUES',
                        Yii::app()->user->id,
                        'CREATED',
                        " with Checkin No: - {$modelIssue->id}"
                    );


                    foreach ($list_issue as  $rowIssue) {
                        $sqlupdateissue = "UPDATE `temp_inventory_uploaded_list` 
                                SET `stock_updated` = 'Y' 
                                WHERE `id` = :id";
                        Yii::app()->db->createCommand($sqlupdateissue)->bindParam(':id', $rowIssue['id'], PDO::PARAM_INT)->execute();
                    }


                    foreach ($model_items_issue as $itemissue) {
                        $itemissue->inventory_goods_issue_id = $modelIssue->id;
                        $itemissue->save(false);
                    }
                }
            } else {
                $error1 = $error2 = $error3 = $error4 = [];
                if (!empty($list)) {
                    $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                    $error2 = $model_items[0]->product_id > 0
                        ? json_decode(CActiveForm::validateTabular($model_items, '', false), true)
                        : ["Please add at least one line item"];
                }
                if (!empty($list_issue)) {
                    $error3 = json_decode(CActiveForm::validate($modelIssue, '', false), true);
                    $error4 = $model_items_issue[0]->product_id > 0
                        ? json_decode(CActiveForm::validateTabular($model_items_issue, '', false), true)
                        : ["Please add at least one line item"];
                }

                $errors = array_merge_recursive($error1, $error2, $error3, $error4, $other);

                echo CJSON::encode(['status' => 'error', 'message' => 'Validation failed.', 'errors' => $errors, 'items' => $model_items]);
                return;
            }
            $remainingCount = Yii::app()->db->createCommand("SELECT COUNT(*) FROM temp_inventory_uploaded_list WHERE quantity != 0 AND stock_updated='N' ")->queryScalar();
            if ($remainingCount > 0) {
                // Generate the link for uploading the remaining stock
                $jsonData['link'] = CHtml::link('Upload Remaining Stock', '#', array(
                    'style' => 'display: inline-block; border: 2px solid #ff4d4f; padding: 5px 15px; border-radius: -3px; font-size: 12px;
                        font-weight: bold; background: #ff4d4f; color: #fff; text-decoration: none; text-align: center; margin-bottom: 10px;',
                    'id' => 'upload-stock-btn',
                    'onclick' => 'uploadStockData(); return false;',
                ));
            }

            echo CJSON::encode([
                'status' => 'success',
                'message' => 'Stock uploaded successfully.',
                'remaining' => $remainingCount,
                'link' => isset($jsonData['link']) ? $jsonData['link'] : '',
            ]);
            return;
        } else {
            echo CJSON::encode(['status' => 'error', 'message' => 'No items with quantity greater than 0 found.']);
            return;
        }
    }
}
