<?php

class HiringController extends Controller
{
	 public $layout = 'layout';
    public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                        'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                        'users' => array('*'),
                ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                        'actions' => array('Index','GetList','Create','Save','Delete','UploadHiringImage','DeleteImage','UploadApplicationHiringImages','DeleteapplicationImages','GetProducts'),
                        'expression' => '$user->isMember()',
                ),
                array('deny', // deny all users
                        'users' => array('*'),
                ),
        );
    }
        public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }
    public function actionIndex()
    {
        $this->render('index');
    }
    public function actionGetList()
    {
        $model=new Hiring();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'part_number',
            2 => 'description',
        );
        
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = 't.isActive="Y"';
        
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $searchString = trim($_POST['search']['value']);
            $condition.=" AND (t.id LIKE '%".$searchString."%' OR t.part_number LIKE '%".$searchString."%' OR t.description LIKE '%".$searchString."%' OR application_name LIKE '%".$searchString."%') ";
        }
        
            
        
        $count = $model->with('storedetails','application')->count(array('condition'=>$condition));
        $model=$model->with('storedetails','application')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.id DESC'));
        
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        
        foreach ($model as $row)
        {
            
            $part_no = $row['part_number'];
            //$row['brand']="";
           //$row['unit']="";
            $rowData[]=array($row['id'] , $part_no, $row['description'], (float) $row['quantity'],$row['storedetails']['unit']['symbol'],$row['application']['application_name']);
        } 
        
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    
    public function actionCreate() {
        $id = (int) Yii::app()->request->getParam('id');
        $action = Yii::app()->request->getParam('action');
        $model = new Hiring();
        $modelItems = array(new HiringItems());
        if($id>0){
            $model = Hiring::model()->findByPK($id);
            $modelItems = HiringItems::model()->findAll(array('condition'=>'hiring_id = '.$id));
            if(empty($modelItems)){
                $modelItems = array(new HiringItems());
            }
            
            if(!empty($action) && $action=='copy'){
                $model->id="";
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        
        $this->render('create', array('model' => $model,'modelItems' =>$modelItems,'action'=>$action));
       
    }
    
    public function actionSave(){
        $model = new Hiring();
        $modelItem = array(new HiringItems());
        $other_errors=array();
        $model_his=array();
        ini_set("memory_limit", "-1");
        if (isset($_POST['Hiring'])) {
            if((int) @$_POST['Hiring']['id'] > 0){
                $model = $model->findByPK($_POST['Hiring']['id']);
                $audit_type = 'UPDATED';
            }else{
                $audit_type = 'CREATED';
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
                $model->received_date=date("Y-m-d");
                if((int)$_POST['Hiring']['product_id']>0){
                    $prod_id =(int)$_POST['Hiring']['product_id'];
                    $model_his=$model->findAll(array('condition'=>'product_id = "'.$prod_id.'"'));
                }
            }
            $model->attributes  = $_POST['Hiring'];
            $model->unit_id     = $_POST['Hiring']['unit_id'];
            $model->notes       = $_POST['Hiring']['notes'];
            $model->part_number       = $_POST['Hiring']['part_number'];
//            $part_number      = explode('-', $_POST['Hiring']['part_number']);
//            $mc_spare=$part_number[1];
//            $value_machine_type = ($mc_spare=='02')? '01': '03';
//            $model->part_number=$part_number[0].'-'.$value_machine_type.'-'.$part_number[2];
         //   $model->doc_image = $_POST['Hiring']['doc_image'];
            $model->application_image = $_POST['Hiring']['application_image'];
             
           
            $valid = $model->validate();
            if (!empty($_POST['HiringItems'])) {                
                foreach ($_POST['HiringItems'] as $k => $rowItem) {
                    if($rowItem['product_id']>0){//---- avoid locking of items as per requirement on 6-1-2020 by jisha
                        if($rowItem['id']>0){
                            $modelItem[$k] = HiringItems::model()->findByPK($rowItem['id']);   
                        }else{
                            $modelItem[$k]= new HiringItems();   
                        } 
                        $modelItem[$k]->hiring_id = 0;
                        $modelItem[$k]->attributes = $_POST['HiringItems'][$k];
                        $modelItem[$k]->quantity = $rowItem['quantity'];
                        $valid = $modelItem[$k]->validate() && $valid;                     
                    }//---- avoid locking of items as per requirement on 6-1-2020 by jisha
                }
            }
            if ($valid){
                if($model->save())
                {
                    // inserting to audit log
                    AuditLog::saveAuditLogs(
                        'HIRING',
                        Yii::app()->user->id,
                        $audit_type,
                        " with Part No: - {$model->part_number}  "
                    );
                    // end audit log
                    if (!empty($modelItem)) {
                        foreach ($modelItem as $eachItem) {
                            $eachItem->hiring_id = $model->id;                       
                            $eachItem->save();
                        }
                    }
                   

                    $jsonData['id'] = $model->id;
                    $jsonData['hiring'] = $model->findByPk($model->id);
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                }
            }
            else
            {
                $error1 = array();$error2 =array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($modelItem[0]->product_id > 0)
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                /*---- avoid locking of items as per requirement on 6-1-2020 by jisha
                 else
                    $error2[] = "Please add atleast one item";*/
                $error = CJSON::encode(array_merge_recursive($error2,$error1,$other_errors));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
     public function actionDelete(){
        $id = $_POST['id'];
        $model = new HiringItems();
        $model->deleteByPk($id);
        $jsonData['status'] = 'success';
        $jsonData['id'] = $id;
        echo CJSON::encode($jsonData);
    }
    
     public function actionUploadHiringImage($folder = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $field_id = "";
        if(isset($_GET['field_id']))
        {
            $field_id = Yii::app()->request->getParam('field_id');
        }
        
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        $allowedExtensions = array("jpg", "jpeg", "gif","png"); //array("jpg","jpeg","gif","exe","mov" and etc...
        $sizeLimit = 2 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        $fileName = $result['filename']; //GETTING FILE NAME
        $imagename	=	Yii::app()->basePath.'/../upload/hiring/'.$fileName;
        $imagename_thumb	=	Yii::app()->basePath.'/../upload/hiring/thumbs/'.$fileName;
        Yii::import("ext.EPhpThumb.EPhpThumb");
        $thumb=new EPhpThumb();
        $thumb->init(); //this is needed
        //chain functions
        $thumb->create($imagename)->resize(100,100)->save($imagename_thumb);
        echo $return; // it's array
    }
    
      public function actionUploadApplicationHiringImages($folder = null) {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $field_id = "";
        if(isset($_GET['field_id']))
        {
            $field_id = Yii::app()->request->getParam('field_id');
        }
        
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
        }
        $allowedExtensions = array("jpg", "jpeg", "gif","png"); //array("jpg","jpeg","gif","exe","mov" and etc...
        $sizeLimit = 2 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        $fileName = $result['filename']; //GETTING FILE NAME
        $imagename	=	Yii::app()->basePath.'/../upload/applicationhiring/'.$fileName;
        $imagename_thumb	=	Yii::app()->basePath.'/../upload/applicationhiring/thumbs/'.$fileName;
        Yii::import("ext.EPhpThumb.EPhpThumb");
        $thumb=new EPhpThumb();
        $thumb->init(); //this is needed
        //chain functions
        $thumb->create($imagename)->resize(100,100)->save($imagename_thumb);
        echo $return; // it's array
    }
    
    public function actionDeleteImage(){
        $id = (int) $_POST['id'];
        $model= Hiring::model()->findByPk($id);
        if($model->doc_image!=''){
            $path = Yii::getPathOfAlias('webroot')."/upload/hiring/".$model->doc_image;
            if(file_exists($path)){
                unlink($path);
            }
        }
        
        $model->doc_image= '';
        $model->save(false);
        echo "success";
    }
     public function actionDeleteapplicationImages() {
        $deletefilename = Yii::app()->request->getparam('deletefilename');
        $images    = Yii::app()->request->getparam('images');
         $id = (int) Yii::app()->request->getparam('id');
        $model= Hiring::model()->findByPk($id);
        //print_r($id);exit;
        $new_image_array   = array();
        if(!empty($images)){
            if(!empty($images)){ 
                $image_array       = explode(',',$images);
                
                foreach ($image_array as $image) {
                    if($image != $deletefilename){
                        $new_image_array[] =$image;
                    } else
                    {
                        $path = Yii::getPathOfAlias('webroot')."/upload/applicationhiring/".$deletefilename;
                         if(file_exists($path)){
                           unlink($path);
                             }
                    }
                }
                
            }
            $available_images    = implode(',',$new_image_array);
             
            //$new_file_name  = str_replace($deletefilename,"","Hello world!");
            $json['new_file_name'] = $available_images;
             $model->application_image= $available_images;
            $model->save(false);
            $json['status']='success';
        }
        else{
            $json['status']='error';
        }
        echo CJSON::encode($json);
    }
    public function actionGetProducts() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $id = $_GET['id'];
        $condition = '(hiring_part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")';
        if($id>0){
            $condition .= ' AND id != '.$id;        
        }
        $model = new Store();
        $model = $model->findAll(array('select' => 'id,hiring_part_number,description,unit_id,rate', 'condition' => $condition, 'limit' => 200));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['other'] = $eachModel->hiring_part_number;
            $data[$i]['label'] = $eachModel->hiring_part_number.':'.$eachModel->description;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit->id;
            $data[$i]['rate'] = $eachModel->rate;
             $data[$i]['unit_name'] = $eachModel->unit->symbol;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    
}