<?php

class GenericController extends Controller
{

    public function accessRules()
    {

        return array(

            array(
                'allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array('login', 'error', 'logout'),

                'users' => array('*'),

            ),

            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions

                'actions' => array('Index', 'Create', 'GetList', 'SaveGeneric', 'DeleteGeneric', 'DirectAdd', 'Disable', 'UploadCategory', 'DownloadSampleCsv', 'DownloadSampleCsv', 'SaveCategoryUploadCsv', 'UploadCategoryCsv', 'DownloadErrorCsv'),

                'expression' => '$user->isMember()',

            ),

            array(
                'deny', // deny all users

                'users' => array('*'),

            ),

        );

    }

    public function actionIndex()
    {

        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn['masters_menu_view']) &&
                isset(Yii::app()->user->havePermissionOn['inventory_generic_name_view']) &&
                Yii::app()->user->havePermissionOn['masters_menu_view'] &&
                Yii::app()->user->havePermissionOn['inventory_generic_name_view']
            )
        ) {
            $this->render('index');
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }

    }


    public function filters()
    {

        return array(

            'accessControl', // perform access control for CRUD operations

        );

    }

    public function actionGetList()
    {

        $model = new MasGeneric();

        $draw = $_POST['draw'];

        $offset = $_POST['start'];

        $limit = $_POST['length'];

        $columns = array(

            // datatable column index  => database column name

            0 => 'id',

            1 => 'generic_name',

            2 => 'generic_description',



        );

        $filterColumn = $columns[$_POST['order'][0]['column']];

        $filterOrder = $_POST['order'][0]['dir'];

        $orderBy = $filterColumn . " " . $filterOrder;

        // $condition = 't.is_Active= "Y" ';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {

            $searchString = $_POST['search']['value'];

            $condition = " generic_name LIKE '%" . $searchString . "%' OR generic_description LIKE '%" . $searchString . "%'";

        }

        $count = $model->count(array('condition' => $condition));

        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;

        $recordsFiltered = $count;

        $data['draw'] = $draw;

        $data['recordsTotal'] = $recordsTotal;

        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();

        $m = 1;


        foreach ($model as $row) {
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inventory_generic_name_edit"])) {
                $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'generic/create&id=' . $row['id'] . '\',\'Generic - ' . $row['generic_name'] . ' \',\'lg\')"><i class="fa fa-pencil"></i></button>';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["inventory_generic_name_delete"])) {
                //   $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteGeneric('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
            }
            $rowData[] = array(
                $m,
                $row['generic_name'],
                $row['generic_description'],
                $row['isDefault'],
                array('id' => $row['id'], 'code' => $row['generic_name'], 'status' => $row->is_Active)
            );

            $m++;

        }

        //                foreach ($model as $row)
//
//                {
//
//                    $rowData[]=array($m,$row['generic_name'],$row['generic_description'],'<div class="btn-wrap text-center">'
//
//                        . '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'generic/create&id='.$row['id'].'\',\'Generic\',\'lg\')"><i class="fa fa-pencil"></i></button> '
//
//                        .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteGeneric('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>');
//
//                    $m++;
//
////                }

        $data['data'] = $rowData;

        echo json_encode($data);

    }

    public function actionCreate()
    {

        $model = new MasGeneric();

        //$model_clevel1=array(new MasCategoryFirstLevel());

        //$model_clevel2=array(new MasCategorySecondLevel());

        $from = Yii::app()->request->getParam('from');

        $id = (int) Yii::app()->request->getParam('id');

        if ($id > 0) {

            $model = $model->findByPk($id);

            /*$model_clevel1 = MasCategoryFirstLevel::model()->findAll(array('condition'=>'generic_name_id="'.$id.'"'));  

            //$model_clevel2 = MasCategorySecondLevel::model()->findAll(array('condition'=>'generic_name_id="'.$id.'"'));  

            if(empty($model_clevel1)){

                  $model_clevel1=array(new MasCategoryFirstLevel());  

            }

             if(empty($model_clevel2)){

                  $model_clevel2=array(new MasCategorySecondLevel());  



            }*/

        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->render('generic_form', array('model' => $model/*,'model_clevel1'=>$model_clevel1,'model_clevel2'=>$model_clevel2*/ , 'from' => $from));

    }

    public function actionSaveGeneric()
    {

        // print_r($_POST); die();
        $model = new MasGeneric();

        /************ START Code for Save ***************/

        if (isset($_POST['MasGeneric'])) {

            if ((int) @$_POST['MasGeneric']['id'] > 0) {

                $id = (int) @$_POST['MasGeneric']['id'];
                $model = $model->findByPk($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('y-m-d');
                $audit_type = 'UPDATED';
                $edit_flag = 1;
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('y-m-d');
                $audit_type = 'CREATED';
            }
            if ($_POST['MasGeneric']['isDefault'] == "Y") {
                MasGeneric::model()->updateAll(array('isDefault' => 'N'), 'isDefault = "Y"');
            }
            $model->isDefault = $_POST['MasGeneric']['isDefault'];
            $model->attributes = $_POST['MasGeneric'];
            $model->generic_description = $_POST['MasGeneric']['generic_description'];
            // $model_user= User::model()->findByPK(Yii::app()->user->user_id);  

            // $model->company_id=$model_user->company_id; 


            if ($model->validate()) {
                $model->save();

                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'GENERIC_MASTER',
                    Yii::app()->user->id,
                    $audit_type,
                    " with name: - {$model->generic_name}  "
                );
                // end audit log


                if (isset($_POST['MasCategoryFirstLevel'])) {

                    foreach ($_POST['MasCategoryFirstLevel'] as $i => $items) {

                        if ($items['id'] > 0) {
                            $model_clevel1[$i] = MasCategoryFirstLevel::model()->findByPK($items['id']);
                            $model_clevel1[$i]->updated_by = Yii::app()->user->id;
                            $model_clevel1[$i]->updated_date_time = date('y-m-d');

                        } else {
                            $model_clevel1[$i] = new MasCategoryFirstLevel();
                            $model_clevel1[$i]->created_by = Yii::app()->user->id;
                            $model_clevel1[$i]->created_date_time = date('y-m-d');
                        }

                        $model_clevel1[$i]->generic_name_id = $model->id;
                        $model_clevel1[$i]->category_name = $items['category_name'];
                        $model_clevel1[$i]->category_description = $items['category_description'];
                        $valid = $model_clevel1[$i]->validate();

                    }

                    if ($valid) {
                        foreach ($model_clevel1 as $eachModel) {
                            $eachModel->save();

                        }
                    }
                }

                if (isset($_POST['MasCategorySecondLevel'])) {

                    foreach ($_POST['MasCategorySecondLevel'] as $i => $items) {

                        if ($items['id'] > 0) {
                            $model_clevel2[$i] = MasCategorySecondLevel::model()->findByPK($items['id']);
                            $model_clevel2[$i]->updated_by = Yii::app()->user->id;
                            $model_clevel2[$i]->updated_date_time = date('y-m-d');
                        } else {
                            $model_clevel2[$i] = new MasCategorySecondLevel();
                            $model_clevel2[$i]->created_by = Yii::app()->user->id;
                            $model_clevel2[$i]->created_date_time = date('y-m-d');

                        }

                        $model_clevel2[$i]->generic_name_id = $model->id;
                        $model_clevel2[$i]->category_name = $items['category_name'];
                        $model_clevel2[$i]->category_description = $items['category_description'];
                        $valid = $model_clevel2[$i]->validate();

                    }

                    if ($valid) {
                        foreach ($model_clevel2 as $eachModel) {
                            $eachModel->save();

                        }
                    }
                }
                $jsonData['id'] = $model->id;
                $jsonData['from'] = $_POST['from'];

                $jsonData['status'] = 'success';

                echo CJSON::encode($jsonData);

            } else {
                $error = CActiveForm::validate($model, '', false);

                if ($error != '[]')

                    echo $error;

            }
        }
    }

    public function actionDeleteGeneric()
    {

        $id = $_POST['id'];

        $store = Yii::app()->db->createCommand('SELECT COUNT(*) FROM crm_store WHERE generic_name = ' . $id . ' ')->queryScalar();

        if ($store > 0) {
            echo "fail";
        } else {

            $model = new MasGeneric();
            $del = $model->findByPk($id); // audit log changes
            $model->deleteByPk($id);
            // inserting to audit log
            AuditLog::saveAuditLogs(
                'GENERIC_MASTER',
                Yii::app()->user->id,
                'DELETED',
                " with name: - {$del->generic_name}  "
            );
            // end audit log
            echo "success";
        }


    }
    public function actionDirectAdd()
    {
        $from = $_POST['from'];
        $name = $_POST['name'];
        $des = $_POST['des'];
        $status = array();
        if ($name != '') {
            $modelGeneric = new MasGeneric;
            $modelGeneric->created_by = Yii::app()->user->id;
            $modelGeneric->created_date_time = date('Y-m-d h:i:s');
            $modelGeneric->generic_description = $des;
            $modelGeneric->generic_name = $name;
            if ($modelGeneric->save()) {
                $data = MasGeneric::getGenericNames();
                if ($from == 'inventory') {
                    $model = new Store;
                    $field_name = 'generic_id';
                }
                $model->$field_name = $modelGeneric->id;
                $drop = CHtml::activedropDownList($model, $field_name, $data, array('class' => 'tooltipster', 'data-label' => 'Generic'));
                $status = array("status" => "success", "drop" => $drop);
                echo CJSON::encode($status);
            } else {
                $error = CActiveForm::validate($modelGeneric, '', false);
                if ($error != '[]')
                    echo $error;
            }

        }



    }
    public function actionDisable()
    {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasGeneric();
        $model = $model->findByPk($id);
        $model->is_Active = ($status == "Y") ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
    // csv bulk upload section
    public function actionUploadCategory()
    {
        //added by nisha on 28-02-2023
        $model = new MasGeneric();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_category', array('model' => $model), false, true);
    }

    public function actionDownloadSampleCsv()
    {
        $filename = 'category_list.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Category Name*';
        Yii::app()->end();
    }

    public function readCategoryCSV($csvFile)
    {
        if (!file_exists($csvFile)) {
            throw new Exception("File not found: $csvFile");
        }

        $file_handle = fopen($csvFile, 'r');
        $line_of_text = [];
        while (($contents = fgetcsv($file_handle, 1024, ',')) !== false) {
            $line_of_text[] = $contents;
        }
        fclose($file_handle);

        return $line_of_text;
    }
    public function actionSaveCategoryUploadCsv()
    {
        $file_name = Yii::app()->request->getParam('filename');
        $batch = (int) Yii::app()->request->getParam('batch', 1);
        $url = Yii::app()->basePath . '/../uploads/generic_csv/' . $file_name;
        $mas_category_list = $this->readCategoryCSV($url);
        $error_url = Yii::app()->basePath . '/../uploads/generic_csv/error/' . $file_name;
        $error_list = [];
        $error_occurred = false;
        $batch_size = 200;
        $success_count = 0;
        $error_count = 0;
        $non_empty_row_count = 0;
        if (!empty($mas_category_list)) {
            $header = array_shift($mas_category_list); // Remove header row only once
        }
        $total_records = count($mas_category_list);
        $start_index = ($batch - 1) * $batch_size;
        $batch_data = array_slice($mas_category_list, $start_index, $batch_size);
        // print_r($batch_data);
        // die();
        foreach ($mas_category_list as $index => $data) {
            if (!empty($data)) {
                $line_number = $index + 2; // Adjust for header row
                $log_remarks = [];

                // Sanitize and validate data

                if ($batch == 1) {
                    $log_remarks = $this->validateAndPrepareLog($data, $log_remarks);
                }


                if (empty($log_remarks)) {
                    $error_list[$line_number] = [
                        'generic_name' => $data[0],
                        'log_remarks' => ''
                    ];
                } else {
                    $error_occurred = true;
                    $error_count++;
                    $error_list[$line_number] = [
                        'generic_name' => $data[0],
                        'log_remarks' => implode(" | ", $log_remarks)
                    ];
                }
            }
        }
        // var_dump($log_remarks);
        // die();
        if ($error_occurred) {
            // echo 'hii';
            $file_error = fopen($error_url, "w+");
            $error_directory = Yii::app()->basePath . '/../uploads/generic_csv/error/';

            if (!is_dir($error_directory)) {
                mkdir($error_directory, 0777, true);  // Create the directory with appropriate permissions
            }
            if ($file_error === false) {
                // Handle the error if the file cannot be opened
                throw new Exception("Unable to open file for writing: $error_url");
            }
            // Add headers to the CSV file
            $headers = ['Category Name', 'Log Remarks'];
            fputcsv($file_error, $headers);

            // Add each line from the original CSV, including rows with no errors
            foreach ($error_list as $error_detail) {
                $line = [
                    $error_detail['generic_name'],
                    $error_detail['log_remarks'], // Include log remarks, empty if no error
                ];
                fputcsv($file_error, $line);
            }
            fclose($file_error);

            $jsonData['error_url'] = $error_url;
            $jsonData['filename'] = $file_name;
            $jsonData['link'] = CHtml::link('Download Log', array('generic/DownloadErrorCsv', 'id' => $file_name), array(
                'target' => '_blank',
                'style' => '
                display: inline-block; border: 2px solid #ff4d4f; padding: 5px 15px;border-radius: -3px;font-size: 12px;
                font-weight: bold; background: #ff4d4f; color: #fff;text-decoration: none;text-align: center; margin-bottom: 10px;'
            )) . '</div>
            <div style="
                font-size: 12px;
                font-weight: bold;
                color: #ff4d4f;
                margin-top: 10px; 
            ">
                Data updation failed. Please see this file.
            </div>';
            echo json_encode($jsonData);

            return; // Return to stop further execution
        }

        foreach ($batch_data as $index => $data) {

            $non_empty_row_count++;
            if (!empty($data)) {
                $line_number = $start_index + $index + 2;
                $log_remarks = [];

                // Sanitize and validate data
                $generic_name = $this->sanitizeData($data[0]);
                if ($this->isTypeNameExists($generic_name)) {
                    $existing_count++;
                } else {
                    // Save to DB
                    $model = new MasGeneric();
                    $model->created_by = Yii::app()->user->id;
                    $model->updated_by = Yii::app()->user->id;
                    $model->created_date_time = date('Y-m-d H:i:s');
                    $model->updated_date_time = date('Y-m-d H:i:s');
                    $model->generic_name = ucfirst(strtolower($generic_name));
                    $model->isDefault = 'N';
                    if ($model->save()) {
                        $success_count++;
                    }
                }


            }
        }
        // $existing_count = ($batch - 1) * $batch_size;

        // Yii::app()->session['batch_no'] = $batch + 1;

        if ($start_index + $batch_size < $total_records) {
            $next_batch = $batch + 1;
            echo json_encode([
                'status' => 'success',
                'message' => '',
                'flag' => 'continue',
                'next_button' => '<a href="javascript:void(0);" 
                            id="next-batch-btn" 
                            data-url="' . Yii::app()->createUrl('generic/SaveCategoryUploadCsv', [
                        'filename' => $file_name,
                        'batch' => $next_batch

                    ]) . '"
                            style="display: inline-block; border: 2px solid #000080; padding: 5px 15px; font-size: 12px; font-weight: bold; background: #000080; color: #fff; text-decoration: none;">
                            Upload Next 200
                          </a>',
                'total_records' => $total_records,
                'success_count' => $success_count,
                'error_count' => $error_count,
                'non_empty_row_count' => $non_empty_row_count,
                'existing_count' => $existing_count,
            ]);
        } else {
            echo json_encode([
                'status' => 'success',
                'message' => '',
                'success_count' => $success_count,
                'error_count' => $error_count,
                'non_empty_row_count' => $non_empty_row_count,
                'existing_count' => $existing_count,
                'total_records' => $total_records,
            ]);
        }
    }
    public function actionDownloadErrorCsv()
    {
        $file_name = $event_id = Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../uploads/generic_csv/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }
    private function sanitizeData($data)
    {
        return !empty($data) ? trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data), '"') : '';
    }

    private function sanitizeNumber($data)
    {
        $sanitizedData = str_replace(',', '', trim($data));
        return is_numeric($sanitizedData) ? (float) $sanitizedData : 0.0;
    }
    private function validateAndPrepareLog($data, &$log_remarks)
    {
        $log_remarks = [];

        // Sanitize and assign data
        $generic_name = $this->sanitizeData($data[0]);



        // Validate 'code'
        if (empty($generic_name)) {

            $log_remarks[] = "Category Name is required.";
        } else {
            // if ($this->isTypeNameExists($generic_name)) {
            //     $log_remarks[] = "Code must be unique.";
            // }
        }
        // var_dump($log_remarks);

        return $log_remarks;
    }
    private function isTypeNameExists($code)
    {
        $code = strtolower(trim($code));
        return MasGeneric::model()->exists('LOWER(TRIM(generic_name)) = :code', [':code' => $code]);
    }

    public function actionUploadCategoryCsv($folder = null)
    {
        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';

        // Check if directory exists or create it
        if (!is_dir($folder)) {
            mkdir($folder, 0777, true);
        }

        // Define allowed extensions and size limit
        $allowedExtensions = array();
        $sizeLimit = 2 * 1024 * 1024; // 2MB

        // Handle file upload
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);

        // Return JSON response
        echo htmlspecialchars(json_encode($result), ENT_NOQUOTES);
    }
}