<?php

class FlyerController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'sendsave', 'sendReportPDF', 'Downloadsentlist', 'sendReportExcel', 'bulksend', 'reportlist', 'getconactlist', 'Create', 'GetList', 'SaveFlyer', 'DeleteFlyer', 'DirectAdd', 'GetFlyers', 'Disable', 'send', 'GetCustomerDetails', 'GetCustomerContactDetails', 'ReportPDF', 'ExcelReport', 'reportsendlist'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionGetList() {
        $model = new Flyers();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column title
            0 => 'id',
            1 => 'title',
            2 => 'isActive',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "  (title LIKE '%" . $searchString . "%' )";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_inv_Flyer_edit"])) {
                //  $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'Flyer/create&id='.$row['id'].'\',\'Edit Flyer\',\'lg\')"><i class="fa fa-pencil"></i></button> ';
            }
            $rowData[] = array($m,
                $row['title'],
                $row['isActive'],
                array('id' => $row['id'], 'code' => $row['title'], 'status' => $row->isActive));


            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new Flyers();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('flyer_form', array('model' => $model), false, false);
    }

    public function actionSaveFlyer() {
        $model = new Flyers();
        if (isset($_POST['Flyers'])) {
            if ((int) @$_POST['Flyers']['id'] > 0) {
                $id = (int) @$_POST['Flyers']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d h:i:s');
            }
            $model->updated_by = Yii::app()->user->id;
            $model->updated_date_time = date('Y-m-d h:i:s');
            $model->attributes = $_POST['Flyers'];
            if ($model->save()) {
                // inserting to audit log
                AuditLog::saveAuditLogs(
                        'FLYER_MASTER', Yii::app()->user->id, $audit_type, " with title: - {$model->title}  "
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['Flyer_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDeleteFlyer() {
        $id = $_POST['id'];
        $model = new Flyers();
        $del = $model->findByPk($id); // audit log changes
        $model->deleteByPk($id);
        // inserting to audit log
        AuditLog::saveAuditLogs(
                'FLYER_MASTER', Yii::app()->user->id, 'DELETED', " with title: - {$del->title}  "
        );
        // end audit log
        echo "success";
    }

    public function actionDirectAdd() {
        $from = $_POST['from'];
        $title = $_POST['title'];
        $rack = $_POST['rack'];
        if ($title != '') {
            $modelFlyer = new Flyers;
            $modelFlyer->title = $title;
            $modelFlyer->rack_id = $rack;
            if ($modelFlyer->save()) {
                $data = Flyers::getFlyers();
                if ($from == 'inventory') {
                    $model = new ProductLocation;
                    $field_title = 'Flyer';
                }
                $model->$field_title = $modelFlyer->id;
                $drop = CHtml::activedropDownList($model, $field_title, $data, array('class' => 'tooltipster', 'data-label' => 'Flyer'));
                $status = array("status" => "success", "drop" => $drop);
                echo CJSON::encode($status);
            } else {
                $error = CActiveForm::validate($modelFlyer, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionGetFlyers() {
        $model = $_POST['model'];
        $field_id = $_POST['field_id'];
        $id = (int) $_POST['id'];
        echo CHtml::activedropDownList(new $model, $field_id, Flyers::getFlyers_rackwise($id), array('data-label' => 'Flyer'));
    }

    public function actionDisable() {
        $status_arr = array('N' => 'Disabled', 'Y' => "Enabled");
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new Flyers();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        $msg = $status_arr[$model->isActive] . ' successfully';
        echo json_encode(array("status" => "success", 'msg' => $msg));
    }

    public function actionSend() {
        $id = Yii::app()->request->getparam('id');
        $model = new Flyers();
        $model = $model->findByPk($id);
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('send_flyer_form', array('model' => $model), false, false);
    }

    public function actionGetCustomerDetails() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'customer_name LIKE "%' . $searchTerm . '%" AND t.isActive="Y"';
        $model = new Customer();
        $model = $model->findAll(array('select' => 't.id,t.customer_name', 'condition' => $condition, 'limit' => 200));
        $i = 0;
        $data = array();
        foreach ($model as $eachModel) {
            $modshipaddress = CustomerShippingDetails::model()->find(array('condition' => 'customer_id=' . $eachModel->id));
            $data[$i]['value'] = $eachModel->id;
            $location = "";
            if (!empty($eachModel->customer_location)) {
                $location = " [" . $eachModel->customer_location . " ]";
            }
            $data[$i]['customername'] = $eachModel->customer_name;
            $data[$i]['label'] = $eachModel->customer_name . "" . $location;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionGetCustomerContactDetails() {
        $id = Yii::app()->request->getparam('id');
        $flyer_id = $_GET['flyer_id'];
        $cond = 't.flyer_id =' . $flyer_id . " AND contractdetail.customer_id =  " . $id;
        $fly_model = FlyerContact::model()->with('contractdetail')->findAll(array('condition' => $cond));
        $already_sent = array("0");
        if (is_array($fly_model)) {
            foreach ($fly_model as $value) {
                array_push($already_sent, $value->contact_id);
            }
        }
        $already_sent_list = implode(",", $already_sent);
        $condition = 't.isActive = "Y"  AND customer_id=' . $id . " AND t.id NOT IN (" . $already_sent_list . ") ";
        $contacts = CustomerContact::model()->findAll(array('condition' => $condition, 'order' => 'person_name'));
        $response = CHtml::listData($contacts, 'id', 'person_name');
        $email = array();
        foreach ($contacts as $value) {
            $email[] = array(
                'id' => $value->id,
                'email' => $value->contact_email_id
            );
        }
        $data['data'] = CHtml::dropDownList('contact_select', '0 ', $response, array('onchange' => 'js:newitem(this.id, this.value)', 'data-label' => 'Contact', 'multiple' => true, 'data-search' => true));
        $data['email'] = $email;
        $data['status'] = 'success';
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionsendsave() {
        if (isset($_POST['contactlist'])) {
            $flyer_id = $_POST['flyer_id'];
            $list_arr = $_POST['contactlist'];
            $valid = true;
            $error = array();
            $model = array();
            $i = 0;
            foreach ($list_arr as $value) {

                $id = $value;
                $condition = 'contact_id = ' . $id . " AND flyer_id= " . $flyer_id;
                $model[$i] = FlyerContact::model()->findAll(array('condition' => $condition));

                if (empty($model[$i])) {
                    $contact = CustomerContact::model()->findByPk($id);
                    $model[$i] = new FlyerContact();
                    $model[$i]->flyer_id = $flyer_id;
                    $model[$i]->contact_id = $id;
                    $model[$i]->customer_id = $contact->customer_id;
                    $model[$i]->created_date_time = date('Y-m-d h:i:s');
                    $model[$i]->created_by = Yii::app()->user->id;
                    $valid = $valid && $model[$i]->validate();
                    $i++;
                }
            }

            if ($valid) {

                foreach ($model as $value) {
                    $value->save();
                }
                $data['status'] = 'success';
                echo CJSON::encode($data);
            } else {
                echo CActiveForm::validateTabular($model, '', false);
            }
        }
    }

    function actiongetconactlist() {
        $model = new FlyerContact();
        $id = Yii::app()->request->getparam('id');
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column title
            0 => 't.id',
            1 => 't.created_date_time',
            2 => 'contact_id',
            3 => 'person_name',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.flyer_id=' . $id;
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= "  AND  (contractdetail.person_name LIKE '%" . $searchString . "%' )";
        }
        $count = $model->with('contractdetail')->count(array('condition' => $condition));
        $model = $model->with('contractdetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            $div = '';

            $rowData[] = array($m,
                date('d/m/Y', strtotime($row->created_date_time)),
                $row->contractdetail->customer->customer_name,
                $row->contractdetail->person_name,
                $row->contractdetail->contact_email_id,
            );


            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionreportlist() {
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('print_flyer_list', $_POST, false, true);
    }

    public function actionReportPDF() {
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.views.front.flyer.print_flyer_pdf', $_GET, true));
        $mpdf->Output("InvoiceReport.pdf", 'I');
    }

    public function actionExcelReport() {


        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"flyer_report.xls\"");
        echo $this->renderPartial('print_flyer_excel', $_GET, true);
        Yii::app()->end();
        return;
    }

    public function actionReportsendlist() {
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);

        $this->render('print_flyer_send_list', $_POST, false, true);
    }

    public function actionbulksend() {
        $arr = $_POST["select"];
        $customer_arr = $_POST['select_customer'];

        $flyer_id = $_POST["flyer_id"];
        $i = 0;
        $j = 0;
        $sent_list = array();

        // Saving Customer contact
        foreach ($arr as $value) {
            $id = $value;
            $condition = 'contact_id = ' . $id . " AND flyer_id= " . $flyer_id;
            $model[$i] = FlyerContact::model()->findAll(array('condition' => $condition));

            if (empty($model[$i])) {
                $contact = CustomerContact::model()->findByPk($id);
                $model[$i] = new FlyerContact();
                $model[$i]->flyer_id = $flyer_id;
                $model[$i]->contact_id = $id;
                $model[$i]->customer_id = $contact->customer_id;
                $model[$i]->created_date_time = date('Y-m-d h:i:s');
                $model[$i]->created_by = Yii::app()->user->id;
                if ($model[$i]->save()) {
                    $j++;
                    $sent_list[] = array(
                        'email' => $contact->contact_email_id,
                        'name' => $contact->person_name,
                    );
                }
            }
            $i++;
        }
        // Saving Customer
        foreach ($customer_arr as $value) {
            $id = $value;
            $condition = 'customer_id = ' . $id . " AND  contact_id = 0  AND flyer_id= " . $flyer_id;
            $model[$i] = FlyerContact::model()->findAll(array('condition' => $condition));

            if (empty($model[$i])) {
                $customer = Customer::model()->findByPk($id);
                $model[$i] = new FlyerContact();
                $model[$i]->flyer_id = $flyer_id;
                $model[$i]->contact_id = 0;
                $model[$i]->customer_id = $customer->id;
                $model[$i]->created_date_time = date('Y-m-d h:i:s');
                $model[$i]->created_by = Yii::app()->user->id;
                if ($model[$i]->save()) {
                    $j++;
                    $sent_list[] = array(
                        'email' => $customer->customer_email_id,
                        'name' => $customer->customer_name,
                    );
                    if ($customer->nick_name != "") {
                        $sent_list[] = array(
                            'email' => $customer->nick_name,
                            'name' => $customer->customer_name,
                        );
                    }
                }
            }
            $i++;
        }
        //end saving

        $bulk_id = 0;

        if ($j > 0) {
            $bluksend = new FlyerBulkSend();
            $bluksend->details = json_encode($sent_list);
            $bluksend->created_date_time = date('Y-m-d h:i:s');
            $bluksend->created_by = Yii::app()->user->id;
            if ($bluksend->save()) {
                $bulk_id = $bluksend->id;
            } else {
                print_r($bluksend->getErrors());
                die();
            }
        }
        echo json_encode(
                array("status" => "success",
                    "no" => $j,
                    'id' => $bulk_id
                )
        );
    }

    public function actionsendReportPDF() {
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('application.views.front.flyer.print_flyer_send_pdf', $_GET, true));
        $mpdf->Output("flyer_report.pdf", 'I');
    }

    public function actionsendReportExcel() {
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"flyer_report.xls\"");
        echo $this->renderPartial('print_flyer_send_excel', $_GET, true);
        Yii::app()->end();
        return;
    }

    function actionDownloadsentlist() {
        header('Content-Type: application/csv');
        header("Content-disposition: attachment; filename=\"flyer_report.xls\"");
        echo $this->renderPartial('download_sent_list', $_GET, true);
        Yii::app()->end();
        return;
    }

}
