<?php

class ExcelController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('PrintDirectTransferReportExcel','salarypaymentreport'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionPrintDirectTransferReportExcel()
    {
        $model = new InventoryDirectTransfer();

        $from_warehouse = Yii::app()->request->getParam('from_warehouse');

        $to_warehouse = Yii::app()->request->getParam('to_warehouse');

        $transfer_from_date = Yii::app()->request->getParam('transfer_from_date');

        $transfer_to_date = Yii::app()->request->getParam('transfer_to_date');

        $transfer_no = Yii::app()->request->getParam('transfer_no');
        
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'Direct Transfer List.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('//excel/print_direct_transfer_excel', array('model' =>$model,'from_warehouse' => $from_warehouse,'to_warehouse' => $to_warehouse,'transfer_from_date' =>$transfer_from_date,'transfer_to_date' =>$transfer_to_date,'transfer_no' => $transfer_no), false, true);
        Yii::app()->end();
    }
    
}
