<?php

/* * ***********created by jisha on 9/11/22********** */

class DirectsalesinvoiceController extends Controller
{

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Create', 'Save', 'DeleteItem', 'Getunitdrop', 'GetunitRate',
                    'CancelInvoice'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionCreate()
    {
        $model = new Invoice();
        $id = Yii::app()->request->getParam('id');
        $type = Yii::app()->request->getParam('type');
        $modelItems = array(new InvoiceItem);
        $modelInvItem = new InvoiceItem;
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelItems = $modelInvItem->model()->findAll(array('condition' => 'invoice_id="' . $id . '"'));
            if (empty($modelItems)) {
                $modelItems = array(new InvoiceItem());
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model, 'modelInvoiceItems' => $modelItems, 'type' => $type));
    }

    public function actionGetunitdrop()
    {
        $row = $_POST['row_field'];
        $product = $_POST['product_id'];
        $type = $_POST['type'];
        $selling_price = $_POST['selling_price'];
        $drop = array();
        $modelInvItem = new InvoiceItem;
        $modUOM = new UnitOfMeasurement();
        if ((int)$product > 0) {
            $arr_uom = $modUOM->getSecondaryBaseUnitWithName((int)$product);
            $modelInvItem->unit_id = $arr_uom->id;
            $drop['drop'] = CHtml::activedropdownlist($modelInvItem, "[" . $row . "]unit_id", $modUOM->getUnits((int)$product), array('class' => 'unit go', 'onchange' => 'checkUnitItem(this.id);'));
            if (!empty($arr_uom)) {
                $drop['factor'] = $arr_uom->factor;
                $drop['selling_price'] = ($selling_price * $arr_uom->factor);
            } else {
                $drop['factor'] = 1;
                $drop['selling_price'] = $selling_price;
            }
        }
        echo CJSON::encode($drop);
    }

    public function actionGetunitRate()
    {
        $product_id = (int) $_POST['product_id'];
        $unit_id = (int) $_POST['unit'];
        $selling_price = $_POST['selling_price'];
        $drop = array();
        if ($product_id > 0) {
            $arr_uom = UnitOfMeasurement::model()->findByPK($unit_id);

            $pricing_condition = 'product_id=' . $product_id . ' AND uom_id=' . (int) $unit_id;
            $arr_price_list = SalesPriceGroup::model()->find(array('condition' => $pricing_condition));

            $drop['factor'] = $arr_uom->factor;
            if (!empty($arr_price_list->sales_price) && (int) $arr_price_list->sales_price > 0) {
                $drop['selling_price'] = number_format(($arr_price_list->sales_price), 2);
            } else {
                $drop['selling_price'] = 0.00;
            }
        }
        echo CJSON::encode($drop);
    }

    public function actionSave()
    {
        if (isset($_POST['Invoice'])) {
            $modelInvoice = new Invoice;
            $others = array();
            $update = 0;
            $warehouse_id = (int)Yii::app()->user->getState('user_warehouse_id');

            if ((int) $_POST['Invoice']['id'] > 0) {
                $modelInvoice = $modelInvoice->findByPK($_POST['Invoice']['id']);
                $modelInvoice->updated_by = Yii::app()->user->id;
                $modelInvoice->updated_datetime = date('Y-m-d H:i:s');
                $update = 1;
            } else {
                $modelInvoice->created_by = Yii::app()->user->id;
                $modelInvoice->created_datetime = date('Y-m-d H:i:s');
                $update = 0;
            }
            $modelInvoice->attributes = $_POST['Invoice'];
            if ($_POST['Invoice']['invoice_date'] != '00/00/0000') {
                $modelInvoice->invoice_date = str_replace('/', '-', $_POST['Invoice']['invoice_date']);
                $modelInvoice->invoice_date = date("Y-m-d", strtotime($modelInvoice->invoice_date));
            } else {
                $modelInvoice->invoice_date = '';
            }
            $grand_total = $total_vat_amount = 0;
            if ($update == 0) {
                $modelInvoice->grand_total = 0;
                $modelInvoice->file_id = 0;
            }

            $modelInvoice->order_id             = 0;
            $modelInvoice->terms_and_conditions = $_POST['Invoice']['terms_and_conditions'];
            $modelInvoice->payment_terms        = $_POST['Invoice']['payment_terms'];
            $modelInvoice->invoice_type         = $_POST['Invoice']['invoice_type'];
            $modelInvoice->currency             = $_POST['Invoice']['currency'];
            $modelInvoice->remarks              = $_POST['Invoice']['remarks'];
            $modelInvoice->billing_address      = $_POST['Invoice']['billing_address'];
            $modelInvoice->invoice_status       = $_POST['Invoice']['invoice_status'];
            $modelInvoice->added_from           = 'W';
            $modelInvoice->receipt_type         = $_POST['Invoice']['receipt_type'];
            $modelInvoice->authorization_code   = $_POST['Invoice']['authorization_code'];
            $modelInvoice->received_amount      = $_POST['Invoice']['received_amount'];
            $modelInvoice->order_lpo_date       = $modelInvoice->invoice_date;
            $modelInvoice->invoice_start_date   = $modelInvoice->invoice_date;
            $modelInvoice->invoice_end_date     = $modelInvoice->invoice_date;
            $modelInvoice->is_direct_invoice    = 'Y';
            $modelInvoice->warehouse_id         = $warehouse_id;
            $modelInvoice->crm_user_id          = (int) $_POST['Invoice']['created_by'];
            $modelInvoice->lead_owner_id        = (int) $_POST['Invoice']['created_by'];

            $valid = $modelInvoice->validate();

            $groups = array();
            if (is_array($_POST['InvoiceItem'])) {
                foreach ($_POST['InvoiceItem'] as $i => $item) {
                    if ($item['product_id'] != '') {
                        $modelInvoiceItems[$i] = new InvoiceItem;
                        if ($item['id'] > 0) {
                            $modelInvoiceItems[$i] = $modelInvoiceItems[$i]->findByPk($item['id']);
                            $modelInvoiceItems[$i]->updated_by = (int) $_POST['Invoice']['created_by'];
                            $modelInvoiceItems[$i]->updated_datetime = date('Y-m-d H:i:s');
                        } else {
                            $modelInvoiceItems[$i]->created_by = (int) $_POST['Invoice']['created_by'];
                            $modelInvoiceItems[$i]->created_datetime = date('Y-m-d H:i:s');
                        }
                        $modelInvoiceItems[$i]->attributes = $item;
                        $modelInvoiceItems[$i]->invoice_id = 0;
                        if ((float) $item['rate'] <= 0) {
                            $others[] = 'Rate should be greater than zero';
                            $valid = false;
                        }
                        $modelUOM = UnitOfMeasurement::model()->findByPk((int) $item['unit_id']);
                        $item_actual_rate = $item['actual_rate'];
                        if (isset($modelUOM->factor) && (int) $modelUOM->factor > 0 && (int) $item_actual_rate > 0) {
                            $item_actual_rate = ($item['actual_rate'] * $modelUOM->factor);
                        }
                        if (!isset(Yii::app()->user->havePermissionOn['edit_selling_price'])) {
                            if ((float) $item['rate'] < (float) $item_actual_rate) {
                                $others[] = 'Rate should be greater than or equal to ' . (float) $item_actual_rate . ' [' . $item['part_no'] . ']';
                                $valid = false;
                            }
                        }
                        if ((int) $item['quantity'] <= 0) {
                            $others[] = 'Quantity should be greater than zero';
                            $valid = false;
                        }
                        $modelInvoiceItems[$i]->description = $item['description'];
                        $modelInvoiceItems[$i]->amount = $item['amount'];
                        $modelInvoiceItems[$i]->net_amount = $item['amount'] + $item['tax_vat_amount'];
                        $modelInvoiceItems[$i]->unit_id = $item['unit_id'];
                        $store = new Store();
                        $store = $store->findByPk((int)$item['product_id']);
                        $modelInvoiceItems[$i]->cost_rate = $store->rate;
                        $modelInvoiceItems[$i]->brand_class_id = $store->brand_class_id;
                        $modelInvoiceItems[$i]->product_generic_name = $store->generic_id;
                        $modelInvoiceItems[$i]->picked_qty = $item['quantity'];
                        $discount_amount = 0;
                        if ((int)$item['deduction_percentage'] > 0) {
                            $discount_amount =  ($item['rate'] * $item['quantity']) * ((int)$item['deduction_percentage'] / 100);
                        }
                        if ((int) $item['deduction_amount'] > 0) {
                            $modelInvoiceItems[$i]->deduction_amount = $item['deduction_amount'] + $discount_amount;
                        } else {
                            $modelInvoiceItems[$i]->deduction_amount = $discount_amount;
                        }
                        $grand_total += $item['amount'];
                        $total_vat_amount += $item['tax_vat_amount'];
                        $valid = $modelInvoiceItems[$i]->validate() && $valid;

                        /*check whether product in user warehouse stock */
                        $modelUOM = UnitOfMeasurement::model()->findByPk((int) $item['unit_id']);
                        $key = $item['product_id'];
                        if (!array_key_exists($key, $groups)) {
                            if ($item['quantity'] && $modelUOM->factor) {
                                $qty = $item['quantity'] * $modelUOM->factor;
                            }
                            $groups[$key] = array(
                                'id' => $item['product_id'],
                                'quantity' => $qty,
                                'unit_id' => $item['unit_id']
                            );
                        } else {
                            $groups[$key]['quantity'] = $groups[$key]['quantity'] + ($item['quantity'] * $modelUOM->factor);
                        }
                        /*check whether product in user warehouse stock */
                    }
                }
            }

            $received_cash_amount = (float) trim($_POST['Invoice']['received_cash_amount']);

            $received_card_amount = (float) trim($_POST['Invoice']['received_card_amount']);
            $total_received_amount = number_format(($received_cash_amount + $received_card_amount), 2, ".", '');
            $modelInvoice->received_amount = $total_received_amount;
            $modelInvoice->received_cash_amount = $received_cash_amount;
            $modelInvoice->received_card_amount = $received_card_amount;



            $modwarehouse = new MasInventoryWarehouse();
            $warehouse_name = $modwarehouse->getWarehouseName((int)$warehouse_id);
            if (!empty($groups)) {
                foreach ($groups as $key => $eachProduct) {
                    $availble_qty = Yii::app()->db->createCommand('SELECT IFNULL(SUM(quantity*unit_factor),0) as availble_qty FROM `erp_stock_ledger` WHERE product_id=' . $eachProduct['id'] . ' AND warehouse_id=' . (int)$warehouse_id)->queryScalar();
                    $store = new Store();
                    $store = $store->findByPk((int)$eachProduct['id']);
                    $modelUOM = new UnitOfMeasurement();
                    $base_unit_name = $modelUOM->getBaseunitname((int)$eachProduct['id']);
                    if ($eachProduct['quantity'] > $availble_qty) {
                        $others[] = $store['part_number'] . ' maximum sellable qty : ' . number_format($availble_qty, 2) . ' ' . $base_unit_name;
                        $valid = false;
                    }
                }
            }
            if ($_POST['Invoice']['received_amount'] < 0) {
                $others[] = 'Received Amount Should be greater than 0 ';
                $valid = false;
            }
            if ($_POST['Invoice']['received_amount'] > ($grand_total + $total_vat_amount)) {
                $others[] = 'Received Amount Should be less than or equal to ' . ($grand_total + $total_vat_amount);
                $valid = false;
            }
            if ($valid && !empty($modelInvoiceItems)) {
                //code added by mereena on 11/11/2022 to get current series no
                $modelWarehouse = new MasInventoryWarehouse();

                $modelWarehouse = $modelWarehouse->findByPk($warehouse_id);

                $current_serial_no = (int) $modelWarehouse->invoice_current_series_no;
                $start_series_no = (int) $modelWarehouse->invoice_start_series_no;

                if ($current_serial_no > 0) {
                    $invoice_current_series_no = $current_serial_no + 1;
                } else {
                    $invoice_current_series_no = $start_series_no;
                }
                //end


                $modelMaster = new MasterFile();
                $modelMaster->customer_id = $_POST['Invoice']['customer_id'];
                $modelMaster->start_from = "I";
                $modelMaster->current_process_status = "I";
                $modelMaster->crm_user_id = (int) $_POST['Invoice']['created_by'];
                $modelMaster->lead_owner_id = (int) $_POST['Invoice']['created_by'];
                $modelMaster->file_title = "";
                $modelMaster->is_approved = "Y";
                $modelMaster->approved_by = (int) $_POST['Invoice']['created_by'];
                $modelMaster->date_of_approval = date('Y-m-d');
                $modelMaster->created_by = (int) $_POST['Invoice']['created_by'];
                $modelMaster->created_datetime = date('Y-m-d');
                $modelMaster->save(false);
                $modelMaster->refresh();
                $file_id = (int)$modelMaster->id;
                $modelInvoice->file_id = $file_id;
                $modelInvoice->save();
                if (!empty($modelInvoiceItems)) {
                    foreach ($modelInvoiceItems as $eachItem) {
                        $eachItem->invoice_id = $modelInvoice->id;
                        $eachItem->save(false);


                        $modelStockLedger = new StockLedger();
                        $modelStockLedger->file_id = $file_id;
                        $modelStockLedger->header_id = $modelInvoice->id;
                        $modelStockLedger->header_item_id = $eachItem['id'];
                        $modelStockLedger->customer_vendor_id = $modelInvoice->customer_id;
                        $modelStockLedger->customer_vendor_name = $_POST['Invoice']['customer_name'];
                        $modelStockLedger->product_id = $eachItem['product_id'];
                        $modelStockLedger->product_name = $eachItem->product->part_number;
                        $modelStockLedger->product_description = $eachItem->product->description;
                        $modelStockLedger->brand_id = $eachItem->product->brand_class_id;
                        $modelStockLedger->brand_name = $eachItem->product->brand_detail->product_class;
                        $modelStockLedger->warehouse_id = $warehouse_id;
                        $modelStockLedger->warehouse_name = $warehouse_name;
                        $modelRack = new MasInvRack();
                        $modelStockLedger->rack_id = $modelRack->getDefaultRackId();
                        $modelStockLedger->rack_name = $modelRack->getRackName((int)$modelStockLedger->rack_id);
                        $modelBin = new MasInvBin();
                        $modelStockLedger->bin_id = $modelBin->getDefaultBinId();
                        $modelStockLedger->bin_name = $modelBin->getBinName((int)$modelStockLedger->bin_id);
                        $modelStockLedger->unit_id = $eachItem['unit_id'];
                        $modelUOM = new UnitOfMeasurement();
                        $modelUOM = $modelUOM->findByPk((int) $eachItem['unit_id']);
                        $modelStockLedger->unit_name               = $modelUOM->name;
                        $modelStockLedger->unit_factor             =  $modelUOM->factor;
                        $modelStockLedger->quantity                = -1 * $eachItem['quantity'];
                        $modelStockLedger->available_status        = 'U';
                        $modelStockLedger->buying_price            = 0;
                        $modelStockLedger->batch_no                = '';
                        $modelStockLedger->serial_no               = '';
                        $modelStockLedger->manufacturing_date      = '0000-00-00';
                        $modelStockLedger->expiry_date             = '0000-00-00';
                        $modelStockLedger->cost_price              = $eachItem->product->rate;
                        $modelStockLedger->sales_price             = $eachItem['rate'] * $modelUOM->factor;
                        $modelStockLedger->transaction_date        = $modelInvoice['invoice_date'];
                        $modelStockLedger->transaction_from        = 'DIRECT_INVOICE';
                        $modelStockLedger->transaction_type        = "OUT";
                        $modelStockLedger->stock_after_transaction =   0;
                        $modelStockLedger->stock_value_after_transaction =   0;
                        $modelStockLedger->master_stock_ledger_id  =   0;
                        $modelStockLedger->stock_updated           =  'Y';
                        $modelStockLedger->created_by              = (int) $_POST['Invoice']['created_by'];;
                        $modelStockLedger->created_date            = date("Y-m-d H:i:s");
                        $modelStockLedger->save(false);
                    }
                }
                $modelInvoice->updateByPk($modelInvoice->id, array('invoice_no' => $invoice_current_series_no, 'file_id' => $file_id, 'total_tax_amount' => $total_vat_amount, 'net_amount' => $grand_total, 'grand_total' => ($grand_total + $total_vat_amount)));

                //code added by mereena on 11/11/2022 to update current series no
                $modelWarehouse = new MasInventoryWarehouse();
                $modelWarehouse->updateByPk($warehouse_id, array('invoice_current_series_no' => $invoice_current_series_no));
                //end


                if ((int) $modelInvoice->id > 0) {
                    AuditLog::saveAuditLogs(
                        'INVOICE',
                        Yii::app()->user->id,
                        'CREATED',
                        " with id: - {$modelInvoice->id}  "
                    );
                    // end audit log
                }
                $jsonData['status'] = 'success';
                $jsonData['invoice_id'] = $modelInvoice->id;
                echo CJSON::encode($jsonData);
            } else {
                $error1 = array();
                $error2 = array();
                $error1 = json_decode(CActiveForm::validate($modelInvoice, '', false), true);
                if (!empty($modelInvoiceItems[0]->product_id)) {
                    $error2 = json_decode(CActiveForm::validateTabular($modelInvoiceItems, '', false), true);
                } else {
                    $error2[] = "Please add atleast one line item";
                }

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $others));

                if ($error != '[]') {
                    echo $error;
                }
            }
        } else {
            echo 'error';
        }
    }

    public function actionDeleteItem()
    {
        $id = $_POST['id'];
        if ($id > 0) {
            InvoiceItem::model()->deleteByPk($id);
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }


    public function actionCancelInvoice()
    {
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $modelInvoice = Invoice::model()->with('items')->findByPk($id);
            if ($modelInvoice->posted == 'Y') {
                $jsonData['status']    = 'Error In Cancellation ,  This Invoice was Posted to the Finance!';
            
                echo CJSON::encode($jsonData);
            } else if($modelInvoice->invoice_status == 'C'){
                
                 $jsonData['status']    = 'Error In Cancellation, Already Cancelled!';
                echo CJSON::encode($jsonData); 
                
            }
            else {
                //Updating File Table
                if ($modelInvoice->file_id > 0) {
                    MasterFile::model()->updateAll(array('current_process_status' => "O", 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d H:i:s')), 'id IN(' . $modelInvoice->file_id . ')');
                }
                //Updating Invoice Table  
                Invoice::model()->updateByPk($id, array('invoice_status' => 'C', 'updated_by' => Yii::app()->user->id, 'updated_datetime' => date('Y-m-d H:i:s'), 'receipt_type' => 'N', 'received_card_amount' => '0.00', 'received_cash_amount' => '0.00','received_amount' => '0.00'));

                foreach ($modelInvoice->items as $eachItem) {
                    //store data into stock ledger  
                    $modelExistStockLedger                         =   new StockLedger();
                    $modelExistStockLedger = $modelExistStockLedger->find(array('condition' => 'header_id=' . $modelInvoice->id . ' AND header_item_id=' . $eachItem->id . ' AND transaction_from="DIRECT_INVOICE"'));

                    //echo '<pre>';
                    //print_r($modelExistStockLedger);

                    $modelStockLedger                         =   new StockLedger();
                    $modelStockLedger->file_id                =   $modelInvoice->file_id;
                    $modelStockLedger->header_id              =   $modelInvoice->id;
                    $modelStockLedger->header_item_id         =   $eachItem->id;
                    $modelStockLedger->customer_vendor_id     =   $modelInvoice->customer_id;
                    $modelStockLedger->customer_vendor_name   =   $modelInvoice->customer->customer_name;
                    $modelStockLedger->product_id             =   $eachItem->product_id;
                    $modelStockLedger->product_name           =   $eachItem->product->part_number;
                    $modelStockLedger->product_description    =   $eachItem->product->description;
                    $modelStockLedger->brand_id               =   $eachItem->product->brand_class_id;
                    $modelStockLedger->brand_name             =   $eachItem->product->brand_detail->product_class;
                    $modelStockLedger->warehouse_id           =   $modelInvoice->warehouse_id;
                    $modelStockLedger->warehouse_name         =   $modelInvoice->warehouse->warehouse_name;
                    $modelStockLedger->rack_id                =   $modelExistStockLedger->rack_id;
                    $modelStockLedger->rack_name              =   $modelExistStockLedger->rack_name;
                    $modelStockLedger->bin_id                 =   $modelExistStockLedger->bin_id;
                    $modelStockLedger->bin_name               =   $modelExistStockLedger->bin_name;
                    $modelStockLedger->unit_id                =   $modelExistStockLedger->unit_id;
                    $modelStockLedger->unit_name              =   $modelExistStockLedger->unit_name;
                    $modelStockLedger->unit_factor            =   1;
                    $modelStockLedger->quantity               =   $eachItem->quantity;
                    $modelStockLedger->available_status       =   'A';
                    $modelStockLedger->batch_no               =   '';
                    $modelStockLedger->serial_no              =   '';
                    $modelStockLedger->manufacturing_date     =   '0000-00-00';
                    $modelStockLedger->expiry_date            =   '0000-00-00';
                    $modelStockLedger->buying_price           =   0;
                    $modelStockLedger->cost_price             =   $modelExistStockLedger->cost_price;
                    $modelStockLedger->sales_price            =   $eachItem->rate;
                    $modelStockLedger->stock_after_transaction =   0;
                    $modelStockLedger->stock_value_after_transaction =   0;
                    $modelStockLedger->transaction_date       =   $modelInvoice['invoice_date'];;
                    $modelStockLedger->transaction_from       =   'CANCEL_INVOICE';
                    $modelStockLedger->transaction_type       =   "IN";
                    $modelStockLedger->master_stock_ledger_id  =   0;
                    $modelStockLedger->stock_updated          =  'Y';
                    $modelStockLedger->created_by             =   Yii::app()->user->id;
                    $modelStockLedger->created_date           =   date("Y-m-d H:i:s");
                    $modelStockLedger->save(false);
                    //end
                }

                //Audit Log
                AuditLog::saveAuditLogs(
                    'INVOICE_CANCELLED',
                    Yii::app()->user->id,
                    'CANCELLED',
                    " with ID: - {$id}  "
                );
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }
        } else {


            $jsonData['status']    = 'Error In Cancellation';
         
            echo CJSON::encode($jsonData);


            // $jsonData['status'] = 'error';
        }
    }
}
