<?php

class DirectpurchaseController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetList', 'Create', 'Save', 'Print', 'getPrize', 'getInvoiceTypeWarehouse','getExchangerate','GetProducts','SavePurchaseInvoice','SaveDirectInvoice','Convert','CheckSerialnoExist','GetCurrency'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        $this->render('index');
    }

    public function actionGetList() {
        $model = new DirectPurchaseInvoice();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.invoice_date',
            2 => 'vendor_details.vendor_name',
            3 => 'purchase_currency.currency_code',
            4 => 't.total_tax_amount',
            5 => 't.grand_total',
            6 => 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1 ';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND t.id LIKE '%" . $searchString . "%' OR t.total_tax_amount LIKE '%" . $searchString . "%' OR t.grand_total LIKE '%" . $searchString . "%' OR vendor_name LIKE '%" . $searchString . "%' OR invoice_date LIKE '%" . $searchString . "%' OR currency_code LIKE '%" . $searchString . "%'";
        }
        $count = $model->with('vendor_details', 'currencyname')->count(array('condition' => $condition));
        $model = $model->with('vendor_details', 'currencyname')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();

        foreach ($model as $i => $row) {
            //Invoice ID
            $invoice_no=$row['id'];
            $model_invoice_id = PurchasingInvoice::model()->find(array('condition' => 'purchase_invoice="DP" AND po_id="'.$row['id'].'"'));
            if($model_invoice_id->id!=''){
                $invoice_no=$model_invoice_id->id;
            }
            $div = '';
            $div .= '<div class="text-center">';
            if ((isset(Yii::app()->user->havePermissionOn['direct_purchase_edit']) || Yii::app()->user->authorised_user == 1) && $row['posted']=='N') {
                    $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'directpurchase/create&type=edit&id=' . $row['id'] . '\',\' Edit Purchase\',\'xl\')"><i class="fa fa-pencil"></i></button> ';
            }
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["direct_purchase_view"])) {
                $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'directpurchase/create&type=view&id=' . $row['id'] . '\',\' View Purchase - ' .$invoice_no. ' \',\'xl\')"><i class="fa fa-eye"></i></button>';
            }
            if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["direct_purchase_pdf"]))) {
                $div .= ' <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=directpurchase/print&id=' . $row['id'] . '&frm=tax"><i class="fa fa-file-pdf-o"></i></a>';
            }
            if ((isset(Yii::app()->user->havePermissionOn['direct_purchase_post']) || Yii::app()->user->authorised_user == 1) && $row['posted']=='N') {
                $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'directpurchase/create&type=convert&id=' . $row['id'] . '\',\'Convert to Invoice\',\'xl\')" title="Convert to Invoice"><i class="fa fa-retweet"></i></button>';
            }
            $rowData[] = array($invoice_no, date("d/m/Y", strtotime($row['invoice_date'])), $row['vendor_details']['vendor_name'], $row['currencyname']['currency_code'], '<div class="text-right">' . number_format($row['total_tax_amount'], 2, '.', '') . '<div>', '<div class="text-right">' . number_format($row['grand_total'], 2, '.', '') . '<div>', $div);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate() {
        $model = new DirectPurchaseInvoice();
        $id = Yii::app()->request->getParam('id');
        $type = Yii::app()->request->getParam('type');
        $modelPurchaseItems = array(new DirectPurchaseInvoiceItem);
        $modelAdditions = array(new DirectPurchaseInvoiceAddition);
        $modelDeductions = array(new DirectPurchaseInvoiceDeduction);
        
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelPurchaseItems = DirectPurchaseInvoiceItem::model()->findAll(array('condition' => 'purchasing_invoice_id="' . $id . '"'));
            if (empty($modelPurchaseItems)) {
                $modelPurchaseItems = array(new DirectPurchaseInvoiceItem);
            }
            $modelAdditions = DirectPurchaseInvoiceAddition::model()->findAll(array('condition' => 'purchasing_invoice_id="' . $id . '"'));
            if (empty($modelAdditions)) {
              $modelAdditions = array(new DirectPurchaseInvoiceAddition);
            }
            $modelDeductions = DirectPurchaseInvoiceDeduction::model()->findAll(array('condition' => 'purchasing_invoice_id="' . $id . '"'));
            if (empty($modelDeductions)) {
              $modelDeductions = array(new DirectPurchaseInvoiceDeduction);
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model, 'modelPurchaseItems' => $modelPurchaseItems, 'type' => $type, 'modelAdditions' => $modelAdditions, 'modelDeductions' => $modelDeductions,'type'=>$type));
    }
     public function actionSaveDirectInvoice()
    {
        $modelPurchaseInvoice = new DirectPurchaseInvoice();
        if (isset($_POST['DirectPurchaseInvoice'])) {
            
            if ((int) $_POST['DirectPurchaseInvoice']['id'] > 0) {

                $modelPurchaseInvoice = $modelPurchaseInvoice->findByPK($_POST['DirectPurchaseInvoice']['id']);
                $modelPurchaseInvoice->updated_by = Yii::app()->user->id;
                $modelPurchaseInvoice->updated_datetime = date('Y-m-d H:i:s');
                $update=1;
            } else {
                $modelPurchaseInvoice->created_by = Yii::app()->user->id;
                $modelPurchaseInvoice->created_datetime = date('Y-m-d H:i:s');
                $update=0;
            }

            $total = $net_total = $tot_tax = 0;
            $modelPurchaseInvoice->attributes = $_POST['DirectPurchaseInvoice'];
            $modelPurchaseInvoice->exchange_rate = $_POST['DirectPurchaseInvoice']['exchange_rate'];
            $modelPurchaseInvoice->currency_id = $_POST['DirectPurchaseInvoice']['currency_id'];
            $modelPurchaseInvoice->invoice_no = $_POST['DirectPurchaseInvoice']['invoice_no'];
            $invoice_exchange_rate = $_POST['DirectPurchaseInvoice']['exchange_rate'];

            if ($_POST['DirectPurchaseInvoice']['invoice_date'] != '') {
                $modelPurchaseInvoice->invoice_date = str_replace('/', '-', $_POST['DirectPurchaseInvoice']['invoice_date']);
                $modelPurchaseInvoice->invoice_date = date("Y-m-d", strtotime($modelPurchaseInvoice->invoice_date));
            }
            if ($_POST['DirectPurchaseInvoice']['payment_date'] != '') {
                $modelPurchaseInvoice->payment_date = str_replace('/', '-', $_POST['DirectPurchaseInvoice']['payment_date']);
                $modelPurchaseInvoice->payment_date = date("Y-m-d", strtotime($modelPurchaseInvoice->payment_date));
            }
            $modelPurchaseInvoice->invoice_type = $_POST['DirectPurchaseInvoice']['invoice_type'];
            $other_errors = array();
            $grand_total = $total_amount = 0;
            $valid = $modelPurchaseInvoice->validate();
            if (is_array($_POST['DirectPurchaseInvoiceItem'])) {
                foreach ($_POST['DirectPurchaseInvoiceItem'] as $i => $item) {

                    if (!empty($item['product_id'])) {

                        $modelItem[$i] = new DirectPurchaseInvoiceItem;
                        $modelItem[$i]->attributes = $_POST['DirectPurchaseInvoiceItem'][$i];
                        $modelItem[$i]->tax_amount = $item['tax_amount'];
                        $modelItem[$i]->description = $item['description'];
                        $modelItem[$i]->id = $item['id'];

                        $total += $item['amount'];
                        $tot_tax += $item['tax_amount'];
                        $valid = $modelItem[$i]->validate() && $valid;
                        $total_amount += ($item['amount'] + $item['tax_amount']);
                    }

                }
            }

            if (is_array($_POST['DirectPurchaseInvoiceAddition'])) {
                foreach ($_POST['DirectPurchaseInvoiceAddition'] as $i => $item) {
                    $modelPurchaseInvoiceAddition[$i] = new DirectPurchaseInvoiceAddition;
                    $modelPurchaseInvoiceAddition[$i]->attributes = $_POST['DirectPurchaseInvoiceAddition'][$i];

                    $modelPurchaseInvoiceAddition[$i]->particular = $item['particular'];
                    $modelPurchaseInvoiceAddition[$i]->particular_value = $item['particular_value'];
                    $modelPurchaseInvoiceAddition[$i]->calculated_value = $item['calculated_value'];

                    $net_total += $item['calculated_value'];
                    $valid = $modelPurchaseInvoiceAddition[$i]->validate() && $valid;
                }
                $modelsToBeValidated[] = $modelPurchaseInvoiceAddition;
            }
            if (is_array($_POST['DirectPurchaseInvoiceDeduction'])) {
                foreach ($_POST['DirectPurchaseInvoiceDeduction'] as $i => $item) {
                    $modelPurchaseInvoiceDeduction[$i] = new DirectPurchaseInvoiceDeduction;
                    $modelPurchaseInvoiceDeduction[$i]->attributes = $_POST['DirectPurchaseInvoiceDeduction'][$i];

                    $modelPurchaseInvoiceDeduction[$i]->particular = $item['particular'];
                    $modelPurchaseInvoiceDeduction[$i]->particular_value = $item['particular_value'];
                    $modelPurchaseInvoiceDeduction[$i]->calculated_value = $item['calculated_value'];

                    $net_total -= $item['calculated_value'];
                    $valid = $modelPurchaseInvoiceDeduction[$i]->validate() && $valid;
                }
                $modelsToBeValidated[] = $modelPurchaseInvoiceDeduction;
            }

            if ($valid) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);

                $modelPurchaseInvoice->save();
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'DIRECT_PURCHASE',
                    Yii::app()->user->id,
                    'CREATED',
                    " INV No: - {$modelPurchaseInvoice->id} "
                );
                // end audit log  
                $invoice_id = $modelPurchaseInvoice->id;

                $tot_of_net = $tot_tax = 0;
                $footer_value = 0;
                DirectPurchaseInvoiceAddition::model()->deleteAll('purchasing_invoice_id=:refer_id', array(':refer_id' => $modelPurchaseInvoice->id));
                if (!empty($modelPurchaseInvoiceAddition)) {
                    foreach ($modelPurchaseInvoiceAddition as $eachModel) {
                        $eachModel->purchasing_invoice_id = $modelPurchaseInvoice->id;
                        $eachModel->save();
                        $grand_total += $eachModel->calculated_value;
                        $footer_value += $eachModel->calculated_value;
                    }
                }
                
                DirectPurchaseInvoiceDeduction::model()->deleteAll('purchasing_invoice_id=:refer_id', array(':refer_id' => $modelPurchaseInvoice->id));
                if (!empty($modelPurchaseInvoiceDeduction)) {
                    foreach ($modelPurchaseInvoiceDeduction as $eachModel) {
                        $eachModel->purchasing_invoice_id = $modelPurchaseInvoice->id;
                        $eachModel->save();
                        $grand_total -= $eachModel->calculated_value;
                        $footer_value -= $eachModel->calculated_value;
                    }
                }
                //echo '<pre>';
                //print_r($modelItem);
                DirectPurchaseInvoiceItem::model()->deleteAll('purchasing_invoice_id=:refer_id', array(':refer_id' => $modelPurchaseInvoice->id));
                if (!empty($modelItem)) {
                    foreach ($modelItem as $eachItem) {
                        $eachItem->purchasing_invoice_id = $modelPurchaseInvoice->id;
                        $eachItem->save(false);
                        
                        $grand_total += $eachItem->amount;
                        $tot_tax += $eachItem->tax_amount;
                    }
                }
                $tot_of_net += $tot_tax;
                $total_net_value = $tot_of_net;
                $grand_total += $tot_tax;
                $modelPurchaseInvoice->updateByPk($modelPurchaseInvoice->id, array('grand_total' => $grand_total, 'total_tax_amount' => $tot_tax));

            } else {
                $error1 = $error2 = $error3 = $error4 = array();
                $error1 = json_decode(CActiveForm::validate($modelPurchaseInvoice, '', false), true);
                if (!empty($modelItem[0]->product_id)) {
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                } else {
                    $error2[] = "Please add atleast one line item";
                }

                if (!empty($modelPurchaseInvoiceAddition)) {
                    $error3 = json_decode(CActiveForm::validateTabular($modelPurchaseInvoiceAddition, '', false), true);
                }

                if (!empty($modelPurchaseInvoiceDeduction)) {
                    $error4 = json_decode(CActiveForm::validateTabular($modelPurchaseInvoiceDeduction, '', false), true);
                }

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4));

                if ($error != '[]') {
                    echo $error;
                }

            }
            Yii::app()->end();
        } else {
            echo 'error';
        }
    }
    
    
    public function actionSavePurchaseInvoice()
    {
        $modelPurchaseInvoice = new PurchasingInvoice();
        //$modelItem = array(new DirectPurchaseInvoiceItem());
        if (isset($_POST['DirectPurchaseInvoice'])) {
            
            /*if ((int) $_POST['DirectPurchaseInvoice']['id'] > 0) {

                $modelPurchaseInvoice = DirectPurchaseInvoice::model()->findByPK($_POST['DirectPurchaseInvoice']['id']);
                $modelPurchaseInvoice->updated_by = Yii::app()->user->id;
                $modelPurchaseInvoice->updated_datetime = date('Y-m-d H:i:s');
                $update=1;
            } else {*/
                $modelPurchaseInvoice->created_by = Yii::app()->user->id;
                $modelPurchaseInvoice->created_datetime = date('Y-m-d H:i:s');
                $update=0;
                $modelMaster = new MasterFile();
                $modelMaster->customer_id = $_POST['DirectPurchaseInvoice']['vendor_id'];
                $modelMaster->start_from = "P_I";
                $modelMaster->current_process_status = "P_I";
                $modelMaster->crm_user_id = Yii::app()->user->id;
                $modelMaster->file_title = "";
                $modelMaster->save(false);

                $modelPurchaseInvoice->file_id = $modelMaster->id;
            //}

            $total = $net_total = $tot_tax = 0;
            $modelPurchaseInvoice->attributes = $_POST['DirectPurchaseInvoice'];
            $modelPurchaseInvoice->exchange_rate = $_POST['DirectPurchaseInvoice']['exchange_rate'];
            $modelPurchaseInvoice->currency = $_POST['DirectPurchaseInvoice']['currency_id'];
            $invoice_exchange_rate = $_POST['DirectPurchaseInvoice']['exchange_rate'];

            if ($_POST['DirectPurchaseInvoice']['invoice_date'] != '') {
                $modelPurchaseInvoice->invoice_date = str_replace('/', '-', $_POST['DirectPurchaseInvoice']['invoice_date']);
                $modelPurchaseInvoice->invoice_date = date("Y-m-d", strtotime($modelPurchaseInvoice->invoice_date));
            }
            $modelPurchaseInvoice->invoice_type = $_POST['DirectPurchaseInvoice']['invoice_type'];
            $modelPurchaseInvoice->crm_user_id = Yii::app()->user->id;
            $modelPurchaseInvoice->purchase_invoice = "DP";//DIRECT PURCHASE
            $modelPurchaseInvoice->is_direct_invoice = "Y";
            $other_errors = array();
            $grand_total = $total_net_value = 0;
            $valid = $modelPurchaseInvoice->validate();
            if (is_array($_POST['DirectPurchaseInvoiceItem'])) {
                foreach ($_POST['DirectPurchaseInvoiceItem'] as $i => $item) {

                    if (!empty($item['product_id'])) {

                        $modelItem[$i] = new PurchasingInvoiceItem;
                        $modelItem[$i]->attributes = $_POST['DirectPurchaseInvoiceItem'][$i];
                        $modelItem[$i]->id=0;
                        $modelItem[$i]->tax_amount = $item['tax_amount'];
                        $modelItem[$i]->net_amount = $item['amount'];

                        $total += $item['net_amount'];
                        $net_total += $item['net_amount'];
                        $tot_tax += $item['tax_amount'];
                        $valid = $modelItem[$i]->validate() && $valid;
                        $total_net_value += ($item['net_amount'] + $item['tax_amount']);
                    }

                }
            }

            if (is_array($_POST['DirectPurchaseInvoiceAddition'])) {
                foreach ($_POST['DirectPurchaseInvoiceAddition'] as $i => $item) {
                    $modelPurchaseInvoiceAddition[$i] = new PurchasingInvoiceAddition;
                    $modelPurchaseInvoiceAddition[$i]->attributes = $_POST['DirectPurchaseInvoiceAddition'][$i];

                    $modelPurchaseInvoiceAddition[$i]->particular = $item['particular'];
                    $modelPurchaseInvoiceAddition[$i]->particular_value = $item['particular_value'];
                    $modelPurchaseInvoiceAddition[$i]->calculated_value = $item['calculated_value'];

                    $net_total += $item['calculated_value'];
                    $valid = $modelPurchaseInvoiceAddition[$i]->validate() && $valid;
                }
                $modelsToBeValidated[] = $modelPurchaseInvoiceAddition;
            }
            if (is_array($_POST['DirectPurchaseInvoiceDeduction'])) {
                foreach ($_POST['DirectPurchaseInvoiceDeduction'] as $i => $item) {
                    $modelPurchaseInvoiceDeduction[$i] = new PurchasingInvoiceDeduction;
                    $modelPurchaseInvoiceDeduction[$i]->attributes = $_POST['DirectPurchaseInvoiceDeduction'][$i];

                    $modelPurchaseInvoiceDeduction[$i]->particular = $item['particular'];
                    $modelPurchaseInvoiceDeduction[$i]->particular_value = $item['particular_value'];
                    $modelPurchaseInvoiceDeduction[$i]->calculated_value = $item['calculated_value'];

                    $net_total -= $item['calculated_value'];
                    $valid = $modelPurchaseInvoiceDeduction[$i]->validate() && $valid;
                }
                $modelsToBeValidated[] = $modelPurchaseInvoiceDeduction;
            }
            
                if (is_array($_POST['ProductLocationDetails'])) {
                foreach ($_POST['ProductLocationDetails'] as $i => $item) {
                    
                    //$qccheckedQuantity[$item['header_item_id']] = (float) $qccheckedQuantity[$item['header_item_id']] + (float) $item['quantity'];
                    
                    if ( $item['product_id']>0 AND $item['quantity'] >0 ) {
                        $modelProLocDetails[$i] = new ProductLocationDetails;   
                        $modelProLocDetails[$i]->attributes = $_POST['ProductLocationDetails'][$i];
                        $modelProLocDetails[$i]->header_id = 0;
                        $modelProLocDetails[$i]->header_item_id  = 0;
                        $modelProLocDetails[$i]->product_id = $item['product_id'];
                        $modelProLocDetails[$i]->bill_of_entry =$item['bill_of_entry'];
                        $modelProLocDetails[$i]->warehouse_id=$item['warehouse_id'];
                        $modelProLocDetails[$i]->rack_id=$item['rack_id'];
                        $modelProLocDetails[$i]->bin_id=$item['bin_id'];
                        $modelProLocDetails[$i]->batch_no=$item['batch_no'];
                        $modelProLocDetails[$i]->serial_no=$item['serial_no'];
                        $modelProLocDetails[$i]->quantity=$item['quantity'];
                        $modelProLocDetails[$i]->transaction_type="PURCHASE";
                        $modelProLocDetails[$i]->created_by = Yii::app()->user->id;
                        $modelProLocDetails[$i]->created_date = date('Y-m-d h:i:s');
                        $modelProLocDetails[$i]->isActive = 'Y';
                        
                        if($item['manufacturing_date']!='00/00/0000' AND $item['manufacturing_date']!='01/01/1970' AND $item['manufacturing_date'] !=''){
                            $mf_date  = str_replace('/', '-', $item['manufacturing_date']);
                            $modelProLocDetails[$i]->manufacturing_date = date("Y-m-d", strtotime($mf_date));
                        }
                        else{
                            $modelProLocDetails[$i]->manufacturing_date = "0000-00-00";
                        }
                        if($item['expiry_date']!='00/00/0000' AND $item['expiry_date']!='01/01/1970' AND $item['expiry_date'] !=''){
                            $expiry_date  = str_replace('/', '-', $item['expiry_date']);
                            $modelProLocDetails[$i]->expiry_date = date("Y-m-d", strtotime($expiry_date));
                        } 
                        else{
                            $modelProLocDetails[$i]->expiry_date = "0000-00-00";
                        }                 
                        $valid = $modelProLocDetails[$i]->validate() && $valid;
                        
                    }
                }
            }
/*echo '<pre>';
print_r($modelProLocDetails);
exit;*/
            if ($valid) {
                

                MasterFile::model()->updateByPk($modelPurchaseInvoice->file_id, array('is_approved' => "Y", 'current_process_status' => 'P_I'));
                
                $modelPurchaseInvoice->po_id = $_POST['DirectPurchaseInvoice']['id'];
                $modelPurchaseInvoice->save();
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'PURCHASE_INVOICE',
                    Yii::app()->user->id,
                    'CREATED',
                    " INV No: - {$modelPurchaseInvoice->id} "
                );
                // end audit log  
                $invoice_id = $modelPurchaseInvoice->id;
                $file_id = $modelPurchaseInvoice->file_id;
                $model_settings = new MasCompanySettings();
                $model_settings = $model_settings->find();
                if (!empty($model_settings)) {
                    $include_vat = $model_settings->include_vat;
                }
                $tot_of_net = $tot_tax = 0;
                $old_total_qty = $old_rate = array();
                $footer_value = 0;
                if (!empty($modelPurchaseInvoiceAddition)) {
                    foreach ($modelPurchaseInvoiceAddition as $eachModel) {
                        $eachModel->purchasing_invoice_id = $modelPurchaseInvoice->id;
                        $eachModel->save();
                        $grand_total += $eachModel->calculated_value;
                        $footer_value += $eachModel->calculated_value;
                    }
                }
                if (!empty($modelPurchaseInvoiceDeduction)) {
                    foreach ($modelPurchaseInvoiceDeduction as $eachModel) {
                        $eachModel->purchasing_invoice_id = $modelPurchaseInvoice->id;
                        $eachModel->save();
                        $grand_total -= $eachModel->calculated_value;
                        $footer_value -= $eachModel->calculated_value;
                    }
                }
                if (!empty($modelItem)) {
                    foreach ($modelItem as $eachItem) {
                        $eachItem->purchasing_invoice_id = $modelPurchaseInvoice->id;
                        /*if ($eachItem['id'] > 0) {
                            $eachItem = $eachItem->findByPk($eachItem['id']);
                        }*/
                        /*echo '<pre>';
                        print_r($eachItem);
                    exit;*/
                        $eachItem->save();
                        //$eachItem->fill_up_previous();
                        
                        $grand_total += $eachItem->amount;
                        $tot_of_net += $eachItem->amount;
                        $tot_tax += $eachItem->tax_amount;
                        $modelStore = Store::model()->findBypk($eachItem->product_id);

                        $rate = $modelStore->rate;
                        $old_qty = $modelStore->totalQuantity;

                        ($include_vat == 'Y') ? $actual_cost = ($eachItem->amount + $eachItem->tax_amount) : $actual_cost = $eachItem->net_amount;
                        $actual_cost_percentage = ($total_net_value > 0) ? $actual_cost / $total_net_value : 0;
                        $actual_cost_percentage = round($actual_cost_percentage, 6);
                        $item_footer_value = $actual_cost_percentage * $footer_value;
                        $total_item_net_value = $actual_cost + $item_footer_value;
                        //code modified by mereena
                        $unit_factor=$eachItem->unitdetails->factor;
                        if(empty($unit_factor)){
                            $unit_factor=1;
                        }
                        $quantity_with_unit_factor = $eachItem->quantity * $unit_factor;
                        //end
                        $variance_value = ($quantity_with_unit_factor > 0) ? $total_item_net_value / $quantity_with_unit_factor : 0;
                        $variance_value = round($variance_value, 6);
                        $cost_with_variance = $variance_value * $modelPurchaseInvoice->exchange_rate;

                        $cur_total = $cost_with_variance * $quantity_with_unit_factor;
                        $old_net_amount = $rate * $old_qty;
                        $total_quantity = $old_qty + $quantity_with_unit_factor;
                        $total_amount = $old_net_amount + $cur_total;
                        $new_amount = ($total_quantity > 0) ? $total_amount / $total_quantity : 0;
                        $new_amount = round($new_amount, 6);
                        //echo $new_amount;
                        Store::model()->updateByPk($eachItem->product_id, array('rate' => $new_amount));
                        
                        
                        
                    }
                    
                    
                    if(!empty($modelProLocDetails)){
                        foreach ($modelProLocDetails as $eachItem) {
                            /*if(empty($eachItem->batch_no)){
                                $eachItem->batch_no  = 'QC-'.date('dmY').'-'.$modelMaterial->id;
                            }*/
                            $eachItem->header_id = $modelPurchaseInvoice->id;
                            $eachItem->save(false);
                            //$item_id  = $eachItem->header_item_id;
                            
                            /*echo '<pre>';
                            print_r($eachItem);*/
                            
                            $modelStore = Store::model()->findBypk($eachItem->product_id);
                            
                            $stockLedger = new StockLedger;
                            $stockLedger->header_id = $modelPurchaseInvoice->id;
                            $stockLedger->header_item_id = 0;
                            $stockLedger->transaction_date = $modelPurchaseInvoice->invoice_date;
                            $stockLedger->transaction_type = "PURCHASE";
                            $stockLedger->product_id = $eachItem->product_id;
                            $stockLedger->quantity = $eachItem->quantity;
                            $stockLedger->product_location_id = $eachItem->id;
                            $stockLedger->unit_id = $modelStore->unit_id;
                            $stockLedger->warehouse_id = $eachItem->warehouse_id;
                            $stockLedger->rack_id = $eachItem->rack_id;
                            $stockLedger->bin_id = $eachItem->bin_id;
                            $stockLedger->created_by = Yii::app()->user->id;
                            $stockLedger->created_date = date('Y-m-d h:i:s');
                            $stockLedger->cost_price = $modelStore->rate;
                            
                            /*echo '<pre>';
                            print_r($stockLedger);*/
                            $stockLedger->save(false);
                            
                            
                            
                            
                        }
                    } 
                    
                    
                    /*if (is_array($_POST['StockLedger'])) {
                        foreach ($_POST['StockLedger'] as $i => $eachItem) {

                            $modelStore = Store::model()->findBypk($eachItem['product_id']);

                            $stockLedger = new StockLedger;
                            $stockLedger->header_id = $eachItem['header_id'];
                            $stockLedger->header_item_id = $eachItem['header_item_id'];
                            $stockLedger->transaction_date = $modelPurchaseInvoice->invoice_date;
                            $stockLedger->transaction_type = "PURCHASE";
                            $stockLedger->product_id = $eachItem['product_id'];
                            $stockLedger->quantity = $eachItem['quantity'];
                            $stockLedger->product_location_id = $eachItem['product_location_id'];
                            $stockLedger->unit_id = $modelStore['unit_id'];
                            $stockLedger->warehouse_id = $eachItem['warehouse_id'];
                            $stockLedger->rack_id = $eachItem['rack_id'];
                            $stockLedger->bin_id = $eachItem['bin_id'];
                            $stockLedger->created_by = Yii::app()->user->id;
                            $stockLedger->created_date = date('Y-m-d h:i:s');
                            $stockLedger->cost_price = $modelStore->rate;
                            $stockLedger->save(false);
                            ProductLocationDetails::model()->updateByPk($eachItem['product_location_id'], array('isActive' => "Y"));
                        }

                    }*/
                }
                
                

                $tot_of_net += $tot_tax;
                $total_net_value = $tot_of_net;
                $net_total += $tot_tax;
                $grand_total += $tot_tax;
                $modelPurchaseInvoice->updateByPk($modelPurchaseInvoice->id, array('grand_total' => $grand_total, 'total_tax_amount' => $tot_tax));
                DirectPurchaseInvoice::model()->updateByPk($_POST['DirectPurchaseInvoice']['id'], array('posted' => 'Y'));
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                /*$model_mail_setting=Notification::model()->find(array('condition' => 'event_id="17"'));
                Yii::import('application.controllers.front.MasternotificationController'); 
                if($model_mail_setting->mail_required=='Y'){      
                    MasternotificationController::sendmail(17,$modelPurchaseInvoice->id);
                }
                if($model_mail_setting->notification_required=='Y'){                    
                    MasternotificationController::sendnotification(17,$modelPurchaseInvoice->id);
                }
                if($model_mail_setting->sms_required=='Y'){                    
                    MasternotificationController::sendsms(17,$modelPurchaseInvoice->id);
                }*/
            } else {
                $error1 = $error2 = $error3 = $error4 = $error5 = array();
                $error1 = json_decode(CActiveForm::validate($modelPurchaseInvoice, '', false), true);
                if (!empty($modelItem[0]->product_id)) {
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                } else {
                    $error2[] = "Please add atleast one line item";
                }

                if (!empty($modelPurchaseInvoiceAddition)) {
                    $error3 = json_decode(CActiveForm::validateTabular($modelPurchaseInvoiceAddition, '', false), true);
                }

                if (!empty($modelPurchaseInvoiceDeduction)) {
                    $error4 = json_decode(CActiveForm::validateTabular($modelPurchaseInvoiceDeduction, '', false), true);
                }
                
                if (!empty($modelProLocDetails)){
                    $error5 = json_decode(CActiveForm::validateTabular($modelProLocDetails, '', false), true);
                }

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4));

                if ($error != '[]') {
                    echo $error;
                }

            }
            Yii::app()->end();
        } else {
            echo 'error';
        }
    }
    
    
    

    public function actionSave() {



        if (isset($_POST['DirectPurchaseInvoice'])) {
            $modelDirectPurchaseInvoice = new DirectPurchaseInvoice;

            $total_tax_amount =0;
            $update=0;
            if ((int) $_POST['DirectPurchaseInvoice']['id'] > 0) {

                $modelDirectPurchaseInvoice = $modelDirectPurchaseInvoice->findByPK($_POST['DirectPurchaseInvoice']['id']);
                $modelDirectPurchaseInvoice->updated_by = Yii::app()->user->id;
                $modelDirectPurchaseInvoice->updated_datetime = date('y-m-d H:i:s');
                $update=1;
            } else {
                $modelDirectPurchaseInvoice->created_by = Yii::app()->user->id;
                $modelDirectPurchaseInvoice->created_datetime = date('y-m-d H:i:s');
                $update=0;
                $modelMaster = new MasterFile();
                $modelMaster->customer_id = $_POST['DirectPurchaseInvoice']['vendor_id'];
                $modelMaster->start_from = "P_I";
                $modelMaster->current_process_status = "P_I";
                $modelMaster->crm_user_id = Yii::app()->user->id;
                $modelMaster->file_title = "";
                $modelMaster->save(false);

                $modelDirectPurchaseInvoice->file_id = $modelMaster->id;
            }
            $modelDirectPurchaseInvoice->attributes = $_POST['DirectPurchaseInvoice'];

            $modelDirectPurchaseInvoice->currency = $_POST['DirectPurchaseInvoice']['currency'];
            $modelDirectPurchaseInvoice->invoice_type = $_POST['DirectPurchaseInvoice']['invoice_type'];
            $warehouse_id = (int) $_POST['DirectPurchaseInvoice']['warehouse_id'];

            $type = $_POST['DirectPurchaseInvoice']['invoice_type'];
            $model_invoice_type = MasInvoiceType::model()->findByPk($type);
            if ($_POST['DirectPurchaseInvoice']['invoice_date'] != '00/00/0000') {
                $modelDirectPurchaseInvoice->invoice_date = str_replace('/', '-', $_POST['DirectPurchaseInvoice']['invoice_date']);
                $modelDirectPurchaseInvoice->invoice_date = date("Y-m-d", strtotime($modelDirectPurchaseInvoice->invoice_date));
            }
            $valid = $modelDirectPurchaseInvoice->validate();

            if (is_array($_POST['DirectPurchaseInvoiceItem'])) {
                foreach ($_POST['DirectPurchaseInvoiceItem'] as $i => $item) {

                    $modelDirectPurchaseInvoiceItem[$i] = new DirectPurchaseInvoiceItem;
                    if ($item['id'] > 0) {
                        $modelDirectPurchaseInvoiceItem[$i] = $modelDirectPurchaseInvoiceItem[$i]->findByPk($item['id']);
                    }
                    $modelDirectPurchaseInvoiceItem[$i]->attributes = $item;
                    $modelDirectPurchaseInvoiceItem[$i]->purchasing_invoice_id = $modelDirectPurchaseInvoice->id;
                    $modelDirectPurchaseInvoiceItem[$i]->description = $item['product_description'];
                    $modelDirectPurchaseInvoiceItem[$i]->unit = $item['unit'];
                    $valid = $modelDirectPurchaseInvoiceItem[$i]->validate() && $valid;
                }
            }
            if (is_array($_POST['DirectPurchaseInvoiceAddition'])) {
                foreach ($_POST['DirectPurchaseInvoiceAddition'] as $i => $item) {
                    $modelPurchaseInvoiceAddition[$i] = new DirectPurchaseInvoiceAddition;
                    $modelPurchaseInvoiceAddition[$i]->attributes = $_POST['DirectPurchaseInvoiceAddition'][$i];

                    $modelPurchaseInvoiceAddition[$i]->particular = $item['particular'];
                    $modelPurchaseInvoiceAddition[$i]->particular_value = $item['particular_value'];
                    $modelPurchaseInvoiceAddition[$i]->calculated_value = $item['calculated_value'];

                    $net_total += $item['calculated_value'];
                    $valid = $modelPurchaseInvoiceAddition[$i]->validate() && $valid;
                }
                $modelsToBeValidated[] = $modelPurchaseInvoiceAddition;
            }
            if (is_array($_POST['DirectPurchaseInvoiceDeduction'])) {
                foreach ($_POST['DirectPurchaseInvoiceDeduction'] as $i => $item) {
                    $modelPurchaseInvoiceDeduction[$i] = new DirectPurchaseInvoiceDeduction;
                    $modelPurchaseInvoiceDeduction[$i]->attributes = $_POST['DirectPurchaseInvoiceDeduction'][$i];

                    $modelPurchaseInvoiceDeduction[$i]->particular = $item['particular'];
                    $modelPurchaseInvoiceDeduction[$i]->particular_value = $item['particular_value'];
                    $modelPurchaseInvoiceDeduction[$i]->calculated_value = $item['calculated_value'];

                    $net_total -= $item['calculated_value'];
                    $valid = $modelPurchaseInvoiceDeduction[$i]->validate() && $valid;
                }
                $modelsToBeValidated[] = $modelPurchaseInvoiceDeduction;
            }
            if ($valid) {
                
                 
                
                if ($warehouse_id == '0') {
                    $default_warehouse = MasInventoryWarehouse::model()->find(array('condition' => 'isBaseWareHouse = "Y" '));
                    $warehouse_id = $default_warehouse->id;
                }
                //$modelDirectPurchaseInvoice->warehouse_id = $warehouse_id;
                if($update==0){  
                    $modelPurchaseInvoiceType = new MasInvoiceType();
                    $invoice_type = $_POST['DirectPurchaseInvoice']['invoice_type'];
                    $invoice_no = 0;
                    $invoice_code = "";
                    if ((int) $invoice_type > 0) {
                        $arr_invoice_type_details = $modelPurchaseInvoiceType->findByPk((int) $invoice_type);
                        $current_serial_no = $arr_invoice_type_details->current_serial_no;
                        if ($current_serial_no == 0) {
                            $invoice_no = $arr_invoice_type_details->start_serial_no;
                        } else {
                            $invoice_no = $current_serial_no + 1;
                        }
                        $invoice_code = $arr_invoice_type_details->inv_code;
                    }
                    $modelDirectPurchaseInvoice->invoice_no = $invoice_code . $invoice_no;
                }
                
                $modelDirectPurchaseInvoice->save();
                $modelDirectPurchaseInvoice->refresh();
                
                
                 // inserting to audit log
                 AuditLog::saveAuditLogs(
                    'PURCHASE_INVOICE',
                    Yii::app()->user->id,
                    'CREATED',
                    " INV No: - {$modelDirectPurchaseInvoice->id} and File - {$modelDirectPurchaseInvoice->file_id} ",
                    $modelDirectPurchaseInvoice->id,
                    $modelDirectPurchaseInvoice->file_id,
                    $_SERVER['REMOTE_ADDR'],
                    'DIRECT PURCHASE'
                );
                
                $model_settings        = new MasCompanySettings();
                $model_settings        = $model_settings->find();
                if(!empty($model_settings)){
                    $qualitycontrol = $model_settings->qualitycontrol;
                    $stock_update_on     = $model_settings->stock_updates_on;
                    $include_vat = $model_settings->include_vat;
                } 
                
                $grand_total =  $total_net_value =  0;
                
                $old_total_qty = $old_rate = array();
                $footer_value = 0;
                if (!empty($modelPurchaseInvoiceAddition)) {
                    foreach ($modelPurchaseInvoiceAddition as $eachModel) {
                        $eachModel->purchasing_invoice_id = $modelPurchaseInvoice->id;
                        $eachModel->save();
                        $grand_total += $eachModel->calculated_value;
                        $footer_value += $eachModel->calculated_value;
                    }
                }
                if (!empty($modelPurchaseInvoiceDeduction)) {
                    foreach ($modelPurchaseInvoiceDeduction as $eachModel) {
                        $eachModel->purchasing_invoice_id = $modelPurchaseInvoice->id;
                        $eachModel->save();
                        $grand_total -= $eachModel->calculated_value;
                        $footer_value -= $eachModel->calculated_value;
                    }
                }
                
                
                    $tot_of_net = $tot_tax = 0;
                    $old_total_qty = $old_rate = array();
                    $footer_value = 0;
                
                if($update==0){
                    if (!empty($modelDirectPurchaseInvoiceItem)) {
                        foreach ($modelDirectPurchaseInvoiceItem as $eachItem) {
                            $eachItem->purchasing_invoice_id = $modelDirectPurchaseInvoice->id;
                            $eachItem->save(false);
                            
                            
                            $eachItem->purchasing_invoice_id = $modelDirectPurchaseInvoice->id;
                            $eachItem->save(false);
                            $grand_total += $eachItem->net_amount;
                            $tot_of_net += $eachItem->net_amount;
                            $tot_tax +=  $eachItem->tax_amount;
                        
                            /**
                             * Orginal rate Updation
                             */
                    
                            $old_qty = Yii::app()->db->createCommand('SELECT SUM(quantity) FROM  crm_product_location WHERE stock_id='.$eachItem->product_id)->queryScalar();
                            $old_total_qty[$eachItem->product_id] = $old_qty;
                            $rate = Store::model()->findBypk($eachItem->product_id)->rate;
                            $old_rate[$eachItem->product_id] = $rate;
                                
                            ( $include_vat == 'Y') ? $actual_cost =   ($eachItem->net_amount +  $eachItem->tax_amount) :  $actual_cost =  $eachItem->net_amount;
                            $actual_cost_percentage =  ( $total_net_value > 0 ) ? $actual_cost/ $total_net_value : 0;
                            $item_footer_value =  $actual_cost_percentage *  $footer_value;
                            $total_item_net_value =  $actual_cost +  $item_footer_value;
                            $quantity_with_unit_factor =  $eachItem->quantity  *  $eachItem->unitdetails->factor;
                            $variance_value = ( $quantity_with_unit_factor > 0 ) ? $total_item_net_value /  $quantity_with_unit_factor : 0;
                            $cost_with_variance =  $variance_value * $modelPurchaseInvoice->exchange_rate;

                            $cur_total = $cost_with_variance * $quantity_with_unit_factor;
                            $old_net_amount = $rate  * $old_qty;
                            $total_quantity=$old_qty + $quantity_with_unit_factor;  
                            $total_amount=$old_net_amount + $cur_total; 
                            $new_amount = ( $total_quantity > 0 ) ? $total_amount/$total_quantity : 0 ; 
                            Store::model()->updateByPk($eachItem->product_id, array('rate' => $new_amount));
                            
                            
                            
                            
                            $extra = 0;
                            
                            if($eachItem->product->inventory_item_type!= 2 && $eachItem->quantity > 0){
                                    updateStock($eachItem,$cost_with_variance,$eachItem->unitdetails,$modelDirectPurchaseInvoice,$eachItem->tax_amount,($eachItem->quantity * $eachItem->unitdetails->factor),$old_total_qty[$eachItem->product_id],$old_rate[$eachItem->product_id]);
                            }
                            
    
                            /*                         * ************* Start Save data into stock ledger *********************** */
                            if ($eachItem->quantity > 0) {
                                $model_stockledger = new StockLedger;
                                $model_stockledger->master_table_id = $modelDirectPurchaseInvoice->id;
                                $model_stockledger->file_id = $modelDirectPurchaseInvoice->file_id;
                                $model_stockledger->transaction_date = $modelDirectPurchaseInvoice->invoice_date;
                                $model_stockledger->posting_date = date("Y-m-d");
                                $model_stockledger->type_description = "Direct Purchase";
                                $model_stockledger->product_id = $eachItem->product_id;
                                $model_stockledger->part_no = $eachItem->product->part_number;
                                $model_stockledger->description = $eachItem->product->description;
                                $model_stockledger->in_qty = $eachItem->quantity;
                                $model_stockledger->out_qty = 0.00;
                                $model_stockledger->brand_class = 0;
                                $model_stockledger->generic_name = "";
                                $model_stockledger->customer_vendor_id = $modelDirectPurchaseInvoice->vendor_id;
                                $model_stockledger->customer_vendor_name = $modelDirectPurchaseInvoice->vendor_details->vendor_name;
                                $model_location = ProductLocation::model()->find(array('condition' => 'stock_id="' . $eachItem->product_id . '"'));
                                $model_stockledger->warehouse_id = $model_location->warehouse_id;
                                $model_stockledger->rack_id = $model_location->rack;
                                $model_stockledger->bin_id = $model_location->bin;
                                $model_stockledger->created_by = Yii::app()->user->id;
                                $model_stockledger->created_date = date("Y-m-d H:i:s");
                                $model_stockledger->cost_rate = $eachItem->product->rate;
                                
    
                                $model_stockledger->sales_price = $eachItem->rate;
                                $model_stockledger->inbound_vat = $eachItem->tax_amount;
                                $model_stockledger->vat_percentage = $eachItem->tax_percentage;
                                $model_stockledger->type = "PR";
                                $model_stockledger->save(false);
                            }
    
                            /*                         * ************* End Save data into stock ledger *********************** */
                            }
                            $grand_total += $eachItem->net_amount;
                            $total_tax_amount += $eachItem->tax_amount;
                        }
                    
    
                    $grand_total += $total_tax_amount;
                    MasterFile::model()->updateByPk($modelDirectPurchaseInvoice->file_id, array('is_approved' => "Y"));
                    
                    
                    $modelDirectPurchaseInvoice->updateByPk($modelDirectPurchaseInvoice->id, array('grand_total' => $grand_total, 'total_tax_amount' => $total_tax_amount,'invoice_no'=>$modelDirectPurchaseInvoice->id,'invoice_code'=>$invoice_code));
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                $modelDirectPurchaseInvoice->refresh();
            } else {

                $error1 = json_decode(CActiveForm::validate($modelDirectPurchaseInvoice, '', false), true);
                if (!empty($modelDirectPurchaseInvoiceItem[0]->product_id))
                    $error2 = json_decode(CActiveForm::validateTabular($modelDirectPurchaseInvoiceItem, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    
    function updateStock($model,$rate,$unit,$modelPurchaseInvoice,$tax_amount,$total_qty,$old_total_qty,$old_rate){
                        $qty = $model->quantity * $unit->factor;
                        $warehouse = $model->warehouse_id;
                        $rack = $model->rack_id;
                        $bin = $model->bin_id;
                        $product_id =  $model->product_id;
                        if($rate > 0)
                            $cur_total = $rate * $qty;
                        else
                            $cur_total = 0;
                        if($product_id > 0){
                            $product = Store::model()->findbyPk($product_id);             
                            $con = 'stock_id='. $product_id;
                            if($warehouse > 0)
                                $con .= ' AND warehouse_id='.$warehouse;
                            if($rack > 0)
                                $con .= ' AND rack='.$rack;
                            if($bin > 0)
                                $con .= ' AND bin='.$bin;
                        
                            $productlocation = ProductLocation::model()->find(array('condition' => $con));
                            if( $productlocation->id > 0){
                                $loc = ProductLocation::model()->findByPk($productlocation->id);
                                $old = $loc->quantity;
                                $loc->quantity = $old+$qty;
                                $loc->save(false);
                            }else{
                                $newloc = new ProductLocation;
                                $newloc->stock_id = $product_id;
                                $newloc->warehouse_id = $warehouse;
                                $newloc->rack = $rack;
                                $newloc->bin = $bin;
                                $newloc->quantity = $qty;
                                $newloc->save(false);
                            }
                            
                            $total_quantity=$old_total_qty + $qty;  
                            Store::model()->updateByPk($product_id, array('total_quantity' =>$total_quantity));
                            
                            //Code added on 9/12/2017 by Dikson R starts
                            $model_stockledger = new StockLedger;
                            $model_stockledger->master_table_id=$modelPurchaseInvoice->id;
                            $model_stockledger->file_id=$modelPurchaseInvoice->file_id;
                            $model_stockledger->transaction_date=$modelPurchaseInvoice->invoice_date;
                            $model_stockledger->posting_date=$modelPurchaseInvoice->invoice_date;
                            $model_stockledger->type_description="Purchase Invoice";
                            $model_stockledger->product_id=$model->product_id;
                            $model_stockledger->part_no=$model->product->part_number;
                            $model_stockledger->description=$model->product->description;
                            $model_stockledger->in_qty=$qty; 
                            $model_stockledger->out_qty=0.00;
                            $model_stockledger->brand_class=$model->product->brand_class_id;
                            $model_stockledger->generic_name=$model->product->genericdetails->generic_name;
                            $model_stockledger->customer_vendor_id=$modelPurchaseInvoice->vendor_id;
                            $model_stockledger->customer_vendor_name=$modelPurchaseInvoice->vendor_details->vendor_name;
                            $model_stockledger->warehouse_id=$warehouse;
                            $model_stockledger->rack_id=$rack;
                            $model_stockledger->bin_id=$bin;
                            $model_stockledger->created_by=Yii::app()->user->id;
                            $model_stockledger->created_date=date("Y-m-d H:i:s");
                            $model_stockledger->cost_rate= $product->rate;
                            $model_stockledger->sales_price=0.00;                   
                            $model_stockledger->vat_percentage=$model->product->tax->percentage;
                            $model_stockledger->inbound_vat = ($qty / $total_qty * $tax_amount) * $modelPurchaseInvoice->exchange_rate;
                            $model_stockledger->type="PR";                                  
                            $model_stockledger->save(false); 
                            //Code added on 9/12/2017 by Dikson R ends
                        }
                    }
    
    
    
    
    

    public function actionPrint() {
        $model = new DirectPurchaseInvoice();
        $id = Yii::app()->request->getParam('id');
        $frm = Yii::app()->request->getParam('frm');

        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        //$stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.direct_purchase_invoice', array('model' => $model, 'id' => $id, 'title' => $title), true));

        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actiongetPrize() {
        $vendor_id = Yii::app()->request->getParam('vendor_id');
        $product_id = Yii::app()->request->getParam('product_id');
        $unit_name = Yii::app()->request->getParam('unit_name');

        $condition = "purchasinginvoice.vendor_id = '" . $vendor_id . "' AND product_id = '" . $product_id . "' ";
        $order_by = ' t.id desc ';
        $model = new DirectPurchaseInvoiceItem();
        $arr_price_details = $model->with('purchasinginvoice')->find(array('condition' => $condition, 'order' => $order_by));
        $price = $arr_price_details->rate;
        echo json_encode(array(
            'status' => 'success',
            'rate' => $price
        ));
    }

    public function actiongetInvoiceTypeWarehouse() {
        $id = Yii::app()->request->getparam("id");
        $select_warehouse_id = Yii::app()->request->getparam("warehouse_id");

        $model_invc_type = MasInvoiceType::model()->findByPK($id);
        $getInvcList = $model_invc_type['warehouse_id'];

        $models = MasInvWarehouse::getInvoiceTypeWarehouse($getInvcList);
        $drop = '<li class="col-sm-4">';
        $model = new DirectPurchaseInvoice;
        $drop .= CHtml::activedropDownList($model, 'warehouse_id', $models, array('data-label' => 'Warehouse <span style="color:red">*</span>', 'class' => 'tooltipster', 'class' => 'text-bold', 'options' => array($select_warehouse_id => array('selected' => 'selected'))));
        $drop .= '</li>';
        $status = array("dt" => $drop);
        echo CJSON::encode($status);
    }
    public function actiongetExchangerate() {
        $id = $_POST['currency'];
        if ($id > 0) {
            $model = MasCurrency::model()->findByPk($id);
            $jsonData['rate'] = $model->exchange_rate;
            echo CJSON::encode($jsonData);
        }
    }
    public function actionGetProducts() {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 't.isActive = "Y" AND ( inventory_item_type =1 OR inventory_item_type=3) AND (part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%")';
        $model = new Store();
        $model = $model->with('tax')->findAll(array('condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->part_number.' : '. $eachModel->description;
            $data[$i]['part_number'] = $eachModel->part_number;
            $data[$i]['description'] = $eachModel->description;
            $data[$i]['unit_id'] = $eachModel->unit->id;
            $data[$i]['unit_name'] = $eachModel->unit->symbol;
            $data[$i]['tax_code'] = $eachModel->tax;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    
    public function actionCheckSerialnoExist(){
        $product_id         = Yii::app()->request->getparam("product_id");
        $serial_no          = trim(Yii::app()->request->getparam("serial_no"));
        $SQL                = "SELECT COUNT(*) FROM `erp_product_location_details` WHERE `serial_no`='".$serial_no."' AND `product_id`=".$product_id;
        $exist_serial_no    = Yii::app()->db->createCommand($SQL)->queryScalar();
        echo $exist_serial_no;
    }
    
    public function actionGetCurrency() {
        $vendor_id = $_POST['vendor_id'];
        $data = array();
        $model = new DirectPurchaseInvoice;
        if($vendor_id > 0){
             $vendor = Vendor::model()->findByPk($vendor_id);
             //$modshipaddress = VendorShippingDetails::model()->findByPk($vendor_id);
            $data['billaddress'] = $vendor->vendor_address . ", PO Box : " . $vendor->vendor_postal_code . "," . $vendor->vendor_city . "," . $vendor->country->country_name;
            $data['shipaddress'] = $vendor->vendor_address . ", PO Box : " . $vendor->vendor_postal_code . "," . $vendor->vendor_city . "," . $vendor->country->country_name;
            //$data['shipaddress'] = $modshipaddress->street_address . ", PO Box : " . $modshipaddress->postal_code . "," . $modshipaddress->city . "," . $modshipaddress->country->country_name;
            
             $model->currency  = $vendor->vendor_currency_id;
             $model->payment_terms = $vendor->vendor_payment_term;
             $data['currency']  =  CHtml::activedropDownList($model, 'currency', MasCurrency::getCurrency(), array('onChange' => 'getCurrencyExchangeRate(this.id)','class' => 'tooltipster', 'title' => 'Currency', 'data-label' => 'Currency', 'prompt' => '-select-')); 
             $data['payterm'] = CHtml::activedropDownList($model, 'payment_terms', MasPaymentTerm::getPaymentTerms(), array('class' => '','title' => 'Select Payment Terms','data-label'=>'Payment Terms <span style="color:red;">*</span> ')); 
             $data['exchange_rate']  = $vendor->currency_detail->exchange_rate;
             
             //code added by mereena on 04/02/2020
            $models = VendorContact::getVendorContacts($vendor_id);
            
            $drop = '<li class="col-sm-2">';
            $model = new PurchasingOrder;
            $drop .= CHtml::activedropDownList($model, 'vendor_contact_id', $models, array('empty' => 'Select', 'class' => 'tooltipster', 'title' => 'Please Select Contact', 'data-label' => 'Contact <span style="color:red">*</span>', 'data-search' => true, 'empty' => '--Select--'));
            $drop .= '</li>';
            $data['contact']  = $drop;
             //end
        }
         echo CJSON::encode($data);
    }
}
