<?php

class DebitnoteController extends Controller
{
    public $layout = 'layout';
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'index',
                    'GetDebitNoteList',
                    'Create',
                    'PurchasedInvoices',
                    'getPurchaseinvoice',
                    'SaveDebitNote',
                    'PrintFile',
                    'GetStockDetails',
                    'GetSortedStockDetails',
                    'returnItems',
                    'returnItemSave',
                    'GetinvoiceDetails',
                    'GetpurchasereturnDetails',
                    'UploadDebitDocuments'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function filters()
    {
        return array('accessControl'); // perform access control for CRUD operations
    }


    public function actionIndex()
    {
        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn['purchase_menu_view']) &&
                isset(Yii::app()->user->havePermissionOn['pur_debitnote_view']) &&
                Yii::app()->user->havePermissionOn['purchase_menu_view'] &&
                Yii::app()->user->havePermissionOn['pur_debitnote_view']
            )
        ) {
            $this->render('index');
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }

    public function actionGetDebitNoteList()
    {
        $model = new Purchasingdebitnote();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.purchasing_invoice_id',
            2 => 't.id',
            3 => 'debited_date',
            4 => 'vendor_details.vendor_name',
            5 => 't.total_tax_amount',
            6 => 't.debited_amount',
            7 => 't.reason'

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        // $orderBy = 't.id DESC';
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.is_goods_returned="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (t.file_id LIKE '%" . $searchString . "%' OR purchasing_invoice_id LIKE '%" . $searchString . "%' OR t.id LIKE '%" . $searchString . "%' OR vendor_details.vendor_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('vendor_details', 'file', 'purchaseinvoice')->count(array('condition' => $condition));
        $model = $model->with('vendor_details', 'file', 'purchaseinvoice')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $status = '';
        foreach ($model as $row) {
            if ($row['debited_date'] != '0000-00-00') {
                $date = date("d/m/Y", strtotime($row['debited_date']));
            } else {
                $date = '';
            }
            $rowData[] = array($row['file_id'], $row['purchasing_invoice_id'], $row['id'], $date, $row->vendor_details->vendor_name, Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'], ""), Yii::app()->numberFormatter->formatCurrency($row['debited_amount'], ""), $row['reason'], $row->invoice->invoicetype->tax, $row['posted']);
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate()
    {
        $model = new Purchasingdebitnote();
        $model_details = array(new PurchasingdebitnoteItem);
        $modelAdditions = array(new PurchasingDebitNoteAddition());
        $modelDeduction = array(new PurchasingDebitNoteDeduction());

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model, 'model_details' => $model_details, 'modelAdditions' => $modelAdditions, 'modelDeduction' => $modelDeduction));
    }
    public function actionReturnItems()
    {
        $model = new Purchasingdebitnote();
        $id = (int) Yii::app()->request->getParam('id');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('returned_items', array('model' => $model, 'id' => $id));
    }

    public function actionPurchasedInvoices()
    {
        $data_array = array();
        $searchTerm = Yii::app()->request->getParam('term');
        if ($searchTerm != '') {

            // $condition = 'file_id LIKE "%' . $searchTerm . '%" OR id LIKE "%' . $searchTerm . '%" OR invoice_no LIKE "%' . $searchTerm . '%"';
            $condition = 'id LIKE "%' . $searchTerm . '%"';
            $model = PurchasingInvoice::model()->findAll(array('condition' => $condition));
            $i = 0;
            foreach ($model as $eachModel) {
                $data[$i]['value'] = $eachModel->id;
                $data[$i]['label'] = $eachModel->id . ' : ' . $eachModel->invoice_no;
                $data[$i]['currency'] = $eachModel->currencyname->currency;
                $data[$i]['currency_id'] = $eachModel->currency;
                $data[$i]['exchangerate'] = $eachModel->currencyname->exchange_rate;
                $data[$i]['customer_id'] = $eachModel->vendor_id;
                $data[$i]['customer_name'] = $eachModel->vendor_details->vendor_name;
                $data[$i]['file_id'] = $eachModel->file_id;
                $data[$i]['total_q'] = $eachModel->grand_total;
            }
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    public function actiongetPurchaseinvoice()
    {
        if ($_POST['id'] > 0) {
            $invoice = PurchasingInvoice::model()->findByPK((int) $_POST['id']);
        }
        if (!empty($invoice)) {

            $masterFile = MasterFile::model()->findByPK($invoice->file_id);
            $jsonData['file'] = $masterFile;
            $jsonData[$_POST['needed_model']] = $invoice;
            //$jsonData['vendor'] = Company::model()->findByPK($invoice->vendor_id);
            $jsonData['currency'] = MasCurrency::model()->findByPK($invoice->currency);
            $jsonData['paymentterms'] = MasPaymentTerm::model()->findByPK($invoice->payment_terms);

            $condition = "purchasing_invoice_id=" . $invoice->id;
            $items = PurchasingInvoiceItem::model()->findAll(array('condition' => $condition, 'order' => 'id ASC'));

            $jsonData['model_items'] = '';
            $total = 0;

            foreach ($items as $i => $model) {
                $qty = 0;
                $exist = Purchasingdebitnote::model()->findAll(array('condition' => 'purchasing_invoice_id = ' . $model->purchasing_invoice_id));
                $unit_name = $model->unitdetails->name;
                $unit_id = $model->unit;
                $unit_factor = $model->unitdetails->factor;


                if (!empty($exist)) {

                    $data = array_map(function ($obj) {
                        return $obj->id; }, $exist);
                    $ids = implode(',', $data);
                    $qty = Yii::app()->db->createCommand('SELECT SUM(returned_quantity) FROM  erp_purchasing_debit_note_item WHERE purchasing_debitnote_id IN (' . $ids . ') AND product_id=' . $model->product_id . '')->queryScalar();

                    $qty = $qty / $unit_factor;
                }

                $invoice_item_id = $model->id;
                $temp = new PurchasingdebitnoteItem;
                $temp->attributes = $model->attributes;
                $temp->purchased_quantity = $model->quantity;
                $temp->tax_vat_percentage = $model->tax_percentage;
                if ($qty > 0) {
                    $temp->purchased_quantity -= $qty;
                }
                $temp->description = $model->description;
                $temp->purchasing_materialreceipt_id = $invoice->materialreceived;
                $model = $temp;
                $total += $temp->purchased_quantity * $temp->rate;
                if (!empty($model->product->oem_number)) {
                    $product_name = $model->product->oem_number;
                } else {
                    $product_name = $model->product->part_number;
                }

                if ($unit_factor > 0) {
                    $base_unit_rate = round(($model->rate / $unit_factor), 2);
                } else {
                    $base_unit_rate = round($model->rate, 2);
                }

                $unit_of_measurement_id = UnitOfMeasurement::model()->find(array('condition' => 'unit_id=' . (int) $model->product->unit_id . ' AND product_id=' . (int) $model->product_id))->id;
                $base_unitname = UnitOfMeasurement::model()->find(array('condition' => 'unit_id=' . (int) $model->product->unit_id . ' AND product_id=' . (int) $model->product_id))->name;


                $jsonData['model_items'] .= '
            <tr>
            <td><input type="hidden" id="debit_note_productname_' . $i . '" value="' . $product_name . '">
                    <label>' . ($i + 1) . '</label></td>
            <td  class="cell-left">' . $model->purchasing_materialreceipt_id . CHtml::activeHiddenField($model, "[$i]id", array('readonly' => true, 'value' => $model->purchasing_materialreceipt_id)) . CHtml::activeHiddenField($model, "[$i]purchasing_materialreceipt_id", array('readonly' => true, 'value' => $model->purchasing_materialreceipt_id)) . '</td>
            <td  class="cell-left">' . $product_name . CHtml::activeHiddenField($model, "[$i]product_name", array('class' => 'description', 'readonly' => true, 'value' => $product->part_number)) . CHtml::activeHiddenField($model, "[$i]product_id") . '</td>
            <td class="cell-left">' . $model->description . CHtml::activeHiddenField($model, "[$i]description", array('class' => 'description', 'readonly' => true, 'value' => $model->description)) . '</td>
            <td class="cell-right">' . number_format($model->purchased_quantity, 2, '.', '') . "/" . $unit_name . CHtml::activeHiddenField($model, "[$i]purchased_quantity", array('class' => 'cell-center', 'value' => number_format($model->purchased_quantity, 2, '.', ''), 'readonly' => true, )) . '</td>' .
                    // '<td>' .number_format($model->purchased_quantity * $unit_factor, 2, '.', '').CHtml::HiddenField("PurchasingdebitnoteItem[$i][unit]",$unit_id).CHtml::HiddenField("PurchasingdebitnoteItem[$i][inv_item_id]",$invoice_item_id).CHtml::HiddenField("PurchasingdebitnoteItem[$i][factor]",$unit_factor).CHtml::HiddenField("PurchasingdebitnoteItem[$i][returned_unit_id]",$unit_of_measurement_id).'</td>'; 
                    '<td>' . number_format($model->purchased_quantity * $unit_factor, 2, '.', '') . '(' . $base_unitname . ')' . CHtml::HiddenField("PurchasingdebitnoteItem[$i][unit]", $unit_id) . CHtml::HiddenField("PurchasingdebitnoteItem[$i][inv_item_id]", $invoice_item_id) . CHtml::HiddenField("PurchasingdebitnoteItem[$i][factor]", $unit_factor) . CHtml::HiddenField("PurchasingdebitnoteItem[$i][returned_unit_id]", $unit_of_measurement_id) . '</td>';

                //<td>' . CHtml::activeTextField($model, "[$i]rate", array('class' => 'cell-right to_be_calculated amount-field', 'value' => $model->rate, 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculatecrediteamount($("#purchasingcredit_item_table"));')) . '</td>';
                $jsonData['model_items'] .= '<td>' . CHtml::activeTextField($model, "[$i]rate", array('class' => 'go form-control', 'value' => $base_unit_rate, 'readonly' => true)) . '</td>
            <td>' . $model->net_amount . '</td>
            <td>' . CHtml::textField('PurchasingdebitnoteItem[' . $i . '][returned_quantity]', '', array('class' => 'go form-control', 'onkeypress' => 'return isPositiveNumber(event)', 'onkeyup' => 'calculateDebitValue($("#purchasingdebit_item_table"))')) . '</td>
            <td>' . CHtml::textField('PurchasingdebitnoteItem[' . $i . '][net_amount]', 0.00, array('class' => 'go form-control', 'value' => 0.00, 'readonly' => true)) . '</td>
             <td>' . CHtml::textField('PurchasingdebitnoteItem[' . $i . '][tax_vat_percentage]', $model->tax_vat_percentage, array('class' => 'go form-control', 'readonly' => true)) .
                    CHtml::hiddenField('PurchasingdebitnoteItem[' . $i . '][tax_vat_amount]') .
                    '</td>
             </tr>';
                /* <td class="cell-left">' . $model->warehousename->name . CHtml::activeHiddenField($model, "[$i]warehouse_name", array('readonly' => true, 'value' => $model->warehousename->name)) .
                  CHtml::activeHiddenField($model, "[$i]warehouse", array('readonly' => true, 'value' => $model->warehouse)) . '</td> */
            }
            $jsonData['total'] = $total;
            echo CJSON::encode($jsonData);
        }
    }
    public function actionGetDocumentList()
    {
        $model = new Document();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $file_id = $_POST['file_id'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.document_name',
            2 => 't.created_by',
            3 => 't.created_datetime',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" and t.file_id = "' . $file_id . '"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (document_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));
            // if(isset(Yii::app()->user->havePermissionOn['order_document']) ||  Yii::app()->user->authorised_user == 1)
            // {
            $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a> &nbsp;';
            // }  
            $button_string .= '<a href ="' . Yii::app()->createUrl('lead/downloaddocument&id=' . $row['id']) . '" class=" btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';
            $rowData[] = array($m, $row['document_name'], $model2->username, date("d/m/Y h:m:s", strtotime($row['created_datetime'])), '<div class="btn-wrap text-center">' . $button_string . '</div>');
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionSaveDebitNote()
    {
        $other = array();
        $valid = true;

        $model = new Purchasingdebitnote;
        if (isset($_POST["Purchasingdebitnote"])) {
            if ($_POST["Purchasingdebitnote"]['id'] > 0) {
                $model = $model->findBypk($_POST["Purchasingdebitnote"]['id']);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('y-m-d H:i:s');
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime = date('y-m-d H:i:s');
            }


            if ($_POST["Purchasingdebitnote"]['purchasing_invoice_id'] > 0) {
                $purchasing_invoice_details = PurchasingInvoice::model()->findByPk($_POST["Purchasingdebitnote"]['purchasing_invoice_id']);
            }


            $model->attributes = $_POST['Purchasingdebitnote'];
            $model->crm_user_id = Yii::app()->user->id;
            $model->warehouse_id = $purchasing_invoice_details->warehouse_id;

            $model->tax_type = 1;
            if ($_POST['Purchasingdebitnote']['debited_date'] != '00/00/0000') {
                $model->debited_date = str_replace('/', '-', $_POST['Purchasingdebitnote']['debited_date']);
                $model->debited_date = date("Y-m-d", strtotime($model->debited_date));
                $model->file_id = $_POST['Purchasingdebitnote']['file_id'];
                $model->terms_and_conditions = $_POST['Purchasingdebitnote']['terms_and_conditions'];
                $model->remarks = $_POST['Purchasingdebitnote']['remarks'];
                $model->notes = $_POST['Purchasingdebitnote']['notes'];
                $model->Isdebitnote_or_goodsreturn = $_POST['Purchasingdebitnote']['Isdebitnote_or_goodsreturn'];
            }
            $valid = $model->validate();

            //   ---------------------AccAuditClose check------------------------------------


            $debited_datex = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['Purchasingdebitnote']['debited_date'])));

            $modelAccAuditClose = new AccAuditClose();
            $existing_date = strtotime($modelAccAuditClose->lastCloseddate());
            $debited_date = strtotime($debited_datex);
            if ($debited_date <= $existing_date) {
                $valid = false;
                $other[] = ' Given Debitnote date must be Greater than Audit Close Date :- ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';

            }
            //   --------------------//-AccAuditClose check------------------------------------



            if (is_array($_POST['PurchasingdebitnoteItem'])) {
                $i = 0;
                foreach ($_POST['PurchasingdebitnoteItem'] as $h => $items) {
                    if ($items['product_id'] > 0 && $items['returned_quantity'] > 0) {
                        $modelItem[$i] = new PurchasingdebitnoteItem;
                        $modelItem[$i]->product_id = $items['product_id'];
                        $modelItem[$i]->purchased_quantity = $items['purchased_quantity'];
                        $modelItem[$i]->description = $items['description'];
                        $modelItem[$i]->rate = $items['rate'];
                        $modelItem[$i]->unit = $items['unit'];
                        $modelItem[$i]->returned_quantity = $items['returned_quantity'];
                        $modelItem[$i]->returned_unit_id = $items['returned_unit_id'];
                        $modelItem[$i]->unit_factor = $items['factor'];
                        $modelItem[$i]->net_amount = $items['net_amount'];
                        $modelItem[$i]->tax_vat_percentage = $items['tax_vat_percentage'];
                        $modelItem[$i]->tax_vat_amount = $items['tax_vat_amount'];
                        $modelItem[$i]->purchasing_materialreceipt_id = $items['purchasing_materialreceipt_id'];
                        $modelItem[$i]->created_by = Yii::app()->user->id;
                        $modelItem[$i]->created_datetime = date('y-m-d H:i:s');
                        $valid = $modelItem[$i]->validate() && $valid;
                        $i++;
                    }
                }

            }

            if (empty($modelItem)) {
                $valid = false;
            }
            if (is_array($_POST['PurchasingDebitNoteAddition'])) {

                foreach ($_POST['PurchasingDebitNoteAddition'] as $i => $item) {
                    if ($item['particular'] > 0) {
                        $modelDebitNoteAddition[$i] = new PurchasingDebitNoteAddition;
                        $modelDebitNoteAddition[$i]->attributes = $_POST['PurchasingDebitNoteAddition'][$i];
                        $valid = $modelDebitNoteAddition[$i]->validate() && $valid;
                    }

                }

            }
            if (is_array($_POST['PurchasingDebitNoteDeduction'])) {

                foreach ($_POST['PurchasingDebitNoteDeduction'] as $i => $item) {
                    if ($item['particular'] > 0) {
                        $modelDebitNoteDeduction[$i] = new PurchasingDebitNoteDeduction;
                        $modelDebitNoteDeduction[$i]->attributes = $_POST['PurchasingDebitNoteDeduction'][$i];
                        $valid = $modelDebitNoteDeduction[$i]->validate() && $valid;
                    }

                }

            }

            if ($valid) {

                /******** START Save Data into Invoice ******************************/
                //Start Code added by Mereena on 13/12/2017 for Invoice no generating
                $modelInvoiceType = new MasInvoiceType();
                $invoice_type = $purchasing_invoice_details->invoice_type;
                //echo "test".$invoice_type;
                $debit_note_no = 0;
                $invoice_code = "";
                if ((int) $invoice_type > 0) {
                    $arr_invoice_type_details = $modelInvoiceType->findByPk((int) $invoice_type);
                    $current_serial_no = $arr_invoice_type_details->cn_current_serial_no;
                    if ($current_serial_no == 0) {
                        $debit_note_no = $arr_invoice_type_details->cn_start_serial_no;
                    } else {
                        $debit_note_no = $current_serial_no + 1;
                    }

                    $invoice_code = $arr_invoice_type_details->inv_code;
                }
                //Update current_serial_no in mas invoice type
                $modelInvoiceType->updateByPK((int) $invoice_type, array('cn_current_serial_no' => $debit_note_no));
                //End Code added by Mereena on 27/12/2017 for Invoice no generating
                $model->debit_note_no = $invoice_code . $debit_note_no;

                $model->invoice_type = $invoice_type;
                //code added by mereena on 08/04/2020
                if ($_POST['service_invoice'] == 'Y') {
                    $model->is_goods_returned = 'Y';
                }
                //end
                $model->save();

                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'PURCHASE_RETURN',
                    Yii::app()->user->id,
                    'CREATED',
                    " PKG No: - {$model->id} "
                );
                // end audit log 

                $total_tax_amount = 0;
                if (!empty($modelItem)) {
                    foreach ($modelItem as $eachItem) {
                        $eachItem->purchasing_debitnote_id = $model->id;
                        $grand_total += $eachItem->net_amount;
                        $total_tax_amount += $eachItem->tax_vat_amount;
                        $eachItem->save();

                    }
                }

                if (!empty($modelDebitNoteAddition)) {
                    foreach ($modelDebitNoteAddition as $eachModel) {

                        $eachModel->purchasing_debit_note_id = $model->id;

                        $eachModel->save(false);

                        $grand_total += $eachModel->calculated_value;

                    }
                }
                if (!empty($modelDebitNoteAddition)) {
                    foreach ($modelDebitNoteDeduction as $eachModel) {
                        $eachModel->purchasing_debit_note_id = $model->id;
                        $eachModel->save(false);
                        $grand_total -= $eachModel->calculated_value;
                    }
                }

                $grand_total += $total_tax_amount;

                $model->updateByPk($model->id, array('total_tax_amount' => $total_tax_amount, 'debited_amount' => $grand_total));

                //$this->dailyclosingstock();
                $model_mail_setting = Notification::model()->find(array('condition' => 'event_id="18"'));
                Yii::import('application.controllers.front.MasternotificationController');
                if ($model_mail_setting->mail_required == 'Y') {
                    // MasternotificationController::sendmail(18,$model->id);
                }
                if ($model_mail_setting->notification_required == 'Y') {
                    // MasternotificationController::sendnotification(18,$model->id);
                }
                if ($model_mail_setting->sms_required == 'Y') {
                    // MasternotificationController::sendsms(18,$model->id);
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {

                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                $error2 = $error3 = $error4 = array();
                if (!empty($modelItem[0]->product_id)) {
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                    if ($modelDebitNoteDeduction[0]->particular > 0)
                        $error4 = json_decode(CActiveForm::validateTabular($modelDebitNoteDeduction, '', false), true);
                    if ($modelDebitNoteAddition[0]->particular > 0)
                        $error3 = json_decode(CActiveForm::validateTabular($modelDebitNoteAddition, '', false), true);
                } else
                    $error2[] = 'Choose Atleast One Item!';

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4, $other));

                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionPrintFile()
    {

        $model = new Purchasingdebitnote();
        $id = Yii::app()->request->getParam('id');
        $file_id = Yii::app()->request->getParam('file');
        $vendor_id = Yii::app()->request->getParam('vendor');
        $type = Yii::app()->request->getParam('tax');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        if ($type == 'Y') {
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.debitnote_individual_tax', array('model' => $model, 'id' => $id, 'file_id' => $file_id, 'vendor_id' => $vendor_id), true));
        } else {
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.debitnote_individual', array('model' => $model, 'id' => $id, 'file_id' => $file_id, 'vendor_id' => $vendor_id), true));
        }
        $mPDF1->Output("PurchaseReturn.pdf", 'I');
    }

    /*public function actionGetStockDetails(){

        $product_id = $_POST['product_id'];
        $quantity = $_POST['Qty'];
        $length = $_POST['length'];
        $inv_item_id = $_POST['inv_item_id'];
        $stock_details = array(new MaterialReceiptStockDetails);

        if((int) $product_id > 0){
            $product = Store::model()->findBypk($product_id);
            $stock_details = MaterialReceiptStockDetails::model()->findAll(array('condition' => 'product_id = '.$product_id.' AND quantity > 0'));
        }

        $table = '';
        $flag   = 0;
        if($stock_details[0]->id > 0){

            foreach($stock_details as $each){

                $class = '';
                if($each->expiry_date != '0000-00-00'){
                    $expire = date('d/m/Y',strtotime($each->expiry_date));
                    if(strtotime($each->expiry_date) < strtotime(date('Y-m-d'))){
                        $class = 'bg-danger';
                    }
                }else{
                    $expire = '-';
                }
                if($each->stock_affect_date != '0000-00-00'){
                    $purchased = date('d/m/Y',strtotime($each->stock_affect_date));
                }else{
                    $purchased = '-';
                }

                if($each->quantity <=$quantity AND $flag == '0'){
                    $picked_qty  = $each->quantity;
                    $quantity    = $quantity-$each->quantity;
                }
                else{
                    if($each->quantity >=$quantity AND $flag == '0'){
                        if($quantity>0){
                            $picked_qty  = number_format((float)$quantity, 2, '.', '');;                                 
                        }
                        else{
                            $picked_qty  = "";
                        }                                                       
                    }
                    else{
                        $picked_qty  = "";
                    }
                    $flag  = 1;                        
                }

                $table .= '<tr class="'.$class.' TR-'.$length.'">';
                $table .= '<td>'.$each->warehousename->warehouse_name.'</td>';
                $table .= '<td>'.$product->part_number.CHtml::hiddenfield('Data['.$length.'][product_id]',$product_id).CHtml::hiddenfield('Data['.$length.'][material_receipt_id]',$each->id).'</td>';
                $table .= '<td>'.$each->rack->name.CHtml::hiddenfield('Data['.$length.'][rack_id]',$each->rack_id).CHtml::hiddenfield('Data['.$length.'][inv_item_id]',$inv_item_id).'</td>';
                $table .= '<td>'.$each->bin->name.CHtml::hiddenfield('Data['.$length.'][bin_id]',$each->bin_id).'</td>';
                $table .= '<td>'.$each->batch_no.'</td>';
                $table .= '<td>'.$each->serial_no.'</td>';
                $table .= '<td>'.$purchased.'</td>';
                $table .= '<td>'.$expire.'</td>';
                $table .= '<td>'.CHtml::textfield('Data['.$length.'][bill_of_exit]','',array('class' => 'form-control')).'</td>';
                $table .= '<td>'.CHtml::textfield('Data['.$length.'][qty_available]',$each->quantity,array('class' => 'form-control text-right','readonly' => 'readonly')).'</td>';
                $table .= '<td>'.CHtml::textfield('Data['.$length.'][picked_qty]',$picked_qty,array('class' => 'form-control text-right','onkeypress' => 'return isPositiveNumber(event)','onkeyup' => 'verifyQty(this.id,this.value);')).'</td>';
                $table .= '</tr>';
                $length++;
            }

        }else{ 
            if($length == 0)
                $table .= '<tr class="no-data-tr"><td colspan="11" class="text-center"> No Data </td></tr>';
        }

        echo $table;
    }
    public function actionGetSortedStockDetails(){

        $products = array();
        if(is_array($_POST['products'])){
            foreach($_POST['products'] as $i => $each){
                $products[$i] = (int) $each;
            }
        }

        $attr = $_POST['attr'];
        $inv_item_id = $_POST['inv_item_id'];

        if($_POST['toggle'] == 1)
            $toggle = 'DESC';
        else
            $toggle = 'ASC';


        if(!empty($products))
            $stock_details = MaterialReceiptStockDetails::model()->findAll(array('condition' => 'product_id IN ('.implode(',',$products).') AND quantity > 0','order' => $attr.' '.$toggle));
        else
            $stock_details = array(new MaterialReceiptStockDetails);

        $table = '';


        if($stock_details[0]->id > 0){

            foreach($stock_details as $length => $each){

                $class = '';
                if($each->expiry_date != '0000-00-00'){
                    $expire = date('d/m/Y',strtotime($each->expiry_date));
                    if(strtotime($each->expiry_date) < strtotime(date('Y-m-d'))){
                        $class = 'bg-danger';
                    }
                }else{
                    $expire = '-';
                }
                if($each->stock_affect_date != '0000-00-00'){
                    $purchased = date('d/m/Y',strtotime($each->stock_affect_date));
                }else{
                    $purchased = '-';
                }

                $table .= '<tr class="'.$class.' TR-'.$length.'">';
                $table .= '<td>'.$each->warehousename->warehouse_name.'</td>';
                $table .= '<td>'.$each->product->part_number.CHtml::hiddenfield('Data['.$length.'][product_id]', $each->product_id).CHtml::hiddenfield('Data['.$length.'][material_receipt_id]',$each->id).'</td>';
                $table .= '<td>'.$each->rack->name.CHtml::hiddenfield('Data['.$length.'][rack_id]',$each->rack_id).CHtml::hiddenfield('Data['.$length.'][inv_item_id]',$inv_item_id).'</td>';
                $table .= '<td>'.$each->bin->name.CHtml::hiddenfield('Data['.$length.'][bin_id]',$each->bin_id).'</td>';
                $table .= '<td>'.$each->batch_no.'</td>';
                $table .= '<td>'.$each->serial_no.'</td>';
                $table .= '<td>'.$purchased.'</td>';
                $table .= '<td>'.$expire.'</td>';
                $table .= '<td>'.CHtml::textfield('Data['.$length.'][bill_of_exit]','',array('class' => 'form-control')).'</td>';
                $table .= '<td>'.CHtml::textfield('Data['.$length.'][qty_available]',$each->quantity,array('class' => 'form-control text-right','readonly' => 'readonly')).'</td>';
                $table .= '<td>'.CHtml::textfield('Data['.$length.'][picked_qty]','',array('class' => 'form-control text-right','onkeypress' => 'return isPositiveNumber(event)','onkeyup' => 'verifyQty(this.id,this.value);')).'</td>';
                $table .= '</tr>';
                $length++;
            }

        }else{ 
            if($length == 0)
                $table .= '<tr class="no-data-tr"><td colspan="11" class="text-center"> No Data </td></tr>';
        }

        echo $table;
    }*/



    public function actionReturnItemSave()
    {

        $debitnote_id = $_POST['debitnote_id'];
        $model = new Purchasingdebitnote();

        $model = $model->findByPk($debitnote_id);
        if (is_array($_POST['StockLedger'])) {
            $k = 0;
            $valid = TRUE;
            foreach ($_POST['StockLedger'] as $i => $item) {

                if (is_numeric($item['quantity']) && $item['quantity'] > 0) {
                    $mod_loc = ProductLocationDetails::model()->findByPk($item['product_location_id']);
                    if (floatval($item['quantity']) > (floatval($mod_loc->quantity))) {
                        $valid = FALSE;
                        $error[] = ' Product' . $mod_loc->id . ' has only ' . $mod_loc['quantity'] . ' items. Quantity should be less than available';
                    } else {
                        $modelItem[$k] = new StockLedger();
                        $modelItem[$k]->product_id = $item['product_id'];
                        $modelItem[$k]->product_location_id = $item['product_location_id'];
                        $modelItem[$k]->transaction_type = "Purchase Debit Note";
                        $modelItem[$k]->warehouse_id = $item['warehouse_id'];
                        $modelItem[$k]->rack_id = $item['rack_id'];
                        $modelItem[$k]->bin_id = $item['bin_id'];
                        $modelItem[$k]->cost_price = $item['cost_price'];
                        $modelItem[$k]->quantity = -1 * $item['quantity'];
                        $modelItem[$k]->transaction_date = date("Y-m-d");
                        $modelItem[$k]->header_id = $model->id;
                        $modelItem[$k]->created_by = Yii::app()->user->id;
                        $modelItem[$k]->created_date = date("Y-m-d H:i:s");
                        $k++;
                    }
                }
            }
            if ($valid) {

                $model->is_goods_returned = 'Y';
                $model->save(false);

                foreach ($modelItem as $eachModel) {
                    $mod_loc = ProductLocationDetails::model()->findByPk($eachModel->product_location_id);
                    $mod_loc->quantity = $mod_loc->quantity + $eachModel->quantity;
                    $eachModel->save(false);
                    $mod_loc->save(false);

                    $modelDebitNoteItemsLoc = new PurchasingDebitNoteIssueItem();
                    $modelDebitNoteItemsLoc->debit_note_id = $debitnote_id;
                    $modelDebitNoteItemsLoc->product_location_details_id = $eachModel->product_location_id;
                    $modelDebitNoteItemsLoc->issued_qty = $eachModel->quantity;
                    $modelDebitNoteItemsLoc->bill_exit = "";
                    $modelDebitNoteItemsLoc->created_by = Yii::app()->user->id;
                    $modelDebitNoteItemsLoc->created_date_time = date("Y-m-d H:i:s");
                    $modelDebitNoteItemsLoc->save(false);


                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error = CJSON::encode($error);
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionGetinvoiceDetails()
    {
        $vendor_id = $_POST['vendor_id'];
        $model_debitnote = new Purchasingdebitnote();
        $model = PurchasingInvoice::model()->findAll(array('condition' => 'vendor_id="' . $vendor_id . '"'));
        $i = 0;
        $data = array();
        foreach ($model as $eachModel) {
            //if($eachModel->purchaseorder->service_invoice!="Y" && $eachModel->po_id!=0){//NOT SERVICE INVOICE OR ADD LANDING COST
            $data[$i]['id'] = $eachModel->id;
            $data[$i]['invoice_no'] = $eachModel->id . ' : ' . $eachModel->invoice_no;
            $i++;
            //}
        }
        $invoice_details = CHtml::listData($data, 'id', 'invoice_no');
        $drop_down = CHtml::activedropDownList($model_debitnote, 'purchasing_invoice_id', $invoice_details, array('class' => 'tooltipster', 'title' => 'Invoice No', 'data-label' => 'Invoice No <span style="color:red">*</span>', 'data-search' => true, 'empty' => 'Select', 'onchange' => 'getreturndetails(this.value);'));
        echo CJSON::encode(array('details' => $drop_down));
    }
    public function actionGetpurchasereturnDetails()
    {
        $invoice_id = $_POST['invoice_id'];
        $model = PurchasingInvoice::model()->findByPk($invoice_id);
        //CODE ADDED BY MEREENA ON 08/04/2020
        $service_invoice = "N";
        if (isset($model->purchaseorder->service_invoice) && $model->purchaseorder->service_invoice == 'Y') {
            $service_invoice = "Y";
        }
        if ($model->po_id == 0) {//from add landing cost
            $service_invoice = "Y";
        }
        //END
        echo CJSON::encode(array(
            'currency' => $model->currencyname->currency,
            'currency_id' => $model->currency,
            'exchangerate' => $model->currencyname->exchange_rate,
            'customer_id' => $model->vendor_id,
            'customer_name' => $model->vendor_details->vendor_name,
            'file_id' => $model->file_id,
            'total_q' => $model->grand_total,
            'service_invoice' => $service_invoice,
            'invoice_date' => date('d/m/Y', strtotime($model->invoice_date)),
        ));
    }

    public function actionUploadDebitDocuments($folder = null)
    {



        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $field_id = "";

        if (isset($_GET['field_id'])) {

            $field_id = Yii::app()->request->getParam('field_id');
        }
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';

        // make the directory to store the pic:

        if (!is_dir($folder)) {

            mkdir($folder, 0777, TRUE);
        }

        //$allowedExtensions = array("jpg", "jpeg", "gif","png","pdf"); //array("jpg","jpeg","gif","exe","mov" and etc...
        $allowedExtensions = array("png", "jpg", "jpeg", "gif", "pdf", "doc", "docx", "xls", "xlsx");

        $sizeLimit = 8 * 1024 * 1024; // maximum file size in bytes


        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        ////////////////////////////////////////
        // 💡 Add date prefix to file name
        if ($result['success']) {
            $originalFile = $result['filename'];
            $datePrefix = date('Y-m-d') . '-';
            $newFileName = $datePrefix . $originalFile;

            $oldPath = $folder . $originalFile;
            $newPath = $folder . $newFileName;

            // Rename the file on the server
            if (file_exists($oldPath)) {
                rename($oldPath, $newPath);
                $result['filename'] = $newFileName;
            }
        }
        ///////////////////////////////////////
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $result['field_id'] = $field_id;
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        echo $return; // it's array




    }
}
