<?php

class DbbackupController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover','GetDBBackup','GetDBBackupInvoice','GetDBBackupStockLedger','GetDBBackupAccountVoucher','GetDBBackupAccountVoucherItems','GetDBBackupAllocationItems'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index','GetDBBackup','GetDBBackupAccountVoucher','GetDBBackupAccountVoucherItems','GetDBBackupAllocationItems','GetDBBackupInvoice','GetDBBackupStockLedger','GetDBBackupAccountVoucherItemsCSV','DownloadFile'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }
//backup1
public function actionGetDBBackup(){
    
    
$host = 'localhost';
$username = 'blueskye_dehnee';
$password = 'Ma9C;(#=3a&P';
$database = 'blueskye_pos_dehnee';


// Connect to MySQL
$connection = new mysqli($host, $username, $password, $database);
if ($connection->connect_error) {
    die('Connection failed: ' . $connection->connect_error);
}


$backupFile = 'dbbackup/backup_1.sql';

//$file_name		= "dbbackup/backup.sql";
//$file_name_path = Yii::getPathOfAlias('webroot')."/".$file_name;


$tables = array();
$result = $connection->query("SHOW FULL TABLES WHERE TABLE_TYPE NOT LIKE 'VIEW'");
while ($row = $result->fetch_row()) {
    $tables[] = $row[0];
}

$handle = fopen($backupFile, 'w');

foreach ($tables as $table) { 
    if($table!='erp_acc_voucher_items' && $table!='erp_acc_voucher' && $table!='erp_acc_allocation_items' && $table!='erp_stock_ledger'  && $table!='erp_invoice' && $table!='erp_invoice_item'){
        $result = $connection->query("SELECT * FROM " . $table);
        $numColumns = $result->field_count;
    
        fwrite($handle, 'DROP TABLE IF EXISTS ' . $table . ";\n");
    
        $createTableQuery = $connection->query("SHOW CREATE TABLE " . $table);
        $createTableRow = $createTableQuery->fetch_row();
        fwrite($handle, $createTableRow[1] . ";\n");
    
        while ($row = $result->fetch_row()) {
            $rowValues = array();
            for ($i = 0; $i < $numColumns; $i++) {
                $rowValues[] = "'" . $connection->real_escape_string($row[$i]) . "'";
            }
            fwrite($handle, 'INSERT INTO ' . $table . ' VALUES (' . implode(',', $rowValues) . ");\n");
        }
    }
}

fclose($handle);

$zip = new ZipArchive();

$zip_file_path = Yii::getPathOfAlias('webroot')."/dbbackup/backup_1.zip";
    		 
if($zip->open($zip_file_path,1?ZIPARCHIVE::OVERWRITE:ZIPARCHIVE::CREATE)===TRUE)
{
	// Add the files to the .zip file
	$zip->addFile($backupFile);
	// Closing the zip file
	$zip->close();
	//remove file from path
	//@unlink($file_name_path);
}


        		 
/*header("Content-type:application/zip"); //for pdf file
//if you want to read text file using text/plain header
header('Content-Disposition: attachment; filename="'.basename($zip_file_path).'"');
header('Content-Length: ' . filesize($zip_file_path));
readfile($zip_file_path);

@unlink($zip_file_path);
Yii::app()->end();*/


/*
// Fetch all table names from the database
$tables = [];
$result = $connection->query("SHOW TABLES");
if ($result->num_rows > 0) {
    while ($row = $result->fetch_row()) {
        $tables[] = $row[0];
    }
}

// Create a ZIP file
$zipFile = 'dbbackup/backup.zip';
$zip = new ZipArchive();
if ($zip->open($zipFile, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== true) {
    die('Error creating ZIP file');
}

// Export each table as a CSV file and add it to the ZIP archive
foreach ($tables as $table) {
    $csvFile = 'dbbackup/' . $table . '.csv';
    $fp = fopen($csvFile, 'w');

    // Fetch data from the table
    $query = "SELECT * FROM " . $table;
    $result = $connection->query($query);
    while ($row = $result->fetch_assoc()) {
        fputcsv($fp, $row);
    }

    fclose($fp);
    $zip->addFile($csvFile, basename($csvFile));
}

$zip->close();

// Send the ZIP file to the user for download
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="'.basename($zipFile).'"');
header('Content-Length: ' . filesize($zipFile));
readfile($zipFile);
exit;
*/

}
//end //backup1



//backup2
public function actionGetDBBackupStockLedger(){
    $host = 'localhost';
    $username = 'blueskye_dehnee';
    $password = 'Ma9C;(#=3a&P';
    $database = 'blueskye_pos_dehnee';
    
    
    // Connect to MySQL
    $connection = new mysqli($host, $username, $password, $database);
    if ($connection->connect_error) {
        die('Connection failed: ' . $connection->connect_error);
    }
    
    $fileName = "backup_2";//stock ledger
    
    $backupFile = 'dbbackup/'.$fileName.'.sql';
    
    $handle = fopen($backupFile, 'w');
    $table = "erp_stock_ledger";
    
    $result = $connection->query("SELECT * FROM " . $table);
    $numColumns = $result->field_count;

    fwrite($handle, 'DROP TABLE IF EXISTS ' . $table . ";\n");

    $createTableQuery = $connection->query("SHOW CREATE TABLE " . $table);
    $createTableRow = $createTableQuery->fetch_row();
    fwrite($handle, $createTableRow[1] . ";\n");

    while ($row = $result->fetch_row()) {
        $rowValues = array();
        for ($i = 0; $i < $numColumns; $i++) {
            $rowValues[] = "'" . $connection->real_escape_string($row[$i]) . "'";
        }
        fwrite($handle, 'INSERT INTO ' . $table . ' VALUES (' . implode(',', $rowValues) . ");\n");
    }
    
    
    fclose($handle);
    
    $zip = new ZipArchive();
    
    $zip_file_path = Yii::getPathOfAlias('webroot')."/dbbackup/".$fileName.".zip";
        		 
    if($zip->open($zip_file_path,1?ZIPARCHIVE::OVERWRITE:ZIPARCHIVE::CREATE)===TRUE)
    {
    	// Add the files to the .zip file
    	$zip->addFile($backupFile);
    	// Closing the zip file
    	$zip->close();
    	//remove file from path
    	//@unlink($file_name_path);
    }

}
// end //backup2




//backup3

public function actionGetDBBackupInvoice(){
    $host = 'localhost';
    $username = 'blueskye_dehnee';
    $password = 'Ma9C;(#=3a&P';
    $database = 'blueskye_pos_dehnee';
    
    
    // Connect to MySQL
    $connection = new mysqli($host, $username, $password, $database);
    if ($connection->connect_error) {
        die('Connection failed: ' . $connection->connect_error);
    }
    
    $fileName = "backup_3"; //invoice
    $table = "erp_invoice";
    $table1="erp_invoice_item";
    
    $backupFile = 'dbbackup/'.$fileName.'.sql';
    
    $handle = fopen($backupFile, 'w');
    
    $result = $connection->query("SELECT * FROM " . $table);
    $numColumns = $result->field_count;

    fwrite($handle, 'DROP TABLE IF EXISTS ' . $table . ";\n");

    $createTableQuery = $connection->query("SHOW CREATE TABLE " . $table);
    $createTableRow = $createTableQuery->fetch_row();
    fwrite($handle, $createTableRow[1] . ";\n");

    while ($row = $result->fetch_row()) {
        $rowValues = array();
        for ($i = 0; $i < $numColumns; $i++) {
            $rowValues[] = "'" . $connection->real_escape_string($row[$i]) . "'";
        }
        fwrite($handle, 'INSERT INTO ' . $table . ' VALUES (' . implode(',', $rowValues) . ");\n");
    }
    
    
    
    $result = $connection->query("SELECT * FROM " . $table1);
    $numColumns = $result->field_count;

    fwrite($handle, 'DROP TABLE IF EXISTS ' . $table1 . ";\n");

    $createTableQuery = $connection->query("SHOW CREATE TABLE " . $table1);
    $createTableRow = $createTableQuery->fetch_row();
    fwrite($handle, $createTableRow[1] . ";\n");

    while ($row = $result->fetch_row()) {
        $rowValues = array();
        for ($i = 0; $i < $numColumns; $i++) {
            $rowValues[] = "'" . $connection->real_escape_string($row[$i]) . "'";
        }
        fwrite($handle, 'INSERT INTO ' . $table1 . ' VALUES (' . implode(',', $rowValues) . ");\n");
    }
    
    
    
    fclose($handle);
    
    $zip = new ZipArchive();
    
    $zip_file_path = Yii::getPathOfAlias('webroot')."/dbbackup/".$fileName.".zip";
        		 
    if($zip->open($zip_file_path,1?ZIPARCHIVE::OVERWRITE:ZIPARCHIVE::CREATE)===TRUE)
    {
    	// Add the files to the .zip file
    	$zip->addFile($backupFile);
    	// Closing the zip file
    	$zip->close();
    	//remove file from path
    	//@unlink($file_name_path);
    }

}
//end //backup3


//backup4
public function actionGetDBBackupAccountVoucher(){
    $host = 'localhost';
    $username = 'blueskye_dehnee';
    $password = 'Ma9C;(#=3a&P';
    $database = 'blueskye_pos_dehnee';
    
    
    // Connect to MySQL
    $connection = new mysqli($host, $username, $password, $database);
    if ($connection->connect_error) {
        die('Connection failed: ' . $connection->connect_error);
    }
    
    $fileName = "backup_4";
    $table = "erp_acc_voucher";
    
    $backupFile = 'dbbackup/'.$fileName.'.sql';
    
    $handle = fopen($backupFile, 'w');
    
    $result = $connection->query("SELECT * FROM " . $table);
    $numColumns = $result->field_count;

    fwrite($handle, 'DROP TABLE IF EXISTS ' . $table . ";\n");

    $createTableQuery = $connection->query("SHOW CREATE TABLE " . $table);
    $createTableRow = $createTableQuery->fetch_row();
    fwrite($handle, $createTableRow[1] . ";\n");

    while ($row = $result->fetch_row()) {
        $rowValues = array();
        for ($i = 0; $i < $numColumns; $i++) {
            $rowValues[] = "'" . $connection->real_escape_string($row[$i]) . "'";
        }
        fwrite($handle, 'INSERT INTO ' . $table . ' VALUES (' . implode(',', $rowValues) . ");\n");
    }
    
    
    fclose($handle);
    
    $zip = new ZipArchive();
    
    $zip_file_path = Yii::getPathOfAlias('webroot')."/dbbackup/".$fileName.".zip";
        		 
    if($zip->open($zip_file_path,1?ZIPARCHIVE::OVERWRITE:ZIPARCHIVE::CREATE)===TRUE)
    {
    	// Add the files to the .zip file
    	$zip->addFile($backupFile);
    	// Closing the zip file
    	$zip->close();
    	//remove file from path
    	//@unlink($file_name_path);
    }

}
//end //backup4


//backup5
public function actionGetDBBackupAccountVoucherItems(){
    $host = 'localhost';
    $username = 'blueskye_dehnee';
    $password = 'Ma9C;(#=3a&P';
    $database = 'blueskye_pos_dehnee';
    
    
    // Connect to MySQL
    $connection = new mysqli($host, $username, $password, $database);
    if ($connection->connect_error) {
        die('Connection failed: ' . $connection->connect_error);
    }
    
    $fileName = "backup_5";
    $table = "erp_acc_voucher_items";
    
    $backupFile = 'dbbackup/'.$fileName.'.sql';
    
    $handle = fopen($backupFile, 'w');
    
  
    
    $result = $connection->query("SELECT * FROM " . $table);
    $numColumns = $result->field_count;

    fwrite($handle, 'DROP TABLE IF EXISTS ' . $table . ";\n");

    $createTableQuery = $connection->query("SHOW CREATE TABLE " . $table);
    $createTableRow = $createTableQuery->fetch_row();
    fwrite($handle, $createTableRow[1] . ";\n");

    while ($row = $result->fetch_row()) {
        $rowValues = array();
        for ($i = 0; $i < $numColumns; $i++) {
            $rowValues[] = "'" . $connection->real_escape_string($row[$i]) . "'";
        }
        fwrite($handle, 'INSERT INTO ' . $table . ' VALUES (' . implode(',', $rowValues) . ");\n");
    }
    
    
    fclose($handle);
    
    $zip = new ZipArchive();
    
    $zip_file_path = Yii::getPathOfAlias('webroot')."/dbbackup/".$fileName.".zip";
        		 
    if($zip->open($zip_file_path,1?ZIPARCHIVE::OVERWRITE:ZIPARCHIVE::CREATE)===TRUE)
    {
    	// Add the files to the .zip file
    	$zip->addFile($backupFile);
    	// Closing the zip file
    	$zip->close();
    	//remove file from path
    	//@unlink($file_name_path);
    }

}
////backup5


//backup5  CSV
public function actionGetDBBackupAccountVoucherItemsCSV(){
    $host = 'localhost';
    $username = 'blueskye_dehnee';
    $password = 'Ma9C;(#=3a&P';
    $database = 'blueskye_pos_dehnee';
    
    
    // Connect to MySQL
    $connection = new mysqli($host, $username, $password, $database);
    if ($connection->connect_error) {
        die('Connection failed: ' . $connection->connect_error);
    }
    
   
    $table = "erp_acc_voucher_items";
    
    $zipFile = 'dbbackup/backup_5_csv.zip';
    $zip = new ZipArchive();
    if ($zip->open($zipFile, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== true) {
        die('Error creating ZIP file');
    }
    
    $csvFile = 'dbbackup/backup_5.csv';
    $fp = fopen($csvFile, 'w');

    // Fetch data from the table
    $query = "SELECT * FROM " . $table;
    $result = $connection->query($query);
    while ($row = $result->fetch_assoc()) {
        fputcsv($fp, $row);
    }

    fclose($fp);
    $zip->addFile($csvFile, basename($csvFile));
    $zip->close();

}
//end backup5 CSV

//backup6
public function actionGetDBBackupAllocationItems(){
    $host = 'localhost';
    $username = 'blueskye_dehnee';
    $password = 'Ma9C;(#=3a&P';
    $database = 'blueskye_pos_dehnee';
    
    
    // Connect to MySQL
    $connection = new mysqli($host, $username, $password, $database);
    if ($connection->connect_error) {
        die('Connection failed: ' . $connection->connect_error);
    }
    
    $fileName = "backup_6";
    $table = "erp_acc_allocation_items";
    
    $backupFile = 'dbbackup/'.$fileName.'.sql';
    
    $handle = fopen($backupFile, 'w');
    
  
    
    $result = $connection->query("SELECT * FROM " . $table);
    $numColumns = $result->field_count;

    fwrite($handle, 'DROP TABLE IF EXISTS ' . $table . ";\n");

    $createTableQuery = $connection->query("SHOW CREATE TABLE " . $table);
    $createTableRow = $createTableQuery->fetch_row();
    fwrite($handle, $createTableRow[1] . ";\n");

    while ($row = $result->fetch_row()) {
        $rowValues = array();
        for ($i = 0; $i < $numColumns; $i++) {
            $rowValues[] = "'" . $connection->real_escape_string($row[$i]) . "'";
        }
        fwrite($handle, 'INSERT INTO ' . $table . ' VALUES (' . implode(',', $rowValues) . ");\n");
    }
    
    
    fclose($handle);
    
    $zip = new ZipArchive();
    
    $zip_file_path = Yii::getPathOfAlias('webroot')."/dbbackup/".$fileName.".zip";
        		 
    if($zip->open($zip_file_path,1?ZIPARCHIVE::OVERWRITE:ZIPARCHIVE::CREATE)===TRUE)
    {
    	// Add the files to the .zip file
    	$zip->addFile($backupFile);
    	// Closing the zip file
    	$zip->close();
    	//remove file from path
    	//@unlink($file_name_path);
    }

}

//end backup6

public function actionIndex(){
        $this->render('index');
}

public function actionDownloadFile(){
    $file_name =  Yii::app()->request->getParam('file_name');
    $filePath = 'dbbackup/'.$file_name; // Specify the file path
    
    // Check if the file exists
    if (file_exists($filePath)) {
        // Set the appropriate headers for the file download
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="'.basename($filePath).'"');
        header('Content-Length: ' . filesize($filePath));
        header('Cache-Control: private, must-revalidate');
        header('Pragma: public');
        header('Expires: 0');
        
        // Read the file and output it to the browser for download
        readfile($filePath);
        exit;
    } else {
        // File not found
        die('File does not exist.');
    }
}
   
}