<?php

class DashboardmatrixEmployeeController extends Controller
{

    public function accessRules()
    {
        return array(
            array(
                'allow',
                'actions' => array('Index', 'loadDetails'),
                'users' => array('*'),
            ),
            array(
                'allow',
                'actions' => array(),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function actionIndex()
    {
        $this->renderPartial('index');
    }
    public function actionLoadDetails()
    {
        $yearStart = date('Y-01-01 00:00:00');
        $yearEnd = date('Y-12-31 23:59:59');
        $currentYear = date("Y");
        $lastYear = $currentYear - 1;

        $lastYearStart = $lastYear . '-01-01 00:00:00';
        $lastYearEnd = $lastYear . '-12-31 23:59:59';

        if (Yii::app()->request->isPostRequest) {
            $employeeId = isset($_POST['employee_id']) ? (int) $_POST['employee_id'] : 0;
            $userId = null;

            if ($employeeId != 0) {
                $user = User::model()->findByAttributes(['hr_connected_employee_id' => $employeeId]);
                if ($user) {
                    $userId = $user->id;
                }
            }

            // ---------- Conditions ----------
            $conditionCustomer = "created_date_time BETWEEN :start AND :end";
            $conditionLead = "enq_date BETWEEN :start AND :end";
            $conditionQuote = "qtn_start_date BETWEEN :start AND :end";
            $conditionOrder = "order_date BETWEEN :start AND :end";
            $conditionInvoice = "invoice_date BETWEEN :start AND :end";
            $conditionCredit = "credited_date BETWEEN :start AND :end"; // adjust field name

            if ($userId) {
                $conditionCustomer .= " AND lead_owner_id = :userId";
                $conditionLead .= " AND lead_owner_id = :userId";
                $conditionQuote .= " AND lead_owner_id = :userId";
                $conditionOrder .= " AND lead_owner_id = :userId";
                $conditionInvoice .= " AND lead_owner_id = :userId";
                $conditionCredit .= " AND lead_owner_id = :userId";
            }

            // Helper function to build params
            $params = function ($start, $end, $userId) {
                $p = [':start' => $start, ':end' => $end];
                if ($userId) {
                    $p[':userId'] = $userId;
                }
                return $p;
            };

            // ---------- Customers ----------
            $yearCustomerCount = Customer::model()->count($conditionCustomer, $params($yearStart, $yearEnd, $userId));
            $lastYearCustomerCount = Customer::model()->count($conditionCustomer, $params($lastYearStart, $lastYearEnd, $userId));

            // ---------- Leads ----------
            $yearLead = Yii::app()->db->createCommand()
                ->select("COUNT(*) as count, IFNULL(SUM(value),0) as total")
                ->from("erp_lead")
                ->where($conditionLead, $params($yearStart, $yearEnd, $userId))
                ->queryRow();

            $lastYearLead = Yii::app()->db->createCommand()
                ->select("COUNT(*) as count, IFNULL(SUM(value),0) as total")
                ->from("erp_lead")
                ->where($conditionLead, $params($lastYearStart, $lastYearEnd, $userId))
                ->queryRow();

            // ---------- Quotes ----------
            $yearQuote = Yii::app()->db->createCommand()
                ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
                ->from("erp_quotes")
                ->where($conditionQuote, $params($yearStart, $yearEnd, $userId))
                ->queryRow();

            $lastYearQuote = Yii::app()->db->createCommand()
                ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
                ->from("erp_quotes")
                ->where($conditionQuote, $params($lastYearStart, $lastYearEnd, $userId))
                ->queryRow();

            // ---------- Orders ----------
            $yearOrder = Yii::app()->db->createCommand()
                ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
                ->from("erp_order")
                ->where($conditionOrder, $params($yearStart, $yearEnd, $userId))
                ->queryRow();

            $lastYearOrder = Yii::app()->db->createCommand()
                ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
                ->from("erp_order")
                ->where($conditionOrder, $params($lastYearStart, $lastYearEnd, $userId))
                ->queryRow();

            // ---------- Invoices ----------
            $yearInvoice = Yii::app()->db->createCommand()
                ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
                ->from("erp_invoice")
                ->where($conditionInvoice, $params($yearStart, $yearEnd, $userId))
                ->queryRow();

            $lastYearInvoice = Yii::app()->db->createCommand()
                ->select("COUNT(*) as count, IFNULL(SUM(grand_total * exchange_rate),0) as total")
                ->from("erp_invoice")
                ->where($conditionInvoice, $params($lastYearStart, $lastYearEnd, $userId))
                ->queryRow();

            // ---------- Credit Notes ----------
            // $yearCreditNote = Yii::app()->db->createCommand()
            //     ->select("COUNT(*) as count, IFNULL(SUM(credited_amount * exchange_rate),0) as total")
            //     ->from("erp_creditnote")
            //     ->where($conditionCredit, $params($yearStart, $yearEnd, $userId))
            //     ->queryRow();

            // $lastYearCreditNote = Yii::app()->db->createCommand()
            //     ->select("COUNT(*) as count, IFNULL(SUM(credited_amount * exchange_rate),0) as total")
            //     ->from("erp_creditnote")
            //     ->where($conditionCredit, $params($lastYearStart, $lastYearEnd, $userId))
            //     ->queryRow();

            // ---------- Render ----------
            $this->renderPartial('_details', [
                'yearCustomerCount' => $yearCustomerCount,
                'lastYearCustomerCount' => $lastYearCustomerCount,
                'yearLead' => $yearLead,
                'lastYearLead' => $lastYearLead,
                'yearQuote' => $yearQuote,
                'lastYearQuote' => $lastYearQuote,
                'yearOrder' => $yearOrder,
                'lastYearOrder' => $lastYearOrder,
                'yearInvoice' => $yearInvoice,
                'lastYearInvoice' => $lastYearInvoice,
                // 'yearCreditNote' => $yearCreditNote,
                // 'lastYearCreditNote' => $lastYearCreditNote,
            ], false, true);

        } else {
            throw new CHttpException(400, 'Invalid request.');
        }
    }







}