<?php

//modified by jisha on 15-9-18.
class CustomerController extends Controller
{

    public $title = "Customer";

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'), //,'temp_form','CompanyFieldDetails'
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'GetCustomerList',
                    'Create',
                    'SaveCustomer',
                    'GetContactList',
                    'CustomerContactCreate',
                    'SaveContact',
                    'getDocsList',
                    'CreateDocumentForm',
                    'SaveDocForm',
                    'DeleteShippingItem',
                    'UploadCustomerDocument',
                    'DownloadDocument',
                    'CheckTrnExistance',
                    'GetCustomerDetails',
                    'GetCustomerContactdetails',
                    'info',
                    'DeleteDocument',
                    'getcustomerorders',
                    'checksubledger',
                    'CheckIndustry',
                    'DeleteBuildingUnit',
                    'Uploadcustomer',
                    'SaveCustomerUploadCsv',
                    'UploadCustomerCsv',
                    'UploadEmployeecsv',
                    'DownloadSampleCsv',
                    'readCustomerCSV',
                    'DownloadErrorCsv'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     * //modified by jisha on 15-9-18.
     */
    public function actionIndex()
    {
        // Disable loading of certain JS files
        Yii::app()->clientScript->scriptMap = array(
            '*jquery.js' => false,
            '*jquery.min.js' => false,
            'jquery.min.js' => false,
            '*jquery-ui.js' => false,
            '*jquery-ui.min.js' => false,
        );

        // Permission check
        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn['sales_menu_view']) &&
                isset(Yii::app()->user->havePermissionOn['customer_view']) &&
                Yii::app()->user->havePermissionOn['sales_menu_view'] &&
                Yii::app()->user->havePermissionOn['customer_view']
            )
        ) {
            // Authorized: render the main view
            $this->render('index');
        } else {
            // Unauthorized: show custom unauthorized page
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }

    }

    /*
     * function to list all customers
     * modified by jisha on 15-9-18.
     */

    public function actionGetCustomerList()
    {
        $model = new Customer();
        //$condition = 't.isActive= "Y"';
        $condition = '1=1';

        //code added sarika on 3-11-2022 toget customer on that location only

        /* if (Yii::app()->user->authorised_user!= 1 ){
          $user_id = Yii::app()->user->id;
          $modelUser=new User();
          $modelUser=$modelUser ->findByPk($user_id);
          //to prevent error when location_id is empty
          if(!empty($modelUser->location_id)){
          $condition  .= ' AND t.location_id IN ('.$modelUser->location_id.') ';
          }
          else{
          $condition  .= ' AND t.location_id=0 ';
          }


          } */

        //end code
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'customer_name',
            2 => 'customer_email_id',
            3 => 'nick_name',
            4 => 'customer_phone_no',
            5 => 'user.first_name',
            6 => 'country.country_name',
            7 => 't.id',
            8 => 'isActive'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $userId = Yii::app()->user->id;
        // var_dump($_POST['view_all'])
        if (Yii::app()->user->authorised_user == 1 || $_POST['view_all'] == 1 || Yii::app()->user->havePermissionOn["view_all_customer_activity"]) {
            $condition = 't.isActive= "Y"';
        } else if (User::isSalesman() == 'Y') {
            $condition = 't.isActive = "Y" AND FIND_IN_SET("' . $userId . '", t.lead_owner_id)';
        } else {
            $condition = 't.isActive = "Y" AND FIND_IN_SET("' . $userId . '", t.lead_owner_id)';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (CONCAT(TRIM(user.first_name),' ',TRIM(user.last_name)) LIKE '%" . $searchString . "%' OR customer_name LIKE '%" . $searchString . "%' OR  t.id LIKE '%" . $searchString . "%'  OR customer_address LIKE '%" . $searchString . "%' OR customer_phone_no LIKE '%" . $searchString . "%' OR customer_location LIKE '%" . $searchString . "%'  OR customer_email_id LIKE '%" . $searchString . "%'  OR paymentmethod.payment_terms LIKE '%" . $searchString . "%' OR customer_trn_no LIKE '%" . $searchString . "%' OR country.country_name LIKE '%" . $searchString . "%')";
        }
        /* if(User::isSalesman()=='Y'){
          $condition.=" AND t.lead_owner_id=".Yii::app()->user->id;
          } */
        $count = $model->with('paymentmethod', 'user', 'country')->count(array('condition' => $condition));
        $model = $model->with('paymentmethod', 'user', 'country')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $current = strtotime(date('y-m-d'));

        function getFirstcontact($id)
        {
            return CustomerContact::model()->find(array('condition' => 'customer_id=' . $id))->person_name;
        }
        $salesmanlist = '';
        foreach ($model as $row) {

            $SQL = 'SELECT MAX(`order_date`) AS last_order_date FROM `erp_order` WHERE customer_id=' . $row['id'];
            $arr_last_order_date = Yii::app()->db->createCommand($SQL)->queryRow();
            //print_r($arr_last_order_date);
            $last_order_date = $arr_last_order_date['last_order_date'];
            //echo $last_order_date;
            $colour = 0;
            $own_flag = 0;
            if ($row['lead_owner_id'] == Yii::app()->user->id || Yii::app()->user->authorised_user == 1) {
                $own_flag = 1;
            }

            $sales_man = ($row['lead_owner_id']);
            //echo ($sales_man);exit;
            if (!empty($sales_man)) {
                $condition_user = ' id IN (' . $sales_man . ')';
            }

            $modelsalesman = User::model()->findAll(array('condition' => $condition_user));
            $userlist = array();
            foreach ($modelsalesman as $key => $rowuser) {
                $userlist[] = ($rowuser['fullname']);
            }
            //print_r($userlist);
            $salesmanlist = implode(', ', $userlist);
            $rowData[] = array(
                $row['id'],
                substr($row['customer_name'], 0, 45),
                ($row['location_id']),
                ($row['customer_phone_no']) ? $row['customer_phone_no'] : '-',
                ($row['customer_trn_no']) ? $row['customer_trn_no'] : '-',
                '<div title="' . $row['paymentmethod']['payment_terms'] . '">' . $row['paymentmethod']['payment_terms'] . '</div>',
                (!empty($last_order_date)) ? date('d/m/Y', strtotime($last_order_date)) : "-",
                $colour,
                $row['isActive'],
                $row['isCompetitor'],
                $own_flag
            );
            $m++;
        }
        $data['data'] = $rowData;
        $data['con'] = $orderBy;
        echo json_encode($data);
    }

    /*
     * function to create customer details
     * modified by jisha on 15-9-18.
     */

    public function actionCreate()
    {
        $model = new Customer();
        $modelcontact = new CustomerContact();
        $modeldoc = new CustomerDocs();
        $modelCustomerDashboard = new CustomerDashboard();

        $id = (int) Yii::app()->request->getParam('id');
        $flag = (int) Yii::app()->request->getParam('flag');
        $industry = Yii::app()->request->getParam('industry');
        $payterms = Yii::app()->request->getParam('payterms');
        $leadform = Yii::app()->request->getParam('frm');
        $leadid = Yii::app()->request->getParam('leadid');
        $file_id = Yii::app()->request->getParam('fileid');
        $type = Yii::app()->request->getParam('type');

        if ($id > 0) {
            $model = $model->findByPk($id);
            $modeldoc = CustomerDocs::model()->findAll(array('condition' => 'customer_id=' . $id));
            $modelCustomerDashboard = CustomerDashboard::model()->findAll(array('condition' => 'customer_id=' . $id));
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('customer_form', array('model' => $model, 'modelcontact' => $modelcontact, 'modeldoc' => $modeldoc, 'flag' => $flag, 'industry' => $industry, 'payterms' => $payterms, 'leadform' => $leadform, 'leadid' => $leadid, 'file_id' => $file_id, 'type' => $type, 'modelCustomerDashboard' => $modelCustomerDashboard));
    }



    function actionSaveCustomer()
    {
        $model = new Customer();
        $modelcontact = new CustomerContact();
        $modeldoc = new CustomerDocs();
        $modelCustomerDashboard = [new CustomerDashboard()];
        $oldship_id_array = array();

        $frm = $_POST['frm'];
        $leadid = $_POST['leadid'];
        $file_id = $_POST['file_id'];

        /*         * ********** START Code for Save ************** */
        if (isset($_POST['Customer'])) {
            $scene = '';
            $customer_approved = '';
            if ($_POST['Customer']['id'] > 0) {
                $id = $_POST['Customer']['id'];
                $model = $model->findByPK($id);
                $oldship_id_array = CustomerShippingDetails::model()->findAll(array('select' => 'id', 'condition' => 'customer_id = "' . $_POST['Customer']['id'] . '"'));
                $scene = 'update';
                $change_type = 'UPDATED';
            } else {
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('Y-m-d H:i:s');
                $scene = 'new';
                $change_type = 'CREATED';
            }
            $model->updated_by = Yii::app()->user->id;
            $model->updated_date_time = date('Y-m-d H:i:s');

            $model->attributes = $_POST['Customer'];

            if (is_array($_POST['Customer']['lead_owner_id'])) {
                $model->lead_owner_id = implode(',', $_POST['Customer']['lead_owner_id']);
            } else {
                $model->lead_owner_id = "";
            }
            $model->customer_credit_limit = floatval($_POST['Customer']['customer_credit_limit']);
            $model->isActive = $_POST['Customer']['isActive'];
            $model->isCompetitor = $_POST['Customer']['isCompetitor'];
            $model->customer_remarks = $_POST['Customer']['customer_remarks'];
            $model->location_id = $_POST['Customer']['location_id'];
            //  if ($_POST['Customer']['customer_country'] != '143') {
            $model->customer_emirates_name = "9";
            // } else {
            //    $model->customer_emirates_name = $_POST['Customer']['customer_emirates_name'];
            // }
            $valid = $model->validate();
            $customer_contact_type = ''; // changes for audit log
            if (isset($_POST['CustomerContact'])) {
                if ($_POST['CustomerContact']['id'] > 0) {
                    $id = $_POST['CustomerContact']['id'];
                    $modelcontact = $modelcontact->findByPK($id);
                    $modelcontact->updated_by = Yii::app()->user->id;
                    $modelcontact->updated_date_time = date('Y-m-d h:i:s');
                    $customer_contact_type = 'UPDATED'; // changes for audit log
                } else {
                    $modelcontact = new CustomerContact();
                    $modelcontact->created_by = Yii::app()->user->id;
                    $modelcontact->created_date_time = date('Y-m-d h:i:s');
                    $modelcontact->updated_by = Yii::app()->user->id;
                    $modelcontact->updated_date_time = date('Y-m-d h:i:s');
                    $customer_contact_type = 'CREATED'; // changes for audit log
                }
                $modelcontact->attributes = $_POST['CustomerContact'];
                $modelcontact->person_name = $_POST['CustomerContact']['person_name'];
                $modelcontact->customer_id = 0;
                $modelcontact->isActive = $_POST['CustomerContact']['isActive'];
                $valid = $valid && $modelcontact->validate();
            } else {
                // for level checking
                if ($change_type == 'CREATED') {
                    $modelcontact = new CustomerContact();
                    $modelcontact->created_by = Yii::app()->user->id;
                    $modelcontact->created_date_time = date('Y-m-d h:i:s');
                    $modelcontact->person_name = 'Sales/Account';
                    $modelcontact->customer_id = 0;
                    $modelcontact->isActive = 'Y';
                    $customer_contact_type = 'CREATED';
                }
            }


            if ($_POST['CustomerDocs']['id'] > 0) {
                $docid = $_POST['CustomerDocs']['id'];
                $modeldoc = $modeldoc->findByPK($docid);
                $docs_type = 'UPDATED';
            } else {
                $docs_type = 'CREATED';
            }
            $modeldoc->attributes = $_POST['CustomerDocs'];




            if (is_array($_POST['CustomerShippingDetails'])) {
                foreach ($_POST['CustomerShippingDetails'] as $i => $item) {

                    if ($item['id'] > 0) {
                        $modelshipping[$i] = CustomerShippingDetails::model()->findByPk($item['id']);
                        $shipid_array[] = $item['id'];
                    } else {
                        $modelshipping[$i] = new CustomerShippingDetails;
                    }
                    $modelshipping[$i]->attributes = $_POST['CustomerShippingDetails'][$i];
                    $modelshipping[$i]->customer_id = 0;
                    $modelshipping[$i]->state = $item['state'];
                    $modelshipping[$i]->city = $item['city'];
                    $modelshipping[$i]->street_address = $item['street_address'];
                    $modelshipping[$i]->po_box = $item['po_box'];
                    $modelshipping[$i]->postal_code = $item['postal_code'];
                    $modelshipping[$i]->country_id = $item['country_id'];
                    $valid = $modelshipping[$i]->validate() && $valid;
                }

            }

            if (is_array($_POST['CustomerDashboard'])) {
                foreach ($_POST['CustomerDashboard'] as $j => $eachCustomerDashboard) {

                    if ($eachCustomerDashboard['id'] > 0) {
                        $modelCustomerDashboard[$j] = CustomerDashboard::model()->findByPk($eachCustomerDashboard['id']);
                    } else {
                        $modelCustomerDashboard[$j] = new CustomerDashboard();
                    }
                    $modelCustomerDashboard[$j]->attributes = $_POST['CustomerDashboard'][$j];
                    $modelCustomerDashboard[$j]->customer_id = 0;
                    $modelCustomerDashboard[$j]->ai_dashboard_id = $eachCustomerDashboard['ai_dashboard_id'];
                    $modelCustomerDashboard[$j]->customer_value = $eachCustomerDashboard['customer_value'];
                    //$valid = $modelCustomerDashboard[$j]->validate() && $valid;
                }

            }


            if ($valid) {
                echo CJSON::encode(array('status' => 'success', 'frm' => $frm, 'leadid' => $leadid, 'file_id' => $file_id));
                $model->save();
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'CUSTOMERS',
                    Yii::app()->user->id,
                    $change_type,
                    " with ID - {$model->id} "
                );
                // end audit log
                ;

                if ($modelcontact->person_name != '') {
                    $modelcontact->customer_id = $model->id;
                    $modelcontact->save(false);
                    // inserting to audit log
                    AuditLog::saveAuditLogs(
                        'CUSTOMERS',
                        Yii::app()->user->id,
                        $customer_contact_type,
                        " Contact with ID - {$modelcontact->id} "
                    );
                    // end audit log
                }
                //  $modelnote->customer_vendor_id = $model->id;
                //  $modelnote->customer_vendor_type = 1;
                if (!empty($modelshipping)) {
                    foreach ($modelshipping as $eachModel) {
                        $eachModel->customer_id = $model->id;
                        $eachModel->save();
                    }
                    if (!empty($oldship_id_array)) {
                        foreach ($oldship_id_array as $eachid) {
                            if (!in_array($eachid->id, $shipid_array)) {
                                CustomerShippingDetails::model()->deleteByPk($eachid->id);
                            }
                        }
                    }
                }

                if (!empty($modelCustomerDashboard)) {
                    foreach ($modelCustomerDashboard as $eachCustomerDashboard) {

                        if (!empty($eachCustomerDashboard->customer_value)) {
                            $eachCustomerDashboard->customer_id = $model->id;
                            $eachCustomerDashboard->save(false);
                        }
                    }
                }


                if ($_POST['CustomerDocs']['document'] != '') {
                    if ($_POST['CustomerDocs']['from_date'] != '00/00/0000' && $_POST['CustomerDocs']['from_date'] != '') {
                        $modeldoc->from_date = str_replace('/', '-', $_POST['CustomerDocs']['from_date']);
                        $modeldoc->from_date = date("Y-m-d", strtotime($modeldoc->from_date));
                    }
                    if ($_POST['CustomerDocs']['to_date'] != '00/00/0000' && $_POST['CustomerDocs']['to_date'] != '') {
                        $modeldoc->to_date = str_replace('/', '-', $_POST['CustomerDocs']['to_date']);
                        $modeldoc->to_date = date("Y-m-d", strtotime($modeldoc->to_date));
                    }
                    $modeldoc->customer_id = $model->id;
                    $modeldoc->save(false);

                    // inserting to audit log
                    AuditLog::saveAuditLogs(
                        'CUSTOMERS',
                        Yii::app()->user->id,
                        $docs_type,
                        " Document with ID - {$modeldoc->id} "
                    );
                    // end audit log
                }


                // -----------------------------------------------------------------------------------------------------------
                //save this customer to Subledgder---added- by-indhu-05-01-2023
                //------------------------------------------------------------------------------------------------------------
                $modelAccSubledger = new AccSubledger();
                $type = "C";
                $modelAccSubledger->saveEachSubledgder($model->id, $model->customer_name, $type);
                // -----------------------------------------------------------------------------------------------------------
                //-----------------------------------end-------------------------------------------------------------------------
                //Mail Settings
                if ($scene == 'new') {
                    $model_mail_setting = Notification::model()->find(array('condition' => 'event_id="1"'));
                    Yii::import('application.controllers.front.MasternotificationController');
                    if ($model_mail_setting->mail_required == 'Y') {
                        // MasternotificationController::sendmail(1,$model->id);
                    }
                    if ($model_mail_setting->notification_required == 'Y') {
                        // MasternotificationController::sendnotification(1,$model->id);
                    }
                    if ($model_mail_setting->sms_required == 'Y') {
                        // MasternotificationController::sendsms(1,$model->id);
                    }
                }
            } else {
                $error2 = array();
                $error3 = array();
                // $error4 =array();
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                if ($modelcontact->person_name != '') {
                    $error2 = json_decode(CActiveForm::validateTabular($modelcontact, '', false), true);
                }
                $error3 = json_decode(CActiveForm::validateTabular($modelshipping, '', false), true);
                // $error4= json_decode(CActiveForm::validateTabular($modelCustomerDashboard, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    /*
     * function to list customer conatcts
     * modified by jisha on 15-9-18.
     */

    function actionGetContactList()
    {
        $model = new CustomerContact();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $customer_id = $_POST['customer_id'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'person_name',
            1 => 'designation',
            2 => 'contact_phone_no',
            3 => 'isActive',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.customer_id = "' . $customer_id . '" AND (t.person_name !="" OR t.designation !="" OR t.contact_phone_no !="")';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (person_name LIKE '%" . $searchString . "%' OR designation LIKE '%" . $searchString . "%' OR contact_phone_no LIKE '%" . $searchString . "%')";
        }
        $or = 't.isActive';
        $count = $model->count(array('condition' => $condition));
        $model = $model->with('customer')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $or));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        foreach ($model as $row) {


            $st = "Blocked";
            if ($row['isActive'] == "Y") {
                $st = "Active";
            }

            $rowData[] = array(
                $row['person_name'],
                $row['designation'],
                $row['contact_phone_no'],
                $row['contact_mobile_no'],
                $row['contact_email_id'],
                $st,
                $row['isActive'],
                $row['id']
            );
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    /*
     * function to create customer contact using modal pop up
     * modified by jisha on 15-9-18.
     */

    public function actionCustomerContactCreate()
    {

        $models = new CustomerContact();
        $id = (int) Yii::app()->request->getParam('id');
        $customer_id = (int) Yii::app()->request->getParam('c_id');
        if ($id > 0) {
            $models = $models->findByPk($id);
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('contact_form', array('models' => $models, 'c_id' => $customer_id));
    }

    /*
     * function to save customer contact
     * modified by jisha on 15-9-18.
     */

    public function actionSaveContact()
    {
        $model = new CustomerContact();
        if (isset($_POST['CustomerContact'])) {

            if ($_POST['CustomerContact']['id'] > 0) {
                $id = $_POST['CustomerContact']['id'];
                $model = $model->findByPK($id);
                $model->updated_by = Yii::app()->user->id;
                $model->updated_date_time = date('y-m-d');
                $customer_contact_type = 'UPDATED';
            } else {
                $customer_contact_type = 'CREATED';
                $model->created_by = Yii::app()->user->id;
                $model->created_date_time = date('y-m-d');
            }
            $model->customer_id = $_POST['hid_customer_id'];
            $model->attributes = $_POST['CustomerContact'];
            $model->isActive = $_POST['CustomerContact']['isActive'];
            //$model->notes = $_POST['CustomerContact']['notes'];
            if ($model->save()) {
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'CUSTOMERS',
                    Yii::app()->user->id,
                    $customer_contact_type,
                    " Contact with ID - {$model->id} "
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['customer__form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    /*
     * function to list customer docs
     * modified by jisha on 15-9-18.
     */

    public function actionGetDocsList()
    {
        $model = new CustomerDocs();
        $vendor_id = $_POST['vendor_id'];
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'document_type',
            2 => 'document_no',
            3 => 'to_date',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        if ($vendor_id > 0) {
            $condition = 't.customer_id=' . $vendor_id;
        } else {
            $condition = '1=1';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (t.document_no LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('cus_details')->count(array('condition' => $condition));
        $model = $model->with('cus_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        $edit = '';
        foreach ($model as $row) {
            $to_date = '';
            // $edit = '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'customer/createDocumentform&id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row['cus_details']['customer_name'] . '\',\'lg\')"><i class="fa fa-pencil"></i></button> ';
            // $edit .= ' <a title= "Download" href ="' . Yii::app()->createUrl('customer/downloaddocument&id=' . $row['id']) . '" class=" btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';
            // if (isset(Yii::app()->user->havePermissionOn['allow_delete_document'])) {
            //     $edit .= '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteERPDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a>';
            // }
            if ($row['to_date'] != '' && $row['to_date'] != '0000-00-00') {
                $to_date = date("d/m/Y", strtotime($row['to_date']));
            }
            $rowData[] = array($m, $row['doctype']['document_type'], $row['document_no'], $to_date, $edit, $row['id']);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    /*
     * function to create customer document using modal pop up
     * modified by jisha on 15-9-18.
     */

    public function actionCreateDocumentForm()
    {

        $model = new Customer();
        $modeldoc = new CustomerDocs();
        $id = (int) Yii::app()->request->getParam('id');
        $customer_id = (int) Yii::app()->request->getParam('c_id');
        if ($id > 0) {
            $modeldoc = $modeldoc->findByPk($id);
            $customer_id = $modeldoc->customer_id;
        }
        if ($customer_id > 0) {
            $model = $model->findByPk($customer_id);
            $modeldoc->customer_id = $customer_id;
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->render('doc_form', array('model' => $model, 'modeldoc' => $modeldoc, 'c_id' => $customer_id));
    }

    /*
     * function to save customer document
     */

    public function actionSaveDocForm()
    {
        $model = new CustomerDocs();
        $id = $_POST['CustomerDocs']['id'];
        if ($_POST['CustomerDocs']['id'] > 0) {
            $model = $model->findByPk($id);
            $docs_type = 'UPDATED';
        } else {
            $docs_type = 'CREATED';
        }
        $model->attributes = $_POST['CustomerDocs'];
        if ($_POST['CustomerDocs']['from_date'] != '00/00/0000' && $_POST['CustomerDocs']['from_date'] != '') {
            $model->from_date = str_replace('/', '-', $_POST['CustomerDocs']['from_date']);
            $model->from_date = date("Y-m-d", strtotime($model->from_date));
        }
        if ($_POST['CustomerDocs']['to_date'] != '00/00/0000' && $_POST['CustomerDocs']['to_date'] != '') {
            $model->to_date = str_replace('/', '-', $_POST['CustomerDocs']['to_date']);
            $model->to_date = date("Y-m-d", strtotime($model->to_date));
        }
        if ($model->save()) {
            // inserting to audit log
            AuditLog::saveAuditLogs(
                'CUSTOMERS',
                Yii::app()->user->id,
                $docs_type,
                " Document with ID - {$model->id}"
            );
            // end audit log
            $jsonData['status'] = 'success';
            $jsonData['frm'] = $_POST['CustomerDocs'];
            $jsonData['id'] = $model->id;
            echo CJSON::encode($jsonData);
        } else {
            $error = CActiveForm::validate($model, '', false);
            if ($error != '[]')
                echo $error;
        }
    }

    public function actionDeleteShippingItem()
    {
        $id = $_POST['id'];
        if ($id > 0) {
            CustomerShippingDetails::model()->deleteByPk($id);
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        }
    }

    public function actionDownloadDocument()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $arr_employee_doc = CustomerDocs::model()->findByPk($id);
        $file = $arr_employee_doc->document;
        $arr_doc_val = explode(',', $arr_employee_doc->document);
        $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $file;
        header("Content-type:application/octet-stream"); //for txt file
        header("Content-Type: application/download");
        //header('Content-Type:text/plain; charset=ISO-8859-15');
        //if you want to read text file using text/plain header
        header('Content-Disposition: attachment; filename="' . basename($path) . '"');
        header('Content-Length: ' . filesize($path));
        readfile($path);
        Yii::app()->end();
    }

    /*
     * function to create customer details for autocomplete in lead
     * modified by jisha on 17-9-18.
     */

    public function actionGetCustomerDetails()
    {
        $from = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition = 'customer_name LIKE "%' . $searchTerm . '%" AND t.isActive="Y"';
        // if(User::isSalesman()=='Y'){
        //     $condition.=" AND t.lead_owner_id=".Yii::app()->user->id;
        // }
        $model = new Customer();
        $model = $model->with('currency_detail', 'country', 'paymentmethod')->findAll(array(
            'select' => 't.lead_owner_id,t.id,t.customer_name,customer_currency_id,customer_payment_term,customer_address,
            customer_city,customer_postal_code,customer_country,t.customer_location,t.customer_emirates_name, customer_state',
            'condition' => $condition,
            'limit' => 200
        ));
        $i = 0;
        $data = array();
        foreach ($model as $eachModel) {
            $modDocuments = CustomerDocs::model()->with('doctype')->findAll(array('condition' => 'customer_id=' . $eachModel->id . ' AND to_date<="' . date('Y-m-d') . '"'));
            $modshipaddress = CustomerShippingDetails::model()->find(array('condition' => 'customer_id=' . $eachModel->id));
            $data[$i]['value'] = $eachModel->id;
            $location = "";
            if (!empty($eachModel->customer_location)) {
                $location = " [" . $eachModel->customer_location . " ]";
            }
            $data[$i]['customername'] = $eachModel->customer_name;
            $data[$i]['label'] = $eachModel->customer_name . "" . $location;
            $billing_address = '';
            //            if($eachModel->customer_address!=''){
//                $billing_address.=$eachModel->customer_address;
//                $billing_address.="\r\n";
//            }
            if (!empty($eachModel->customer_city)) {
                $billing_address .= $eachModel->customer_city . ", ";
            }
            if ($eachModel->customer_postal_code != '') {
                $billing_address .= 'P.O Box : ' . $eachModel->customer_postal_code;
            }
            $billing_address .= "\r\n";

            if (!empty($eachModel->customer_state)) {
                $billing_address .= $eachModel->customer_state . " - " . $eachModel->country->country_name;
            } else {
                $billing_address .= $eachModel->country->country_name;
            }
            $arr_doc = array();
            $doc_msg = '';
            if (!empty($modDocuments)) {
                foreach ($modDocuments as $each) {
                    $arr_doc[] = $each->doctype->document_type . ' is Expired.<br/>';
                }
                $doc_msg = implode(',', $arr_doc);
            }
            $data[$i]['msg'] = $doc_msg;
            $data[$i]['billaddress'] = $billing_address;
            $data[$i]['shipaddress'] = $modshipaddress->street_address . ", PO Box : " . $modshipaddress->postal_code . "," . $modshipaddress->city . "," . $modshipaddress->country->country_name;
            $data[$i]['currency'] = $eachModel->currency_detail->currency;
            $data[$i]['currency_id'] = $eachModel->currency_detail->id;
            $data[$i]['exchangerate'] = $eachModel->currency_detail->exchange_rate;
            $data[$i]['payment_term'] = $eachModel->customer_payment_term;
            $data[$i]['countryid'] = $eachModel->customer_country;
            $data[$i]['emiratesname'] = $eachModel->customer_emirates_name;
            $data[$i]['contact_id'] = $eachModel->lead_owner_id; //To assign leadowner taking contact
            $data[$i]['other'] = $eachModel->paymentmethod->payment_terms;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionCheckTrnExistance()
    {
        $terms = $_POST['trn_no'];
        $term = ltrim($terms);
        $status = array();
        if ($term != '') {
            $store = Customer::model()->findAll(array('condition' => 'customer_trn_no = "' . $term . '"'));
            if (!empty($store)) {
                $status['status'] = 'exist';
            } else {
                $status['status'] = 'not_exist';
            }
        }
        echo CJSON::encode($status);
    }

    public function actionGetCustomerContactdetails()
    {
        $customer_id = Yii::app()->request->getparam("id");
        $modelName = Yii::app()->request->getparam("modelName");
        $columnWidth = Yii::app()->request->getparam("columnWidth");
        $models = CustomerContact::getCustomerContacts($customer_id);
        $drop = '<li class="col-sm-' . $columnWidth . '">';
        $model = new $modelName;
        $drop .= CHtml::activedropDownList($model, 'contact_id', $models, array('class' => 'tooltipster', 'title' => 'Please Select Contact', 'data-label' => 'Contact <span style="color:red">*</span>', 'data-search' => true));
        $drop .= '</li>';
        $status = array("dt" => $drop);
        echo CJSON::encode($status);
    }

    //info button details
    public function actioninfo()
    {
        $this->render('info', $_GET);
    }

    public function actionDeleteDocument()
    {
        $id = $_POST['id'];
        $modelDocument = new CustomerDocs();
        $model_doc = CustomerDocs::model()->findbyPK($id);
        $document_details = explode(',', $model_doc->document);
        foreach ($document_details as $value) {
            $path = Yii::getPathOfAlias('webroot') . "/uploads/documents/" . $value;
            unlink($path);
        }
        $modelDocument->deleteByPk($id);
        echo "success";
    }

    public function actionGetcustomerorders()
    {
        $customer_id = $_POST['customer_id'];
        $model_orders = Order::model()->findAll(array('condition' => 'customer_id=' . (int) $customer_id));
        $arr_orders = CHtml::listData($model_orders, 'id', 'id');
        $drop = '<div class="material"> ';
        $drop .= CHtml::dropDownList('ordhis_order_id', '', $arr_orders, array('class' => 'tooltipster', 'data-label' => 'Order <span style="color:red;"> *</span>', 'empty' => '-Select-', 'data-search' => 'true'));
        $drop .= '</div>';
        echo $drop;
    }

    public function actionChecksubledger()
    {
        //     $customers=Customer::model()->findAll(array('condition'=>'id>10900 AND id<=11500'));
        foreach ($customers as $each) {
            $model = Customer::model()->findByPk($each->id);
            $model->saveSublegder();
        }
    }

    public function actionCheckIndustry()
    {
        $industry = FinanceSubledger::model()->findAll(array('condition' => 'subledger_type_id=1 AND industry=0'));
        foreach ($industry as $each) {
            if ($each->parent_id > 0) {
                $model = Customer::model()->findByPk($each->parent_id);
                if ($model->id > 0) {
                    $model->saveSublegder();
                }
            }
        }
    }

    /*
     * function to delete customer contact
     */

    /* public function actionDeleteContact() {
      $id = $_POST['id'];
      $model = new CustomerContact();
      $model->deleteByPk($id);
      echo "success";
      } */

    /*
     * function to delete customer
     */

    /* public function actionDeleteCustomer() {
      $id = $_POST['id'];
      $model = Customer::model()->findByPk($id);
      if (!empty($model)) {
      $model->isActive = "N";
      $model->save(false);
      echo "success";
      } else {
      echo "fail";
      }
      } */



    /*
      public function actionGetContact() {
      $from = $_GET['frm'];
      $searchTerm = $_GET['term'];
      $condition = 'person_name LIKE "%' . $searchTerm . '%" AND t.isActive="Y"';
      $model = new CustomerContact();
      $model = $model->findAll(array('select' => 't.id,t.person_name,designation,customer_id', 'condition' => $condition));
      $i = 0;
      foreach ($model as $eachModel) {
      $data[$i]['label'] = $eachModel->person_name;
      $data[$i]['value'] = $eachModel->id;
      $data[$i]['customer_id'] = $eachModel->customer_id;

      $data[$i]['designation'] = $eachModel->designation;
      $i++;
      }
      echo CJSON::encode($data);
      Yii::app()->end();
      }

      public function actionGetCustomers() {
      $from = $_GET['frm'];
      $searchTerm = $_GET['term'];
      $condition = 'customer_name LIKE "%' . $searchTerm . '%"';
      $model = new Customer();
      $model = $model->with('currency_detail', 'country')->findAll(array('select' => 't.id,t.customer_name,customer_currency_id,customer_payment_term,customer_address,
      customer_city,customer_postal_code,customer_country', 'condition' => $condition));
      $i = 0;
      foreach ($model as $eachModel) {
      $data[$i]['value'] = $eachModel->id;
      $customer_location = ucfirst(trim($eachModel->customer_location));
      $customer_name = $eachModel->customer_name;
      if(!empty($customer_location)){
      $customer_name = $eachModel->customer_name."[".$customer_location."]";
      }

      $data[$i]['label'] = $customer_name;
      $data[$i]['address'] = $eachModel->customer_address . ", PO Box : " . $eachModel->customer_postal_code . "," . $eachModel->customer_city . "," . $eachModel->country->country_name;
      $data[$i]['currency'] = $eachModel->currency_detail->currency;
      $data[$i]['currency_id'] = $eachModel->currency_detail->id;
      $data[$i]['exchangerate'] = $eachModel->currency_detail->exchange_rate;
      $data[$i]['payment_term'] = $eachModel->customer_payment_term;
      $i++;
      }
      echo CJSON::encode($data);
      Yii::app()->end();
      }

      public function actionGetCustomerActivity() {
      $contact_id = $_POST['contact_id'];
      $customer_id = $_POST['customer_id'];
      $file_id = $_POST['file_id'];
      if ($contact_id != '' && $file_id != '') {
      $model = Activity::model()->findAll(array('condition' => 'contact_id="' . $contact_id . '" and file_id=' . $file_id, 'order' => 'id desc'));
      } else if ($contact_id == '' && $file_id != '') {
      $model = Activity::model()->findAll(array('condition' => 'file_id=' . $file_id, 'order' => 'id desc'));
      } else if ($contact_id != '' && $file_id == '') {
      $model = Activity::model()->findAll(array('condition' => 'contact_id=' . $contact_id, 'order' => 'id desc'));
      } else if ($contact_id == '' && $file_id == '') {
      $model = Activity::model()->findAll(array('condition' => 'customer_id="' . $customer_id . '"', 'order' => 'id desc'));
      }
      $this->render('//activity/activity_history_new', array('model' => $model, 'contact_id' => $contact_id));
      }

      public function actionSetMenu() {
      echo Yii::app()->session['selected_menu'] = $_POST['menu_name'];
      }


     */

    public function actionDeleteBuildingUnit()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $unitModels = new MasBuildingUnit();
        $unitModels = $unitModels->findbyPK($id);
        $unitModels->isActive = 'N';
        if ($unitModels->save(false)) {
            $jsonData['status'] = 'success';
        } else {
            $jsonData['status'] = 'fail';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionUploadCustomerDocument()
    {
        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $folder = Yii::getPathOfAlias('webroot') . '/' . $_GET['folder'] . '/'; // target folder
        $allowedExtensions = array("jpg", "png", "doc", "docx", "xls", "xlsx", "pdf", "bmp", "jpeg");
        $sizeLimit = 1 * 1024 * 1024; // 1MB limit

        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);

        if ($result['success']) {
            $originalFile = $result['filename'];
            $extension = pathinfo($originalFile, PATHINFO_EXTENSION);
            $datePrefix = date('Y-m-d') . '-';

            $newFileName = $datePrefix . $originalFile;
            $oldPath = $folder . $originalFile;
            $newPath = $folder . $newFileName;

            if (file_exists($oldPath)) {
                rename($oldPath, $newPath);
            }

            $result['filename'] = $newFileName;
            $result['fileType'] = strtolower($extension);
        }

        echo htmlspecialchars(json_encode($result), ENT_NOQUOTES);
    }

    // csv bulk upload section
    public function actionUploadcustomer()
    {
        //added by nisha on 28-02-2023
        $model = new Customer();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_customer', array('model' => $model), false, true);
    }
    public function actionSaveCustomerUploadCsv()
    {
        $file_name = Yii::app()->request->getParam('filename');
        $batch = (int) Yii::app()->request->getParam('batch', 1);
        $url = Yii::app()->basePath . '/../uploads/customer_csv/' . $file_name;
        $mas_customer_list = $this->readCustomerCSV($url);
        $error_url = Yii::app()->basePath . '/../uploads/customer_csv/error/' . $file_name;
        $error_list = [];
        $error_occurred = false;
        $batch_size = 200;
        $success_count = 0;
        $error_count = 0;
        $non_empty_row_count = 0;
        $existing_count = 0;

        if (!empty($mas_customer_list)) {
            $header = array_shift($mas_customer_list); // Remove header row
        }

        $total_records = count($mas_customer_list);
        $start_index = ($batch - 1) * $batch_size;
        $batch_data = array_slice($mas_customer_list, $start_index, $batch_size);

        // Validate full file for errors
        foreach ($mas_customer_list as $index => $data) {
            if (!empty($data)) {
                $line_number = $index + 2; // Adjust for header
                $log_remarks = [];
                if ($batch == 1) {
                    $log_remarks = $this->validateCustomerRow($data, $log_remarks); // Your own validation method
                }

                if (empty($log_remarks)) {
                    $error_list[$line_number] = [
                        'customer_name' => $data[0],
                        'customer_phone_no' => $data[1],
                        'customer_email_id' => $data[2],
                        'customer_web' => $data[3],
                        'location_id' => $data[4],
                        'customer_trn_no' => $data[5],
                        'customer_address' => $data[6],
                        'customer_city' => $data[7],
                        'customer_postal_code' => $data[8],
                        'customer_country' => $data[9],
                        'customer_currency_id' => $data[10],
                        'customer_payment_term' => $data[11],
                        'remarks' => $data[12],
                        'credit_limit' => $data[13],
                        'contact_person' => $data[14],
                        'contact_person_mobile' => $data[15],
                        'contact_person_phone' => $data[16],
                        'contact_person_designation' => $data[17],
                        'contact_person_department' => $data[18],
                        'contact_person_email' => $data[19],
                        'log_remarks' => ''
                    ];
                } else {
                    $error_occurred = true;
                    $error_count++;
                    $error_list[$line_number] = [
                        'customer_name' => $data[0],
                        'customer_phone_no' => $data[1],
                        'customer_email_id' => $data[2],
                        'customer_web' => $data[3],
                        'location_id' => $data[4],
                        'customer_trn_no' => $data[5],
                        'customer_address' => $data[6],
                        'customer_city' => $data[7],
                        'customer_postal_code' => $data[8],
                        'customer_country' => $data[9],
                        'customer_currency_id' => $data[10],
                        'customer_payment_term' => $data[11],
                        'remarks' => $data[12],
                        'credit_limit' => $data[13],
                        'contact_person' => $data[14],
                        'contact_person_mobile' => $data[15],
                        'contact_person_phone' => $data[16],
                        'contact_person_designation' => $data[17],
                        'contact_person_department' => $data[18],
                        'contact_person_email' => $data[19],
                        'log_remarks' => implode(" | ", $log_remarks)
                    ];
                }
            }
        }

        if ($error_occurred) {
            $error_directory = Yii::app()->basePath . '/../uploads/customer_csv/error/';
            if (!is_dir($error_directory)) {
                mkdir($error_directory, 0777, true);
            }

            $file_error = fopen($error_url, "w+");
            $headers = ['Customer Name', 'Phone No', 'Email', 'Website', 'Location', 'TRN No.', 'Address.', 'City', 'P.O Box', 'Country Code', 'Currency', 'Payment Terms', 'Remarks', 'Credit Limit', 'Contact Person', 'Contact Person Mobile', 'Contact Person Phone', 'Designation', 'Department', 'Contact Person Email', 'Log Remarks'];
            fputcsv($file_error, $headers);

            foreach ($error_list as $err) {
                $line = [
                    $err['customer_name'],
                    $err['customer_phone_no'],
                    $err['customer_email_id'],
                    $err['customer_web'],
                    $err['location_id'],
                    $err['customer_trn_no'],
                    $err['address'],
                    $err['customer_city'],
                    $err['customer_postal_code'],
                    $err['customer_country'],
                    $err['customer_currency_id'],
                    $err['customer_payment_term'],
                    $err['remarks'],
                    $err['credit_limit'],
                    $err['contact_person'],
                    $err['contact_person_mobile'],
                    $err['contact_person_phone'],
                    $err['contact_person_designation'],
                    $err['contact_person_department'],
                    $err['contact_person_email'],
                    $err['log_remarks']
                ];
                fputcsv($file_error, $line);
            }

            fclose($file_error);

            echo json_encode([
                'error_url' => $error_url,
                'filename' => $file_name,
                'success_count' => $success_count,
                'error_count' => $error_count,
                'link' => CHtml::link('Download Log', ['customer/DownloadErrorCsv', 'id' => $file_name], [
                    'target' => '_blank',
                    'style' => 'display: inline-block; border: 2px solid #ff4d4f; padding: 5px 15px; font-size: 12px; font-weight: bold; background: #ff4d4f; color: #fff; text-decoration: none;'
                ]) . '<div style="font-size: 12px; font-weight: bold; color: #ff4d4f; margin-top: 10px;">Data updation failed. Please see this file.</div>'
            ]);
            return;
        }

        foreach ($batch_data as $index => $data) {
            if (!empty($data)) {
                $non_empty_row_count++;
                $line_number = $start_index + $index + 2;

                $customer = new Customer();
                $CustomerShippingDetails = new CustomerShippingDetails();
                $modelcontact = new CustomerContact();



                $customer_name = $this->sanitizeData($data[0]);
                $phone_no = isset($data[1]) ? $this->sanitizeNumber($data[1]) : '';
                $email = isset($data[2]) ? $this->sanitizeData($data[2]) : '';
                $website = trim($data[3]);
                $location = isset($data[4]) ? $this->sanitizeData($data[4]) : '';
                $trn_no = isset($data[5]) ? $this->sanitizeNumber($data[5]) : '';
                $address = isset($data[6]) ? $this->sanitizeData($data[6]) : '';
                $city = isset($data[7]) ? $this->sanitizeData($data[7]) : '';
                $postal_code = isset($data[8]) ? $this->sanitizeNumber($data[8]) : '';
                $country = isset($data[9]) ? $this->sanitizeData($data[9]) : '';
                $currency = isset($data[10]) ? $this->sanitizeData($data[10]) : '';
                $payment_terms = isset($data[11]) ? $this->sanitizeData($data[11]) : '';
                $remarks = isset($data[12]) ? $this->sanitizeData($data[12]) : '';
                $credit_limit = isset($data[13]) ? $this->sanitizeNumber($data[13]) : '';
                $contact_person = isset($data[14]) ? $this->sanitizeData($data[14]) : '';
                $contact_person_mobile = isset($data[15]) ? $this->sanitizeNumber($data[15]) : '';
                $contact_person_phone = isset($data[16]) ? $this->sanitizeNumber($data[16]) : '';
                $contact_person_designation = isset($data[17]) ? $this->sanitizeData($data[17]) : '';
                $contact_person_department = isset($data[18]) ? $this->sanitizeData($data[18]) : '';
                $contact_person_email = isset($data[19]) ? $this->sanitizeData($data[19]) : '';



                //to fetch the country details

                $country_exist = MasCountry::model()->find(
                    'LOWER(country_name) = :country OR LOWER(country_code) = :country',
                    [':country' => strtolower($country)]
                );

                if (!empty($country_exist)) {
                    $country_id = $country_exist->id;
                }
                // var_dump($country);
                // die();
                // to fetch the currency_details

                $currency_exist = MasCurrency::model()->find(
                    'LOWER(currency_code) = :currency_code',
                    [':currency_code' => strtolower($currency)]
                );
                if (!empty($currency_exist)) {
                    $currency_id = $currency_exist->id;
                }
                // var_dump($currency_id);
                // die();
                // to fetch pyament Term
                $payment_exist = MasPaymentTerm::model()->find(
                    'LOWER(payment_code) = :payment_code OR LOWER(payment_terms) = :payment_code',
                    [':payment_code' => strtolower($payment_terms)]
                );
                if (!empty($payment_exist)) {
                    $payment_id = $payment_exist->id;
                }

                $customer->created_by = Yii::app()->user->id;
                $customer->updated_by = Yii::app()->user->id;
                $customer->created_date_time = date('Y-m-d H:i:s');
                $customer->updated_date_time = date('Y-m-d H:i:s');

                $customer->customer_name = ucfirst(strtolower($customer_name));
                $customer->customer_phone_no = $phone_no;
                $customer->customer_email_id = $email;
                $customer->customer_web = $website;
                $customer->location_id = $location;
                $customer->customer_trn_no = $trn_no;
                $customer->customer_address = $address;
                $customer->customer_city = $city;
                $customer->customer_postal_code = $postal_code;
                $customer->customer_country = $country_id;
                $customer->customer_currency_id = $currency_id;
                $customer->customer_remarks = $remarks;
                $customer->customer_credit_limit = $credit_limit;
                $customer->customer_payment_term = $payment_id;
                $customer->default_pricing_group_id = 0;
                $customer->lead_owner_id = Yii::app()->user->id;
                // $customer->contact_person = $this->sanitizeData($data[12]);

                if ($this->isTypeNameExists($customer->customer_name)) {
                    $existing_count++;
                    continue;
                }

                if ($customer->save()) {
                    $CustomerShippingDetails->customer_id = $customer->id;
                    $CustomerShippingDetails->country_id = $customer->customer_country;
                    if ($CustomerShippingDetails->save(false)) {
                        $errors = $CustomerShippingDetails->getErrors();
                        foreach ($errors as $field => $messages) {
                            foreach ($messages as $message) {
                                echo 'CustomerShippingDetails-' . $message . '<br>';
                            }
                        }
                    }

                    $modelcontact->person_name = (!empty($contact_person)) ? $contact_person : 'Sales / Accounts';
                    $modelcontact->customer_id = $customer->id;
                    $modelcontact->designation = $contact_person_designation;
                    $modelcontact->contact_phone_no = $contact_person_phone;
                    $modelcontact->department = $contact_person_department;
                    $modelcontact->contact_mobile_no = $contact_person_mobile;
                    $modelcontact->contact_email_id = $contact_person_email;
                    $modelcontact->created_by = Yii::app()->user->id;
                    $modelcontact->updated_by = Yii::app()->user->id;
                    $modelcontact->created_date_time = date('Y-m-d H:i:s');
                    $modelcontact->updated_date_time = date('Y-m-d H:i:s');
                    $modelcontact->isActive = 'Y';
                    if ($modelcontact->save(false)) {
                        $errors = $modelcontact->getErrors();
                        foreach ($errors as $field => $messages) {
                            foreach ($messages as $message) {
                                echo 'modelcontact-' . $message . '<br>';
                            }
                        }
                    }

                    $success_count++;
                } else {
                    $errors = $customer->getErrors();
                    foreach ($errors as $field => $messages) {
                        foreach ($messages as $message) {
                            echo 'customer-' . $message . '<br>';
                        }
                    }
                }
            }
        }

        if ($start_index + $batch_size < $total_records) {
            $next_batch = $batch + 1;
            echo json_encode([
                'status' => 'success',
                'message' => '',
                'flag' => 'continue',
                'next_button' => '<a href="javascript:void(0);" id="next-batch-btn" data-url="' . Yii::app()->createUrl('customer/SaveCustomerUploadCsv', ['filename' => $file_name, 'batch' => $next_batch]) . '" style="display: inline-block; border: 2px solid #000080; padding: 5px 15px; font-size: 12px; font-weight: bold; background: #000080; color: #fff; text-decoration: none;">Upload Next ' . $batch_size . '</a>',
                'total_records' => $total_records,
                'success_count' => $success_count,
                'error_count' => $error_count,
                'non_empty_row_count' => $non_empty_row_count,
                'existing_count' => $existing_count,
            ]);
        } else {
            echo json_encode([
                'status' => 'success',
                'message' => '',
                'total_records' => $total_records,
                'success_count' => $success_count,
                'error_count' => $error_count,
                'non_empty_row_count' => $non_empty_row_count,
                'existing_count' => $existing_count,
            ]);
        }
    }

    public function actionDownloadSampleCsv()
    {
        $filename = 'customerlisttemplate.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Customer Name ,Phone No, Email, Website, Location, TRN No. ,Address , City, P.O Box, Country Code, Currency, Payment Terms, Remarks, Credit Limit, Contact Person, Contact Person Mobile, Contact Person Phone, Designation,Department,Contact Person Email';
        Yii::app()->end();
    }
    public function readCustomerCSV($csvFile)
    {
        if (!file_exists($csvFile)) {
            throw new Exception("File not found: $csvFile");
        }

        $file_handle = fopen($csvFile, 'r');
        $line_of_text = [];
        while (($contents = fgetcsv($file_handle, 1024, ',')) !== false) {
            $line_of_text[] = $contents;
        }
        fclose($file_handle);

        return $line_of_text;
    }
    public function actionDownloadErrorCsv()
    {
        $file_name = $event_id = Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../uploads/customer_csv/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }
    private function sanitizeData($data)
    {
        return !empty($data) ? trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data), '"') : '';
    }

    private function sanitizeNumber($data)
    {
        $sanitizedData = str_replace(',', '', trim($data));
        return is_numeric($sanitizedData) ? (float) $sanitizedData : 0.0;
    }
    private function validateCustomerRow($data, &$log_remarks)
    {
        $log_remarks = [];

        $customer_name = $this->sanitizeData($data[0]);
        $phone_no = isset($data[1]) ? $this->sanitizeNumber($data[1]) : '';
        $email = isset($data[2]) ? $this->sanitizeData($data[2]) : '';
        $website = $data[3];
        $location = isset($data[4]) ? $this->sanitizeData($data[4]) : '';
        $trn_no = isset($data[5]) ? $this->sanitizeNumber($data[5]) : '';
        $address = isset($data[6]) ? $this->sanitizeData($data[6]) : '';
        $city = isset($data[7]) ? $this->sanitizeData($data[7]) : '';
        $postal_code = isset($data[8]) ? $this->sanitizeNumber($data[8]) : '';
        $country = isset($data[9]) ? $this->sanitizeData($data[9]) : '';
        $currency = isset($data[10]) ? $this->sanitizeData($data[10]) : '';
        $payment_terms = isset($data[11]) ? $this->sanitizeData($data[11]) : '';
        $remarks = isset($data[12]) ? $this->sanitizeData($data[12]) : '';
        $credit_limit = isset($data[13]) ? $this->sanitizeNumber($data[13]) : '';
        $contact_person = isset($data[14]) ? $this->sanitizeData($data[14]) : '';


        $contact_person_mobile = isset($data[15]) ? $this->sanitizeNumber($data[15]) : '';
        $contact_person_phone = isset($data[16]) ? $this->sanitizeNumber($data[16]) : '';
        $contact_person_designation = isset($data[17]) ? $this->sanitizeData($data[17]) : '';
        $contact_person_department = isset($data[18]) ? $this->sanitizeData($data[18]) : '';
        $contact_person_email = isset($data[19]) ? $this->sanitizeData($data[19]) : '';


        // Validations
        if (empty($customer_name)) {
            $log_remarks[] = "Customer Name is required.";
        }

        if (empty($phone_no)) {
            $log_remarks[] = "Phone Number is required.";
        }

        if (!empty($email) && !filter_var($email, FILTER_VALIDATE_EMAIL)) {
            $log_remarks[] = "Invalid Email format.";
        }
        if (empty($country)) {
            $log_remarks[] = "Country is required.";
        } else {

            $country_exist = MasCountry::model()->find(
                'LOWER(country_name) = :country OR LOWER(country_code) = :country',
                [':country' => strtolower($country)]
            );
            if (empty($country_exist)) {
                $log_remarks[] = "Invalid Country Code.";
            }
        }

        if (empty($currency)) {
            $log_remarks[] = "Currency is required.";
        } else {
            $currency_exist = MasCurrency::model()->findAll(
                'LOWER(currency_code) = :currency_code',
                [':currency_code' => strtolower($currency)]
            );
            if (empty($currency_exist)) {
                $log_remarks[] = "Currency is Not Exist.";
            }
        }

        if (empty($payment_terms)) {
            $log_remarks[] = "Payment Terms is required.";
        } else {
            $payment_exist = MasPaymentTerm::model()->findAll(
                'LOWER(payment_code) = :payment_code OR LOWER(payment_terms) = :payment_code',
                [':payment_code' => strtolower($payment_terms)]
            );
            if (empty($payment_exist)) {
                $log_remarks[] = "Payment Term is Not Exist.";
            }
        }



        return $log_remarks;
    }


    private function isTypeNameExists($code)
    {
        $code = strtolower(trim($code));
        return Customer::model()->exists('LOWER(TRIM(customer_name)) = :code', [':code' => $code]);
    }

    public function actionUploadCustomerCsv($folder = null)
    {
        Yii::import("ext.EAjaxUpload.qqFileUploader");

        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';

        // Check if directory exists or create it
        if (!is_dir($folder)) {
            mkdir($folder, 0777, true);
        }

        // Define allowed extensions and size limit
        $allowedExtensions = array();
        $sizeLimit = 2 * 1024 * 1024; // 2MB

        // Handle file upload
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);

        // Return JSON response
        echo htmlspecialchars(json_encode($result), ENT_NOQUOTES);
    }
}
