<?php

class CreditnoteController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetCreditNoteList', 'Create', 'DeleteNotes', 'GetNotesList', 'UploadDocuments',
                    'GetDocumentList', 'DeleteDocument', 'GetDeliveryList', 'createInvoice', 'SetFile', 'GetFileDetails',
                    'GetFiles', 'Getfileno', 'FetchDeliveryNotes', 'SaveMultipleDeliveryInvoice', 'CreateReceipt', 'SaveReceipt', 'EditReceipt',
                    'GetDescription', 'SaveCreditNote', 'PrintFile', 'AddQuantityDetails', 'GetFactor', 'GetCheckingList', 'ReturnItems', 'PostCreditNote',
                    'GetinvoiceDetails','GetsalesreturnDetails',
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex()
{
    $frm = (int) Yii::app()->request->getParam('frm');

    if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['sales_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['credit_view']) &&
            Yii::app()->user->havePermissionOn['sales_menu_view'] && 
            Yii::app()->user->havePermissionOn['credit_view']
        )
    ) {
        $this->render('index', array('frm' => $frm));
    } else {
        $this->layout = false;
        $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
}

    public function actionGetFileDetails($file_id, $needed_model) {

        $masterFile = MasterFile::model()->with($needed_model)->findByPK($file_id);
        $jsonData['file'] = $masterFile;
        $jsonData[$needed_model] = $masterFile->{$needed_model};
        $jsonData['salesgroup'] = MasSalesGroup::model()->findByPK($jsonData[$needed_model]->sales_group);
        $jsonData['currency'] = MasCurrency::model()->findByPK($jsonData[$needed_model]->currency);
        $jsonData['paymenttermdetails'] = MasPaymentTerm::model()->findByPK($jsonData[$needed_model]->payment_terms);
        $jsonData['payemntterm'] = $jsonData['paymenttermdetails']->payment_code . ':' . $jsonData['paymenttermdetails']->payment_terms;
        return $jsonData;
    }

    public function actionGetFiles($status = array(), $options = array()) {
        $data_array = array();
        if (isset($_GET['term'])) {
            $condition = 'isActive="Y" AND current_process_status in ("' . implode('","', $status) . '") AND (	file_title like "%' . $_GET['term'] . '%" or id like "%' . $_GET['term'] . '%")';
            if (!empty($options)) {
                foreach ($options as $column => $column_val) {
                    $condition .= ' AND ' . $column . '="' . $column_val . '"';
                }
            }
            $model = MasterFile::model()->findAll(array('condition' => $condition, 'order' => 'id DESC'));
            $i = 0;
            foreach ($model as $eachModel) {
                $data_array[$i]['value'] = $eachModel->id;
                $data_array[$i]['label'] = $eachModel->id . ':' . $eachModel->file_title;
                $i++;
            }
        }
        echo CJSON::encode($data_array);
        Yii::app()->end();
    }

    public function actionCreate() {
        
        $model = new Creditnote();
        $modelAdd = array(new CreditnoteAddition());
        $modelDed = array(new CreditnoteDeduction());
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model, 'modelAdd' => $modelAdd, 'modelDed' => $modelDed));
    }

    public function actioncreateInvoice() {
        $model = new Invoice();
        $id = (int) Yii::app()->request->getParam('id');
        $delivery_id = (int) Yii::app()->request->getParam('delivery_id');
        $file_id = (int) Yii::app()->request->getParam('file_id');

        $modelItems = array(new InvoiceItem);
        if ($id > 0) {
            $model = $model->findByPk($id);
            $modelOrderItems = InvoiceItem::model()->findAll(array('condition' => 'invoice_id="' . $id . '"'));
            if (empty($modelOrderItems)) {
                $modelOrderItems = array(new InvoiceItem);
            }
        }
        if ($delivery_id > 0) {
            $modelorder = DeliveryNote::model()->findByPK($delivery_id);
            $model->file_id = $modelorder->file_id;
            $model->company_id = $modelorder->company_id;
            $model->order_id = $modelorder->order_id;
            $model->delivery_ids = $modelorder->id;
            $model->billing_address = $modelorder->billing_address;
            $model->shipping_address = $modelorder->shipping_address;
            $model->contact_id = $modelorder->contact_id;
            $model->sales_group = $modelorder->order->sales_group;
            $model->notes = $modelorder->notes;
            $model->terms_and_conditions = $modelorder->terms_and_conditions;
            $model->lpo = $modelorder->lpo;
            $model->others = $modelorder->others;
            $model->currency = $modelorder->order->currency;
            $model->exchange_rate = $modelorder->order->exchange_rate;
            $model->payment_terms = $modelorder->order->payment_terms;
            $model->remarks = $modelorder->remarks;
            $model->terms_and_conditions = $modelorder->terms_and_conditions;
            $modelItems = DeliveryNoteItem::model()->findAll(array('condition' => 'delivery_note_id=' . $modelorder->id));
            foreach ($modelItems as $i => $eachItem) {
                if ($eachItem->picked_qty > 0) {
                    $orderItems = OrderItem::model()->find(array('condition' => 'order_id=' . $modelorder->order_id . ' AND product_id=' . $eachItem->product_id));
                    $modelInvoiceItems[$i] = new InvoiceItem;
                    $modelInvoiceItems[$i]->product_id = $eachItem->product_id;
                    $modelInvoiceItems[$i]->description = $eachItem->description;
                    $modelInvoiceItems[$i]->quantity = $eachItem->picked_qty;
                    $modelInvoiceItems[$i]->rate = $orderItems->rate;
                    $modelInvoiceItems[$i]->tax_vat_percentage = $eachItem->tax_vat_percentage;
                    $modelInvoiceItems[$i]->tax_vat_amount = $eachItem->tax_vat_amount;
                    $modelInvoiceItems[$i]->amount = $eachItem->picked_qty * $orderItems->rate;
                    $modelInvoiceItems[$i]->addition_percentage = $orderItems->addition_percentage;
                    $modelInvoiceItems[$i]->addition_amount = $orderItems->addition_amount;
                    $modelInvoiceItems[$i]->deduction_percentage = $orderItems->deduction_percentage;
                    $modelInvoiceItems[$i]->deduction_amount = $orderItems->deduction_amount;
                    $modelInvoiceItems[$i]->net_amount = ($eachItem->picked_qty * $orderItems->rate) + $orderItems->addition_amount - $orderItems->deduction_amount;
                }
            }
            $modelAdd = OrderAddition::model()->findAll(array('condition' => 'order_id=' . $modelorder->id));
            if (empty($modelAdd)) {
                $modelAdd = array(new OrderAddition);
            }
            $modelDed = OrderDeduction::model()->findAll(array('condition' => 'order_id=' . $modelorder->id));
            if (empty($modelDed)) {
                $modelDed = array(new OrderDeduction);
            }
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('create', array('model' => $model, 'file_id' => $model->file_id,
            'modelInvoiceItems' => $modelInvoiceItems, 'modelAdd' => $modelAdd, 'modelDed' => $modelDed
        ));
    }

    public function actionSaveCreditNote() {
        
        
        $modelCreditNote = new Creditnote;
         $others = array();
         $valid=true;
        if (isset($_POST['Creditnote'])) {

            $modelCompanySettings = new MasCompanySettings();
            $condition = 'crm_company_id = ' . (int) Yii::app()->user->master_user_company_id;
            $modelCompanySettings = $modelCompanySettings->find(array('condition'=>$condition));    
            $stock_lock_flag =$modelCompanySettings->stock_lock_flag;
            if($stock_lock_flag=="N"){

            $modelCreditNote->scenario             = 'add';
            $modelCreditNote->scenario             = 'update';
            $modelCreditNote->attributes           = $_POST['Creditnote'];
            
          // $modelCreditNote->file_id = invoice id

            $invoice = Invoice::model()->findByPk($modelCreditNote->invoice_id);
            $modelCreditNote->file_id              = $invoice->file_id;
            $modelCreditNote->currency             = $invoice->currency_id;
            $modelCreditNote->exchange_rate        = $invoice->exchange_rate;
            $modelCreditNote->invoice_type         = $invoice->invoice_type;
            $modelCreditNote->customer_id          = $invoice->customer_id;
            $modelCreditNote->contact_id           = $invoice->contact_id;
            $modelCreditNote->created_datetime     = date('Y-m-d h:i:s');
         // $modelCreditNote->created_by           = $invoice->lead_owner_id;  
            $modelCreditNote->created_by           = $invoice->created_by; 
            $modelCreditNote->credited_date        = date('Y-m-d', strtotime( str_replace('/', '-', $_POST['Creditnote']['credited_date']) ));
            $modelCreditNote->crm_user_id          = $invoice->created_by;
            //$modelCreditNote->terms_and_conditions =  $_POST['terms_conditions'];
            $modelCreditNote->terms_and_conditions = $invoice->terms_and_conditions;
            $return_update                         = $_POST['Creditnote']['sales_return'];
            $modelCreditNote->sales_return         = $_POST['Creditnote']['sales_return'];
            $modelCreditNote->warehouse_id         = $invoice->warehouse_id;
            $other_errors = array();
            $grand_total = 0;
            $valid1 = true;
            $valid = true;
            $f=0;
             $StockLedger =new StockLedger();
             $StoreModel=new Store();
             $arr_product_UOM = new UnitOfMeasurement();
             $grand_total_for_paid = $total_vat_amount =0;
             
             
               //   ---------------------AccAuditClose check------------------------------------
            

                $credited_datex = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['Creditnote']['credited_date'])));
                
                $modelAccAuditClose = new AccAuditClose();
                $existing_date = strtotime($modelAccAuditClose->lastCloseddate());
                $credited_date = strtotime($credited_datex);
                if ($credited_date <= $existing_date) {
                $valid = false;
                $other_errors[] = ' Given Credited date must be Greater than Audit Close Date :-' .date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';
                
                } 
            //   --------------------//-AccAuditClose check------------------------------------
            
            
            foreach ($_POST['CreditnoteItem'] as $i => $item) {
                 if ($item['product_id']>0 && $item['returned_quantity']>0) {
                    $modelItem[$f] = new CreditnoteItem;
                    $modelItem[$f]->attributes         = $_POST['CreditnoteItem'][$i];
                    $modelItem[$f]->description        = $item['description'];
                    $modelItem[$f]->tax_vat_percentage = $_POST['CreditnoteItem'][$i]['tax_vat_percentage'];
                    $modelItem[$f]->tax_vat_amount     = $_POST['CreditnoteItem'][$i]['tax_vat_amount'];
                    $modelItem[$f]->unit               = $_POST['CreditnoteItem'][$i]['unit'];
                    //code added sarika on 15-09-2022
                    $StockLedger  =$StockLedger->find(array( 'condition' => 'product_id="' . $_POST['CreditnoteItem'][$i]['product_id'] . '" AND  file_id="'.$modelCreditNote->file_id.'"  AND unit_id="'.$_POST['CreditnoteItem'][$i]['unit'].'" '));
                    $old_cp_amt  =$StockLedger->cost_price*$_POST['CreditnoteItem'][$i]['returned_quantity'];
                    $query = "SELECT rate,quantity FROM view_all_stock_items WHERE id=".$_POST['CreditnoteItem'][$i]['product_id'];
                    $allocated_qty =$model = Yii::app()->db->createCommand($query)->queryRow();
                    $arr_product_UOM = $arr_product_UOM->findByPk($_POST['CreditnoteItem'][$i]['unit']);
                    $unit_factor_quantitiy=$allocated_qty['quantity']/$arr_product_UOM->factor;
                    $current_cp_amt=$allocated_qty['rate']*$unit_factor_quantitiy;
                    $total_quantity=$_POST['CreditnoteItem'][$i]['returned_quantity']+$unit_factor_quantitiy;
                    if($total_quantity>0){
                        $new_cp=($old_cp_amt+$current_cp_amt)/$total_quantity;
                    }
                      // echo '<pre>';print_r($new_cp);exit;
                    $StoreModel->updateByPk($_POST['CreditnoteItem'][$i]['product_id'], array('rate' => $new_cp));
                    //end code
                    // ----------------------------
                        $grand_total_for_paid += $item['net_amount'];
                        $total_vat_amount += $item['tax_vat_amount'];
                    // ----------------------------
                    $valid = $modelItem[$f]->validate() && $valid;
                    $f++;
                }
            }
            
          

            // ----------------03_02_2023----------------------------

            if($modelCreditNote->payment_type=='CC'){
                if((int) $_POST['Creditnote']['paid_cash_amount']==0){
                    $others[]='Cash amount should be grater than 0';
                    $valid=false;
                }
                elseif((int) $_POST['Creditnote']['paid_card_amount']==0){
                    $others[]='Card amount should be grater than 0';
                    $valid=false;
                }
                
            }
            
            
            
            if($modelCreditNote->payment_type=='BT' && (int) $_POST['Creditnote']['paid_amount']==0){
                     $others[]='Bank Transfer amount should be grater than 0';
                    $valid=false;
            }
            
            
            if($modelCreditNote->payment_type=='CA' && (int) $_POST['Creditnote']['paid_card_amount']==0){
                     $others[]='Card amount should be grater than 0';
                    $valid=false;
            }
            
            
            
            
            if($modelCreditNote->payment_type=='CH' && (int) $_POST['Creditnote']['paid_cash_amount']==0){
                    $others[]='Cash amount should be grater than 0';
                    $valid=false;
            }
            
            
            $paid_cash_amount                  = (float) trim($_POST['Creditnote']['paid_cash_amount']);
            $paid_card_amount                  = (float) trim($_POST['Creditnote']['paid_card_amount']);
            $paid_bank_transfer_amount         = (float) trim($_POST['Creditnote']['paid_amount']); 
            
            $total_paid_amount                 = (float)  number_format(($paid_cash_amount + $paid_card_amount+$paid_bank_transfer_amount),2,".",'');
            $modelCreditNote->paid_amount      = -1*($total_paid_amount);
            $modelCreditNote->paid_cash_amount = -1*($paid_cash_amount);
            $modelCreditNote->paid_card_amount = -1*($paid_card_amount);
            $total_invoice_amount              = (float)  number_format(($grand_total_for_paid+$total_vat_amount),2,".",'');
          

            /* if($total_paid_amount!=$total_invoice_amount){
                $others[]='Paid Amount should be equal to '.$total_invoice_amount;
                $valid=false;
            } */
            // --------------------------------------------
           /* if (is_array($_POST['CreditnoteAddition'])) {

                foreach ($_POST['CreditnoteAddition'] as $i => $item) {

                    $modelCreditNoteAddition[$i] = new CreditnoteAddition;

                    $modelCreditNoteAddition[$i]->attributes = $_POST['CreditnoteAddition'][$i];

                    $valid = $modelCreditNoteAddition[$i]->validate() && $valid;
                }
                $modelsToBeValidated[] = $modelCreditNoteAddition;
            }


            if (is_array($_POST['CreditnoteDeduction'])) {

                foreach ($_POST['CreditnoteDeduction'] as $i => $item) {

                    $modelCreditNoteDeduction[$i] = new CreditnoteDeduction;

                    $modelCreditNoteDeduction[$i]->attributes = $_POST['CreditnoteDeduction'][$i];

                    $valid = $modelCreditNoteDeduction[$i]->validate() && $valid;
                }
                $modelsToBeValidated[] = $modelCreditNoteDeduction;
            }*/

            $valid = $valid && is_array($modelItem);
            if ($modelCreditNote->validate() && $valid) { 
                
              
                // after validation saving the whole data 
               /* if (!empty($_POST['Icon']['actual_file'])) {
                    foreach ($_POST['Icon']['actual_file'] as $row) {

                        $modelDocument = new Document;
                        $modelDocument->uploaded_from = "I";
                        $modelDocument->file_id = $modelCreditNote->file_id;
                        $modelDocument->created_by = Yii::app()->user->id;
                        $modelDocument->created_datetime = date('Y-m-d h:i:s');
                        $modelDocument->document_name = $row;
                        $modelDocument->save(false);
                    }
                }*/
                $modelCreditNote->save();

                 // inserting to audit log
                 AuditLog::saveAuditLogs(
                    'HIRING_RETURN',
                    Yii::app()->user->id,
                    'CREATED',
                    " Checking No: - {$modelCreditNote->id}   "
                );
                // end audit log 
                
                $modelCreditNote->refresh();
                $jsonData['shoratage'] = "";
                $total_tax_amount = $grand_total = $commision_amount = 0;
                foreach ($modelItem as $eachItem) {
                    $eachItem->creditnote_id = $modelCreditNote->id;
                    $eachItem->save(false);
                    $grand_total += $eachItem->net_amount;
                    $total_tax_amount += $eachItem->tax_vat_amount;
                }
               /* foreach ($modelCreditNoteAddition as $eachModel) {

                    $eachModel->creditnote_id = $modelCreditNote->id;

                    $eachModel->save();

                    $grand_total += $eachModel->calculated_value;
                }
                foreach ($modelCreditNoteDeduction as $eachModel) {

                    $eachModel->creditnote_id = $modelCreditNote->id;

                    $eachModel->save();

                    $grand_total -= $eachModel->calculated_value;
                }*/
                foreach ($model_stock_item as $each_item) {
                    $each_item->material_receipt_id = $modelCreditNote->id;

                    if ($return_update == "ST") {
                        $each_item->save(false);
                        $this->updateInventoryStockMR2($each_item);
                    }
                }

                $grand_total += $total_tax_amount;
          // ----------------------------------------------------------------
             $commision_percentage = $modelCreditNote->commision_percentage;
             $commision_amount = -1*(($commision_percentage*($grand_total-$total_tax_amount))/100);
          // ---------------------------------------------------------------

                $modelCreditNote->updateByPk($modelCreditNote->id, array('credited_amount' => $grand_total, 'total_tax_amount' => $total_tax_amount,'commision_amount'=>$commision_amount));
                $model_mail_setting=Notification::model()->find(array('condition' => 'event_id="9"'));
                Yii::import('application.controllers.front.MasternotificationController'); 
                   if($model_mail_setting->mail_required=='Y'){                       
                    //    MasternotificationController::sendmail(9,$modelCreditNote->id);
                   }
                   if($model_mail_setting->notification_required=='Y'){                    
                        // MasternotificationController::sendnotification(9,$modelCreditNote->id);
                    }
                    if($model_mail_setting->sms_required=='Y'){                    
                        // MasternotificationController::sendsms(9,$modelCreditNote->id);
                    }

                $jsonData['id'] = $modelCreditNote->id;
                $jsonData['file'] = $modelCreditNote->file;
                $jsonData['model'] = $modelCreditNote;
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                $error5 = array();
                $error1 = json_decode(CActiveForm::validate($modelCreditNote, '', false), true);

                if (!empty($modelItem[0]->product_id))
                    $error2 = json_decode(CActiveForm::validateTabular($modelItem, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";

                $error3 =  array();//json_decode(CActiveForm::validateTabular($modelCreditNoteAddition, '', false), true);

                $error4 =  array();//json_decode(CActiveForm::validateTabular($modelCreditNoteDeduction, '', false), true);

                if (!empty($model_stock_item))
                    $error5 = json_decode(CActiveForm::validate($model_stock_item, '', false), true);

                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $error4, $error5,$others,$other_errors));

                if ($error != '[]')
                    echo $error;
            }
            Yii::app()->end();
        }else{
            echo CJSON::encode( array( 'error' => ' Transactions are already locked!' ));
           }
        }
    }


    public function actionGetCreditNoteList() {
        $model = new Creditnote();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $warehouse_id = $_POST['warehouse_id'];
        $frm  = $_POST['frm'];
        $columns = array(
            // datatable column index  => database column name
            /*0 => 't.file_id',
            1 => 't.invoice_id',
            2 => 't.id',
            3 => 't.customer_id',
            4 => 't.credited_date',
            5 => 't.currency',
            6 => 't.id',
            7 => 't.total_tax_amount',
            8 => 't.id',
            9 => 't.id'*/
            
            0 => 't.id',
            1 => 't.file_id',
            2 => 't.invoice_id',
            3 => 'customer.customer_name',
            4 => 't.credited_date',
            5 => 't.currency',
            6 => 'invoice.grand_total',
            7 => 't.total_tax_amount',
            8 => 't.credited_amount',
            11 => 't.created_by'
            
            
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        // if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["credit_view_all"])){
        //     $condition = 't.isActive="Y" ';
        // }else{
        //     $condition = 't.isActive="Y" AND t.crm_user_id= "'.Yii::app()->user->id.'" ';
        // }

        $condition = 't.isActive="Y" AND t.is_updated_store="Y"';
        
        if($warehouse_id > 0)  {
            $condition .= 'AND t.warehouse_id='. $warehouse_id ;
         }



        if (!isset(Yii::app()->user->havePermissionOn["credit_view_all"]) && Yii::app()->user->authorised_user != 1) {
            $condition .= ' AND (t.crm_user_id= "' . Yii::app()->user->id . '" OR file.lead_owner_id="' . Yii::app()->user->id . '")';
        }


        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (customer.customer_name LIKE '%" . $searchString . "%' OR t.file_id LIKE '%" . $searchString . "%' OR  t.id LIKE '%" . $searchString . "%' OR  t.invoice_id LIKE '%" . $searchString . "%'  OR invoice.invoice_no LIKE '%" . $searchString . "%' OR t.reference LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('customer', 'file', 'invoice','createdby')->count(array('condition' => $condition));
        $model = $model->with('customer', 'file', 'invoice','createdby')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();

        foreach ($model as $row) {
            $status = '';
            $div = '';
            $invoice_type = $row['invoice']['invoice_type'];
            //$invoice_no = $row['invoice']['invoice_no'];
            $invoice_no = $row['invoice']['id'];
            /* if((int) $invoice_type > 0){
              $modelInvoiceType = new MasInvoiceType();
              $arr_invoice_type_details = $modelInvoiceType->findByPk((int) $invoice_type);
              $inv_code      = $arr_invoice_type_details->inv_code;
              $invoice_no=$inv_code.'-'.$invoice_no;
              } */
                if ((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["credit_pdf"])) && $row->invoice->invoicetype->tax == 'Y') {
                    $div .= '<a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=creditnote/printfile&file=' . $row['file_id'] . '&id=' . $row['id'] . '&customer=' . $row['customer_id'] . '&frm=tax"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
                } else if (Yii::app()->user->authorised_user == 1 || ( (int) Yii::app()->user->havePermissionOn["credit_pdf"] && $row->invoice->invoicetype->tax == 'N') || ( (int) Yii::app()->user->havePermissionOn["credit_pdf"])) {
                    $div .= '<a class="btn btn-primary btn-xs" title="Print" target="_blank" href="index.php?r=creditnote/printfile&file=' . $row['file_id'] . '&id=' . $row['id'] . '&customer=' . $row['customer_id'] . '&frm=taxnil"><i class="fa fa-file-pdf-o" aria-hidden="true"></i></a>';
                }
           
            $net_returned_amount = (($row['credited_amount'] + $row['total_tax_amount']) * $row['exchange_rate']);


            $rowData[] = array(
                $row['id'], 
                $row['file_id'], 
                $invoice_no,
                $row->customer->customer_name, 
                date("d/m/Y", strtotime($row['credited_date'])),
                $row['currencyname']['currency_code'], 
                Yii::app()->numberFormatter->formatCurrency($row['invoice']['grand_total'], ""),
                Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'], ""), 
                Yii::app()->numberFormatter->formatCurrency($row['credited_amount'], ""), 
                '<div class="btn-wrap text-center">' . $div . '</div>',
                $row->created_user,
                $row->posted,
              $row->createdby->first_name . " " .  $row->createdby->last_name,
                $row->customer_id,
                );
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionDeleteNotes() {
        $id = $_POST['id'];
        $model = new FileNotes();
        $model->deleteByPk($id);
        echo "success";
    }

    public function actionGetNotesList() {
        $id = $_POST['id'];
        $model = new FileNotes();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 'notes',
            2 => 'created_datetime',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        if ($id == '') {
            $id = 0;
        }
        $condition = 't.file_id="' . $id . '"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (notes LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $rowData[] = array($m, $row->notes, date('d/m/Y', STRTOTIME($row->created_datetime)), '<div class="btn-wrap">
                            <a href ="#" class="btn btn-danger btn-xs" onclick="deleteNotes(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a></div>');
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionGetDocumentList() {
        $model = new Document();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.document_name',
            2 => 't.created_by',
            3 => 't.created_datetime',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" and t.file_id = "' . $_POST['file_id'] . '" and uploaded_from = "O"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (document_name LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $model2 = User::model()->find(array('condition' => 't.id = "' . $row['created_by'] . '"'));
            if (isset(Yii::app()->user->havePermissionOn['credit_document']) || Yii::app()->user->authorised_user == 1) {
                $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a> &nbsp;';
            }
            //$button_string .= '<a href ="'. Yii::app()->createUrl('lead/downloaddocument&id='.$row['id']).'" class=" btn btn-primary btn-xs"><i class="fa fa-download"></i></a>';
            $rowData[] = array($m, $row['document_name'], $model2->username, date("d/m/Y", strtotime($row['created_datetime'])), '<div class="btn-wrap text-center">' . $button_string . '</div>');
//                    $model2 = User::model()->find(array('condition'=>'t.id = "'.$row['created_by'].'"'));
//                    $rowData[]=array($m,$row['document_name'],$model2->username,date("d/m/Y",strtotime($row['created_datetime'])),
//                            '<div class="btn-wrap text-center">'
//                             .'<a href ="#" class="btn btn-danger btn-xs" onclick="deleteDocument(' . $row['id'] . ')"><i class="fa fa-trash-o "></i></a></div>');
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionDeleteDocument() {
        $id = $_POST['id'];
        $modelDocument = new Document();
        $modelDocument->deleteByPk($id);
        echo "success";
    }

    public function actionGetfileno() {
        $searchTerm = $_GET['term'];
        $condition = 't.file_id LIKE "%' . $searchTerm . '%" OR t.id LIKE "%' . $searchTerm . '%"';
        $model = new Invoice();
        $model = $model->with('file', 'customer', 'contact')->findAll(array('condition' => $condition));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value'] = $eachModel->id;
            $data[$i]['label'] = $eachModel->file_id . ' : ' . $eachModel->id; //$eachModel->invoicetype->inv_code.'-'.
            $data[$i]['currency'] = $eachModel->currency0->currency;
            $data[$i]['currency_id'] = $eachModel->currency0->id;
            $data[$i]['exchangerate'] = $eachModel->currency0->exchange_rate;
            $data[$i]['customer_id'] = $eachModel->customer_id;
            $data[$i]['customer_name'] = $eachModel->customer->customer_name;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }
    
    

    public function actionGetDescription() {
        $invoice_id = (int) Yii::app()->request->getParam('id');
        $model = Invoice::model()->findByPk($invoice_id);
        $data['customer_name'] = $model->customer->customer_name;
        $data['customer_id'] = $model->customer_id;
        $invitems = InvoiceItem::model()->findAll(array('condition' => 'invoice_id=' . $invoice_id));
        $colspan=10;
        $tbl = '<table class="table table-hover table-bordered personal-task" id="credit_item_table">        
            <tr>            
            <th>No</th>     
            <th>Product</th>            
            <th>Description</th>            
            <th>Qty(Invoiced)</th>
            <th>Qty(Picked)</th>
            <th>Unit(Picked)</th>            
            <th>Qty.(Returning)<span style="color : red;">(Base Qty)</th>             
            <th>Rate</th>            
            <th>Amount</th>          
            <th>Tax(%)</th>                     
           </tr>';
        $data_exist=0;
        foreach ($invitems as $i => $eachRow) {
            $factor = 1;
            $model = new CreditnoteItem;
            $store = Store::model()->findByPk($eachRow->product_id);
            $model->unit = $eachRow->unit_id;
            
             if($store->inventory_item_type==1){
                $total_qty = $eachRow->quantity * $eachRow->invoiceunit->factor;
            }
            else{
                $total_qty = $eachRow->quantity;
            }

            $return_qty = CreditnoteItem::model()->with('orderunit')->find(array('select' => '(SUM(t.returned_quantity)) * orderunit.factor AS returned_quantity', 'condition' => 't.invoice_item_id="' . $eachRow->id . '" AND t.product_id="' . $eachRow->product_id . '" AND t.returned_quantity !="0"', 'group' => 't.product_id'))->returned_quantity;
            if ($return_qty < 1) {
                $return_qty = 0;
            }
            $total_return = $return_qty;
            $total_remaining = $total_qty - $total_return;
            if ($total_remaining < 1) {
                $total_remaining = 0;
            }
            if ($total_remaining>0) {
                $data_exist=1;
            }
            //code added sarika on 29=-8-2022
            // $transaction_from=CREDIT_NOTE;
            // $qty_picked =StockLedger::model()->find(array('select' => 'sum(quantity)', 'condition' => 'transaction_from="'.$transaction_from.'" AND t.product_id="' . $eachRow->file_id . '" ', 'group' => 't.product_id'));
            // if(!empty($qty_picked)){
            //     $picked_total=$total_qty - $qty_picked;
            // }
            //end
            //for bonus qty
           /* $total_bonus_qty = $eachRow->bonus_qty * $eachRow->invoiceunit->factor;
            $return_bonus_qty = CreditnoteItem::model()->with('orderunit')->find(array('select' => '(SUM(t.returned_bonus_qty)) * orderunit.factor AS returned_bonus_qty', 'condition' => 't.invoice_item_id="' . $eachRow->id . '" AND t.product_id="' . $eachRow->product_id . '" AND t.returned_bonus_qty !="0"', 'group' => 't.product_id'))->returned_bonus_qty;
            if ($return_bonus_qty < 1) {
                $return_bonus_qty = 0;
            }
            $total_bonus_return = $return_bonus_qty;
            $total_bonus_remaining = $total_bonus_qty - $total_bonus_return;
            if ($total_bonus_remaining < 1) {
                $total_bonus_remaining = 0;
            }
            if ($total_bonus_remaining>0) {
                $data_exist=1;
            }*/
            if($total_remaining>0){
                
                $arr_unit_of_measurement = UnitOfMeasurement::model()->find(array('condition'=>'unit_id='.(int) $store->unit_id.' AND product_id='.(int) $store->id));
                
             
            /*$base_rate = ($eachRow->net_amount / ($eachRow->quantity * $eachRow->invoiceunit->factor));
            $base_rate = $eachRow->net_per_item-($eachRow->net_per_item* 5/105);
            $base_rate = $eachRow->net_per_item;*/
            
            // --------------------------------------------------------
             $net_per_item = $eachRow->net_amount / $eachRow->quantity ;
             $base_rate = $net_per_item - ($net_per_item * 5/105);
             $base_rate = $net_per_item;
            // --------------------------------------------------------


            $tbl .= '<tr>';
            $tbl .= '<td>' . ($i + 1) . '</td>';
            $tbl .= '<td><input type="hidden" id="credits_note_productname_' . $i . '" value="' . $store->part_number . '">' . $store->part_number
                    . CHtml::activeHiddenField($model, "[$i]product_id", array('value' => $eachRow->product_id)) .
                    CHtml::activeHiddenField($model, "[$i]description", array('value' => $eachRow->description)) .
                    CHtml::activeHiddenField($model, "[$i]invoice_item_id", array('value' => $eachRow->id))
                    . CHtml::activeHiddenField($model, "[$i]rate", array('value' => $base_rate))
                    . CHtml::activeHiddenField($model, "[$i]id", array('value' => $eachRow->id))
                    . CHtml::hiddenField("InvoiceItem[$i]_factor", $eachRow->invoiceunit->factor)
                    . CHtml::activeHiddenField($model, "[$i]unit", array('value' => $eachRow->unit_id))
                    . CHtml::activeHiddenField($model, "[$i]returned_unit_id", array('value' => $arr_unit_of_measurement->id))
                    . CHtml::hiddenField("InvoiceItem[$i]_total_return", $total_return)
                    . CHtml::hiddenField("InvoiceItem[$i]_total_quantity", $total_qty)
                    . CHtml::hiddenField("InvoiceItem[$i]_total_remaining", $total_remaining) . '</td>';
            $tbl .= '<td>' . $eachRow->description . '</td>';
            $tbl .= '<td>' . $eachRow->quantity . '</td> ';
            $tbl .= '<td>' . $total_remaining . '</td> ';
            //$tbl .= '<td>' . CHtml::activedropdownlist($model, "[" . $i . "]unit", UnitOfMeasurement::getUnits($eachRow->product_id), array('class' => 'unit go', 'onchange' => 'getFactor(this.id,this.value)')) . '</td> ';
            $tbl .= '<td>' . $eachRow->invoiceunit->name . '</td> ';
            $tbl .= '<td class="cell-right">' . CHtml::activeHiddenField($model, "[$i]quantity", array('value' => $eachRow->quantity))
                    . CHtml::activeTextField($model, "[$i]returned_quantity", array('class' => 'qty go cell-center text-right', 'onkeypress' => 'removequantity($("#material_receipt_stocktable"),this,this.id);return isNumberKey1(event,' . $eachRow->quantity . ',this.value);', 'onkeyup' => 'calculateValues11($("#credit_item_table"));')) . '</td>';
            $tbl .= '<td>' . CHtml::activeTextField($model, "[$i]net_rate", array('class' => 'rate go text-right to_be_calculated', 'readonly' => 'true', 'value' => (round($base_rate, 2)))) . '</td>'
                    . '<td class="cell-right">' . CHtml::activeTextField($model, "[$i]net_amount", array('class' => 'rate go text-right to_be_calculated', 'readonly' => 'true')) . '</td>'
                    . '<td>' . CHtml::activeTextField($model, "[$i]tax_vat_percentage", array('class' => 'rate go text-right to_be_calculated', 'readonly' => 'true', 'value' => $eachRow->tax_vat_percentage))
                    . CHtml::activeHiddenField($model, "[$i]tax_vat_amount", array('value' => $eachRow->tax_vat_amount))
                    . '</td>'
                    . '</tr>';
            }
        }
        
        
        if($data_exist==0){
            $tbl .=  '<tr><td colspan="'.$colspan.'" class="text-center text-bold">No Item Exist</td></tr>';
        }
        $tbl .= '</table>';
        $data['tbl'] = $tbl;
        
        $modelInvoice = Invoice::model()->findByPk($invoice_id);
        

        $data['invoice_id'] = $invoice_id;
        $data['sales_man'] = $modelInvoice->createdby->fullname;
        $data['customer_name'] = $modelInvoice->customer->customer_name;
        $data['warehouse'] = $modelInvoice->warehouse->warehouse_name;
        $data['warehouse_id'] = $modelInvoice->warehouse->id;
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionPrintFile() {


        $id = Yii::app()->request->getParam('id');
        $file_id = Yii::app()->request->getParam('file');
        $customer_id = Yii::app()->request->getParam('customer');
        $frm = Yii::app()->request->getParam('frm');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        if ($frm == 'tax') {
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.creditnote_individual_tax', array('id' => $id, 'file_id' => $file_id, 'customer_id' => $customer_id), true));
        } else {
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.creditnote_individual', array('id' => $id, 'file_id' => $file_id, 'customer_id' => $customer_id), true));
        }
        $mPDF1->Output($htmlTemplate, 'I');
    }

    public function actionAddQuantityDetails() {

        $product_name = filter_var($_POST['product_name'], FILTER_SANITIZE_STRING);
        $product_id = filter_var($_POST['product_id'], FILTER_VALIDATE_INT);
        $quantity = filter_var($_POST['quantity'], FILTER_VALIDATE_INT);
        $totalquantity = filter_var($_POST['totalquantity'], FILTER_VALIDATE_INT);
        $order_id = filter_var($_POST['order_id'], FILTER_VALIDATE_INT);
        $newId = filter_var($_POST['newId'], FILTER_VALIDATE_INT);
        $item_row_id = filter_var($_POST['item_row_id'], FILTER_VALIDATE_INT);
        $model_material_stock = new MaterialReceiptStockDetails();
        $model_product = Store::model()->findbyPK($product_id);
        $batch_mandty = 0;
        $serial_mandty = 0;
        $color_mandatory = "";
        $color_mandatory_1 = "";
        if ($model_product->have_expiry_date == "Y") {
            $batch_mandty = 1;
            $color_mandatory = "bg-danger";
        }
        if ($model_product->have_serial_no == "Y") {
            $serial_mandty = 1;
            $color_mandatory_1 = "bg-danger";
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if ($model_product->have_serial_no == "Y") {
            $this->render('material_receipt_stock_serial', array('model_material_stock' => $model_material_stock, 'product_name' => $product_name, 'product_id' => $product_id, 'quantity' => $quantity, 'newId' => $newId, 'batch_mandty' => $batch_mandty, 'serial_mandty' => $serial_mandty, 'color_mandatory' => $color_mandatory, 'color_mandatory_1' => $color_mandatory_1, 'order_id' => $order_id, 'totalquantity' => $totalquantity, 'item_row_id' => $item_row_id));
        } else {
            $this->render('material_receipt_stock', array('model_material_stock' => $model_material_stock, 'product_name' => $product_name, 'product_id' => $product_id, 'quantity' => $quantity, 'newId' => $newId, 'batch_mandty' => $batch_mandty, 'serial_mandty' => $serial_mandty, 'color_mandatory' => $color_mandatory, 'color_mandatory_1' => $color_mandatory_1, 'order_id' => $order_id, 'totalquantity' => $totalquantity, 'item_row_id' => $item_row_id));
        }
    }

    public function actionGetFactor() {
        $factor = 1;
        if ((int) $_POST['value'] > 0) {
            $factor = UnitOfMeasurement::getFactor($_POST['value']);
        }
        echo $factor;
    }

    public function actionGetCheckingList() {
        $model = new Creditnote();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.file_id',
            1 => 't.invoice_id',
            2 => 't.id',
            3 => 't.customer_id',
            4 => 't.credited_date',
            5 => 't.currency',
            6 => 't.id',
            7 => 't.total_tax_amount',
            8 => 't.id',
            9 => 't.id'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        $condition = 't.isActive="Y" AND t.is_updated_store="N"';
        if (!isset(Yii::app()->user->havePermissionOn["credit_view_all"]) && Yii::app()->user->authorised_user != 1) {
            $condition .= ' AND (t.crm_user_id= "' . Yii::app()->user->id . '" OR file.lead_owner_id="' . Yii::app()->user->id . '")';
        }


        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (customer.customer_name LIKE '%" . $searchString . "%' OR t.file_id LIKE '%" . $searchString . "%' OR  t.id LIKE '%" . $searchString . "%' OR  credit_note_no LIKE '%" . $searchString . "%' OR t.invoice_id LIKE '%" . $searchString . "%'  OR invoice.invoice_no LIKE '%" . $searchString . "%' OR t.reference LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('customer', 'file', 'invoice')->count(array('condition' => $condition));
        $model = $model->with('customer', 'file', 'invoice')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();

        foreach ($model as $row) {
            $status = '';
            $div = '';
            $invoice_type = $row['invoice']['invoice_type'];
            $invoice_no = $row['invoice']['invoice_no'];
            if ((int) $invoice_type > 0) {
                $modelInvoiceType = new MasInvoiceType();
                $arr_invoice_type_details = $modelInvoiceType->findByPk((int) $invoice_type);
                $inv_code = $arr_invoice_type_details->inv_code;
                $invoice_no = $inv_code . '-' . $invoice_no;
            }

            $net_returned_amount = (($row['credited_amount'] + $row['total_tax_amount']) * $row['exchange_rate']);


            $rowData[] = array($row['id'], $row['file_id'], $invoice_no, $row->customer->customer_name, $row['currencyname']['currency_code'], Yii::app()->numberFormatter->formatCurrency($row['total_tax_amount'], ""), Yii::app()->numberFormatter->formatCurrency($row['credited_amount'], ""));
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionReturnItems() {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new Creditnote();

        if ($id > 0) {
            $model = $model->findByPk($id);

            $k = 0;
            $modelItems = CreditnoteItem::model()->findAll(array('condition' => 'creditnote_id=' . $id . ' AND quantity>0'));
            if (!empty($modelItems)) {
                foreach ($modelItems as $eachItem) {
                    $modelItems[$k] = new ProductLocationDetails;
                    $modelItems[$k]->product_id = $eachItem->product_id;
                    $modelItems[$k]->quantity = $eachItem->quantity;
                    $modelItems[$k]->header_id = $eachItem->creditnote_id;
                    $modelItems[$k]->header_item_id = $eachItem->id;
                    $modelItems[$k]->transaction_type = "CREDIT_NOTE";
                    $k++;
                }
            }
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('return_item_form', array('model' => $model, 'items' => $modelItems, 'id' => $id));
    }

    public function actionPostCreditNote() {
        $modelCreditNote = new Creditnote();
        $receivedQuantity = array();
        $valid = true;

        if (is_array($_POST['ProductLocationDetails'])) {
            foreach ($_POST['ProductLocationDetails'] as $i => $item) {

                if ($item['product_id'] > 0 AND $item['quantity'] > 0) {
                    $modelProLocDetails[$i] = new ProductLocationDetails;
                    $modelProLocDetails[$i]->attributes = $_POST['ProductLocationDetails'][$i];
                    $modelProLocDetails[$i]->header_id = $item['header_id'];
                    $modelProLocDetails[$i]->header_item_id = $item['header_item_id'];
                    $modelProLocDetails[$i]->product_id = $item['product_id'];
                    $modelProLocDetails[$i]->bill_of_entry = $item['bill_of_entry'];
                    $modelProLocDetails[$i]->warehouse_id = $item['warehouse_id'];
                    $modelProLocDetails[$i]->rack_id = $item['rack_id'];
                    $modelProLocDetails[$i]->bin_id = $item['bin_id'];
                    $modelProLocDetails[$i]->batch_no = $item['batch_no'];
                    $modelProLocDetails[$i]->serial_no = $item['serial_no'];
                    $modelProLocDetails[$i]->quantity = $item['quantity'];
                    $modelProLocDetails[$i]->transaction_type = $item['transaction_type'];
                    $modelProLocDetails[$i]->created_by = Yii::app()->user->id;
                    $modelProLocDetails[$i]->created_date = date('Y-m-d h:i:s');

                    if ($item['manufacturing_date'] != '00/00/0000' AND $item['manufacturing_date'] != '01/01/1970' AND $item['manufacturing_date'] != '') {
                        $mf_date = str_replace('/', '-', $item['manufacturing_date']);
                        $modelProLocDetails[$i]->manufacturing_date = date("Y-m-d", strtotime($mf_date));
                    } else {
                        $modelProLocDetails[$i]->manufacturing_date = "0000-00-00";
                    }
                    if ($item['expiry_date'] != '00/00/0000' AND $item['expiry_date'] != '01/01/1970' AND $item['expiry_date'] != '') {
                        $expiry_date = str_replace('/', '-', $item['expiry_date']);
                        $modelProLocDetails[$i]->expiry_date = date("Y-m-d", strtotime($expiry_date));
                    } else {
                        $modelProLocDetails[$i]->expiry_date = "0000-00-00";
                    }
                    $valid = $modelProLocDetails[$i]->validate() && $valid;
                }
            }



            if ($valid) {

                $credit_note_id = $_POST['credit_note_id'];
                if ($credit_note_id > 0) {
                    $modelCreditNote = $modelCreditNote->findByPk($credit_note_id);
                    $modelCreditNote->is_updated_store = "Y";
                    $modelCreditNote->save(false);
                }
                if (!empty($modelProLocDetails)) {
                    foreach ($modelProLocDetails as $eachItem) {
                        if (empty($eachItem->batch_no)) {
                            $eachItem->batch_no = $modelCreditNote->id;
                        }
                        $eachItem->isActive = "Y";
                        $eachItem->save(false);

                        $stockLedger = new StockLedger;
                        $stockLedger->header_id = $eachItem['header_id'];
                        $stockLedger->header_item_id = $eachItem['header_item_id'];
                        $stockLedger->transaction_date = date('Y-m-d');
                        $stockLedger->transaction_type = $eachItem['transaction_type'];
                        $stockLedger->product_id = $eachItem['product_id'];
                        $stockLedger->quantity = $eachItem['quantity'];
                        $stockLedger->product_location_id = $eachItem->id;

                        $modelStore = Store::model()->findBypk($eachItem['product_id']);
                        $stockLedger->unit_id = $modelStore['unit_id'];
                        $stockLedger->warehouse_id = $eachItem['warehouse_id'];
                        $stockLedger->rack_id = $eachItem['rack_id'];
                        $stockLedger->bin_id = $eachItem['bin_id'];
                        $stockLedger->created_by = Yii::app()->user->id;
                        $stockLedger->created_date = date('Y-m-d h:i:s');
                        $stockLedger->cost_price = $modelStore->rate;
                        $stockLedger->save(false);
                    }
                }
                echo CJSON::encode(array('status' => 'success'));
            } else {

                $error2 = array();
                $error4 = array();
                $error1 = array();
                if (!empty($modelProLocDetails))
                    $error2 = json_decode(CActiveForm::validateTabular($modelProLocDetails, '', false), true);
                $error = CJSON::encode(array_merge_recursive($error1, $error2));
                if ($error != '[]' || $error != '')
                    echo $error;
            }
        }
    }
    public function actionGetinvoiceDetails() {
        $customer_id = $_POST['customer_id'];
        $warehouse_id = (int)Yii::app()->user->getState('user_warehouse_id');
        if((int)Yii::app()->user->authorised_user !=1 && $warehouse_id>0){
            $condition = 'customer_id="'.$customer_id.'" AND invoice_status="Y" AND warehouse_id='.Yii::app()->user->user_warehouse_id;
        }else{
            $condition = 'customer_id="'.$customer_id.'" AND invoice_status="Y"';
        }
        
        $model = Invoice::model()->findAll(array('condition' =>$condition));       
        $i = 0;
        $data=array();
        foreach ($model as $eachModel) {
            $data[$i]['invoice_id'] = $eachModel->id;
            $data[$i]['file_id'] = $eachModel->file_id . ' : ' . $eachModel->invoice_no; 
            $i++;
        }
        $invoice_details=CHtml::listData($data, 'id', 'file_id');
        $drop_down=CHtml::dropDownList('tax_invoice_id', '',$invoice_details,  array('class' => 'tooltipster', 'title' => 'Invoice No','data-label'=>'Invoice No <span style="color:red">*</span>','data-search'=>true,'empty'=>'Select','onchange' => 'gethiringreturndetails(this.value);'));   
        echo CJSON::encode( array('details'=>$drop_down));
    }

    public function actionGetsalesreturnDetails() {
        $invoice_id = $_POST['invoice_id'];
        $model = Invoice::model()->findByPk($invoice_id);
        //Default Currency
        $default_currency='N';
        if($model->currency0->id==Yii::app()->user->company_base_currency){
            $default_currency='Y';
        }
        echo CJSON::encode( array(
            'currency'=>$model->currency0->currency_code,
            'currency_id'=>$model->currency0->id,
            'exchangerate'=>$model->currency0->exchange_rate,
            'customer_id'=>$model->customer_id,
            'customer_name'=>$model->customer->customer_name,
            'default_currency'=>$default_currency,
            'invoice_date'=>date('d/m/Y',strtotime($model->invoice_date)),
        ));
    }

}
