<?php

class ChequeCollectionController extends Controller
{
	 public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'GetList', 'SaveCheque','GetLocation','ChangeStatus','UploadChequeImage','SaveCollectionCheque'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
    {
        $this->render('index');
    }
     public function actionGetList()
        {
                $model=new ChequeCollection();
                
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'customer_id',
                   1 => 't.location_id',
                    2 => 'cheque_amount',
                    3 => 'no_of_cheque',
                    3 => 'status',

                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
               //serach
                $condition = '1=1';
                if (Yii::app()->user->authorised_user!= 1 ){
		            $user_id = Yii::app()->user->id;
		            $modelUser=new User();
		            $modelUser=$modelUser ->findByPk($user_id);
		            if(!empty($modelUser->location_id)){
		                $condition  .= ' AND t.location_id IN ('.$modelUser->location_id.') ';
		            }
		            else{
		                $condition  .= ' AND t.location_id=0 ';
		            }
                }
                
               if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
	            $searchString = $_POST['search']['value'];
	            $condition.=" AND  ( t.status LIKE '%" . $searchString . "%' OR  t.cheque_amount LIKE '%" . $searchString . "%'   OR location.location_name LIKE '%" . $searchString . "%'  OR customer.customer_name LIKE '%" . $searchString . "%')";
                }
                if(isset($_POST['chq_status']) &&$_POST['chq_status'] !="" ) {
                    $condition  .= ' AND t.status="'.$_POST['chq_status'].'" ';
                }
                
                $count = $model->with('customer','location')->count(array('condition' => $condition));
                $model = $model->with('customer','location')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
                
                //$count = $model->count(array('condition'=>$condition));
                // $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=> 'id desc'));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m = 1;

                  foreach ($model as $row)
                {

                    $div = '';
                     if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["cheque_collection_upload"]))){
                       $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'ChequeCollection/ChangeStatus&id='.$row->id.'\',\'Collection Status-'.$row->customer->customer_name.'\',\'md\')" title="Collection Image Upload"><i class="fa fa-upload"></i></button>';
                      }
                     if((Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["cheque_collection_edit"]))){
                       $div .= ' <button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'ChequeCollection/create&id='.$row->id.'\',\'Edit-'.$row->customer->customer_name.'\',\'xl\')" title="Edit Data"><i class="fa fa-edit"></i></button>';
                    }

                    $rowData[]=array($m,
                        $row->customer->customer_name,
                        $row->location->location_name,
                        date("d/m/Y", strtotime($row->date_of_collection)),
                        $row->cheque_amount,
                        $row->no_of_cheque,
                        $row->status,
                        '<div class="btn-wrap text-center">'.$div.'</div>',
                       array('id' => $row->id,'name'=>$row->customer->customer_name));
                    

                    $m++;

                }


                $data['data'] = $rowData;
                echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new ChequeCollection();
        $id = (int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('cheque_form', array('model' => $model), false, false);
    }
    public function actionSaveCheque()
        {
            $model = new ChequeCollection();
            if (isset($_POST['ChequeCollection']))
            {
    		    if ((int) @$_POST['ChequeCollection']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_datetime =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['ChequeCollection']['id'];
                    $model=$model->findByPk($id);
                   
                }
                else{
                    $model->created_by = Yii::app()->user->id;
                    $model->created_datetime =date('Y-m-d h:i:s');
                    $model->scenario='add';
               
                }
                $model->attributes=$_POST['ChequeCollection'];
                $model->no_of_cheque = $_POST['ChequeCollection']['no_of_cheque'];
                 // $model->status = $_POST['ChequeCollection']['is_lead_owner'];
                $model->notes = $_POST['ChequeCollection']['notes'];
                $date_of_collection = str_replace('/', '-', $_POST['ChequeCollection']['date_of_collection']);

                $model->date_of_collection= date("Y-m-d", strtotime( $date_of_collection));
               

                $model->cheque_amount = $_POST['ChequeCollection']['cheque_amount'];
               
                if ($model->save())
                {
                          
                        $jsonData['status'] = 'success';
                        $jsonData['frm'] = $_POST['cheque_from'];
                        $jsonData['id'] = $model->id;
	                echo CJSON::encode($jsonData);
                }
                else
                {
                        $error = CActiveForm::validate($model, '', false);
                        if ($error != '[]')
		               echo $error;
                }

            }
        }

        public function actionGetLocation(){
            $id=Yii::app()->request->getparam("id");  
            $modelLocation = new MasLocation();
            $modelCustomer = new Customer(); 
            $loc_id=$modelCustomer->findByPk($id)->location_id; 
            $modelLocation = $modelLocation->findByPk($loc_id);
            $drop='<li class="col-sm-3">';
            $drop.=CHtml::textField('location_name', $modelLocation->location_name,array('class' => 'text-bold', 'data-label'=>'Location','disabled' => true));
            $drop.='</li>';
            $status=array("location" => $modelLocation->location_name,"loc_id"=>$loc_id,"dt"=>$drop);
            echo CJSON::encode($status);
        }
        public function actionChangeStatus()
	    {
	        $model=new ChequeCollection();
	        $id = (int) Yii::app()->request->getParam('id');
	        if($id>0){
	            $model=$model->findByPk($id);
	        }
	            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
	        $this->render('upload_form', array('model' => $model), false, false);
	    }

        public function actionUploadChequeImage($folder = null,$filename=null){
            Yii::import("ext.EAjaxUpload.qqFileUploader");
       
	        if(empty($filename)){
	            $filename='chequeImage_'.date('YmdHis');
	        }
	        
	        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
	        // make the directory to store the pic:
	        if (!is_dir($folder)) {
	            mkdir($folder, 0777, TRUE);
	        }
	        $allowedExtensions = array("zip", "png", "txt", "jpg", "jpeg", "gif"); //array("jpg","jpeg","gif","exe","mov" and etc...
	        $sizeLimit = 30 * 1024 * 1024; // maximum file size in bytes
	        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
	        $result = $uploader->handleUpload($folder,FALSE,$filename);
	        //$result = $uploader->handleUpload($folder);
	        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
	        $result['field_id'] = $field_id;
	        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
	        $fileName = $result['filename']; //GETTING FILE NAME
	        $imagename  =   Yii::app()->basePath.'/../uploads/cheueImage/'.$fileName;
	        $imagename_thumb    =   Yii::app()->basePath.'/../uploads/cheueImage/thumbs/'.$fileName;
	        Yii::import("ext.EPhpThumb.EPhpThumb");
	        $thumb=new EPhpThumb();
	        $thumb->init(); //this is needed
	        //chain functions
	        $thumb->create($imagename)->resize(120,120)->save($imagename_thumb);
	        echo $return; // it's array
        }

        public function actionSaveCollectionCheque(){
        	$model = new ChequeCollection();
        	$valid_set = true;
        	$other = array();
            if (isset($_POST['ChequeCollection']))
            {
    		    if ((int) @$_POST['ChequeCollection']['id'] > 0)
                {   $model->updated_by = Yii::app()->user->id;
                    $model->updated_datetime =date('Y-m-d h:i:s');
                    $id= (int) @$_POST['ChequeCollection']['id'];
                    $model=$model->findByPk($id);
                    $model->scenario='update';
                   
                }
                else{
                    $model->created_by = Yii::app()->user->id;
                    $model->created_datetime =date('Y-m-d h:i:s');
                    $model->scenario='add';
               
                }

                if ($_POST['ChequeCollection']['cheque_image'] =="") {
                        $valid_set = false;
                        $other[] = "Upload Image";
                        
                } 
                if($_POST['ChequeCollection']['status'] =="") {
                        $valid_set = false;
                        $other[] = "status cannot be empty";
                }
                if( ($_POST['ChequeCollection']['status']=="Collected") &&
                    ($_POST['ChequeCollection']['cheque_image'] =="")){
                	$valid_set = false;
                    $other[] = "Upload Image";

                }
               if($_POST['ChequeCollection']['status']=="Not Collected"){
                    $valid_set = false;
                    $other[] = "Set Status Collected";
                }
                $model->cheque_image = $_POST['ChequeCollection']['cheque_image'];
                $model->status = $_POST['ChequeCollection']['status'];
                
                if($valid_set){
	                if ($model->save())
	                {
	                          
	                        $jsonData['status'] = 'success';
	                        $jsonData['frm'] = $_POST['cheque_collection_from'];
	                        $jsonData['id'] = $model->id;
		                echo CJSON::encode($jsonData);
	                }
	            }
                else
                {
                       $error = json_decode(CActiveForm::validate($model, '', false), true);
                       $error = CJSON::encode(array_merge_recursive($error, $other));
                	// print_r($error);exit;
                        if ($error != '[]')
		                echo $error;
                }

            }

        }













}