<?php

class CheckinController extends Controller
{
	
    public function accessRules() {
            return array(
                            array('allow', // allow all users to perform 'index' and 'view' actions
                                            'actions' => array('login', 'error', 'logout'),
                                            'users' => array('*'),
                            ),
                            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                                            'actions' => array('Index','GetList','Create','UpdateStockDetails'),
                                            'expression' => '$user->isMember()',
                            ),
                            array('deny', // deny all users
                                            'users' => array('*'),
                            ),
            );
    }
    public function actionIndex()
    {
    	$frm = Yii::app()->request->getParam('frm');
        $hire = Yii::app()->request->getParam('hire');
        $this->render('index',array('frm'=>$frm,'hire'=>$hire));
    }

    public function filters()
    {
            return array(
                            'accessControl', // perform access control for CRUD operations
            );
    }
    public function actionGetList()
    {
        $model=new CheckinList();
        
        $frm = Yii::app()->request->getParam('frm');
        $hire = Yii::app()->request->getParam('hire');
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
       //  $warehouse_id = $_POST['warehouse_id'];
        $warehouse_id = Yii::app()->request->getParam('warehouse_id');

        $columns = array(
                        // datatable column index  => database column name
                        0 =>'t.transaction_id',
                        1 =>'t.file_id',
                        2 => 't.customer_name',
                        4 => 't.transaction_date',

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        $condition = '1=1';


        if($warehouse_id > 0)  {
            $condition .= 'AND t.warehouse_id='. $warehouse_id ;
         }

        if(!empty($frm)){
        	$condition="t.status='".$frm."'";
        }
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
                $searchString = $_POST['search']['value'];
                $condition.=" AND (t.transaction_id LIKE '%".$searchString."%' OR t.customer_name LIKE '%".$searchString."%' OR t.checkin_frm LIKE '%".$searchString."%')";
        }
        
        if($frm=='CN' && $hire=='1'){
          //  $count = $model->with('creditdetails')->count(array('condition'=>$condition));
         //   $model=$model->with('creditdetails')->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.transaction_date desc'));
            $SQL = "SELECT t.* FROM `view_checkin_list` `t` LEFT OUTER JOIN `erp_creditnote` `creditdetails` ON ( `t`.`transaction_id` = `creditdetails`.`id` ) WHERE ( $condition ) ORDER BY t.transaction_date DESC LIMIT $limit ";
            $model = Yii::app()->db->createCommand($SQL)->queryAll();
            $count=count($model);
        }else{
            $count = $model->count(array('condition'=>$condition));
            $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'t.transaction_date desc'));
        }
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m = 1;
        foreach ($model as $row)
        {
                $transaction_date=date("d/m/Y", strtotime($row['transaction_date']));
                $rowData[]=array($row['transaction_id'],$transaction_date,$row['customer_name'],$row['checkin_frm'],$row['status']); 
                $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
        
    public function actionCreate_09_02_2023() 
    {
        $model=new CheckinList();
        $transaction_id = (int) Yii::app()->request->getParam('id');
        $status = Yii::app()->request->getParam('status');
        if ($status != '') {
            $cndn = 'transaction_id=' . $transaction_id . ' AND status="' . $status . '"';
        } else {
            $cndn = 'transaction_id=' . $transaction_id;
        }
        $model  = $model->find(array('condition'=>$cndn));
        $status = $model->status;
        $warehouse = 0;
        $transaction_date=date('Y-m-d');
        if($status=='CN'){
        	$transaction_from='CREDIT_NOTE';
            $model_master 	= Creditnote::model()->findByPk($transaction_id);
            $modelItems  	= CreditnoteItem::model()->findAll(array('condition'=>'creditnote_id ='.$transaction_id.' AND returned_quantity>0'));
            if($model_master->credited_date!="0000-00-00"){
                $transaction_date = $model_master->credited_date;
            }
            
        }else if($status=='PGR'){
        	$transaction_from='PROD_GOODS_RECEIPT';
            $model_master	= ProductionGoodsReceipt::model()->findByPk($transaction_id);           
            $modelItems  	= ProductionGoodsReceiptItem::model()->findAll(array('condition'=>'PROD_GOODS_RECEIPT_id ='.$transaction_id));
            if($model_master->goods_receipt_date!="0000-00-00"){
                $transaction_date = $model_master->goods_receipt_date;
            }
        }
        else if($status=='IGR'){
        	$transaction_from='GOODS_RECEIPT';
            $model_master	= InventoryGoodsReceipt::model()->findByPk($transaction_id);           
            $modelItems  	= InventoryGoodsReceiptItem::model()->findAll(array('condition'=>'inventory_goods_receipt_id ='.$transaction_id));
            
             if($model_master->goods_receipt_date!="0000-00-00"){
                $transaction_date = $model_master->goods_receipt_date;
            }
            $warehouse =$model_master->warehouse_id;
        } else if($status=='DTCK'){
        	$transaction_from='TRANSFER_IN';
            $model_master	= InventoryDirectTransfer::model()->findByPk($transaction_id);           
            $modelItems  	= InventoryDirectTransferItem::model()->findAll(array('condition'=>'direct_transfer_id ='.$transaction_id));
           
            $warehouse = $model_master->to_warehouse_id;
            
            if($model_master->transfer_date!="0000-00-00"){
                $transaction_date = $model_master->transfer_date;
            }
        }
        else if($status=='IDTCK'){
        	$transaction_from='IND_TRANSFER_IN';
            $model_master	= InventoryIndirectTransfer::model()->findByPk($transaction_id);           
            $modelItems  	= InventoryIndirectTransferItem::model()->findAll(array('condition'=>'indirect_transfer_id ='.$transaction_id,'order'=>'item_id'));
            $warehouse = $model_master->to_warehouse_id;
            
            if($model_master->transfer_date!="0000-00-00"){
                $transaction_date = $model_master->transfer_date;
            }
        }
        $k=0;
        if(!empty($modelItems)){
        	foreach ($modelItems as $eachItem) {
        	        $modelItems[$k] = new StockLedger;
        	        
        	        
                    $modelItems[$k]->cost_price   = "";

                    if($status=='DTCK' || $status=='IDTCK')
                    {
                            $modelItems[$k]->product_id =  $eachItem->item_id;   
                    }
                    else {
                            $modelItems[$k]->product_id =  $eachItem->product_id;       
                    }
                    if(isset($eachItem->quantity) && $status!='CN'){
                            $modelItems[$k]->quantity   = $eachItem->quantity;
                    }
                    elseif(isset($eachItem->picked_qty)){
                            $modelItems[$k]->quantity   = $eachItem->picked_qty;
                    }
                    elseif(isset($eachItem->returned_quantity) && $status=='CN'){
                            //$modelItems[$k]->quantity   = $eachItem->returned_quantity+$eachItem->returned_bonus_qty;
                             $modelItems[$k]->quantity   = $eachItem->returned_quantity;
                    }else if(isset($eachItem->transfer_qty) && ($status=='DTCK' || $status=='IDTCK')){
                        $modelItems[$k]->quantity   = $eachItem->transfer_qty;
                    }
                    
                    if(isset($eachItem->rate) && $status=='IGR'){//Inventory Goods Receipt
                            $modelItems[$k]->cost_price     = $eachItem->rate;
                            $modelItems[$k]->unit_id        = $eachItem->unit;
                            $modelItems[$k]->unit_name      = $eachItem->unitdetails->name;
                            $modelItems[$k]->unit_factor    = $eachItem->unitdetails->factor;
                            
                    }
                    else if(isset($eachItem->rate) && $status=='PGR'){//Production Goods receipt
                            $modelItems[$k]->cost_price     = $eachItem->rate;
                            $modelItems[$k]->unit_id        = $eachItem->unit;
                            $modelItems[$k]->unit_name      = $eachItem->unitdetails_mes->name;
                            $modelItems[$k]->unit_factor    = $eachItem->unitdetails_mes->factor;
                    }
                    elseif($status=='DTCK' && isset($eachItem->stock->rate)){
                        
                            $modelItems[$k]->cost_price     = $eachItem->stock->rate;
                            $modelItems[$k]->unit_id        = $eachItem->stock->unit_id;
                            $modelItems[$k]->unit_name      = $eachItem->stock->unit->symbol;
                            $modelItems[$k]->unit_factor    = 1;
                    }
                    elseif($status=='CN'){
                        
                            $arr_product_details =Store::model()->findByPk($eachItem->product_id);
                            $modelItems[$k]->cost_price     = $eachItem->rate;
                            $modelItems[$k]->unit_id        = $eachItem->orderunit->id;
                            $modelItems[$k]->unit_name      = $eachItem->orderunit->name;
                            $modelItems[$k]->unit_factor    = $eachItem->orderunit->factor;
                    }
                    else{
                            $arr_product_details =Store::model()->findByPk($eachItem->product_id);
                            $modelItems[$k]->cost_price     = $arr_product_details->rate;
                            $modelItems[$k]->unit_id        = $arr_product_details->unit_id;
                            $modelItems[$k]->unit_name      = $arr_product_details->unit->symbol;
                            $modelItems[$k]->unit_factor    = 1;
                    }
                    
                    $modelItems[$k]->id   = $eachItem->id;
                    $modelItems[$k]->header_id   = $transaction_id;
                    $modelItems[$k]->header_item_id   = $eachItem->id;
                    $modelItems[$k]->transaction_from   = $transaction_from;
                    $modelItems[$k]->customer_vendor_id   = 0;
                    $modelItems[$k]->customer_vendor_name   = "";
                    
                    $k++;
        	}
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);
        $this->render('create',array('model'=>$model_master,'status'=>$status,'items'=>$modelItems, 'warehouse' => $warehouse,'transaction_date'=>$transaction_date));
    }
    
     public function actionCreate() 
    {
        $model=new CheckinList();
        $transaction_id = (int) Yii::app()->request->getParam('id');
        $status = Yii::app()->request->getParam('status');
        if ($status != '') {
            $cndn = 'transaction_id=' . $transaction_id . ' AND status="' . $status . '"';
        } else {
            $cndn = 'transaction_id=' . $transaction_id;
        }
        $model  = $model->find(array('condition'=>$cndn));
        $status = $model->status;
        $warehouse = 0;
        $transaction_date=date('Y-m-d');
        if($status=='CN'){
        	$transaction_from='CREDIT_NOTE';
            $model_master 	= Creditnote::model()->findByPk($transaction_id);
            $modelheader_items  	= CreditnoteItem::model()->findAll(array('condition'=>'creditnote_id ='.$transaction_id.' AND returned_quantity>0'));
            if($model_master->credited_date!="0000-00-00"){
                $transaction_date = $model_master->credited_date;
            }
            
        }else if($status=='PGR'){
        	$transaction_from='PROD_GOODS_RECEIPT';
            $model_master	= ProductionGoodsReceipt::model()->findByPk($transaction_id);           
            $modelheader_items  	= ProductionGoodsReceiptItem::model()->findAll(array('condition'=>'PROD_GOODS_RECEIPT_id ='.$transaction_id));
            if($model_master->goods_receipt_date!="0000-00-00"){
                $transaction_date = $model_master->goods_receipt_date;
            }
        }
        else if($status=='IGR'){
        	$transaction_from='GOODS_RECEIPT';
            $model_master	= InventoryGoodsReceipt::model()->findByPk($transaction_id);           
            $modelheader_items  	= InventoryGoodsReceiptItem::model()->findAll(array('condition'=>'inventory_goods_receipt_id ='.$transaction_id));
            
             if($model_master->goods_receipt_date!="0000-00-00"){
                $transaction_date = $model_master->goods_receipt_date;
            }
            $warehouse =$model_master->warehouse_id;
        } else if($status=='DTCK'){
        	$transaction_from='TRANSFER__IN';
            $model_master	= InventoryDirectTransfer::model()->findByPk($transaction_id);           
            $modelheader_items  	= InventoryDirectTransferItem::model()->findAll(array('condition'=>'direct_transfer_id ='.$transaction_id));
           
            $warehouse = $model_master->to_warehouse_id;
            
            if($model_master->transfer_date!="0000-00-00"){
                $transaction_date = $model_master->transfer_date;
            }
        }
        else if($status=='IDTCK'){
        	$transaction_from='IND_TRANSFER_IN';
            $model_master	= InventoryIndirectTransfer::model()->findByPk($transaction_id);           
            $modelheader_items  	= InventoryIndirectTransferItem::model()->findAll(array('condition'=>'indirect_transfer_id ='.$transaction_id,'order'=>'item_id'));
            $warehouse = $model_master->to_warehouse_id;
            
            if($model_master->transfer_date!="0000-00-00"){
                $transaction_date = $model_master->transfer_date;
            }
        }
        $k=0;
        if(!empty($modelheader_items)){
        	foreach ($modelheader_items as $eachItem) {
        	        $modelItems[$k] = new StockLedger;
        	        
        	        
                    $modelItems[$k]->cost_price   = "";

                    if($status=='DTCK' || $status=='IDTCK')
                    {
                            $modelItems[$k]->product_id =  $eachItem->item_id;   
                    }
                    else {
                            $modelItems[$k]->product_id =  $eachItem->product_id;       
                    }
                    if(isset($eachItem->quantity) && $status!='CN'){
                            $modelItems[$k]->quantity   = $eachItem->quantity;
                    }
                    elseif(isset($eachItem->picked_qty)){
                            $modelItems[$k]->quantity   = $eachItem->picked_qty;
                    }
                    elseif(isset($eachItem->returned_quantity) && $status=='CN'){
                            //$modelItems[$k]->quantity   = $eachItem->returned_quantity+$eachItem->returned_bonus_qty;
                            $modelItems[$k]->quantity   = $eachItem->returned_quantity;
                    }else if(isset($eachItem->transfer_qty) && ($status=='DTCK' || $status=='IDTCK')){
                        $modelItems[$k]->quantity   = $eachItem->transfer_qty;
                    }
                    
                    if(isset($eachItem->rate) && $status=='IGR'){//Inventory Goods Receipt
                            $modelItems[$k]->cost_price     = $eachItem->rate;
                            $modelItems[$k]->unit_id        = $eachItem->unit;
                            $modelItems[$k]->unit_name      = $eachItem->unitdetails->name;
                            $modelItems[$k]->unit_factor    = $eachItem->unitdetails->factor;
                    }
                    else if(isset($eachItem->rate) && $status=='PGR'){//Production Goods receipt
                            $modelItems[$k]->cost_price     = $eachItem->rate;
                            $modelItems[$k]->unit_id        = $eachItem->unit;
                            $modelItems[$k]->unit_name      = $eachItem->unitdetails_mes->name;
                            $modelItems[$k]->unit_factor    = $eachItem->unitdetails_mes->factor;
                    }
                    elseif($status=='DTCK' && isset($eachItem->stock->rate)){
                        
                            $modelItems[$k]->cost_price     = $eachItem->stock->rate;
                            $modelItems[$k]->unit_id        = $eachItem->stock->unit_id;
                            $modelItems[$k]->unit_name      = $eachItem->stock->unit->symbol;
                            $modelItems[$k]->unit_factor    = 1;
                    }
                    elseif($status=='CN'){
                        
                            $arr_product_details =Store::model()->findByPk($eachItem->product_id);
                            $modelItems[$k]->cost_price     = $eachItem->rate;
                            $modelItems[$k]->unit_id        = $eachItem->orderunit->id;
                            $modelItems[$k]->unit_name      = $eachItem->orderunit->name;
                            $modelItems[$k]->unit_factor    = $eachItem->orderunit->factor;
                            $modelItems[$k]->sales_price    = $eachItem->rate;
                    }
                    else{
                            $arr_product_details =Store::model()->findByPk($eachItem->product_id);
                            $modelItems[$k]->cost_price     = $arr_product_details->rate;
                            $modelItems[$k]->unit_id        = $arr_product_details->unit_id;
                            $modelItems[$k]->unit_name      = $arr_product_details->unit->symbol;
                            $modelItems[$k]->unit_factor    = 1;
                    }
                    
                    $modelItems[$k]->id   = $eachItem->id;
                    $modelItems[$k]->header_id   = $transaction_id;
                    if($status=='IGR' && !empty($model_master->reference)){
                        $modelItems[$k]->batch_no   = $model_master->customer->customer_name.'#'.$model_master->reference;
                    }else{
                        $modelItems[$k]->batch_no   = $transaction_id;
                    }
                    //$modelItems[$k]->batch_no   = $transaction_id;
                    $modelItems[$k]->header_item_id   = $eachItem->id;
                    $modelItems[$k]->transaction_from   = $transaction_from;
                    $modelItems[$k]->customer_vendor_id   = 0;
                    $modelItems[$k]->customer_vendor_name   = "";
                    
                    $k++;
        	}
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);
        $this->render('create',array('model'=>$model_master,'status'=>$status,'items'=>$modelItems, 'warehouse' => $warehouse,'transaction_date'=>$transaction_date));
    }
    
    
    
    public function actionUpdateStockDetails()
    {
        $valid  = true;
        $other=array();
        
    	$transaction_id = $_POST['transaction_id'];
        $checkin_status = $_POST['checkin_status'];
        $file_id = 0;
        $customer_vendor_id=0;
        $customer_vendor_name="";
        if($checkin_status=='CN'){
            $model= new Creditnote();
            $transaction_from='CREDIT_NOTE';
            if($transaction_id>0){
    				$modelmas = $model->findByPk($transaction_id);
				 if($modelmas->is_updated_store == 'Y'){
                
                    $valid = false;
                    $other[] = "Credit Note alredy done [Transaction No:$transaction_id]" ;
                }
                else{
    				$file_id=$modelmas->file_id;
    				$customer_vendor_id=$modelmas->customer_id;
    				$customer_vendor_name=$modelmas->customer->customer_name;
            }
        }
        }
        else if($checkin_status=='PGR'){
            $model= new ProductionGoodsReceipt();
            $transaction_from='PROD_GOODS_RECEIPT';
        }
        else if($checkin_status=='IGR'){
            $model= new InventoryGoodsReceipt();
            $transaction_from='GOODS_RECEIPT'; 
            if($transaction_id>0){
    			$modelmas = $model->findByPk($transaction_id);
    			if($modelmas->stock_updated == 'Y'){
                
                    $valid = false;
                    $other[] = "Goods Receipt alredy done [Transaction No:$transaction_id]" ;
                }
                else{
    			$file_id=$modelmas->file_id;
    			$customer_vendor_id=$modelmas->customer_id;
    			$customer_vendor_name=$modelmas->customer->customer_name;
                }
    				
    				
            }
        }
        else if($checkin_status=='DTCK'){
            $model= new InventoryDirectTransfer();
            $transaction_from='TRANSFER_IN';
        }
        else if($checkin_status=='IDTCK'){
            $model= new InventoryIndirectTransfer();
            $transaction_from='IND_TRANSFER_IN';
        }
        
    	if (is_array($_POST['StockLedger'])) {
        		foreach ($_POST['StockLedger'] as $i => $item) {
        
        			if ( $item['product_id']>0 && $item['quantity'] >0 ) {
        			    
        			    
        				$modelStockLedger[$i]                       = new StockLedger;
        				$modelStockLedger[$i]->attributes           = $_POST['StockLedger'][$i];
        				$modelStockLedger[$i]->file_id              = $file_id;
        				$modelStockLedger[$i]->header_id            = $item['header_id'];
        				$modelStockLedger[$i]->header_item_id       = $item['header_item_id'];
        				$modelStockLedger[$i]->reference_id         = $item['header_id'];
        				if($checkin_status=='IGR'){
                            $modelStockLedger[$i]->reference_no         = $model->reference;
        				}
        				if($checkin_status=='CN'){
                            $modelStockLedger[$i]->reference_no         = $modelmas->invoice_id;
        				}
        				$modelStockLedger[$i]->customer_vendor_id   = $customer_vendor_id;
        				$modelStockLedger[$i]->customer_vendor_name = $customer_vendor_name;
        				$modelStockLedger[$i]->product_id           = $item['product_id'];
        				$modelStockLedger[$i]->product_name         = $item['product_name'];
        				$modelStockLedger[$i]->product_description  = $item['product_description'];
        				$modelStockLedger[$i]->brand_id             = $item['brand_id'];
        				$modelStockLedger[$i]->brand_name           = $item['brand_name'];
        				$modelStockLedger[$i]->warehouse_id         = $item['warehouse_id'];
        				$modelMasInventoryWarehouse = new MasInventoryWarehouse();
        				$modelStockLedger[$i]->warehouse_name       = $modelMasInventoryWarehouse->getWarehouseName($item['warehouse_id']);
        				$modelStockLedger[$i]->rack_id              = $item['rack_id'];
        				$modelMasInvRack = new MasInvRack();
        				$modelStockLedger[$i]->rack_name            = $modelMasInvRack->getRackName($item['rack_id']);
        				$modelStockLedger[$i]->bin_id               = $item['bin_id'];
        				$modelMasInvBin = new MasInvBin();
        				$modelStockLedger[$i]->bin_name             = $modelMasInvBin->getBinName($item['bin_id']);
        				$modelStockLedger[$i]->batch_no             = $item['batch_no'];
        				$modelStockLedger[$i]->serial_no            = $item['serial_no'];
        				$modelStockLedger[$i]->quantity             = $item['quantity'];
        				$modelStockLedger[$i]->transaction_from     = $item['transaction_from'];
        				$modelStockLedger[$i]->transaction_type     = $item['transaction_type'];
        				$modelStockLedger[$i]->unit_name            = $item['unit_name'];
        				$modelStockLedger[$i]->unit_id              = $item['unit_id'];
        				$modelStockLedger[$i]->unit_factor          = $item['unit_factor'];
        				$modelStockLedger[$i]->cost_price           = $item['cost_price'];
        				if((int)$item['unit_factor']==0){
        				    $item['unit_factor']=1;
        				}
        				if($checkin_status=='IGR' || $checkin_status=='PGR'){//Inventory Goods Receipt and Production Goods receipt
        				    $modelStockLedger[$i]->buying_price     = $item['cost_price']/$item['unit_factor'];
        				    
        				    
        				}
        				$modelStockLedger[$i]->sales_price          = $item['sales_price'];
        				//$modelStockLedger[$i]->transaction_date     = date('Y-m-d');
        				$modelStockLedger[$i]->transaction_date     = $item['transaction_date'];
        				$modelStockLedger[$i]->created_by           = Yii::app()->user->id;
        				$modelStockLedger[$i]->created_date         = date('Y-m-d h:i:s');
        				$modelStockLedger[$i]->stock_updated        = "Y";
        				
        				if($checkin_status=='CN'){
        				    $model_stock_ledger_details                     =   StockLedger::model()->find(array('condition' => 'file_id="'.$file_id.'" AND product_id='.$item['product_id'].' AND serial_no="'.$item['serial_no'].'" AND transaction_from="DELIVERY_NOTE"'));
        				    $modelStockLedger[$i]->manufacturing_date       =   $model_stock_ledger_details->manufacturing_date;
        				    $modelStockLedger[$i]->expiry_date              =   $model_stock_ledger_details->expiry_date;
        				    $modelStockLedger[$i]->master_stock_ledger_id   =   $model_stock_ledger_details->id;;
        				    $modelStockLedger[$i]->batch_no                 =   $model_stock_ledger_details->batch_no;
        				}
        				else if($checkin_status=='DTCK'){
        				    $model_stock_ledger_details                     =   StockLedger::model()->find(array('condition' => 'header_id="'.$item['header_id'].'" AND product_id='.$item['product_id'].' AND serial_no="'.$item['serial_no'].'" AND transaction_from="TRANSFER_OUT"'));
        				    $modelStockLedger[$i]->master_stock_ledger_id   =   $model_stock_ledger_details->id;;
        				}
        				else{
        				    if($item['manufacturing_date']!='00/00/0000' AND $item['manufacturing_date']!='01/01/1970' AND $item['manufacturing_date'] !=''){
        				        $mf_date  = str_replace('/', '-', $item['manufacturing_date']);
        				        $modelStockLedger[$i]->manufacturing_date = date("Y-m-d", strtotime($mf_date));
        				    }
        				    else{
        				        $modelStockLedger[$i]->manufacturing_date = "0000-00-00";
        				    }
        				    if($item['expiry_date']!='00/00/0000' AND $item['expiry_date']!='01/01/1970' AND $item['expiry_date'] !=''){
        				        $expiry_date                                = str_replace('/', '-', $item['expiry_date']);
        				        $modelStockLedger[$i]->expiry_date          = date("Y-m-d", strtotime($expiry_date));
        				    }
        				    else{
        				        $modelStockLedger[$i]->expiry_date          = "0000-00-00";
        				    }
        				    $modelStockLedger[$i]->master_stock_ledger_id   = 0;
        				}
        				
        
        				
                        if(!empty($item['serial_no']))
                        {
    
                            //$checkItemSerialNo=$total_available_product = StockLedger::model()->find(array('select' => 'sum(quantity) as quantity','condition'=>'serial_no="'.$item['serial_no'].'" AND product_id="'.$item['product_id'].'"'))->quantity; 
                            $checkItemSerialNo=$total_available_product = StockLedger::model()->find(array('select' => 'sum(quantity) as quantity','condition'=>'serial_no="'.trim($item['serial_no']).'" AND product_id="'.$item['product_id'].'"'))->quantity; 
                            if($checkItemSerialNo>0)
                            {
                                $valid=false;
                                $repeated_item=Store::model()->findByPk($item['product_id'])->part_number;
                                $other[]="$repeated_item : Serial No (".$item['serial_no'].") Already Exist";        
                            }
                        
                        }
                        
                        
                        /*if(isset($item['batch_date']) && $item['batch_date']!='' && $item['batch_date']!='0000-00-00'){
                            
                        }*/
                        
        				$valid = $modelStockLedger[$i]->validate() && $valid;
        				
        			}
        		}
    
    
    		if ($valid){
    			if($transaction_id>0){
    				$model = $model->findByPk($transaction_id);
    				if($checkin_status=='IGR'){
    					$model->stock_updated = "Y";
    				}
    				else if($checkin_status=='DTCK'){
                        $model->status = "C";
                    }
    				else{
    					$model->is_updated_store = "Y";
    				}
    		       
                    $model->save(false);
                    
                    if($checkin_status=='CN'){
                        $modelCreditNote = new Creditnote();
                        $modelCreditNote->updateByPk($transaction_id, array('creditnote_no'=>$transaction_id));
                          //code added by mereena on 11/11/2022 to get current series no
                            /*$user_warehouse_id = (int) Yii::app()->user->user_warehouse_id;
                            $modelWarehouse = new MasInventoryWarehouse();
                             
                            $modelWarehouse = $modelWarehouse->findByPk($user_warehouse_id);
                            
                            $current_serial_no = (int) $modelWarehouse->creditnote_current_series_no;
                            $start_series_no = (int) $modelWarehouse->creditnote_start_series_no;
                            
                            if($current_serial_no > 0){
                                $creditnote_current_series_no = $current_serial_no + 1;
                            }
                            else{
                                $creditnote_current_series_no = $start_series_no;
                            }
                            $modelCreditNote = new Creditnote();
                            $modelCreditNote->updateByPk($transaction_id, array('creditnote_no'=>$creditnote_current_series_no));
                            $modelWarehouse = new MasInventoryWarehouse();
                            $modelWarehouse->updateByPk($user_warehouse_id, array('creditnote_current_series_no'=>$creditnote_current_series_no));*/
                        //end

                    }
                    
                    
                
                    $randomBatch = $checkin_status.rand(100,10000);
        			if(!empty($modelStockLedger)){
        				foreach ($modelStockLedger as $eachItem) {
        				    $arr_product_details = Store::model()->findbyPk($eachItem->product_id);
        				    $existing_store_rate = $arr_product_details->rate;
        				    if($checkin_status=='IGR' || $checkin_status=='PGR'){//Inventory Goods Receipt and Production Goods receipt
        				        
        				        
        				        $rate = $existing_store_rate;
                                $existing_qty = $arr_product_details->totalQuantity;
        
                                $new_cost_price = $eachItem->cost_price * $eachItem->quantity;
                                $new_cost_price = round($new_cost_price, 6);
                                if((int) $eachItem->unit_factor==0){
                                    $eachItem->unit_factor=1;
                                }
                                $quantity_with_unit_factor = $eachItem->quantity * $eachItem->unit_factor;
                                $variance_value = ($quantity_with_unit_factor > 0) ? $new_cost_price / $quantity_with_unit_factor : 0;
                                $variance_value = round($variance_value, 6);
                                $cost_with_variance = $variance_value;
        
                                $cur_total = $cost_with_variance * $quantity_with_unit_factor;
                                $existing_amount = $rate * $existing_qty;
                                $total_quantity = $existing_qty + $quantity_with_unit_factor;
                                $total_amount = $existing_amount + $cur_total;
                                $new_amount = ($total_quantity > 0) ? $total_amount / $total_quantity : $existing_store_rate;
                                $new_amount = round($new_amount, 6);
        				        
        				        $eachItem->cost_price = $new_amount;
        				        
        				        Store::model()->updateByPk($eachItem->product_id, array('rate' => $new_amount));
        				        
        				        
        				    }
        				    else if($checkin_status=='DTCK'){
        				        $SQL = "UPDATE erp_stock_ledger SET stock_updated='Y' WHERE header_id=".$eachItem->header_id." AND header_item_id=".$eachItem->header_item_id." AND product_id=".$eachItem->product_id." AND transaction_from='TRANSFER_OUT'";
        				        //echo $SQL;
        				         Yii::app()->db->createCommand($SQL)->execute();
        				    }
        				    else{
        				        $eachItem->cost_price = $existing_store_rate;
        				    }
        					if(empty($eachItem->batch_no)){
        						$eachItem->batch_no  = $randomBatch;
        					}
        					$eachItem->save(false);
        					
        				
        				}
                    }
                    if($checkin_status=='CN'){
                        // ----------added-by-indhu-27-1-2023---------------------------
                            Yii::import('application.modules.accounts.controllers.PostingController');
                            $from='creditnote';
                            PostingController::DirectPost((int)$transaction_id,$from);
                          // ---------------------------------------------------------------
                    }
    			}
    			echo CJSON::encode( array( 'status' => 'success' ));
    		}
    		else{
 
    			$error2 = array();
    			$error4 = array();
    			$error1 = array();
    			if (!empty($modelStockLedger))
    				$error2 = json_decode(CActiveForm::validateTabular($modelStockLedger, '', false), true);
    			$error = CJSON::encode(array_merge_recursive($error1,$error2,$other));
    			if ($error != '[]'||$error!='')
    				echo $error;
    		}
    	}
    
    
    }
       public function ChanageDB($database = MasCompany::DB_ACE){
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $database;
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
    }
}