<?php

class BrandsalaryController extends Controller {

    //public $layout = 'main';
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array( 'Index', 'GetList','Create','SaveSalaryPercent','Edit','DeletebrandSalary','UpdateSalaryPercent','DeletePercent'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index');
    }
    public function actionGetList() {
        $model = new EmployeeBrandSalaryPercent();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.branch_or_sponsor_id',
            2 => 'employeedetail.employee_code',
            3 => 'employeedetail.first_name',
            4 => 'branddetail.product_class',
            5 => '',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition='1=1';
        if (isset($_POST['employee_id']) && $_POST['employee_id'] > 0) {
            $condition.= ' AND t.employee_id="' . $_POST['employee_id'] . '"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $searchString_en=$this->ciphertext($searchString,"e");
            $condition.=" and (employeedetail.employee_code LIKE '%".$searchString_en."%' OR employeedetail.first_name LIKE '%".$searchString_en."%' OR employeedetail.middle_name LIKE '%".$searchString_en."%' OR employeedetail.last_name LIKE '%".$searchString_en."%')";      
        
        }
        $count = $model->with('employeedetail')->count(array('condition' => $condition,'limit' => $limit, 'offset' => $offset, 'order' => $orderBy,'group'=>'employee_id'));
        $model = $model->with('employeedetail')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy,'group'=>'employee_id'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_brandsalary_edit']) || Yii::app()->user->authorised_user == 1) {
                $button_string.= '<button class="btn btn-primary btn-xs" title="Edit Brand Salary Percentage" onclick="loadPopupModal(\'brandsalary/edit&id=' . $row['employee_id'] . '\',\'Brand Salary Percentage\',\'lg\')"><i class="fa fa-edit"></i></button>&nbsp;';       
            }
            if (isset(Yii::app()->user->haveHrPermissionOn['hr_brandsalary_delete'])  || Yii::app()->user->authorised_user == 1) {                
                $button_string .=' <a href ="javascript:void(0);" class="btn btn-danger btn-xs" title="Delete" onclick="deletepercent(' . $row['employee_id'] . ')"><i class="fa fa-trash"></i></a>' ;                      
            }
            $employee_code=$this->ciphertext($row['employeedetail']['employee_code'], "d");
            $employee_name=$this->ciphertext($row['employeedetail']['first_name'], "d") . " " . $this->ciphertext($row['employeedetail']['last_name'], "d");
            $rowData[] = array($m,$employee_code,$employee_name,EmployeeBrandSalaryPercent::getbrandpercentage($row['employee_id']), $button_string);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate() {
        $model = array(new EmployeeBrandSalaryPercent());
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('create', array('model' => $model));
    }
    public function actionSaveSalaryPercent() {
        if (isset($_POST['EmployeeBrandSalaryPercent'])) {           
            $valid=true;
            date_default_timezone_set("Asia/Dubai");
            if ((isset($_POST['EmployeeBrandSalaryPercent']))){                   		
                foreach ($_POST['EmployeeBrandSalaryPercent'] as $i => $items) {
                    if($items['id']>0){
                        $model_percent[$i] =EmployeeBrandSalaryPercent::model()->findByPK($items['id']);      
                        $model_percent[$i]->updated_by= Yii::app()->user->id;
                        $model_percent[$i]->updated_datetime = date('Y-m-d h:i:s');
                        $model_percent[$i]->employee_id = $_POST['emply_id'];
                    }else{
                        $model_percent[$i] = new EmployeeBrandSalaryPercent();   
                        $model_percent[$i]->created_by= Yii::app()->user->id;
                        $model_percent[$i]->created_datetime = date('Y-m-d h:i:s');
                        $model_percent[$i]->employee_id = $items['employee_id'];
                    } 
                    $model_percent[$i]->brand_id = $items['brand_id'];
                    $model_percent[$i]->salary_percent = $items['salary_percent'];
                    $valid=$model_percent[$i]->validate() && $valid;
                }
            }else{
                $valid=false;
            }
            if($valid){             
                if (!empty($model_percent)) {
                    foreach ($model_percent as $eachModel) {
                        $eachModel->save();
                    }
                }       
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                Yii::app()->end();
            }else{                
                $error1=array();
                if (count($model_percent)>0){                    
                   $error1 = json_decode(CActiveForm::validateTabular($model_percent, '', false), true);
                }else{                    
                    $model_percent = array(new EmployeeBrandSalaryPercent());                   
                    $error1 = json_decode(CActiveForm::validateTabular($model_percent, '', false), true); 
                }
                $error = CJSON::encode($error1);
                if ($error != '[]')
                    echo $error;
            }
            
        }
    }	 
    public function actionEdit() {
        $employee_id = Yii::app()->request->getparam("id");
        $empdetail = Employee::model()->findByPk($employee_id);
        $employee_name=$this->ciphertext($empdetail->first_name, "d") . ' ' . $this->ciphertext($empdetail->middle_name, "d") . ' ' . $this->ciphertext($empdetail->last_name, "d");
        $model = EmployeeBrandSalaryPercent::model()->findAll(array('condition' =>'employee_id="'.$employee_id.'"','order'=>'id asc'));
        Yii::app()->clientScript->scriptMap = array('jquery.min.js' => false, 'jquery-ui-timepicker-addon.js' => false, 'jquery-ui.min.js' => false, 'jquery-ui-i18n.min.js' => false);
        $this->render('edit', array('employee_id' => $employee_id,'employee_name' => $employee_name,'model' => $model));
    }
    public function actionDeletebrandSalary(){
        $id = $_POST['id'];
        if($id>0){
            $model = new EmployeeBrandSalaryPercent();                
            $model->deleteByPk($id);
            $jsonData['status'] = 'success';
        }
        else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
    public function actionUpdateSalaryPercent() {
        if (isset($_POST['EmployeeBrandSalaryPercent'])) {           
            $valid=true;
            date_default_timezone_set("Asia/Dubai");
            if ((isset($_POST['EmployeeBrandSalaryPercent']))){                   		
                foreach ($_POST['EmployeeBrandSalaryPercent'] as $i => $items) {
                    if($items['id']>0){
                        $model_percent[$i] =EmployeeBrandSalaryPercent::model()->findByPK($items['id']);      
                        $model_percent[$i]->updated_by= Yii::app()->user->id;
                        $model_percent[$i]->updated_datetime = date('Y-m-d h:i:s');
                        $model_percent[$i]->employee_id = $_POST['emply_id'];
                    }else{
                        $model_percent[$i] = new EmployeeBrandSalaryPercent();   
                        $model_percent[$i]->created_by= Yii::app()->user->id;
                        $model_percent[$i]->created_datetime = date('Y-m-d h:i:s');
                        $model_percent[$i]->employee_id = $_POST['emply_id'];
                    } 
                    $model_percent[$i]->brand_id = $items['brand_id'];
                    $model_percent[$i]->salary_percent = $items['salary_percent'];
                    $valid=$model_percent[$i]->validate() && $valid;
                }
            }else{
                $valid=false;
            }
            if($valid){             
                if (!empty($model_percent)) {
                    foreach ($model_percent as $eachModel) {
                        $eachModel->save();
                    }
                }       
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
                Yii::app()->end();
            }else{                
                $error1=array();
                if (count($model_percent)>0){                    
                   $error1 = json_decode(CActiveForm::validateTabular($model_percent, '', false), true);
                }else{                    
                    $model_percent = array(new EmployeeBrandSalaryPercent());                   
                    $error1 = json_decode(CActiveForm::validateTabular($model_percent, '', false), true); 
                }
                $error = CJSON::encode($error1);
                if ($error != '[]')
                    echo $error;
            }
            
        }
    }	 
    public function actionDeletePercent(){
        $id = $_POST['id'];
        if($id>0){
            EmployeeBrandSalaryPercent::model()->deleteAll('employee_id=:refer_id', array(':refer_id' => $id));
            $jsonData['status'] = 'success';
        }
        else{
           $jsonData['status'] = 'error';
        }
        echo CJSON::encode($jsonData);
    }
}
