<?php
class BankController extends Controller
{
    public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','DisableBank','SaveBank','GetBankList','DirectAdd','SaveBankUploadCsv','Uploadbank','UploadEmployeecsv',
                    'DownloadSampleCsv','readBankCSV','DownloadErrorCsv'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    
    public function filters()
    {
        return array(
        'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['bank_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['bank_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
    }
    public function actionGetBankList()
    {
        $model=new MasBank();
        $draw    = $_POST['draw'];
        $offset = $_POST['start'];
        $limit  = $_POST['length'];
        $columns = array(
            0 =>'id',
            1 =>'bank_name',
            2 =>'bank_code',
            3 =>'routing_code',
            4 =>'isDefault',
            5 =>'' // for action buttons
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy   = $filterColumn." ".$filterOrder;
        // $condition = 't.isActive="Y"';
        if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
        {
            $condition = "1=1 ";
            $searchString = $_POST['search']['value'];
          $condition.=" and (bank_name LIKE '%".$searchString."%' OR bank_code LIKE '%".$searchString."%' OR t.routing_code LIKE '%".$searchString."%' )";
        }
        $count = $model->count(array('condition'=>$condition));
        $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>'bank_name ASC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData=array();
        $m=1;
        foreach ($model as $row)
        {
            $button_string="";
                if(isset(Yii::app()->user->havePermissionOn['bank_edit']) ||  Yii::app()->user->authorised_user == 1)
                {
                    //$button_string = '<button class="btn btn-primary btn-xs" title="Edit" onclick="loadPopupModal(\'bank/create&id='.$row['id'].'\',\'Edit Bank \',\'lg\')"><i class="fa fa-edit"></i></button>';
                }
                if(isset(Yii::app()->user->havePermissionOn['bank_delete']) ||  Yii::app()->user->authorised_user == 1)
                {
                //    $button_string .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteBank('.$row['id'].')"><i class="fa fa-trash-o "></i></a></div>';
                }

                $rowData[] = array(
                    $m,
                    $row['bank_name'],
                    $row['bank_code'],
                    $row['routing_code'],
                    $row['isDefault'], // <-- NEW COLUMN
                    array('id' => $row['id'], 'code' => $row['bank_name'], 'isActive' => $row['isActive']),
                    $button_string
                );

            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionCreate()
    {
        $model=new MasBank(); 
        $id=(int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
                   
            
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('bank_form', array('model' => $model), false, true);
    }
    public function actionSaveBank()
    {
        $model = new MasBank();
        if (isset($_POST['MasBank']))
        {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime =date('Y-m-d h:i:s');

            if ((int) @$_POST['MasBank']['id'] > 0)
            {
                $id= (int) @$_POST['MasBank']['id'];
                $model=$model->findByPk($id); 
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime =date('Y-m-d h:i:s');
                $audit_type = 'UPDATED';
            }else{
                $audit_type = 'CREATED';
            }
            if($_POST['MasBank']['isDefault'] == "Y"){
                MasBank::model()->updateAll(array( 'isDefault' => 'N' ), 'isDefault = "Y"' );
            }
            $model->attributes=$_POST['MasBank'];
            $model->isDefault=$_POST['MasBank']['isDefault'];

            if($model->save())
            {       
                    // inserting to audit log
                    AuditLog::saveAuditLogs(
                        'BANK',
                        Yii::app()->user->id,
                        $audit_type,
                        " with name: - {$model->bank_name}  "
                    );
                    // end audit log 
                    $jsonData['status'] = 'success';
                    $jsonData['frm'] = $_POST['bank_form'];
                    $jsonData['id'] = $model->id;
                    echo CJSON::encode($jsonData);
                   // $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('index'));
            }
            else
            {
                    $error = CActiveForm::validate($model, '', false);
                    if ($error != '[]')
                           echo $error;
            }
           // $this->render('bank_form', array('model' => $model), false, true);

        }
    }
    public function actionDisableBank()
    {
        date_default_timezone_set("Asia/Dubai");
        $id = $_POST['id'];
        //$model_c = Customer::model()->findAll(array('condition'=>'customer_bank_id='.$id.''));
        //$model_v = Vendor::model()->findAll(array('condition'=>'vendor_bank_name='.$id.''));
        //if(empty($model_c) && empty($model_v)){
        if(!empty($id))  {
            $model=new MasBank();
            $model=$model->findByPk($id);
            if($model->isActive=='N'){
                $model->isActive='Y';
            }else{
                $model->isActive = 'N';            
            }           
            $model->updated_by = Yii::app()->user->id;
            $model->updated_datetime =date('Y-m-d h:i:s');
            $model->save(FALSE);
            echo "success";
        }
        else{
              echo "fail";
        }
              
    }
    public function actionDirectAdd(){
       $from = $_POST['from'];
       $name = $_POST['name'];
       $status =  array();
       $drop = '';
       if($name != ''){
           $modelBank = new MasBank;
           $modelBank->bank_name = $name;
           if($modelBank->save()){
                $status['status']= "success";
                $data  = MasBank::getBanks();
                if($from == 'vendor'){
                    $model = new Vendor;
                    $field_name = 'vendor_bank_name';
                }
                $model->$field_name = $modelBank->id;
                $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Bank'));  
                $status['drop']= $drop;
                echo CJSON::encode($status); 
           }else{
                $error = CActiveForm::validate($modelBank, '', false);
                    if ($error != '[]')
                           echo $error;
           }
       }
    }   
    public function actionUploadbank(){
        //added by nisha on 28-02-2023
        $model=new MasBank();
        // Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('upload_bank', array('model' => $model), false, true);
    }
    public function actionSaveBankUploadCsv() {
        $file_name = Yii::app()->request->getParam('filename');
        $url = Yii::app()->basePath . '/../uploads/bank_csv/' . $file_name;
        $error_url = Yii::app()->basePath . '/../uploads/bank_csv/error/' . $file_name;
    
        if (!file_exists($url)) {
            echo CJSON::encode([
                'status' => 'error',
                'message' => 'Uploaded CSV file not found: ' . $file_name
            ]);
            return;
        }
    
        $bank_list = $this->readBankCSV("uploads/bank_csv/" . $file_name);
        if (empty($bank_list) || count($bank_list) < 2) {
            echo CJSON::encode([
                'status' => 'error',
                'message' => 'CSV file is empty or missing header.'
            ]);
            return;
        }
    
        $validate = true;
        $error_list = array();
        $bank_error_names = array();
        $bank_models = array();
    
        foreach (array_slice($bank_list, 1) as $i => $data) {
            if (!empty($data[0])) {
                $bank_models[$i] = new MasBank();
                $bank_models[$i]->scenario = "excelupload";
    
                $bank_models[$i]->bank_name = isset($data[0]) ? trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data[0])) : '';
                $bank_models[$i]->bank_code = isset($data[1]) ? trim($data[1]) : '';
                $bank_models[$i]->routing_code = isset($data[2]) ? trim($data[2]) : '';
                $bank_models[$i]->isActive = 'Y';
                $bank_models[$i]->created_by = Yii::app()->user->id;
                $bank_models[$i]->created_datetime = date('Y-m-d h:i:s');
                $bank_error_names[$i] = $bank_models[$i]->bank_name;
                $bank_models[$i]->isDefault = 'N';
                $validate = $bank_models[$i]->validate() && $validate;
            }
        }
    
        // Duplicate check on bank_name
        function array_not_unique($raw_array) {
            $dupes = array();
            natcasesort($raw_array);
            reset($raw_array);
            $old_key = null;
            $old_value = null;
            foreach ($raw_array as $key => $value) {
                if ($value === null) continue;
                if ($old_value !== null && strcasecmp($old_value, $value) === 0) {
                    $dupes[$old_key] = $old_value;
                    $dupes[$key] = $value;
                }
                $old_value = $value;
                $old_key = $key;
            }
            return $dupes;
        }
    
        $ban_common = array_not_unique($bank_error_names);
    
        if ($validate) {
            foreach ($bank_models as $eachModel) {
                $eachModel->save();
            }
            $jsonData['error'] = "";
        } else {
            foreach ($bank_models as $s => $data_model) {
                $error_list[$s]['bank_name'] = $data_model->bank_name;
                $error_list[$s]['bank_code'] = $data_model->bank_code;
                $error_list[$s]['routing_code'] = $data_model->routing_code;
                $error_list[$s]['errors'] = [];
    
                if (!$data_model->validate()) {
                    foreach ($data_model->getErrors() as $field => $messages) {
                        foreach ($messages as $msg) {
                            $error_list[$s]['errors'][] = "$field: $msg";
                        }
                    }
                }
            }
        }
    
        // Write error file if needed
        if (!empty($error_list)) {
            $file_error = fopen($error_url, "w+");
            fputcsv($file_error, ['Bank Name*', 'Bank Code*', 'Routing Code*', 'Errors']);
    
            foreach ($error_list as $i => $error_detail) {
                $error_message = implode(" / ", $error_detail['errors']);
                if (in_array($error_detail['bank_name'], $ban_common)) {
                    $error_message .= " / Duplicate bank name in CSV";
                }
                fputcsv($file_error, [
                    $error_detail['bank_name'],
                    $error_detail['bank_code'],
                    $error_detail['routing_code'],
                    $error_message
                ]);
            }
            fclose($file_error);
        }
    
        $jsonData['status'] = "success";
        $jsonData['error_url'] = $error_url;
        $jsonData['filename'] = $file_name;
        $jsonData['link'] = CHtml::link('Download log', array('bank/DownloadErrorCsv', 'id' => $file_name), array(
            'target' => '_blank',
            'style' => 'border: 1px solid #686869;padding: 2px 10px;border-radius: 10px;font-size: 10px;background: #a1a1a1;color: #fff;'
        ));
    
        echo CJSON::encode($jsonData);
    }
    
    public function actionDownloadSampleCsv()
    {
        $filename = 'banklisttemplate.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        echo 'Bank Name*,Bank Code*,Routing Code*';
        Yii::app()->end();
    }
    public function readBankCSV($csvFile)
    {
        $file_handle = fopen($csvFile, 'r');
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            $line_of_text[] = $contents;
        }
        fclose($file_handle);
        return $line_of_text;
    }
    public function actionDownloadErrorCsv() {
        $file_name = $event_id = Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../uploads/bank_csv/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('log.csv', @file_get_contents($error_url));
    }
}