<?php
//created by nisha on 21-09-2022
class AutoproductionController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('CreateAutoProductionOrder','SaveAutoProductionOrder'),/**modified and editted by jisha on 08-11-17**/
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionCreateAutoProductionOrder() {
        $id = (int) Yii::app()->request->getParam('id');
        $modelProductionOrder = new ProductionOrder();
        $modelProductionOrderItem   =   array(new ProductionOrderItem());
        
        $modelBillofMaterial        =   new ProductionBillofmaterial();
        $modelBillofMaterial        =   $modelBillofMaterial->findByPk($id);
        $modelProductionOrder->billofmaterial_id = $id;
        $modelProductionOrder->quantity = $modelBillofMaterial->quantity;
        $modelBillofMaterialItems = ProductionBillofmaterialItem::model()->findAll(array('condition'=>'production_billofmaterial_id = '.$id));
        if(empty($modelBillofMaterialItems)){
            $modelProductionOrderItem = array(new ProductionOrderItem());
        }
        else{
            foreach($modelBillofMaterialItems as $i=>$eachBOMItem){
                    
                    $modelProductionOrderItem[$i] = new ProductionOrderItem();
                    $modelProductionOrderItem[$i]->product_id           = $eachBOMItem->product_id;
                    $modelProductionOrderItem[$i]->product_name         = $eachBOMItem->product_name;
                    $modelProductionOrderItem[$i]->description          = $eachBOMItem->description;
                    $modelProductionOrderItem[$i]->quantity             = (float) ($eachBOMItem->quantity * $modelProductionOrder->quantity);
                   // echo"tesr=".$modelProductionOrderItem[$i]->quantity;
                    $modelProductionOrderItem[$i]->bom_qty              = $eachBOMItem->quantity;
            }
        }
        
       
        $modelStore = new Store();
        $modelStore = $modelStore->findByPk((int) $modelBillofMaterial->product_id);
        $total_free_qty         = (float) $modelStore->totalQuantity;
        $total_allocated_qty    = (float) $modelStore->total_allocated_quantity;
        $total_available_qty    = $total_free_qty - $total_allocated_qty;
        //$modelProductionOrder->product_id = $modelBillofMaterial->product_id;
        $this->render('auto_product_order',array('modelProductionOrder'=>$modelProductionOrder,'modelProductionOrderItem'=>$modelProductionOrderItem,'total_available_qty'=>$total_available_qty));
    }
    public function actionSaveAutoProductionOrder() {
        $modelProductionOrder = new ProductionOrder();
        $modelProductionOrderItem = array(new ProductionOrderItem());
        $valid=true;
        $qty_error=array();
        if (isset($_POST['ProductionOrder'])) {
            if((int) @$_POST['ProductionOrder']['billofmaterial_id'] > 0){
                
                $bom_id = (int) @$_POST['ProductionOrder']['billofmaterial_id'];
                $production_qty = $_POST['ProductionOrder']['quantity'];
                $modelBillofMaterial        =   new ProductionBillofmaterial();
                $modelBillofMaterialItems   =   array(new ProductionBillofmaterialItem());
                
                $modelBillofMaterial        =   $modelBillofMaterial->findByPk($bom_id);
                
                $modelProductionOrder->billofmaterial_id    = $bom_id;
                $modelProductionOrder->product_id           = $modelBillofMaterial->product_id;
                $modelProductionOrder->description          = $modelBillofMaterial->description;
                $modelProductionOrder->quantity             = $production_qty;
                $modelProductionOrder->unit                 = $modelBillofMaterial->unit;
                $modelProductionOrder->file_id              = $modelBillofMaterial->file_id;
                $modelProductionOrder->productionorder_date = date('Y-m-d');
                $modelProductionOrder->end_date             = date('Y-m-d');
                $modelProductionOrder->customer_id          = 0;
                $modelProductionOrder->variance             = 0;
                $modelProductionOrder->vendor_id            = 0;
                $modelProductionOrder->notes                = $modelBillofMaterial->notes;
                $modelProductionOrder->remarks              = $modelBillofMaterial->remarks;
                $modelProductionOrder->terms_and_conditions = $modelBillofMaterial->terms_and_conditions;
                $modelProductionOrder->reference            = '';
                $modelProductionOrder->connected_file       = 0;
                $modelProductionOrder->grand_total          = 0;
                $modelProductionOrder->project              = 0;
                $modelProductionOrder->goods_issue_status   = "C";
                $modelProductionOrder->po_row               = 0;
                $modelProductionOrder->crm_user_id          = Yii::app()->user->id;
                $modelProductionOrder->created_by           = Yii::app()->user->id;
                $modelProductionOrder->created_datetime     = date('Y-m-d h:i:s');
                $modelProductionOrder->updated_by           = 0;
                $modelProductionOrder->created_datetime     = '0000-00-00 00:00:00';
                
                
                $modelBillofMaterialItems = ProductionBillofmaterialItem::model()->findAll(array('condition'=>'production_billofmaterial_id = '.$bom_id));
                if(empty($modelBillofMaterialItems)){
                    $modelBillofMaterialItems = array(new ProductionBillofmaterialItem());
                }
                
                
                foreach($modelBillofMaterialItems as $i=>$eachBOMItem){
                    
                    $modelProductionOrderItem[$i] = new ProductionOrderItem();
                    $modelProductionOrderItem[$i]->production_order_id  = 0;
                    $modelProductionOrderItem[$i]->bom_item_id          = $eachBOMItem->id;
                    $modelProductionOrderItem[$i]->product_id           = $eachBOMItem->product_id;
                    $modelProductionOrderItem[$i]->product_name         = $eachBOMItem->product_name;
                    $modelProductionOrderItem[$i]->description          = $eachBOMItem->description;
                    $modelProductionOrderItem[$i]->unit                 = $eachBOMItem->unit;
                    $modelProductionOrderItem[$i]->quantity             = ($eachBOMItem->quantity * $production_qty);
                    $modelProductionOrderItem[$i]->bom_qty              = $eachBOMItem->quantity;
                    $modelProductionOrderItem[$i]->amount               = 0;
                    $modelProductionOrderItem[$i]->created_by           = Yii::app()->user->id;
                    $modelProductionOrderItem[$i]->created_datetime     = date('Y-m-d h:i:s');
                    $modelProductionOrderItem[$i]->updated_by           = 0;
                    $modelProductionOrderItem[$i]->updated_datetime     = '0000-00-00 00:00:00';
                    
                    $modelStore = new Store();
                    $modelStore = $modelStore->findByPk((int) $eachBOMItem->product_id);
                    
                    $total_free_qty         = (float) $modelStore->totalQuantity;
                    $total_allocated_qty    = (float) $modelStore->total_allocated_quantity;
                    
                    $total_available_qty    = $total_free_qty - $total_allocated_qty;
                    
                    if($modelProductionOrderItem[$i]->quantity > $total_available_qty){
                        $qty_error[]=$eachBOMItem->product_name.' maximum sellable qty : '.($total_available_qty);
                        $valid=false;
                    }
                    
                    $i++;
                }
            }
        }
        
       /* echo '<pre>';
        print_r($modelProductionOrderItem);
        exit;*/
                
        $cost_rate=0;    
        if($valid){
            
            //Save to production order
            $modelProductionOrder->save();
            
            //save data into goods issue
            $modelProductionGoodsIssue = new ProductionGoodsIssue();
            $modelProductionGoodsIssue->crm_user_id          = Yii::app()->user->id;;
            $modelProductionGoodsIssue->production_order_id  = $modelProductionOrder->id;
            $modelProductionGoodsIssue->goods_issue_date     = date('Y-m-d');
            $modelProductionGoodsIssue->file_id              = 0;
            $modelProductionGoodsIssue->notes                = $modelBillofMaterial->notes;
            $modelProductionGoodsIssue->remarks              = $modelBillofMaterial->remarks;
            $modelProductionGoodsIssue->terms_and_conditions = $modelBillofMaterial->terms_and_conditions;
            $modelProductionGoodsIssue->isActive             = 'Y';
            $modelProductionGoodsIssue->product_id           = $modelBillofMaterial->product_id;
            $modelProductionGoodsIssue->description          = $modelBillofMaterial->description;
            $modelProductionGoodsIssue->quantity             = $production_qty;
            $modelProductionGoodsIssue->reference            = '';
            $modelProductionGoodsIssue->customer_id          = 0;
            $modelProductionGoodsIssue->connected_file       = 0;
            $modelProductionGoodsIssue->project              = 0;
            $modelProductionGoodsIssue->grand_total          = 0;
            $modelProductionGoodsIssue->is_goods_issued      = 'Y';
            $modelProductionGoodsIssue->status               = 'CM';
            $modelProductionGoodsIssue->created_by           = Yii::app()->user->id;
            $modelProductionGoodsIssue->created_datetime     = date('Y-m-d h:i:s');;
            $modelProductionGoodsIssue->updated_by           = Yii::app()->user->id;
            $modelProductionGoodsIssue->updated_datetime     = "0000-00-00 00:00:00";
            $modelProductionGoodsIssue->save(false);
            //end
            
          
            
            
            
            foreach($modelProductionOrderItem as $j=>$eachItem){
                
                //save data into production order item
                $eachItem->production_order_id = $modelProductionOrder->id;
                $eachItem->save(false);
                //end
                
                //save data into goods issue item
                $modelProductionGoodsIssueItem = new ProductionGoodsIssueItem();
                $modelProductionGoodsIssueItem->production_goods_issue_id = $modelProductionGoodsIssue->id;
                $modelProductionGoodsIssueItem->po_item_id                = $eachItem->id;
                $modelProductionGoodsIssueItem->product_id               = $eachItem->product_id;
                $modelProductionGoodsIssueItem->product_name             = $eachItem->product_name;
                $modelProductionGoodsIssueItem->description              = $eachItem->description;
                $modelProductionGoodsIssueItem->quantity                 = $eachItem->quantity;
                $modelProductionGoodsIssueItem->picked_qty               = $eachItem->quantity;
                $modelProductionGoodsIssueItem->unit                     = $eachItem->unit; 
                $modelProductionGoodsIssueItem->rate                     = 0;
                $modelProductionGoodsIssueItem->amount                   = 0;
                $modelProductionGoodsIssueItem->created_by               = Yii::app()->user->id; 
                $modelProductionGoodsIssueItem->created_datetime        = date("Y-m-d H:i:s");
                $modelProductionGoodsIssueItem->save(false);
                //end
                
                
                //save data into stock ledger for goods issue
                $modelStore = new Store();
                $modelStore = $modelStore->findByPk((int) $eachItem->product_id);
                
                $modelUOM   = new UnitOfMeasurement();
                $arr_uom    = $modelUOM->findByPk((int) $eachItem->unit);
                
                $modelIssueStockLedger                         =   new StockLedger();
                $modelIssueStockLedger->file_id                =   $modelBillofMaterial->file_id;   
                $modelIssueStockLedger->header_id              =   $modelProductionGoodsIssue->id;   
                $modelIssueStockLedger->header_item_id         =   $modelProductionGoodsIssueItem->id;  
                $modelIssueStockLedger->customer_vendor_id     =   0;
                $modelIssueStockLedger->customer_vendor_name   =   '';  
                $modelIssueStockLedger->product_id             =   $eachItem->product_id;
                $modelIssueStockLedger->product_name           =   $eachItem->product_name;  
                $modelIssueStockLedger->product_description    =   $eachItem->description;
                $modelIssueStockLedger->brand_id               =   $modelStore->brand_class_id;  
                $modelIssueStockLedger->brand_name             =   $modelStore->brand_detail->product_class;
                $modelIssueStockLedger->warehouse_id           =   $modelStore->warehouse_id;  
                $modelIssueStockLedger->warehouse_name         =   MasInventoryWarehouse::getWarehouseName($modelStore->warehouse_id);
                $modelIssueStockLedger->rack_id                =   $modelStore->rack_id;  
                $modelIssueStockLedger->rack_name              =   MasInvRack::getRackName($modelStore->rack_id);
                $modelIssueStockLedger->bin_id                 =   $modelStore->bin_id;  
                $modelIssueStockLedger->bin_name               =   MasInvBin::getBinName($modelStore->bin_id);
                $modelIssueStockLedger->unit_id                =   $eachItem->unit;  
                $modelIssueStockLedger->unit_name              =   $arr_uom->name;
                $modelIssueStockLedger->unit_factor            =   abs($arr_uom->factor);  
                $modelIssueStockLedger->quantity               =   (-1 * $eachItem->quantity);
                $modelIssueStockLedger->available_status       =   'U';
                $modelIssueStockLedger->batch_no               =   '';  
                $modelIssueStockLedger->serial_no              =   '';
                $modelIssueStockLedger->manufacturing_date     =   '0000-00-00';  
                $modelIssueStockLedger->expiry_date            =   '0000-00-00';
                $modelIssueStockLedger->cost_price             =   $modelStore->rate;  
                $modelIssueStockLedger->sales_price            =   0;
                $modelIssueStockLedger->transaction_date       =   date('Y-m-d');;
                $modelIssueStockLedger->transaction_from       =   'PRODUCTION_GOODS_ISSUE';
                $modelIssueStockLedger->transaction_type       =   "OUT";
                $modelIssueStockLedger->created_by             =   Yii::app()->user->id;
                $modelIssueStockLedger->created_date           =   date("Y-m-d H:i:s");     
                $modelIssueStockLedger->master_stock_ledger_id =   0;
                $modelIssueStockLedger->save(false);    
                //end
                
                 $cost_rate+=($eachItem->bom_qty * $modelStore->rate); 
                
            }
            
            
             $modelProductionStore              = new Store();
             $modelProductionStore              = $modelProductionStore->findByPk((int) $modelBillofMaterial->product_id);
             
             $production_item_exist_qty         = (float) $modelProductionStore->totalQuantity;
             $production_item_exist_rate        = $modelProductionStore->rate;
             
             $production_item_rate = $cost_rate * $production_qty;
             //echo "production_item_rate=".$production_item_rate."<br>";
             $production_item_old_rate = $production_item_exist_rate*$production_item_exist_qty;
             //echo "production_item_old_rate=".$production_item_old_rate."<br>";
             
             $production_total_qty = $production_item_exist_qty + $production_qty;
             //echo "production_total_qty=".$production_total_qty."<br>fgfg=";
             $new_production_rate = (($production_item_rate+$production_item_old_rate)/$production_total_qty);
             $new_production_rate = round($new_production_rate,6);
             //echo $new_production_rate;
             //exit;
            
            
            
            
            //save data into goods receipt
            $modelProductionGoodsReceipt = new ProductionGoodsReceipt();
            $modelProductionGoodsReceipt->crm_user_id          = Yii::app()->user->id;;
            $modelProductionGoodsReceipt->production_order_id  = $modelProductionOrder->id;
            $modelProductionGoodsReceipt->goods_receipt_date   = date('Y-m-d');
            $modelProductionGoodsReceipt->product_id           = $modelBillofMaterial->product_id;
            $modelProductionGoodsReceipt->product_name         = $modelBillofMaterial->part_number;
            $modelProductionGoodsReceipt->description          = $modelBillofMaterial->description;
            $modelProductionGoodsReceipt->quantity             = $production_qty;
            $modelProductionGoodsReceipt->file_id              = 0;
            $modelProductionGoodsReceipt->notes                = $modelBillofMaterial->notes;
            $modelProductionGoodsReceipt->remarks              = $modelBillofMaterial->remarks;
            $modelProductionGoodsReceipt->terms_and_conditions = $modelBillofMaterial->terms_and_conditions;
            $modelProductionGoodsReceipt->isActive             = 'Y';
            $modelProductionGoodsReceipt->reference            = '';
            $modelProductionGoodsReceipt->customer_id          = 0;
            $modelProductionGoodsReceipt->variants              = 0;
            $modelProductionGoodsReceipt->grand_total          = 0;
            $modelProductionGoodsReceipt->is_updated_store     = 'Y';
            $modelProductionGoodsReceipt->created_by           = Yii::app()->user->id;
            $modelProductionGoodsReceipt->created_datetime     = date('Y-m-d h:i:s');;
            $modelProductionGoodsReceipt->updated_by           = Yii::app()->user->id;
            $modelProductionGoodsReceipt->updated_datetime     = "0000-00-00 00:00:00";
            $modelProductionGoodsReceipt->save(false);
            
            //end
            
            //save data into goods receipt item
            $modelProductionGoodsReceiptItem = new ProductionGoodsReceiptItem();
            $modelProductionGoodsReceiptItem->production_goods_receipt_id = $modelProductionGoodsReceipt->id;
            $modelProductionGoodsReceiptItem->po_id                     = $modelProductionOrder->id;
            $modelProductionGoodsReceiptItem->product_id               = $modelBillofMaterial->product_id;
            $modelProductionGoodsReceiptItem->product_name             = $modelBillofMaterial->part_number;
            $modelProductionGoodsReceiptItem->description              = $modelBillofMaterial->description;
            $modelProductionGoodsReceiptItem->quantity                  = $production_qty;
            $modelProductionGoodsReceiptItem->unit                     = $modelBillofMaterial->unit; 
            $modelProductionGoodsReceiptItem->rate                     = $new_production_rate;
            $modelProductionGoodsReceiptItem->amount                   = ($new_production_rate * $production_qty);
            $modelProductionGoodsReceiptItem->created_by               = Yii::app()->user->id; 
            $modelProductionGoodsReceiptItem->created_datetime        = date("Y-m-d H:i:s");
            $modelProductionGoodsReceiptItem->save(false);
            //end
            
             //save data into stock ledger for goods issue
                $modelStore = new Store();
                $modelStore = $modelStore->findByPk((int) $modelBillofMaterial->product_id);
                
                $modelUOM   = new UnitOfMeasurement();
                $arr_uom    = $modelUOM->findByPk((int) $eachItem->unit);
                
                $modelReceiptStockLedger                         =   new StockLedger();
                $modelReceiptStockLedger->file_id                =   $modelBillofMaterial->file_id;   
                $modelReceiptStockLedger->header_id              =   $modelProductionGoodsReceipt->id;   
                $modelReceiptStockLedger->header_item_id         =   $modelProductionGoodsReceiptItem->id;  
                $modelReceiptStockLedger->customer_vendor_id     =   0;
                $modelReceiptStockLedger->customer_vendor_name   =   '';  
                $modelReceiptStockLedger->product_id             =   (int) $modelBillofMaterial->product_id;
                $modelReceiptStockLedger->product_name           =   $modelBillofMaterial->part_number;  
                $modelReceiptStockLedger->product_description    =   $modelBillofMaterial->description;
                $modelReceiptStockLedger->brand_id               =   $modelStore->brand_class_id;  
                $modelReceiptStockLedger->brand_name             =   $modelStore->brand_detail->product_class;
                $modelReceiptStockLedger->warehouse_id           =   $modelStore->warehouse_id;  
                $modelReceiptStockLedger->warehouse_name         =   MasInventoryWarehouse::getWarehouseName($modelStore->warehouse_id);
                $modelReceiptStockLedger->rack_id                =   $modelStore->rack_id;  
                $modelReceiptStockLedger->rack_name              =   MasInvRack::getRackName($modelStore->rack_id);
                $modelReceiptStockLedger->bin_id                 =   $modelStore->bin_id;  
                $modelReceiptStockLedger->bin_name               =   MasInvBin::getBinName($modelStore->bin_id);
                $modelReceiptStockLedger->unit_id                =   $modelBillofMaterial->unit;  
                $modelReceiptStockLedger->unit_name              =   $arr_uom->name;
                $modelReceiptStockLedger->unit_factor            =   abs($arr_uom->factor);  
                $modelReceiptStockLedger->quantity               =   $production_qty;
                $modelReceiptStockLedger->available_status       =   'A';
                $modelReceiptStockLedger->batch_no               =   '';  
                $modelReceiptStockLedger->serial_no              =   '';
                $modelReceiptStockLedger->manufacturing_date     =   '0000-00-00';  
                $modelReceiptStockLedger->expiry_date            =   '0000-00-00';
                $modelReceiptStockLedger->cost_price             =   $new_production_rate;  
                $modelReceiptStockLedger->sales_price            =   0;
                $modelReceiptStockLedger->transaction_date       =   date('Y-m-d');;
                $modelReceiptStockLedger->transaction_from       =   'PRODUCTION_GOODS_RECEIPT';
                $modelReceiptStockLedger->transaction_type       =   "IN";
                $modelReceiptStockLedger->created_by             =   Yii::app()->user->id;
                $modelReceiptStockLedger->created_date           =   date("Y-m-d H:i:s");     
                $modelReceiptStockLedger->master_stock_ledger_id =   0;
                $modelReceiptStockLedger->save(false);    
                //end
            
            
                $modelProductionStore=new Store();
                
                $modelProductionStore->updateByPK((int) $modelBillofMaterial->product_id, array('rate' =>$new_production_rate));
                
            
            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
            
            
        }
        else{
            
            $error = CJSON::encode($qty_error);    
            if ($error != '[]')
                echo $error;
        }
         
       
    }
   
    
}