<?php

class ApprovelevelController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('AddApprovelevel','loademployeedetails','listleveldetail','SaveApprovelevel','listdetaillevel','addsingleapprovelevel','SaveSameApprovelevel'
                    ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }	 
    public function actionAddApprovelevel() {
        $model = new Employee();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('approve_level', array('model' => $model), false, true);
    }
    public function actionloademployeedetails() {
        $branch =Yii::app()->request->getparam('branch'); 
        $functionality_id =Yii::app()->request->getparam('functionality_id'); 
        $department_id =Yii::app()->request->getparam('department_id'); 
        $condition='branch_or_sponsor_id="' . $branch . '" and isActive!="B"';
        if($department_id>0){
            $condition.=' AND department="' . $department_id . '"';
        }
        $model_employee = Employee::model()->findAll(array('condition' =>$condition));
        $arr_employee=array();
        foreach ($model_employee as $key => $value) {
            $arr_employee[$this->ciphertext($value['first_name'],"d").' '.$this->ciphertext($value['last_name'],"d")]=$value['id'];
        }
        ksort($arr_employee);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('employee_list', array('branch' => $branch,'functionality_id' => $functionality_id,'arr_employee'=>$arr_employee), false, true); 
    }
    public function actionlistleveldetail() {
        $max_level =Yii::app()->request->getparam('max_level'); 
        $functionality_id =Yii::app()->request->getparam('functionality_id'); 
        $employee_id =Yii::app()->request->getparam('employee_id'); 
        $row =Yii::app()->request->getparam('row'); 
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('level_list', array('max_level' => $max_level,'functionality_id' => $functionality_id,'employee_id'=>$employee_id,'row'=>$row), false, true); 
    }
    public function actionSaveApprovelevel() {
        if ((isset($_POST['HrEmployeeApproveLevel']))){
            $valid=true;
            foreach ($_POST['HrEmployeeApproveLevel'] as $i => $items) {
                if($items['id']>0){
                    $model_level[$i] = HrEmployeeApproveLevel::model()->findByPK($items['id']);  
                    $model_level[$i]->updated_by= Yii::app()->user->id;
                    $model_level[$i]->updated_date_time = date('Y-m-d H:i:s');
                }else{
                    $model_level[$i] = new HrEmployeeApproveLevel();   
                    $model_level[$i]->created_by= Yii::app()->user->id;
                    $model_level[$i]->created_date_time = date('Y-m-d H:i:s');
                }   
                $model_level[$i]->attributes = $_POST['HrEmployeeApproveLevel'][$i];   
                $valid=$model_level[$i]->validate() && $valid;                   
            }
            if($valid){
                if (!empty($model_level)) {
                    foreach ($model_level as $eachModel) {
                        $eachModel->save();

                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else{
                $error = CJSON::encode(json_decode(CActiveForm::validateTabular($model_level, '', false), true));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    public function actionlistdetaillevel() {
        $max_level =Yii::app()->request->getparam('max_level'); 
        $functionality_id =Yii::app()->request->getparam('functionality_id'); 
        $employee_id =Yii::app()->request->getparam('employee_id'); 
        $row =Yii::app()->request->getparam('row'); 
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('level_detail_list', array('max_level' => $max_level,'functionality_id' => $functionality_id,'employee_id'=>$employee_id,'row'=>$row), false, true); 
    }
    //Setting all employees to the same level
    public function actionaddsingleapprovelevel() {
        $model = new Employee();
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('same_approve_level', array('model' => $model), false, true);
    }
    public function actionSaveSameApprovelevel() {
        $branch = $_POST['branch_detail'];
        $functionality_id = $_POST['functionality_id'];
        $model_employee = Employee::model()->findAll(array('condition' => 'branch_or_sponsor_id="' . $branch . '"'));
        foreach ($model_employee as $key => $value) {
            $model_approved_level = HrEmployeeApproveLevel::model()->find(array('condition' => 'employee_id="'.$value->id. '" and functionality_id="'.$functionality_id.'"'));
            if($model_approved_level->id>0){
                $model_level = HrEmployeeApproveLevel::model()->findByPK($model_approved_level->id);  
                $model_level->updated_by= Yii::app()->user->id;
                $model_level->updated_date_time = date('Y-m-d H:i:s');
            }else{
                $model_level = new HrEmployeeApproveLevel();   
                $model_level->created_by= Yii::app()->user->id;
                $model_level->created_date_time = date('Y-m-d H:i:s');
            }
            $model_level->functionality_id = $_POST['functionality_id'];
            $model_level->employee_id = $value->id;
            $model_level->max_level = $_POST['max_level_id'];
            $model_level->level_1_type = $_POST['set_level_1'];
            $level_1=$_POST['set_level_1'];
            if($level_1=='L'){
                $model_level->level_1_authority = $value->reporting_manager;
            }else if($level_1=='S'){
                $model_level->level_1_authority = $value->attendance_manager;
            }else{
                $model_level->level_1_authority = $_POST['set_level_1_employee'];
            }
            $model_level->level_2_type = $_POST['set_level_2'];
            $level_2=$_POST['set_level_2'];
            if($level_2=='L'){
                $model_level->level_2_authority = $value->reporting_manager;
            }else if($level_2=='S'){
                $model_level->level_2_authority = $value->attendance_manager;
            }else{
                $model_level->level_2_authority = $_POST['set_level_2_employee'];
            }
            $model_level->level_3_type = $_POST['set_level_3'];
            $level_3=$_POST['set_level_3'];
            if($level_3=='L'){
                $model_level->level_3_authority = $value->reporting_manager;
            }else if($level_3=='S'){
                $model_level->level_3_authority = $value->attendance_manager;
            }else{
                $model_level->level_3_authority = $_POST['set_level_3_employee'];
            }
            $model_level->level_4_type = $_POST['set_level_4']; 
            $level_4=$_POST['set_level_4'];
            if($level_4=='L'){
                $model_level->level_4_authority = $value->reporting_manager;
            }else if($level_4=='S'){
                $model_level->level_4_authority = $value->attendance_manager;
            }else{
                $model_level->level_4_authority = $_POST['set_level_4_employee'];
            }
            $model_level->level_5_type = $_POST['set_level_5']; 
            $level_5=$_POST['set_level_5'];
            if($level_5=='L'){
                $model_level->level_5_authority = $value->reporting_manager;
            }else if($level_5=='S'){
                $model_level->level_5_authority = $value->attendance_manager;
            }else{
                $model_level->level_5_authority = $_POST['set_level_5_employee'];
            }
            $model_level->save();
        }
        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }
}
