<?php

class ApiprintController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('PrintInvoiceReportPDF'),
                'users' => array('*'),
            ),
//            array('allow', // allow authenticated user to perform 'create' and 'update' actions
//                'actions' => array(''),
//                'expression' => '$user->isMember()',
//            ),
            array('deny', // deny all users
            // 'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
         $this->ChangeDB();
        return parent::beforeAction($action);
    }

    public function actionPrintInvoiceReportPDF() {
        header("Content-Type:application/pdf");

// It will be called downloaded.pdf
      //  header("Content-Disposition:attachment;filename='downloaded.pdf'");
      //  header("Cache-control: private");
        $model = new DirectInvoice();
        $id = $this->ciphertext(Yii::app()->request->getParam('id'), "d");
        $c_id = Yii::app()->request->getParam('c_id');
        $frm = Yii::app()->request->getParam('frm');
        $type = Yii::app()->request->getParam('type');
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('direct_invoice', array('model' => $model, 'id' => $id, 'c_id' => $c_id, 'title' => $title, 'type' => $type), true));
        $mPDF1->Output($htmlTemplate, 'I');
    }

}
