<?php

class ApikitchenController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('orderlist'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(''),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
            // 'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
        if (isset($_SERVER['HTTP_TOKEN']) && $_SERVER['HTTP_TOKEN'] == $this->http_token) {
            return parent::beforeAction($action);
        } else {
            echo json_encode([
                "status" => false,
                "message" => "Invalid token"
            ]);
        }
    }

    public function actionOrderlist() {
        $k_id = Yii::app()->request->getParam('kitchen_id');
    }

}
