<?php

class ApidirectsalesController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('save'),
                'users' => array('*'),
            ),
//            array('allow', // allow authenticated user to perform 'create' and 'update' actions
//                'actions' => array(''),
//                'expression' => '$user->isMember()',
//            ),
            array('deny', // deny all users
            // 'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {

         $this->ChangeDB();
        return parent::beforeAction($action);
    }

    public function actionSave() {

        $data_array = json_decode(file_get_contents('php://input'), true);
        $modelDirectInvoice = new DirectInvoice;
        $others = array();
        $modelDirectInvoice->created_by = $data_array['user_id'];
        $modelDirectInvoice->created_datetime = date('Y-m-d H:i:s');
        $modelDirectInvoice->attributes = $data_array;
        $modelDirectInvoice->invoice_date = date('Y-m-d');
        $modelDirectInvoice->customer_id = 1003; // Cash Customer
        $modelDirectInvoice->contact_id = 3;
        $modelDirectInvoice->card_num = $data_array['card_num'];
        $modelDirectInvoice->payment_type = $data_array['payment_type'];
        $modelDirectInvoice->lead_owner_id = 3;
        $modelDirectInvoice->sales_group_id = 1;
        $modelDirectInvoice->exchange_rate = 1;
        $modelDirectInvoice->currency_id = 1;
        $grand_total = $total_tax = 0;
        $modelDirectInvoice->payment_terms = 1;
        $modelDirectInvoice->invoice_type = 1;
        $modelDirectInvoice->reference = $data_array['notes'];
        $modelDirectInvoice->phone = $data_array['phone_num'];
        $valid = $modelDirectInvoice->validate();

        foreach ($data_array['items'] as $i => $item) {
            $product = Store::model()->findByPk($item['id']);
            $modelDirectInvoiceItems[$i] = new DirectInvoiceItem;
            $modelDirectInvoiceItems[$i]->created_by = $data_array['user_id'];
            $modelDirectInvoiceItems[$i]->product_id = $item['id'];
            $modelDirectInvoiceItems[$i]->quantity = $item['qty'];
            $modelDirectInvoiceItems[$i]->part_no = $product->part_number;
            $modelDirectInvoiceItems[$i]->rate = $item['price'];
            $modelDirectInvoiceItems[$i]->created_datetime = date('Y-m-d H:i:s');
            $modelDirectInvoiceItems[$i]->attributes = $item;
            $modelDirectInvoiceItems[$i]->invoice_id = 0;
            $modelDirectInvoiceItems[$i]->description = $item['name'];
            $modelDirectInvoiceItems[$i]->amount = $item['price'] * $item['qty'];
            $modelDirectInvoiceItems[$i]->unit_id = $product->unit_id;
            $grand_total += $modelDirectInvoiceItems[$i]->amount;
            $total_tax += $item['tax_amount'];
            $valid = $modelDirectInvoiceItems[$i]->validate() && $valid;
        }
        $jsonData['status'] = false;
        $jsonData['key'] = "";
        $jsonData['erro_log'] = [];
        if ($valid && !empty($modelDirectInvoiceItems)) {
            if (!empty($modelDirectInvoiceItems)) {
                $modelDirectInvoice->save();
                foreach ($modelDirectInvoiceItems as $eachItem) {
                    $eachItem->invoice_id = $modelDirectInvoice->id;
                    $eachItem->save(false);
                    $total_vat_amount += $eachItem->tax_amount;
                }
            }
            $modelDirectInvoice->updateByPk($modelDirectInvoice->id, array('total_tax_amount' => $total_tax, 'grand_total' => ($grand_total + $total_tax)));
            $seatList = $data_array['seat'];
            foreach ($seatList as $seat) {
                $cond = " table_id =  {$seat['table_id']} AND seat_num = {$seat['id']}  AND is_billed ='N' ";
                $sql = "UPDATE erp_table_order set  is_billed= 'Y' , bill_id = {$modelDirectInvoice->id} where " . $cond;
                Yii::app()->db->createCommand($sql)->execute();
            }
            $jsonData['status'] = true;
            $jsonData['id'] = $modelDirectInvoice->id;
            $jsonData['key'] = $this->ciphertext($modelDirectInvoice->id, "e");
        } else {
            $error1 = $error2 = $error3 = $error4 = array();
            $error1 = json_decode(CActiveForm::validate($modelDirectInvoice, '', false), true);
            if (!empty($modelDirectInvoiceItems[0]->product_id)) {
                $error2 = json_decode(CActiveForm::validateTabular($modelDirectInvoiceItems, '', false), true);
            } else {
                $error2[] = "Please add atleast one line item";
            }
            $error = CJSON::encode(array_merge_recursive($error1, $error2, $others));
            $jsonData['erro_log'] = $error;
        }
        echo CJSON::encode($jsonData);
    }

}
