<?php

class ApidirectinvoiceController extends Controller {

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array("GetList", "SaveDirectInvoice", "SavePackageList", "GetInvoiceDetailsFromId", 'PrintInvoiceReportPDF', 'UnlinkPDF', 'GetPackageListNew',
                    'PrintDeliveryReportPDF', 'UnlinkDeliveryNotePDF', 'PrintDirectInvoiceReportPDF','EditDirectInvoice','EditDirectInvoiceItem'),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function beforeAction($action) {
         $this->ChangeDB();
        return parent::beforeAction($action);
    }

    public function actionGetList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);

        if ($userModel->id > 0) {
            $modelDirectInvoice = new DirectInvoice();
            $condition = '1=1 AND t.isActive="Y" ';
            $term = $_REQUEST['term'];
            if (!empty($term)) {
                $condition = " ( t.invoice_id  LIKE '{$term}%' OR t.file_id  LIKE '%{$term}%' OR customer_details.customer_name  LIKE '%{$term}%' )";
            }
            $invoice_date = $_REQUEST['invoice_date'];
            if ($invoice_date != '') {
                $condition .= ' AND t.invoice_date="' . $invoice_date . '"';
            } else {
                $condition .= ' AND t.invoice_date="' . date('Y-m-d') . '"';
            }
            //echo $condition;
            $models = $modelDirectInvoice->with('customer_details')->findAll(array('condition' => $condition, "order" => "t.id DESC"));

            $data = [];
            foreach ($models as $key => $row) {
                $data[] = [
                    "id" => $row['id'],
                    "file_id" => $row['file_id'],
                    "customer_name" => $row['customer_details']['customer_name'],
                    "invoice_date" => date("d/m/Y", strtotime($row['invoice_date'])),
                    "vat_amount" => $row['total_tax_amount'],
                    "grand_total" => $row['grand_total'],
                    "posted" => $row['posted'],
                    "invoice_id" => $row['invoice_id'],
                    "delivery_id" => $row['reference'],
                    "active" => $row['isActive']
                ];
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($data);
    }

    /* {"customerid":"1004","contactid":"14","paymentid":"14","invoicedate":"2 / 11 / 2021","lpo":"","lpodate":"2 / 11 / 2021","invoicetype":"1","billingaddress":"","notes":"","remarks":"","termsandconditions":"",
      "items":[{"part_number":"A1002","product_id":"2","description":"A1002 Desc","unit_name":"","unit_id":"1","quantity":"30","rate":"0.00"}]} */

    public function actionSaveDirectInvoice() {

        /*     $variables = '{"customername": "rumaise", "customerid":"1001","contactid":"1","paymentid":"1","invoicedate":"17 / 1 / 2022","invoicetype":"2","billingaddress":"","termsandconditions":"",
          "items":[{"part_number":"003-36 PC","product_id":"1001","description":"GLASS","unit_name":"Pcs","unit_id":"1",
          "unit_array": [{"id": 1, "unit_name": "Pcs", "unit_factor": "1.000000"},
          {"id": "5951", "unit_name": "CTN", "unit_factor": "36.000000"}],
          "quantity": "15", "rate": "0.5555", "vat": "0.00", "net": "8.33334"}]}'; */

        $others = array();
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);
        if ((int) $userModel->id > 0) {
            $input = file_get_contents('php://input');
            error_log('directinvoice');
            error_log($input);
            $variables = json_decode($input, true);
           
            $arr_mas_invoice_type = MasInvoiceType::model()->findByPk($variables['invoicetype']);

            $user_id = $userModel->id;
            $modelDirectInvoice = new DirectInvoice;
            $modelDirectInvoiceItems = array(new DirectInvoiceItem());
            $others = array();
            $update = 0;
            $order_id = (int) $variables['id'];
            //echo "order_id=".$order_id;
            if ((int) $order_id > 0) {
                $modelDirectInvoice = $modelDirectInvoice->findByPK($order_id);
                 $file_id = (int) $modelDirectInvoice->file_id;
                $update = 1;
            } else {
                $modelDirectInvoice->created_by = $user_id;
                $modelDirectInvoice->created_datetime = date('Y-m-d H:i:s');
                $update = 0;
            }
            $modelDirectInvoice->updated_by = $user_id;
            $modelDirectInvoice->updated_datetime = date('Y-m-d H:i:s');
            if ($variables['invoicedate'] != '') {
                $modelDirectInvoice->invoice_date = str_replace('/', '-', $variables['invoicedate']);
                $modelDirectInvoice->invoice_date = date("Y-m-d", strtotime($modelDirectInvoice->invoice_date));
            } else {
                $modelDirectInvoice->invoice_date = '';
            }
            $modelDirectInvoice->customer_id = $variables['customerid'];
            $modelDirectInvoice->contact_id = $variables['contactid'];
            $modelDirectInvoice->lead_owner_id = $user_id;
            $modelDirectInvoice->exchange_rate = '1';

            $grand_total = $total_tax = 0;
            if ($update == 0) {
                $modelDirectInvoice->grand_total = 0;
            }
            $modelDirectInvoice->sales_group_id = 1;
            $modelDirectInvoice->terms_and_conditions = $variables['termsandconditions'];
            $modelDirectInvoice->payment_terms = $variables['paymentid'];
            $modelDirectInvoice->invoice_type = $variables['invoicetype'];
            $modelDirectInvoice->currency_id = $userModel->own_company->currency_id;

            $valid = $modelDirectInvoice->validate();
            $arr_items = $variables['items'];
            // echo '<pre>';
            //print_r($arr_items);exit;
            if (!empty($arr_items)) {
                foreach ($arr_items as $i => $item) {
                    if ($item['product_id'] != '') {
                        $modelDirectInvoiceItems[$i] = new DirectInvoiceItem;
                        $mod_store = Store::model()->findByPK((int) $item['product_id']);
                        if ($item['id'] > 0) {
                            $modelDirectInvoiceItems[$i] = $modelDirectInvoiceItems[$i]->findByPk($item['id']);
                        } else {
                            $modelDirectInvoiceItems[$i]->created_by = $user_id;
                            $modelDirectInvoiceItems[$i]->created_datetime = date('Y-m-d H:i:s');
                        }
                        $modelDirectInvoiceItems[$i]->updated_by = $user_id;
                        $modelDirectInvoiceItems[$i]->updated_datetime = date('Y-m-d H:i:s');
                        $modelDirectInvoiceItems[$i]->part_no = $item['part_number'];
                        $modelDirectInvoiceItems[$i]->product_id = $item['product_id'];
                        $modelDirectInvoiceItems[$i]->quantity = $item['quantity'];
                        $modelDirectInvoiceItems[$i]->rate = $item['rate'];
                        $modelDirectInvoiceItems[$i]->invoice_id = 0;
                        if ($item['rate'] <= 0) {
                            $others[] = 'Rate should be greater than zero';
                            $valid = false;
                        }
                        if ((int) $item['quantity'] <= 0) {
                            $others[] = 'Quantity should be greater than zero';
                            $valid = false;
                        }
                        $modelDirectInvoiceItems[$i]->description = $item['description'];
                        $modelDirectInvoiceItems[$i]->amount = ($item['rate'] * $item['quantity']);
                        $modelDirectInvoiceItems[$i]->unit_id = $item['unit_id'];
                        $arr_mas_invoice_type = MasInvoiceType::model()->findByPk($variables['invoicetype']);

                        //echo $arr_mas_invoice_type['tax'];
                        if ($arr_mas_invoice_type['tax'] == 'Y') {
                            $modelDirectInvoiceItems[$i]->tax_percentage = $mod_store->tax->percentage;
                            $modelDirectInvoiceItems[$i]->tax_amount = ($mod_store->tax->percentage * $modelDirectInvoiceItems[$i]->amount) / 100;
                        } else {
                            $modelDirectInvoiceItems[$i]->tax_percentage = 0;
                            $modelDirectInvoiceItems[$i]->tax_amount = 0;
                        }
                        $grand_total += $modelDirectInvoiceItems[$i]->amount;
                        $total_tax += $modelDirectInvoiceItems[$i]->tax_amount;
                        $modelDirectInvoiceItems[$i]->created_datetime = date('Y-m-d H:i:s');
                        $modelDirectInvoiceItems[$i]->updated_datetime = date('Y-m-d H:i:s');
                        $modelDirectInvoiceItems[$i]->created_by = $user_id;
                        $modelDirectInvoiceItems[$i]->updated_by = $user_id;
                        $valid = $modelDirectInvoiceItems[$i]->validate() && $valid;
                    }
                }
            }
            if ($valid && !empty($modelDirectInvoiceItems)) {
                
                if($file_id==0){
                    $modelMaster = new MasterFile();
                    $modelMaster->customer_id = $variables['customer_id'];
                    $modelMaster->start_from = "I";
                    $modelMaster->current_process_status = "I";
                    $modelMaster->crm_user_id = $user_id;
                    $modelMaster->file_title = "";
                    $modelMaster->save(false);
                    $modelMaster->refresh();
                    $file_id = $modelMaster->id;
                }
                $modelDirectInvoice->save();
                $modelDelivery = new DeliveryNote();
                if($order_id > 0){
                    $modelDeliveryNote = new DeliveryNote();
                    $arr_delivery_note=$modelDeliveryNote->find(array('condition'=>'order_id='.$order_id));
                    
                    if(count($arr_delivery_note) > 0){
                        $modelDelivery = $modelDelivery->findByPk((int) $arr_delivery_note->id);
                    }
                }
                
                
                $modelDelivery->file_id = $file_id;
                $modelDelivery->customer_id = $modelDirectInvoice->customer_id;
                $modelDelivery->order_id = $modelDirectInvoice->id;
                $modelDelivery->delivery_date = $modelDirectInvoice->invoice_date;
                $modelDelivery->billing_address = $modelDirectInvoice->billing_address;
                $modelDelivery->shipping_address = $modelDirectInvoice->billing_address;
                $modelDelivery->contact_id = $modelDirectInvoice->contact_id;
                $modelDelivery->shipped_by = MasShipping::getDefault();
                $modelDelivery->sales_group = $modelDirectInvoice->sales_group_id;
                $modelDelivery->notes = $modelDirectInvoice->reference;
                $modelDelivery->terms_and_conditions = $modelDirectInvoice->terms_and_conditions;
                $modelDelivery->delivery_from = 'DI';
                $modelDelivery->crm_user_id = $user_id;
                $modelDelivery->created_by = $user_id;
                $modelDelivery->created_datetime = date('Y-m-d H:i:s');
                $modelDelivery->save(false);
                $modelDelivery->refresh();
                
                if (!empty($modelDirectInvoiceItems)) {
                    if($order_id > 0){
                        DirectInvoiceItem::model()->deleteAll('invoice_id=:refer_id', array(':refer_id' => $order_id));
                    }
                    foreach ($modelDirectInvoiceItems as $eachItem) {
                        $eachItem->invoice_id = $modelDirectInvoice->id;
                        $eachItem->save(false);
                        $total_vat_amount += $eachItem->tax_amount;
                    }
                    $modelItems = DirectInvoiceItem::model()->findAll(array('condition' => 'invoice_id="' . (int) $modelDirectInvoice->id . '"'));
                    
                    if($order_id > 0 && (int) $modelDelivery->id > 0){
                        DeliveryNoteItem::model()->deleteAll('delivery_note_id=:refer_id', array(':refer_id' => (int) $modelDelivery->id));
                    }
                    foreach ($modelItems as $eachItem) {
                        $modelItem[$i] = new DeliveryNoteItem;
                        $modelItem[$i]->product_id = $eachItem['product_id'];
                        $modelItem[$i]->delivery_note_id = $modelDelivery->id;
                        $modelItem[$i]->description = $eachItem['description'];
                        $modelItem[$i]->quantity = $eachItem['quantity'];
                        $modelItem[$i]->order_item_id = $eachItem['id'];
                        $modelItem[$i]->unit = $eachItem['unit_id'];
                        $modelItem[$i]->picked_qty = floatval($eachItem['quantity']);
                        $modelItem[$i]->picked_bonus_qty = 0;
                        $modelItem[$i]->remarks = '';
                        $modelItem[$i]->save(false);
                    }
                }


                $modelDirectInvoice->updateByPk($modelDirectInvoice->id, array('reference' => $modelDelivery->id, 'file_id' => $file_id, 'total_tax_amount' => $total_tax, 'grand_total' => ($grand_total + $total_tax)));

                $data['status'] = 'success';
                $data['delivery_id'] = $modelDelivery->id;
                $data['direct_id'] = $modelDirectInvoice->id;
            } else {
                $data['status'] = 'failed';
                $error1 = json_decode(CActiveForm::validate($modelDirectInvoice, '', false), true);
                if (!empty($modelDirectInvoiceItems[0]->product_id))
                    $error2 = json_decode(CActiveForm::validateTabular($modelDirectInvoiceItems, '', false), true);
                else
                    $error2[] = "Please add atleast one line item";
                $error = array_merge_recursive($error1, $error2);
                foreach ($error as $a => $eacherror) {
                    $others[] = $eacherror[0];
                }
                if ($others != '[]')
                    $data['msg'] = implode(',', $others);
            }
            /*

             */

            header("HTTP/1.1 200 OK");
            header('Content-Type: application/json');
        }else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($data);
    }

    public function actionGetPackageList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        //$token ='3-1641300108';
        //$token='3-1644758511';
        $userModel = User::model()->findBytoken($token);

        if ($userModel->id > 0) {
            $del_id = $_REQUEST['delivery_id'];
            //$del_id=30080;
            $user_warehouse = $userModel->available_warehouses;
            $modelDelivery = DeliveryNote::model()->findByPK((int) $del_id);

            $count_dlvd_items = Yii::app()->db->createCommand('SELECT COUNT(DISTINCT(product_id)) FROM `erp_delivery_item` DI 
                        WHERE delivery_note_id=' . (int) $modelDelivery->id . ' and picked_qty>0 ')->queryScalar();



            $SQL = "SELECT DI.product_id,part_number,S.description,SUM(picked_qty) AS picked_qty,unit,UOM.name AS unit_name,DI.unit AS unit_id,factor AS unit_factor,rate,SU.unit_name AS store_unit_name FROM `erp_delivery_item` AS DI 
                INNER JOIN erp_unit_of_measurement UOM ON UOM.id=unit 
                INNER JOIN erp_store AS S ON S.id=DI.product_id 
                INNER JOIN erp_unit AS SU ON S.unit_id=SU.id 
                WHERE `delivery_note_id`=" . $del_id . " GROUP by DI.product_id,unit";

            $arr_packaging_details = Yii::app()->db->createCommand($SQL)->queryAll();

            $j = 0;
            $u = -1;
            $count_actual_product_flag = 0;
            foreach ($arr_packaging_details as $eachItem) {


                $total_balance_qty = (int) Yii::app()->db->createCommand('SELECT SUM(quantity * unit_factor) FROM  erp_stock_ledger WHERE product_id=' . $eachItem['product_id'] . ' ')->queryScalar();

                // echo "total_bal_qty=".$total_balance_qty;

                if ($eachItem['product_id'] != $str_product_id) {
                    $u++;
                    $str_product_id = $eachItem['product_id'];
                    $str_unit_id = $eachItem['unit_id'];


                    $part_number = $eachItem['part_number'];
                    $itemdata[$u]["product_id"] = $str_product_id;
                    $itemdata[$u]["part_number"] = $eachItem['part_number'];
                    $itemdata[$u]["description"] = $eachItem['description'];
                    $itemdata[$u]["deliveryqty"] = $eachItem['picked_qty'];
                    $itemdata[$u]["deliveryqtyunit"] = (int) $eachItem['picked_qty'] . " " . $eachItem['unit_name'];
                    //$arr_heading =$part_number.' | '.$each_stock_item->product->description.'  |   Delivered QTY - '.$sum_qty_pdt;

                    $arr_heading = $eachItem['part_number'] . ' | ' . $eachItem['description'] . '  |   Delivered QTY - ' . (int) $eachItem['picked_qty'] . " " . $eachItem['unit_name'];
?>
                    <?php

                } elseif ($eachItem['product_id'] == $str_product_id && $eachItem['unit_id'] != $str_unit_id) {
                    $u++;
                    $str_product_id = $eachItem['product_id'];
                    $str_unit_id = $eachItem['unit_id'];

                    $part_number = $eachItem['part_number'];
                    $itemdata[$u]["product_id"] = $str_product_id;
                    $itemdata[$u]["part_number"] = $eachItem['part_number'];
                    $itemdata[$u]["description"] = $eachItem['description'];
                    $itemdata[$u]["deliveryqty"] = $eachItem['picked_qty'];
                    $itemdata[$u]["deliveryqtyunit"] = (int) $eachItem['picked_qty'] . " " . $eachItem['unit_name'];
                    //$arr_heading =$part_number.' | '.$each_stock_item->product->description.'  |   Delivered QTY - '.$sum_qty_pdt;

                    $arr_heading = $eachItem['part_number'] . ' | ' . $eachItem['description'] . '  |   Delivered QTY - ' . (int) $eachItem['picked_qty'] . " " . $eachItem['unit_name'];
                }



                $cond_pack = 'product_id=' . $eachItem['product_id'];
                if ($user_warehouse != '') {
                    $cond_pack.=' AND warehouse_id IN (' . $user_warehouse . ')';
                }
                $product_items = StockLedger::model()->findAll(array('condition' => $cond_pack, 'order' => 'product_id,quantity DESC'));

                $count_stockledger_items = Yii::app()->db->createCommand('SELECT COUNT(DISTINCT(product_id)) FROM `erp_stock_ledger`  
                        WHERE ' . $cond_pack . ' GROUP BY erp_stock_ledger.product_id ')->queryScalar();

                $picked_qty = (int) $eachItem['picked_qty'];
                $arr_package_items = [];
                if (!empty($product_items)) {
                    foreach ($product_items as $p => $each_stock_item) {
                        $modelItems = new StockLedger();
                        $out_qty = (int) Yii::app()->db->createCommand('SELECT SUM(quantity * unit_factor) FROM  erp_stock_ledger WHERE master_stock_ledger_id=' . $each_stock_item->id . ' ')->queryScalar();
                        $stock_ledger_quantity = ($each_stock_item->quantity * $each_stock_item->unit_factor) - (-1 * $out_qty);


                        if ((int) $eachItem['unit_factor'] > 1) {
                            if ($each_stock_item->quantity > 0) {
                                $display_stock_ledger_quantity = ($each_stock_item->quantity * $each_stock_item->unit_factor) - (-1 * $out_qty);

                                $display_stock_ledger_quantity = ($display_stock_ledger_quantity / (int) $eachItem['unit_factor']);
                            }

                            $unit_factor = (int) $eachItem['unit_factor'];
                        } else {
                            $display_stock_ledger_quantity = ($each_stock_item->quantity * $each_stock_item->unit_factor) - (-1 * $out_qty);
                            $unit_factor = 1;
                        }

                        if ((int) $total_balance_qty <= 0) {
                            $count_actual_product_flag = 1;
                        }


                        if ($stock_ledger_quantity > 0) {
                            $sum_qty_pdt = $picked_qty;

                            if ($picked_qty > (int) $display_stock_ledger_quantity) {
                                $picked_qty = (int) $display_stock_ledger_quantity;
                            }

                            //$base_unit_name=$eachItem['store_unit_name'];
                            $itemdata[$u]["items"][] = [ "product_id" => $each_stock_item->product_id,
                                "heading" => $arr_heading,
                                "warehouse_name" => $each_stock_item->warehouse->warehouse_name,
                                "available_qty" => (int) round($display_stock_ledger_quantity, 2),
                                "available_qty_unit" => $eachItem['unit_name'],
                                "rack_name" => $each_stock_item->rack->name,
                                "bin_name" => $each_stock_item->bin->name,
                                "transaction_date" => $modelDelivery->delivery_date,
                                "rack_id" => $each_stock_item->rack->id,
                                "bin_id" => $each_stock_item->bin->id,
                                "warehouse_id" => $each_stock_item->warehouse->id,
                                "cost_price" => $each_stock_item->product->rate,
                                "sales_price" => ($eachItem['rate'] * $picked_qty),
                                'unit_factor' => $unit_factor,
                                "quantity_to_pick" => 0,
                                "master_stock_ledger_id" => $each_stock_item->id,
                                "unit_id" => $eachItem['unit_id'],
                                    //"header_item_id"=>$modeltems->id
                            ];
                        } else {

                            $available_qty = 0;
                            $itemdata[$u]["items"][] = [ "product_id" => $eachItem['product_id'],
                                "heading" => $arr_heading,
                                "warehouse_name" => 'null',
                                "available_qty" => (int) $available_qty,
                                "available_qty_unit" => 'null',
                                "rack_name" => 'null',
                                "bin_name" => 'null',
                                "transaction_date" => $modelDelivery->delivery_date,
                                "rack_id" => 0,
                                "bin_id" => 0,
                                "warehouse_id" => 0,
                                "cost_price" => '0.00',
                                "sales_price" => '0.00',
                                'unit_factor' => $unit_factor,
                                "quantity_to_pick" => 0,
                                "master_stock_ledger_id" => 0,
                                "unit_id" => $eachItem['unit_id'],
                                    //"header_item_id"=>$modeltems->id
                            ];

                            //$itemdata[$u]["items"][]=array();
                            //$count_actual_product_flag=1;
                        }
                    }
                } else {
                    $itemdata = [];
                }
            }

            if (!empty($itemdata)) {
                header("HTTP/1.1 200 OK");
                /* if((int)$count_dlvd_items!=(int)$count_stockledger_items){
                  $data = array('status' => "failed", "msg"=>"Stock Not Available. Delivery Item Count -".$count_dlvd_items. " Available Items Count - ".$count_stockledger_items);
                  }else{ */
                $data = array('status' => "success", 'count_actual_product_flag' => $count_actual_product_flag, "result" => $itemdata, "product_count" => $count_dlvd_items, "count_stockledger_items" => $count_stockledger_items);
                //}
            } else {
                $data = array('status' => "failed", "msg" => "Stock Not Available");
            }


            /* echo '<pre>';
              print_r( $data);
              print_r($itemdata);
              print_r($arr_heading);

              exit; */

            /* if(!empty($itemdata)){
              header("HTTP/1.1 200 OK");
              /*if((int)$count_dlvd_items!=(int)$count_stockledger_items){
              $data = array('status' => "failed", "msg"=>"Stock Not Available. Delivery Item Count -".$count_dlvd_items. " Available Items Count - ".$count_stockledger_items);
              }else{
              $data = array('status' => "success", "result"=>$itemdata,"product_count"=>$count_dlvd_items,"count_stockledger_items"=>$count_stockledger_items);
              //}
              }else{
              $data = array('status' => "failed", "msg"=>"Stock Not Available");
              }
             */
        } else {
            header("HTTP/1.1 401 Unauthorized");
            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }

        /* echo '<pre>';
          print_r($data); */
        header('Content-Type: application/json');
        echo json_encode($data);
    }

    /* public function actionGetPackageList() {
      $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
      //$token ='3-1641300108';
      //$token='3-1643792731';
      $token='3-1644758511';
      $userModel = User::model()->findBytoken($token);

      if ($userModel->id > 0) {
      $del_id = $_REQUEST['delivery_id'];
      //$del_id=30080;
      $user_warehouse  = $userModel->available_warehouses;
      $modelDelivery=DeliveryNote::model()->findByPK((int)$del_id);
      $count_dlvd_items = Yii::app()->db->createCommand('SELECT COUNT(DISTINCT(product_id)) FROM `erp_delivery_item` DI
      WHERE delivery_note_id='.(int)$modelDelivery->id.' and picked_qty>0 ')->queryScalar();

      //echo $count_dlvd_items;
      $cond_pack='product_id IN(SELECT product_id from erp_delivery_item WHERE delivery_note_id='.(int)$modelDelivery->id.'  and picked_qty>0) AND quantity > 0 AND available_status="A" AND stock_updated="Y"';
      if($user_warehouse!=''){
      $cond_pack.=' AND warehouse_id IN ('.$user_warehouse.')';
      }
      $product_items= StockLedger::model()->findAll(array('condition'=>$cond_pack,'order'=>'product_id,quantity DESC'));
      $count_stockledger_items = Yii::app()->db->createCommand('SELECT COUNT(DISTINCT(product_id)) FROM `erp_stock_ledger`
      WHERE '.$cond_pack.' GROUP BY erp_stock_ledger.product_id ')->queryScalar();

      //echo "count_stockledger_items=".$count_stockledger_items;
      $str_product_id="";$rem_qty = 0;$sales_price=0;
      $u=-1;
      $arr_package_items=[];
      if(!empty($product_items)){
      foreach($product_items as $j=>$each_stock_item){

      $stock_from = "";
      $display_unit_name="";
      $secondary_unit_qty="";
      $base_unit_name="";

      if($each_stock_item->transaction_from=='INVENTORY_GOODS_RECEIPT'){
      $stock_from="/IGR";
      }
      elseif($each_stock_item->transaction_from=='PURCHASE_QUALITY_CHECK'){
      $stock_from="/PIN";
      }
      elseif($each_stock_item->transaction_from=='DIRECT_TRANSFER_IN'){
      $stock_from="/DTIN";
      }
      elseif($each_stock_item->transaction_from=='CREDIT_NOTE'){
      $stock_from="/CN";
      }
      $arr_delivery_details = DeliveryNoteItem::model()->with('unitdetails')->find(array('condition'=>'delivery_note_id='.$modelDelivery->id.' AND t.product_id='.$each_stock_item->product_id));
      if(isset($arr_delivery_details->unitdetails->factor) && $arr_delivery_details->unitdetails->factor!=""){
      $unit_factor = $arr_delivery_details->unitdetails->factor;
      $display_unit_name = $arr_delivery_details->product->unit->unit_name;
      $base_unit_name = $arr_delivery_details->product->unit->unit_name;


      }
      //$delivery_item_model= DeliveryNoteItem::model()->with('unitdetails')->find(array('select'=>'IFNULL(SUM(t.picked_qty),0) as picked_qty,IFNULL(SUM(picked_bonus_qty),0) as picked_bonus_qty','condition'=>'delivery_note_id='.$modelDelivery->id.' AND product_id='.$each_stock_item->product_id));
      $SQL='SELECT SUM(picked_qty * factor) FROM `erp_delivery_item` AS DI INNER JOIN erp_unit_of_measurement AS UOM ON UOM.id=DI.unit WHERE delivery_note_id='.$modelDelivery->id.' AND DI.product_id='.$each_stock_item->product_id;
      $delivery_picked_qty= Yii::app()->db->createCommand($SQL)->queryScalar();

      $sum_qty_pdt=$delivery_picked_qty;
      //$sum_qty_pdt=$delivery_item_model->picked_qty+$delivery_item_model->picked_bonus_qty;
      $modeltems = DeliveryNoteItem::model()->find(array('condition' => 'delivery_note_id =' . $modelDelivery->id.' AND product_id='.$each_stock_item->product_id));
      $sales_price = $modeltems->doitem->rate;
      $header_items_id = $modeltems->id;




      //$sum_qty_pdt = $sum_qty_pdt * $unit_factor;
      if($unit_factor > 0){


      //$arr_secondary_unit = UnitOfMeasurement::getSecondaryBaseUnitWithName((int) $each_stock_item->product_id);
      $display_unit_name.= " | ".round(($sum_qty_pdt /  $unit_factor),4)." ".$arr_delivery_details->unitdetails->name;
      }
      $stock_ledger_quantity= 1;
      if(empty($each_stock_item->serial_no)){
      $out_qty = Yii::app()->db->createCommand('SELECT SUM(quantity*unit_factor) FROM  erp_stock_ledger WHERE master_stock_ledger_id=' . $each_stock_item->id . ' ')->queryScalar();
      $stock_ledger_quantity= ($each_stock_item->quantity*$each_stock_item->unit_factor)-(-1*$out_qty);
      }


      if ($each_stock_item->product->id != $str_product_id) {
      $u++;
      $rem_qty=$sum_qty_pdt;
      if(($stock_ledger_quantity)>=$rem_qty){
      $picked_qty=$rem_qty;
      $rem_qty = 0;
      }else{
      $picked_qty=($stock_ledger_quantity);
      $rem_qty = $rem_qty-($stock_ledger_quantity);
      }
      $str_product_id = $each_stock_item->product->id;
      $part_number=$each_stock_item->product->part_number;
      $itemdata[$u]["product_id"] =$str_product_id;
      $itemdata[$u]["part_number"] =$part_number;
      $itemdata[$u]["description"] =$each_stock_item->product->description;
      $itemdata[$u]["deliveryqty"] =$sum_qty_pdt;
      $itemdata[$u]["deliveryqtyunit"] =(int) $sum_qty_pdt." ".$display_unit_name;
      $arr_heading =$part_number.' | '.$each_stock_item->product->description.'  |   Delivered QTY - '.$sum_qty_pdt;


      }else{
      if(($stock_ledger_quantity)>=$rem_qty){
      $picked_qty=$rem_qty;
      $rem_qty = 0;
      }else{
      $picked_qty=($stock_ledger_quantity);
      $rem_qty = $rem_qty-($stock_ledger_quantity);
      }
      }

      if($stock_ledger_quantity > 0){
      $itemdata[$u]["items"][] =[ "product_id"=>$each_stock_item->product_id,
      "heading"=>$arr_heading,
      "warehouse_name"=>$each_stock_item->warehouse->warehouse_name,
      "available_qty"=>round($stock_ledger_quantity,2),
      "available_qty_unit"=>$base_unit_name,
      "rack_name"=>$each_stock_item->rack->name,
      "bin_name"=>$each_stock_item->bin->name,
      "transaction_date"=>$modelDelivery->delivery_date,
      "rack_id"=>$each_stock_item->rack->id,
      "bin_id"=>$each_stock_item->bin->id,
      "warehouse_id"=>$each_stock_item->warehouse->id,
      "cost_price"=>$each_stock_item->product->rate,
      "sales_price"=>$sales_price,
      "quantity_to_pick"=>$picked_qty,
      "master_stock_ledger_id"=>$each_stock_item->id,
      "header_item_id"=>$modeltems->id
      ];
      }

      }
      }else{
      $itemdata=[];
      }
      if(!empty($itemdata)){
      header("HTTP/1.1 200 OK");
      /*if((int)$count_dlvd_items!=(int)$count_stockledger_items){
      $data = array('status' => "failed", "msg"=>"Stock Not Available. Delivery Item Count -".$count_dlvd_items. " Available Items Count - ".$count_stockledger_items);
      }else{
      $data = array('status' => "success", "result"=>$itemdata,"product_count"=>$count_dlvd_items,"count_stockledger_items"=>$count_stockledger_items);
      //}
      }else{
      $data = array('status' => "failed", "msg"=>"Stock Not Available");
      }

      }else{
      header("HTTP/1.1 401 Unauthorized");
      $data = array('status' => "failed", "msg"=>"Unauthorized user");
      }
      header('Content-Type: application/json');
      echo '<pre>';
      print_r($data);
      echo json_encode($data);
      } */

    /* public function actionGetPackageListNew() {
      $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
      //$token ='3-1641300108';
      $token='3-1644758511';
      $userModel = User::model()->findBytoken($token);

      if ($userModel->id > 0) {
      $del_id = $_REQUEST['delivery_id'];
      //$del_id=30080;
      $user_warehouse  = $userModel->available_warehouses;
      $modelDelivery=DeliveryNote::model()->findByPK((int)$del_id);

      $count_dlvd_items = Yii::app()->db->createCommand('SELECT COUNT(DISTINCT(product_id)) FROM `erp_delivery_item` DI
      WHERE delivery_note_id='.(int)$modelDelivery->id.' and picked_qty>0 ')->queryScalar();



      $SQL="SELECT DI.product_id,part_number,S.description,SUM(picked_qty) AS picked_qty,unit,UOM.name AS unit_name,DI.unit AS unit_id,factor AS unit_factor,rate,SU.unit_name AS store_unit_name FROM `erp_delivery_item` AS DI
      INNER JOIN erp_unit_of_measurement UOM ON UOM.id=unit
      INNER JOIN erp_store AS S ON S.id=DI.product_id
      INNER JOIN erp_unit AS SU ON S.unit_id=SU.id
      WHERE `delivery_note_id`=".$del_id." GROUP by DI.product_id,unit";

      $arr_packaging_details=Yii::app()->db->createCommand($SQL)->queryAll();

      $j=0;
      $u=-1;

      foreach($arr_packaging_details as $eachItem){

      if($eachItem['product_id']!=$str_product_id){
      $u++;
      $str_product_id = $eachItem['product_id'];
      $str_unit_id    = $eachItem['unit_id'];


      $part_number=$eachItem['part_number'];
      $itemdata[$u]["product_id"] =$str_product_id;
      $itemdata[$u]["part_number"] =$eachItem['part_number'];
      $itemdata[$u]["description"] =$eachItem['description'];
      $itemdata[$u]["deliveryqty"] =$eachItem['picked_qty'];
      $itemdata[$u]["deliveryqtyunit"] =(int) $eachItem['picked_qty']." ".$eachItem['unit_name'];
      //$arr_heading =$part_number.' | '.$each_stock_item->product->description.'  |   Delivered QTY - '.$sum_qty_pdt;

      $arr_heading =$eachItem['part_number'].' | '.$eachItem['description'].'  |   Delivered QTY - '.(int) $eachItem['picked_qty']." ".$eachItem['unit_name'];


      ?>
      <?php
      }
      elseif($eachItem['product_id']==$str_product_id && $eachItem['unit_id']!=$str_unit_id){
      $u++;
      $str_product_id = $eachItem['product_id'];
      $str_unit_id    = $eachItem['unit_id'];

      $part_number=$eachItem['part_number'];
      $itemdata[$u]["product_id"] =$str_product_id;
      $itemdata[$u]["part_number"] =$eachItem['part_number'];
      $itemdata[$u]["description"] =$eachItem['description'];
      $itemdata[$u]["deliveryqty"] =$eachItem['picked_qty'];
      $itemdata[$u]["deliveryqtyunit"] =(int) $eachItem['picked_qty']." ".$eachItem['unit_name'];
      //$arr_heading =$part_number.' | '.$each_stock_item->product->description.'  |   Delivered QTY - '.$sum_qty_pdt;

      $arr_heading =$eachItem['part_number'].' | '.$eachItem['description'].'  |   Delivered QTY - '.(int) $eachItem['picked_qty']." ".$eachItem['unit_name'];
      }



      $cond_pack ='product_id='.$eachItem['product_id'];
      if($user_warehouse!=''){
      $cond_pack.=' AND warehouse_id IN ('.$user_warehouse.')';
      }
      $product_items= StockLedger::model()->findAll(array('condition'=>$cond_pack,'order'=>'product_id,quantity DESC'));

      $count_stockledger_items = Yii::app()->db->createCommand('SELECT COUNT(DISTINCT(product_id)) FROM `erp_stock_ledger`
      WHERE '.$cond_pack.' GROUP BY erp_stock_ledger.product_id ')->queryScalar();

      $picked_qty = (int) $eachItem['picked_qty'];
      $arr_package_items=[];
      if(!empty($product_items)){
      foreach($product_items as $p=>$each_stock_item){
      $modelItems= new StockLedger();
      $out_qty = (int) Yii::app()->db->createCommand('SELECT SUM(quantity * unit_factor) FROM  erp_stock_ledger WHERE master_stock_ledger_id=' . $each_stock_item->id . ' ')->queryScalar();
      $stock_ledger_quantity= ($each_stock_item->quantity  * $each_stock_item->unit_factor)-(-1*$out_qty);


      if((int) $eachItem['unit_factor'] > 1){
      if($each_stock_item->quantity > 0){
      $display_stock_ledger_quantity= ($each_stock_item->quantity  * $each_stock_item->unit_factor)-(-1*$out_qty);

      $display_stock_ledger_quantity=($display_stock_ledger_quantity/(int) $eachItem['unit_factor']);
      }

      $unit_factor = (int) $eachItem['unit_factor'];
      }
      else{
      $display_stock_ledger_quantity= ($each_stock_item->quantity  * $each_stock_item->unit_factor)-(-1*$out_qty);
      $unit_factor=1;

      }
      if($stock_ledger_quantity > 0){
      $sum_qty_pdt=$picked_qty;

      if($picked_qty > (int) $display_stock_ledger_quantity){
      $picked_qty= (int) $display_stock_ledger_quantity;
      }

      //$base_unit_name=$eachItem['store_unit_name'];
      $itemdata[$u]["items"][] =[ "product_id"=>$each_stock_item->product_id,
      "heading"=>$arr_heading,
      "warehouse_name"=>$each_stock_item->warehouse->warehouse_name,
      "available_qty"=>(int) round($display_stock_ledger_quantity,2),
      "available_qty_unit"=>$eachItem['unit_name'],
      "rack_name"=>$each_stock_item->rack->name,
      "bin_name"=>$each_stock_item->bin->name,
      "transaction_date"=>$modelDelivery->delivery_date,
      "rack_id"=>$each_stock_item->rack->id,
      "bin_id"=>$each_stock_item->bin->id,
      "warehouse_id"=>$each_stock_item->warehouse->id,
      "cost_price"=>$each_stock_item->product->rate,
      "sales_price"=>($eachItem['rate'] * $picked_qty),


      "quantity_to_pick"=>$picked_qty,
      "master_stock_ledger_id"=>$each_stock_item->id,
      //"header_item_id"=>$modeltems->id
      ];



      }
      }

      }
      else{
      $itemdata=[];
      }





      }

      if(!empty($itemdata)){
      header("HTTP/1.1 200 OK");
      /*if((int)$count_dlvd_items!=(int)$count_stockledger_items){
      $data = array('status' => "failed", "msg"=>"Stock Not Available. Delivery Item Count -".$count_dlvd_items. " Available Items Count - ".$count_stockledger_items);
      }else{
      $data = array('status' => "success", "result"=>$itemdata,"product_count"=>$count_dlvd_items,"count_stockledger_items"=>$count_stockledger_items);
      //}
      }else{
      $data = array('status' => "failed", "msg"=>"Stock Not Available");
      }



      if(!empty($itemdata)){
      header("HTTP/1.1 200 OK");
      /*if((int)$count_dlvd_items!=(int)$count_stockledger_items){
      $data = array('status' => "failed", "msg"=>"Stock Not Available. Delivery Item Count -".$count_dlvd_items. " Available Items Count - ".$count_stockledger_items);
      }else{
      $data = array('status' => "success", "result"=>$itemdata,"product_count"=>$count_dlvd_items,"count_stockledger_items"=>$count_stockledger_items);
      //}
      }else{
      $data = array('status' => "failed", "msg"=>"Stock Not Available");
      }

      }else{
      header("HTTP/1.1 401 Unauthorized");
      $data = array('status' => "failed", "msg"=>"Unauthorized user");
      }

      header('Content-Type: application/json');
      echo json_encode($data);
      } */

    public function actionSavePackageList() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        //$token = '3-1652771385';
        $userModel = User::model()->findBytoken($token);
        $groups = array();
        //added By jisha on 17-05-22 start
        $productgroups= array();
        //added By jisha on 17-05-22 end
        $other = array();
        if ((int) $userModel->id > 0) {
            $input = file_get_contents('php://input');
            /*$input = '{
               "delivery_id":31045,
               "items":[
                  {
                     "product_id":2973,
                     "quantity":99,
                     "master_stock_ledger_id":5695,
                     "header_item_id":null,
                     "cost_price":1.667290,
                     "sales_price":165.06171,
                     "unit_id":5360,
                     "unit_factor":24
                  },
                  {
                     "product_id":2973,
                     "quantity":1,
                     "master_stock_ledger_id":8222,
                     "header_item_id":null,
                     "cost_price":1.667290,
                     "sales_price":1.66729,
                     "unit_id":5360,
                     "unit_factor":24
                  }
               ]
            }';
            */
            error_log($input);
            $variables = json_decode($input, true);
            //echo '<pre>';print_r($variables);
            $user_id = $userModel->id;
            $transaction_id = $variables['delivery_id'];
            $model = new DeliveryNote();
            $transaction_from = 'DELIVERY_NOTE';
            $model = $model->findByPk($transaction_id);
            $customer_vendor_id = (int) $model->customer_id;
            if ($customer_vendor_id > 0) {
                $customer_vendor_name = Customer::GetCustomerName($customer_vendor_id);
            }
            $file_id = (int) $model->file_id;
            $arr_items = $variables['items'];

            if (!empty($arr_items)) {
                $k = 0;
                $valid = TRUE;
                $flag = 0;
                foreach ($arr_items as $i => $item) {
                    //added By jisha on 17-05-22 start
                    $pkey = $item['product_id'].'_'.$item['unit_id'];
                    if (!array_key_exists($pkey, $productgroups)) {
                        $productgroups[$pkey] = array(
                            'id' => $item['product_id'],
                            'quantity' => $item['quantity'] * $item['unit_factor'],
                            'unit_id' => $item['unit_id'],
                            'unit_factor' => $item['unit_factor']
                        );
                    } else {
                        $productgroups[$pkey]['quantity'] = $productgroups[$pkey]['quantity'] + ($item['quantity'] * $item['unit_factor']);
                    }
                    //added By jisha on 17-05-22 end
                    $key = $item['product_id'] . "_" . (int) $item['master_stock_ledger_id'];
                    if (!array_key_exists($key, $groups)) {
                        $groups[$key] = array(
                            'id' => $item['product_id'],
                            'master_stock_ledger_id' => $item['master_stock_ledger_id'],
                            'quantity' => $item['quantity'] * $item['unit_factor'],
                            'unit_id' => $item['unit_id']
                        );
                    } else {
                        $groups[$key]['quantity'] = $groups[$key]['quantity'] + ($item['quantity'] * $item['unit_factor']);
                    }

                    $arr_warehouse_qty = StockLedger::model()->findByPk((int) $item['master_stock_ledger_id']);

                    $ware_house_qty = (float) $arr_warehouse_qty['quantity'] * $arr_warehouse_qty['unit_factor'];



                    if ($ware_house_qty < 0) {
                        $ware_house_qty = 0;
                    }

                    $out_qty = (int) Yii::app()->db->createCommand('SELECT SUM(quantity * unit_factor) FROM  erp_stock_ledger WHERE master_stock_ledger_id=' . $item['master_stock_ledger_id'] . ' ')->queryScalar();


                    $availble_qty = $ware_house_qty - (-1 * $out_qty);



                    if (is_numeric($item['quantity']) && $item['quantity'] > 0) {
                        $totallocatedQuantity = @AllocatedMaterial::model()->find('product_id=:product_id AND allocation_end_date>=:today', array(':product_id' => $item['product_id'], ':today' => date("Y-m-d")))->quantity;
                        $allocatedQuantityForThis = @AllocatedMaterial::model()->find('file_id=:file_id AND product_id=:product_id AND allocation_end_date>=:today', array(':file_id' => $file_id, ':product_id' => $item['product_id'], ':today' => date("Y-m-d")))->quantity;
                        $availableQty = ($availble_qty + floatval($allocatedQuantityForThis)) - $totallocatedQuantity;

                        if ($availableQty < $item['quantity']) {
                            $flag = 1;
                            $valid = FALSE;
                        }
                        $modelExistingStockLedger = StockLedger::model()->findByPk($item['master_stock_ledger_id']);


                        /*
                        commented by jisha on 17-05-2022
                        $sum_qty_dlvd = Yii::app()->db->createCommand('SELECT IFNULL(SUM(DI.picked_qty*U.factor),0) as picked_qty FROM `erp_delivery_item` DI LEFT JOIN erp_unit_of_measurement U ON U.id=DI.unit
                        WHERE delivery_note_id=' . (int) $model->id . ' AND DI.product_id=' . (int) $item['product_id'] . ' AND DI.unit=' . (int) $item['unit_id'])->queryScalar();

                        $product = Store::model()->findByPk($item['product_id']);

                        $item_unit_qty = $item['quantity'] * $item['unit_factor'];

                        if ((int) $item_unit_qty != (int) $sum_qty_dlvd) {
                            $arr_uom_details = UnitOfMeasurement::model()->findByPk((int) $item['unit_id']);

                            if ((int) $item['unit_factor'] == 0) {
                                $unit_fact = 1;
                            } else {
                                $unit_fact = (int) $item['unit_factor'];
                            }
                            $display_qty = ($sum_qty_dlvd / $unit_fact);

                            $other[] = $product->part_number . ' total deliverable qty : ' . (number_format($display_qty, 2));
                            $valid = false;
                        }*/


                        if (floatval($item['quantity']) > (floatval($availble_qty))) {
                            $valid = FALSE;
                            $other[] = ' Product' . $item['part_number'] . ' has only ' . $availble_qty . ' items. Quantity should be less than available';
                        } else {
                            $modelItem[$k] = new StockLedger();
                            $modelItem[$k]->file_id = $file_id;
                            $modelItem[$k]->header_id = $model->id;
                            $modelItem[$k]->header_item_id = $item['header_item_id'];
                            $modelItem[$k]->customer_vendor_id = $customer_vendor_id;
                            $modelItem[$k]->customer_vendor_name = $customer_vendor_name;
                            $modelItem[$k]->product_id = $item['product_id'];
                            $modelItem[$k]->product_name = $modelExistingStockLedger->product_name;
                            $modelItem[$k]->product_description = $modelExistingStockLedger->product_description;
                            $modelItem[$k]->brand_id = $modelExistingStockLedger->brand_id;
                            $modelItem[$k]->brand_name = $modelExistingStockLedger->brand_name;
                            $modelItem[$k]->warehouse_id = $modelExistingStockLedger->warehouse_id;
                            $modelItem[$k]->warehouse_name = $modelExistingStockLedger->warehouse_name;
                            $modelItem[$k]->rack_id = $modelExistingStockLedger->rack_id;
                            $modelItem[$k]->rack_name = $modelExistingStockLedger->rack_name;
                            $modelItem[$k]->bin_id = $modelExistingStockLedger->bin_id;
                            $modelItem[$k]->bin_name = $modelExistingStockLedger->bin_name;
                            $modelItem[$k]->unit_id = $item['unit_id'];
                            $modelItem[$k]->unit_name = $item['unit_name'];
                            $modelItem[$k]->unit_factor = $item['unit_factor'];
                            $modelItem[$k]->quantity = -1 * $item['quantity'];
                            $modelItem[$k]->available_status = 'A';
                            $modelItem[$k]->batch_no = $modelExistingStockLedger->batch_no;
                            $modelItem[$k]->serial_no = $modelExistingStockLedger->serial_no;
                            $modelItem[$k]->manufacturing_date = $modelExistingStockLedger->manufacturing_date;
                            $modelItem[$k]->expiry_date = $modelExistingStockLedger->expiry_date;
                            $modelItem[$k]->cost_price = $item['cost_price'];
                            $modelItem[$k]->sales_price = $item['sales_price'];
                            $modelItem[$k]->transaction_date = $model->delivery_date;
                            $modelItem[$k]->transaction_from = $transaction_from;
                            $modelItem[$k]->transaction_type = "OUT";
                            $modelItem[$k]->master_stock_ledger_id = $item['master_stock_ledger_id'];
                            $modelItem[$k]->created_by = $user_id;
                            $modelItem[$k]->created_date = date("Y-m-d H:i:s");
                            $k++;
                        }
                    }
                }



                // QTY Checking
                //added By jisha on 17-05-22 start
                if (!empty($productgroups)) {
                    foreach ($productgroups as $pkey => $eachProductgp) {
                        $arr_uom_details = UnitOfMeasurement::model()->findByPk((int) $eachProductgp['unit_id']);
                        $product = Store::model()->findByPk((int)$eachProductgp['id']);
                        $sum_qty_dlvd = Yii::app()->db->createCommand('SELECT IFNULL(SUM(DI.picked_qty*U.factor),0) as picked_qty FROM `erp_delivery_item` DI LEFT JOIN erp_unit_of_measurement U ON U.id=DI.unit
                        WHERE delivery_note_id=' . (int) $model->id . ' AND DI.product_id=' . (int) $eachProductgp['id'] . ' AND DI.unit=' . (int) $eachProductgp['unit_id'])->queryScalar();
                        
                        if ((int) $eachProductgp['unit_factor'] == 0) {
                            $unit_fact = 1;
                        } else {
                            $unit_fact = (int) $eachProductgp['unit_factor'];
                        }
                        $display_qty = ($sum_qty_dlvd / $unit_fact);
                        
                        if ($eachProductgp['quantity'] != $sum_qty_dlvd) {
                            $other[] = $product->part_number . ' total deliverable qty : ' . (number_format($display_qty, 2));
                            $valid = false;
                        }
                    }
                }
                //added By jisha on 17-05-22 end
                    
                if (!empty($groups)) {
                    foreach ($groups as $key => $eachProduct) {
                        $arr_warehouse_qty = StockLedger::model()->findByPk((int) $eachProduct['master_stock_ledger_id']);
                        $ware_house_qty = (float) $arr_warehouse_qty['quantity'] * $arr_warehouse_qty['unit_factor'];
                        if ($ware_house_qty < 0) {
                            $ware_house_qty = 0;
                        }
                        $out_qty = (int) Yii::app()->db->createCommand('SELECT SUM(quantity * unit_factor) FROM  erp_stock_ledger WHERE master_stock_ledger_id=' . (int) $eachProduct['master_stock_ledger_id'] . ' ')->queryScalar();
                        $availble_qty = $ware_house_qty - (-1 * $out_qty);

                        if ($eachProduct['quantity'] > $availble_qty) {
                            $other[] = $arr_warehouse_qty['product_name'] . ' maximum sellable qty : ' . ($availble_qty);
                            $valid = false;
                        }
                    }
                }
                if ($valid && $flag == 0) {
                    //echo "success";exit;
                    $check_sales_group = 0;
                    $model->ready_to_invoice = 'Y';
                    $model->driver_name = $variables['driver_name'];
                    $model->save(false);
                    // inserting to audit log
                    if ($model->id > 0) {
                        AuditLog::saveAuditLogs(
                                'DELIVERY_NOTE', $user_id, 'CREATED', " with DLVRY Note No: - {$model->id}  "
                        );
                        // end audit log
                    }
                    //Invoice CREATE start
                    $modelDI = DirectInvoice::model()->find(array('condition' => 'reference=' . (int) $model->id));
                    if (!empty($modelDI)) {
                        $modelInvoice = new Invoice();
                        $modelInvoice->created_by = $user_id;
                        $modelInvoice->created_datetime = date('Y-m-d H:i:s');
                        $modelInvoice->file_id = $model->file_id;
                        $modelInvoice->delivery_ids = $model->id;
                        $total = $net_total = $tot_tax = 0;
                        $modelInvoice->exchange_rate = 1;
                        $modelInvoice->currency = $userModel->own_company->currency_id;
                        $modelInvoice->contact_id = $model->contact_id;
                        $modelInvoice->customer_id = $model->customer_id;
                        $modelInvoice->lead_owner_id = $userModel->id;
                        $modelInvoice->sales_group = 1;
                        $modelInvoice->custom_invoice_no = $modelDI->custom_invoice_no;
                        $modelInvoice->order_id = $modelDI->id;
                        $modelInvoice->terms_and_conditions = $modelDI->terms_and_conditions;
                        $modelInvoice->invoice_date = $modelDI->invoice_date;
                        $modelInvoice->invoice_type = $modelDI->invoice_type;
                        $modelInvoice->payment_terms = $modelDI->payment_terms;
                        $modelInvoice->crm_user_id = $userModel->id;
                        $modelInvoice->is_direct_invoice = "Y";
                        $modelInvoice->save(false);
                        $modelInvoice->refresh();
                        $grand_total = $tot_tax = 0;
                        $actual_item_quantity = 0;
                        $modelDirectInvoiceItem = DirectInvoiceItem::model()->findAll(array('condition' => 'invoice_id =' . (int) $modelDI->id));
                        if (!empty($modelDirectInvoiceItem)) {
                            foreach ($modelDirectInvoiceItem as $i => $item) {

                                $modeInvoicelItem[$i] = new InvoiceItem;
                                $modeInvoicelItem[$i]->product_id = $item['product_id'];
                                $modeInvoicelItem[$i]->invoice_item_type = 'D';
                                $modeInvoicelItem[$i]->order_item_id = $item['id'];
                                $modeInvoicelItem[$i]->invoice_id = $modelInvoice->id;
                                $modeInvoicelItem[$i]->description = $item['description'];
                                $modeInvoicelItem[$i]->quantity = $item['quantity'];
                                $modeInvoicelItem[$i]->bonus_qty = 0;
                                $modeInvoicelItem[$i]->picked_qty = $item['quantity'];
                                $modeInvoicelItem[$i]->rate = $item['rate'];
                                $modeInvoicelItem[$i]->amount = $item['amount'];
                                $modeInvoicelItem[$i]->id = 0;
                                $modeInvoicelItem[$i]->tax_vat_amount = $item['tax_amount'];
                                $modeInvoicelItem[$i]->tax_vat_percentage = $item['tax_percentage'];
                                $modeInvoicelItem[$i]->deduction_amount = $item['deduction_amount'];
                                $modeInvoicelItem[$i]->net_amount = $item['amount'] - $item['deduction_amount'];
                                $modeInvoicelItem[$i]->unit_id = $item['unit_id'];
                                $tot_tax += $item['tax_amount'];
                                $grand_total += ($item['amount'] + $item['tax_amount']);
                                $modeInvoicelItem[$i]->save(false);
                            }
                            $modelInvoice->updateByPk($modelInvoice->id, array('grand_total' => $grand_total, 'total_tax_amount' => $tot_tax));
                            DirectInvoice::model()->updateByPk((int) $modelDI->id, array('posted' => 'Y', 'invoice_id' => (int) $modelInvoice->id));
                        }
                        foreach ($modelItem as $w => $eachModel) {

                            $arr_stock_ledger_data = $eachModel;
                            if ((int) $file_id > 0) {
                                //Deallocate products
                                $modelAllocate = new AllocatedMaterial();
                                $modelAllocate = $modelAllocate->find(array('condition' => 'file_id=' . (int) $file_id . ' AND product_id=' . $eachModel->product_id));
                                if (count($modelAllocate) > 0) {

                                    if ($eachModel->quantity == $modelAllocate['quantity']) {
                                        $modelDelAllocate = new AllocatedMaterial();
                                        $modelDelAllocate->deleteByPk($modelAllocate['id']);
                                    } else {

                                        $eachItemQuantity = -1 * $eachModel->quantity;
                                        $new_allocate_qty = $modelAllocate['quantity'] - $eachItemQuantity;
                                        if ((int) $new_allocate_qty > 0) {
                                            $modelAllocateQty = new AllocatedMaterial();
                                            $modelAllocateQty->updateByPk($modelAllocate['id'], array('quantity' => $new_allocate_qty));
                                        } else {
                                            $modelDelAllocate = new AllocatedMaterial();
                                            $modelDelAllocate->deleteByPk($modelAllocate['id']);
                                        }
                                    }
                                }
                                //End
                            }
                            $eachModel->save(false);
                        }

                        if (!empty($eachModel->serial_no)) {
                            StockLedger::model()->updateByPK($eachModel->master_stock_ledger_id, array('available_status' => 'U'));
                        } else {
                            $out_qty = Yii::app()->db->createCommand('SELECT SUM(quantity*unit_factor) FROM  erp_stock_ledger WHERE master_stock_ledger_id=' . $eachModel->master_stock_ledger_id . ' ')->queryScalar();
                            $arr_existing_stock_ledger = StockLedger::model()->findByPK($eachModel->master_stock_ledger_id);
                            $delivered_qty = (-1 * $out_qty);
                            if (($arr_existing_stock_ledger->quantity * $arr_existing_stock_ledger->unit_factor) == $delivered_qty) {
                                StockLedger::model()->updateByPK($eachModel->master_stock_ledger_id, array('available_status' => 'U'));
                            } else {
                                StockLedger::model()->updateByPK($eachModel->master_stock_ledger_id, array('available_status' => 'A'));
                            }
                        }
                        if ((int) $transaction_id > 0) {
                            DeliveryNote::model()->updateByPK($transaction_id, array('invoiced' => 'Y', 'status' => 'CL', 'updated_by' => $userModel->id, 'updated_datetime' => date('Y-m-d h:i:s')));
                        }
                    }
                    $data['status'] = 'success';
                    header("HTTP/1.1 200 OK");
                    header('Content-Type: application/json');

                    //Invoice Create end
                } else {
                    if ($flag == 1) {
                        $other[] = "Insufficient Quantity";
                    }
                    $data['status'] = 'failed';
                    if ($other != '[]') {
                        $data['msg'] = implode(',', $other);
                    }
                }
            } else {
                $data = array('status' => "failed", "msg" => "No Details Entered");
            }
            
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($data);
    }

    public function actionGetInvoiceDetailsFromId() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);

        if ($userModel->id > 0) {
            //$input = file_get_contents('php://input');
            //error_log($input);
            //$variables = json_decode($input, true);
            $invoice_id = (int) $_REQUEST['invoice_id'];
            $modelInvoice = Invoice::model()->with('customer', 'file')->findByPK($invoice_id);
            $data = [];
            if (!empty($modelInvoice)) {
                $modelInvoiceItem = InvoiceItem::model()->findAll(array('condition' => 'invoice_id=' . $invoice_id));
                $arr_items = [];
                foreach ($modelInvoiceItem as $row) {
                    $net_amount = $row->net_amount + $row->tax_vat_amount;
                    $arr_items[] = [
                        "id" => $row->id,
                        "product_id" => $row->product_id,
                        "part_number" => $row->product->part_number,
                        "description" => $row->description,
                        "rate" => $row->rate,
                        "quantity" => $row->quantity,
                        "amount" => $row->amount,
                        "discount" => $row->deduction_amount,
                        "unit_id" => $row->unit_id,
                        "unit_name" => $row->invoiceunit->name,
                        "net_amount" => $row->net_amount,
                        "tax_vat_amount" => $row->tax_vat_amount,
                        "tax_vat_percentage" => $row->tax_vat_percentage
                    ];
                }
                $data[] = [
                    "id" => $modelInvoice->id,
                    "file_id" => $modelInvoice['file_id'],
                    "company_name" => "AL SHAMSHI",
                    "address_line_1" => "Add 1",
                    "address_line_2" => "Add 2",
                    "company_phone" => "Phone12345",
                    "company_trn" => "XXXX-XXXXX",
                    "customer_name" => $modelInvoice['customer']['customer_name'],
                    "invoice_date" => date("d/m/Y", strtotime($modelInvoice['invoice_date'])),
                    "vat_amount" => $modelInvoice['total_tax_amount'],
                    "grand_total" => $modelInvoice['grand_total'],
                    "current_process_status" => $modelInvoice['file']['current_process_status'],
                    "payment_terms" => $modelInvoice->paymentTerm->payment_terms,
                    "terms_and_conditions" => $modelInvoice->terms_and_conditions,
                    "notes" => $modelInvoice->notes,
                    "items" => $arr_items
                ];
            } else {
                header('Content-Type: application/json');
                $data = array('status' => "failed", "msg" => "Invoice Not Exist");
            }
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($data);
    }

    public function actionPrintInvoiceReportPDF() {

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        //$token = "3-1637931714";
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {

            $model = new Invoice();
            $id = $_REQUEST['id'];
            $type = $_REQUEST['type'];
            $company_id = $userModel->company_id;

            $pdf_name = "";
            if ($id > 0) {
                $model = $model->findByPk($id);

                $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
                $page_name = "invoice_list_individual_tax";
                $pdf_name = "Invoice_" . $id . "_" . $model->customer->customer_name . '.pdf';
            }

            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.' . $page_name, array('model' => $model, 'id' => $id, 'company_id' => $company_id, 'title' => $title, 'mpdf' => $mPDF1), true));
            $mPDF1->Output('uploads/apppdf/' . $pdf_name, 'F');

            header('Content-Type: application/json');
            $data = array('status' => "success", "file_path" => "https://cumuluserp.me/awasi/uploads/apppdf/" . $pdf_name, "file_name" => $pdf_name);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($data);
    }

    public function actionUnlinkPDF() {

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        //$token = "3-1637919046";
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $id = $_REQUEST['id'];
            $file_name = $_REQUEST['file_name'];
            $path = Yii::getPathOfAlias('webroot') . "/uploads/apppdf/" . $file_name;
            if (file_exists($path)) {
                unlink($path);
            }
            $data = array('status' => "success");
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($data);
    }

    public function actionPrintDeliveryReportPDF() {
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        //$token = "3-1646040090";
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {

            $model = new DeliveryNote();
            $id = $_REQUEST['id'];
            $company_id = $userModel->company_id;

            $pdf_name = "";
            if ($id > 0) {
                $model = $model->findByPk($id);

                $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
                $page_name = "delivery_list_individual";
                $pdf_name = "Delivery_Note_" . $id . "_" . $model->customer->customer_name . '.pdf';
            }

            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.' . $page_name, array('model' => $model, 'id' => $id, 'company_id' => $company_id, 'title' => $title, 'mpdf' => $mPDF1), true));
            $mPDF1->Output('uploads/apppdf/' . $pdf_name, 'F');

            header('Content-Type: application/json');
            $data = array('status' => "success", "file_path" => "https://cumuluserp.me/awasi/uploads/apppdf/" . $pdf_name, "file_name" => $pdf_name);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($data);
    }

    public function actionUnlinkDeliveryNotePDF() {

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        //$token = "3-1637919046";
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {
            $id = $_REQUEST['id'];
            $file_name = $_REQUEST['file_name'];
            $path = Yii::getPathOfAlias('webroot') . "/uploads/apppdf/" . $file_name;
            if (file_exists($path)) {
                unlink($path);
            }
            $data = array('status' => "success");
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($data);
    }

    public function actionPrintDirectInvoiceReportPDF() {

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        //$token = "3-1651668113";
        $userModel = User::model()->findBytoken($token);
        if ($userModel->id > 0) {

            $model = new DirectInvoice();
            $id = $_REQUEST['id'];
            $company_id = $userModel->company_id;

            $pdf_name = "";
            if ($id > 0) {
                $model = $model->findByPk($id);

                $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
                $page_name = "direct_invoice_list_individual";
                $pdf_name = "ProformaInvoice_" . $id . '.pdf'; //."_".$model->customer_details->customer_name
            }

            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mPDF1->WriteHTML($stylesheet, 1);
            $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.' . $page_name, array('model' => $model, 'id' => $id, 'company_id' => $company_id, 'title' => $title, 'mpdf' => $mPDF1), true));
            $mPDF1->Output('uploads/apppdf/' . $pdf_name, 'F');

            header('Content-Type: application/json');
            $data = array('status' => "success", "file_path" => "https://cumuluserp.me/awasi/uploads/apppdf/" . $pdf_name, "file_name" => $pdf_name);
        } else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($data);
    }
    
    public function actionEditDirectInvoice(){
        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        //$token = "3-1637931714";
        $userModel = User::model()->findBytoken($token);
       
        if ($userModel->id > 0) {
            $id = $_REQUEST['id'];
            $modelDirectInvoice = new DirectInvoice();
            $modelDirectInvoice = $modelDirectInvoice->model()->findByPK($id);
            $arr_invoice_type[]=["invoice_type_id"=>$modelDirectInvoice->invoicetype->id,"inv_name" => $modelDirectInvoice->invoicetype->inv_name,"inv_tax"=>$modelDirectInvoice->invoicetype->tax];
            $arr_payment_terms[]=["id"=>$modelDirectInvoice->paymentTerm->id,"payment_terms" => $modelDirectInvoice->paymentTerm->payment_terms];
            $arr_customer_contacts[]=["contact_id" => $modelDirectInvoice['contact_id'],"person_name" => $modelDirectInvoice['contact_details']['person_name']];
            $data = [];
            if (!empty($modelDirectInvoice)) {
                
                $data[] = [
                    "id" => $modelDirectInvoice->id,
                    "file_id" => $modelDirectInvoice['file_id'],
                    "customer_id" => $modelDirectInvoice['customer_id'],
                    "customer_name" => $modelDirectInvoice['customer_details']['customer_name'],
                    "invoice_date" => date("d/m/Y", strtotime($modelDirectInvoice['invoice_date'])),
                    "vat_amount" => $modelDirectInvoice['total_tax_amount'],
                    "grand_total" => $modelDirectInvoice['grand_total'],
                    "terms_and_conditions" => $modelDirectInvoice->terms_and_conditions,
                    "default_contact_id" => $modelDirectInvoice['contact_id'],
                    //"items" => $arr_items,
                    "invoicetype" => $arr_invoice_type,
                    "payment_terms" => $arr_payment_terms,
                    "arr_contacts" => $arr_customer_contacts
                ];
            }
             else {
                header('Content-Type: application/json');
                $data = array('status' => "failed", "msg" => "Invoice Not Exist");
            } 
             
             
             
        } 
        else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($data);
    }
    
    public function actionEditDirectInvoiceItem(){
         $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
       // $token='3-1654078355';
        $userModel = User::model()->findBytoken($token);
       
        if ($userModel->id > 0) {
            $id = $_REQUEST['id'];
            $payment_term_id = $_REQUEST['payment_term_id'];
            $invoice_type_id = $_REQUEST['invoice_type_id'];
            $modelDirectInvoice = new DirectInvoice();
            $modelDirectInvoice = $modelDirectInvoice->model()->findByPK($id);
            
            $payment_term_type='';
            if($payment_term_id > 0){
                    $payment_term_type = MasPaymentTerm::model()->findByPk($payment_term_id)->payment_type;
            }
            //get invoice type
            $arr_mas_invoice_type = MasInvoiceType::model()->findByPk($invoice_type_id);
            
            $data = [];
            if (!empty($modelDirectInvoice)) {
                $modelDirectInvoiceItem = DirectInvoiceItem::model()->findAll(array('condition' => 'invoice_id=' . $id));
                $arr_items = [];
                
                
                
                foreach ($modelDirectInvoiceItem as $row) {
                    
                    //get price list
                    $arr_price_list = SalesPriceGroup::model()->find(array('condition'=>'product_id='.$row->product_id));
                    
                    //get uom details
                    $arr_uom = UnitOfMeasurement::model()->findByPK($row->unit_id);
        
                    $arr_secondary_uom = UnitOfMeasurement::getSecondaryBaseUnitWithName($row->product_id);
                    
                    $user_warehouse_ids = $userModel->available_warehouses;
                   
                    
                    if($payment_term_type=='CA'){
                        $cash_credit_price = $arr_price_list->cash_price;
                    }
                    else{
                        $cash_credit_price = $arr_price_list->credit_price;
                    }
        
                    
                     //To get product units
                    $arr_product_uom = UnitOfMeasurement::model()->findAll(array('condition'=>'product_id='.$row->product_id));
                    $arr_unit_details=[];
                    foreach ($arr_product_uom as $eachItem) {
                         $arr_unit_details[] = [
                             "id" => $eachItem->id,
                             "unit_name" => $eachItem->name,
                             "unit_factor" => $eachItem->factor,
                             "unit_price" => $cash_credit_price * $eachItem->factor
                             ];
                    }
                    
                    
                    if($arr_secondary_uom->unit_id!=$arr_uom->unit_id){
                        $cash_credit_price =  number_format(($cash_credit_price / $arr_secondary_uom->factor),2);
                    }
                    else{
                         $cash_credit_price =  number_format(($cash_credit_price * $arr_uom->factor),2);
                    }
                    
                    $total_amount = ($cash_credit_price * $row->quantity);
                    
                    
                    $tax_percentage = $row->tax_percentage;
                    
                    $tax_amount = ($total_amount * $tax_percentage) / 100;
                   // echo $total_amount."<br>";
                    //echo $tax_percentage;
                    
                    if($invoice_type_id!=$modelDirectInvoice->invoice_type && $arr_mas_invoice_type->tax=="N"){
                         $tax_amount = "0.00";
                        $tax_percentage = 0;
                    }
                    
                    
                     $location_condition='product_id='.$row->product_id.' AND stock_updated="Y"';
                
                    if(!empty($user_warehouse_ids)){
                        $location_condition.=' AND warehouse_id IN('.$user_warehouse_ids.')';
                    }
                    
                    $SQL='SELECT warehouse_name,SUM(quantity*unit_factor) as quantity FROM erp_stock_ledger WHERE '.$location_condition.' GROUP BY warehouse_id';
                    $locations = Yii::app()->db->createCommand($SQL)->queryAll();
                    $locations_data=[];
                    if( !empty( $locations ) ){ 
                        foreach( $locations as $i => $each){
                            $locations_data[] =[
                                "warehouse_name" => $each['warehouse_name'],
                                "quantity" => $each['quantity'],
                                "primary_unit" => $row['product']['unit']['unit_name'],
                                "secondary_quantity" => (int) ( $each['quantity']  / $second_unit_factor),
                                "secondary_unit" => $arr_secondary_uom->name,
                            ];
                        }
                    }
                    
                    
                    
                    
                    $arr_items[] = [
                        "id" => $row->id,
                        "product_id" => $row->product_id,
                        "part_number" => $row->product->part_number,
                        "description" => $row->description,
                        "rate" => $cash_credit_price,
                        "existing_rate" => $row->rate,
                        "quantity" => $row->quantity,
                        "amount" => $total_amount,
                        "existing_amount" => $row->amount,
                        "discount" => $row->deduction_amount,
                        "unit_id" => $row->unit_id,
                        "unit_name" => $row->uomdetails->name,
                        "tax_amount" => $tax_amount,
                        "tax_percentage" => $tax_percentage,
                        "net_amount" => ($total_amount + $tax_amount),
                        "unit_array" => $arr_unit_details,
                        "location" => $locations_data,
                    ];
                }
                $data[] = [
                    "items" => $arr_items
                ];
            }
             else {
                header('Content-Type: application/json');
                $data = array('status' => "failed", "msg" => "Invoice Not Exist");
            } 
             
             
             
        } 
        else {
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg" => "Unauthorized user");
        }
        echo json_encode($data);
    }

}