<?php



class ApicustomerController extends Controller {



    public function accessRules() {

        return array(

            array('allow', // allow all users to perform 'index' and 'view' actions

                'actions' => array("GetList","SaveCustomer","SearchOrderCustomer"),

                'users' => array('*'),

            ),

        );

    }



    public function filters() {

        return array(

            'accessControl', // perform access control for CRUD operations

        );

    }



    public function beforeAction($action) {

         $this->ChangeDB();
        return parent::beforeAction($action);

    }

    /**

     * API to Get customer list

     * Author  : Mereena

     * Modified :  09/11/2022

     * url https://cumuluserp.me/dehnee/index.php?r=apicustomer/GetList

     * input parameters term for auto search

     * 

     */

    public function actionGetList() {

        try {

                $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);

                $userModel = User::model()->findBytoken($token);



                //if(1==1) {

                if ($userModel->id > 0) {

        

                    $condition = " 1= 1";
                    

                    $term = $_REQUEST['term'];

                    if (!empty($term)) {

                        $condition .= " AND (( t.customer_name  LIKE '%{$term}%' ) OR ( t.customer_location  LIKE '%{$term}%' ) OR ( t.customer_phone_no  LIKE '%{$term}%' ))  ";

                    }

                    $count = Customer::model()->count(array('condition'=>$condition));

                    $models = Customer::model()->findAll([

                        "condition" => $condition,"order"=>"customer_name ASC",'limit'=>100

                    ]);
                     

                    header("HTTP/1.1 200 OK");

                    header('Content-Type: application/json');

                    $list = [];
if(isset($_REQUEST['all']) && $_REQUEST['all']  == 1){
	                                $list[]= ["id" => "0", "name" => "All Customer", "location" => "", "phone" => "", "email" => "" ];
                            }
                    if(!empty($models)) {

                        foreach ($models as $key => $row) {

                        $arr_contacts =[];

                        $mod_contacts =CustomerContact::model()->findAll(array('condition'=>'customer_id='.$row->id));

                        if(!empty($mod_contacts)){

                            $p=1;

                            foreach($mod_contacts as $each){

                                $arr_contacts[] =["id"=>"$p","contact_id"=>$each->id,"person_name"=>$each->person_name];

                                $p++;

                            }

                        }
                        
                            
                        $list[] = [

                            "id" => $row->id,

                            "name" => $row->customer_name,

                            "location" => $row->customer_location,

                            "phone" => $row->customer_phone_no,

                            "email" => $row->customer_email_id,

                            "address" => $row->customer_address,

                            "active" => $row->isActive,

                            "trn_no" => $row->customer_trn_no,

                            "trn_no_2" => $row->customer_trn_no_2,

                            "lattitude"=>$row->lattitude,

                            "longitude"=>$row->longitude,

                            "remarks"=>$row->customer_remarks,

                            "payment_terms" => $row['paymentmethod']['payment_terms'],

                            "payment_terms_id" => $row['paymentmethod']['id'],

                            "default_contact_id" => $arr_contacts[0]['contact_id'],

                            "arr_contacts" => $arr_contacts

                        ];

                    }

                        $data = array("status" => "success", "count"=>$count, "data"=>$list, "message"=>$count. "Records"); 

                    } else {

                        $data = array("status" => "success", "count"=>0, "data"=>$list, "message"=>"Empty Records"); 

                    }

                    

                    

                } else {

                    header("HTTP/1.1 401 Unauthorized");

                    header('Content-Type: application/json');

                    $data = array('status' => "error", "message"=>"Unauthorized user"); 

                }

        }

        catch(Exception $e) {

            header("HTTP/1.1 404 not found");

            header('Content-Type: application/json');

            $data = array('status' => "error", "message"=>"Unexpected Server error"); 

	   }

        echo json_encode($data);

    }

    /**

     * API to Save a customer

     * Author  : Mereena

     * Modified :  09/11/2022

     * url https://cumuluserp.me/dehnee/index.php?r=apicustomer/SaveCustomer

     * input parameters HTTP_TOKEN

     * input data 

            {

            	"customer_name": "Mereena",

            	"email": "demo@bluesky.com",

            	"location": "Dubai",

            	"phone": "1234567890",

            	"trn_no": "101",

            	"remarks": "Demo User"

            }

     */

    public function actionSaveCustomer() {

        try {

                $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
                //$token='2-1667976132';

                $userModel = User::model()->findBytoken($token);


                if ($userModel->id > 0) {


                    $input = file_get_contents('php://input');
                  /*  $input ='{

            	"customer_name": "Jisha",

            	"email": "demo@bluesky.com",

            	"location": "Sharjah",

            	"phone": "4554545454"


            }';*/
                    
                   
                    $variables = json_decode($input, true);
                    /*echo 'jjj<pre>';
                     print_r($variables);
                    exit;*/

                    $user_id   = $userModel->id;

                  

                    $model          = new Customer();

                    $model_contact   = new CustomerContact();
                      

                    if ((int)$variables['id'] > 0) {

                        $id =  (int)$variables['id'];

                        $model = $model->findByPK($id);

                        $scene = 'update';

                        $change_type = 'UPDATED';

                    } else {

                        $model->created_by = (int)$user_id;

                        $model->created_date_time = date('Y-m-d H:i:s');

                        $scene = 'new';

                        $change_type = 'CREATED';

                    }

                    $model->updated_by = (int)$user_id;

                    $model->updated_date_time =date('Y-m-d H:i:s');

                    $model->customer_name = $variables['customer_name'];

                    $model->customer_email_id = $variables['email'];

                    $model->customer_location = $variables['location'];

                    $model->customer_phone_no = $variables['phone'];

                    $model->customer_trn_no = '';

                    $model->customer_remarks = ''; 

                    $model->customer_payment_term= 0 ;    


                    $arr_company = MasCompany::model()->findByPk($userModel->company_id);
                    
                    $model->customer_country= $arr_company->billing_country;

                    $model->customer_currency_id = $arr_company->currency_id;

                    $modelSalesPriceGroupName = new SalesPriceGroupName();

                    $arr_default_pricing_group = $modelSalesPriceGroupName->find(array('condition'=>'default_pricing_group="Y"'));

                    $model->default_pricing_group_id=$arr_default_pricing_group->id;
                    
                    $valid =$model->validate();


                    if($valid){

                    $model->save();


                    //--------------inserting customer contact-------------
                    $model_contact->customer_id=$model->id;
                    $model_contact->prefix="Mr"; 
                    $model_contact->person_name="Sales/Account";                    
                    $model_contact->isActive="Y";
                    $model_contact->created_by = (int)$user_id;
                    $model_contact->created_date_time = date('Y-m-d H:i:s');
                    $model_contact->save();
                    //-------------- end inserting customer contact-------------



                    // inserting to audit log

                        AuditLog::saveAuditLogs(

                            'CUSTOMERS',

                            (int)$user_id,

                            $change_type,

                            " with ID - {$model->id} "

                        );

                        $model->saveSublegder();

                       
                        $data = array('status' => "success", "data" => ["user_id" => $model->id, "message"=>"Customer saved successfully"]); 

            

                    } else {

                        $error2 =array();

                        $error1 = json_decode(CActiveForm::validate($model, '', false), true);


                        $error = array_merge_recursive($error1, $error2);

                        foreach($error as $a=>$eacherror){

                            $other[]= $eacherror[0];

                        }      

                        header("HTTP/1.1 200 OK");

                        header('Content-Type: application/json');

                        $data = array('status' => "error", "message"=>implode(',',$other)); 

                    }

                    

                }else{

                    header("HTTP/1.1 401 Unauthorized");

                    header('Content-Type: application/json');

                    $data = array('status' => "error", "message"=>"Unauthorized user"); 

                }

        }

	    catch(Exception $e) {

            header("HTTP/1.1 404 not found");

            header('Content-Type: application/json');

            $data = array('status' => "error", "message"=>"Unexpected Server error"); 

	   }

        echo json_encode($data);

    }

    public function actionGetCustomerDetails(){

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);

        $userModel = User::model()->findBytoken($token);



        if ($userModel->id > 0) {

            $condition = ' inv_type="sales" ';

            $models = MasInvoiceType::model()->findAll(array('condition' => $condition));

            $data = [];

            foreach ($models as $key => $row) {

                $data[] = [

                    "id" => $row->id,

                    "inv_name" => $row->inv_name

                ];

            }

            

        }else{

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 

        }

        echo json_encode($data);

    }

    public function actionSearchOrderCustomer(){ 

        $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);

        $userModel = User::model()->findBytoken($token);



        if ($userModel->id > 0) {

            $input = file_get_contents('php://input');

            //error_log($input);

            $variables = json_decode($input, true);

            $term = trim($variables['term']);

            $customer_id = trim((int)$variables['customer_id']);

        

            $condition = " 1= 1";

            if (!empty($term)) {

                $condition = " ( t.customer_name  LIKE '{$term}%' ) ";

            }

            $models = Customer::model()->findAll([

                "condition" => $condition

            ]);

            $data = [];

            foreach ($models as $key => $row) {

                $arr_contacts =[];

                $mod_contacts =CustomerContact::model()->findAll(array('condition'=>'customer_id='.$row->id));

                if(!empty($mod_contacts)){

                    foreach($mod_contacts as $p=>$each){

                        $arr_contacts[] =["id"=>"$p","contact_id"=>$each->id,"person_name"=>$each->person_name];

                    }

                }

                $data[] = [

                    "id" => $row->id,

                    "name" => $row->customer_name,

                    "payment_terms_id" => $row['paymentmethod']['id'],

                    "arr_contacts" => $arr_contacts

                ];

            }

            header("HTTP/1.1 200 OK");

            header('Content-Type: application/json');

            

        }else{

            header("HTTP/1.1 401 Unauthorized");

            header('Content-Type: application/json');

            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 

        }

        echo json_encode($data);

    }
    
    
           
   

}

