<?php

/**
 * alaqsar Image API
 * Author  : Ramesh
 * Created :  21/06/2022
 */
class ApiImageController extends Controller {
    
    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(
                    'GetCategoryImage','GetInventoryImage'
                ),
                'users' => array('*'),
            ),
            
        );
    }
    
    public function beforeAction($action) {
        $this->ChangeDB();
        return parent::beforeAction($action);
    }
     /**
     * API to update last call date in db
     * Author  : Ramesh
     * Created :  27/06/2022
     * url https://cumuluserp.me/alaqsar/index.php?r=apiImage/UpdateCall
     * input parameters HTTP_TOKEN
     * input data 
            {
            	"status": "success",
            	"path": "apiImage/GetCategoryImage",
            	"count":30,
            	"user_id":2
            }
     */
	public function actionUpdateCall() {
	    try {
    	    $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
    	    $userModel = User::model()->findBytoken($token);//checking user token
            //if ($userModel->id > 0) {
            if (1==1) {
                $input = file_get_contents('php://input');
                $variables = json_decode($input, true);
                //print_r($variables);
                $status = $variables['status'];
                $path = $variables['path'];
                $count = $variables['count'];
                $user_id = $variables['user_id'];
                $total_count = 0;
                if($path=='apiImage/GetCategoryImage') {
                    $model = new MasGeneric();
                    $condition = "is_Active='Y'";
                    $total_count = $model->count(array('condition'=>$condition));
                } else if($path=='apiImage/GetInventoryImage') {
                    $model = new Store();
                    $condition = "isActive='Y'";
                    $total_count = $model->count(array('condition'=>$condition));
                }
                
                if($status=='success' && $total_count==$count) {
                    $logmodel = new ApiCall();
                    $logmodel->api = $path;
                    $logmodel->user_id = $user_id;
                    $logmodel->call_date = date('Y-m-d');
                    $logmodel->save();
                    $data = array('status' => "success", "message" => "Api Call log updated");
                    
                } else {
                    $data = array('status' => "success", "message" => "Api Call log update failed");
                }
                header("HTTP/1.1 200 OK");
                header('Content-Type: application/json');
    	    } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $data = array('status' => "error", "error"=>"Unauthorized user"); 
            }
	    }
	    catch(Exception $e) {
            header("HTTP/1.1 404 not found");
            header('Content-Type: application/json');
            $data = array('status' => "error", "message"=>"Unexpected Server error"); 
	   }
        echo json_encode($data);

	}
    /**
     * API to get category images and category details
     * Author  : Ramesh
     * Created :  21/06/2022
     * url https://cumuluserp.me/alaqsar/index.php?r=apiImage/GetCategoryImage
     * input parameters HTTP_TOKEN
     */
	public function actionGetCategoryImage() {
	    try {
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $from_date = '';
            $user_id = 0;
            if(isset($_REQUEST['user_id']))
            $user_id = $_REQUEST['user_id'];
            $path = 'apiImage/GetCategoryImage';
            $logmodel = new ApiCall();
            $condition = "api='".$path."' AND user_id=".$user_id;
            $log = $logmodel->find([
                    "condition" => $condition,"order"=>"id DESC"
                ]);
            if(!empty($log)) {
                $from_date = $log->call_date;
            } 
            //$from_date = '2022-06-19';

            $userModel = User::model()->findBytoken($token);//checking user token
             //if ($userModel->id > 0) {
            if (1==1) {
                $model = new MasGeneric();
                $condition = "is_Active='Y'";
                $list = array();
                
                //$from_date = $_SERVER['HTTP_DATE'];
                if($from_date!='') $condition .= " AND created_date_time >= '".$from_date."' OR updated_date_time >= '".$from_date."'";
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition));
                $recordsTotal = $count;
                
                if(!empty($model)) {
                    foreach ($model as $row) {
                        if($row['generic_image']!='') 
                            $image = "/uploads/category/".$row['generic_image'];
                        else 
                            $image = "/uploads/no-image-icon.png";
                        if($row['updated_date_time']!='0000-00-00 00:00:00' && $from_date!='') 
                            $list['updated_list'][] = array("id"=>$row['id'],"title"=>$row['generic_name'],"description"=>$row['generic_description'],"image"=>$image);
                        else
                            $list['created_list'][] = array("id"=>$row['id'],"title"=>$row['generic_name'],"description"=>$row['generic_description'],"image"=>$image);
                    }
                }
                if(empty($list['updated_list']))
                    $list['updated_list'] = array();
                if(empty($list['created_list']))
                    $list['created_list'] = array();
                $data = array('status' => "success", "count"=>$recordsTotal, "data"=>$list);
                header("HTTP/1.1 200 OK");
                header('Content-Type: application/json');
    	    } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $data = array('status' => "error", "error"=>"Unauthorized user"); 
            }
	    }
	    catch(Exception $e) {
            header("HTTP/1.1 404 not found");
            header('Content-Type: application/json');
            $data = array('status' => "error", "message"=>"Unexpected Server error"); 
	   }
        echo json_encode($data);

	}
	/**
     * API to get Inventory images and Inventory details
     * Author  : Ramesh
     * Created :  22/06/2022
     * url https://cumuluserp.me/alaqsar/index.php?r=apiImage/GetInventoryImage
     * input parameters HTTP_TOKEN
     */
	public function actionGetInventoryImage() {
	    try {
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $from_date = '';
            $user_id = 0;
            if(isset($_REQUEST['user_id']))
            $user_id = $_REQUEST['user_id'];
            $path = 'apiImage/GetInventoryImage';
            $logmodel = new ApiCall();
            $condition = "api='".$path."' AND user_id=".$user_id;
            $log = $logmodel->find([
                    "condition" => $condition,"order"=>"id DESC"
                ]);
            if(!empty($log)) {
                $from_date = $log->call_date;
            } 
            //$from_date = '2022-06-19';

            $userModel = User::model()->findBytoken($token);//checking user token
            //if ($userModel->id > 0) {
            if (1==1) {
                $model = new Store();
                $condition = "isActive='Y'";
                if($from_date!='') $condition .= " AND created_date_time >= '".$from_date."' OR updated_date_time >= '".$from_date."'";
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition));
                $recordsTotal = $count;
                $list = array();
                if(!empty($model)) {
                    foreach ($model as $row) {
                        if($row['item_image']!='') 
                            $image = "/uploads/inventoryimages/".$row['item_image'];
                        else 
                            $image = "/uploads/no-image-icon.png";
                        $unit_symbol = '';
                        $unit_name = '';
                        if($row['unit_id']!=""){
                            $unit = Unit::model()->findByPk($row['unit_id']);
                            $unit_symbol =  $unit->symbol;
                            $unit_name =  $unit->unit_name;
                        }
                        $unit_array = array();
                        $all_units = UnitOfMeasurement::model()->findAll(array('condition' => 'product_id = '.$row['id'],'order' => 'isBase'));
                        if(!empty($all_units)) {
                            foreach ($all_units as $unit) {
                                $unit_array[] = array(
                                         "unit_id"=>$unit->id,
                                         "unit_name"=>$unit->name,
                                         "unit_factor"=>$unit->factor,
                                         "unit_price"=>$unit->price,
                                        );
                            }
                        }
                        if($row['updated_date_time']!='0000-00-00 00:00:00' && $from_date!='') 
                            $list['updated_list'][] = array(
                                "id"=>$row['id'],
                                "part_number"=>$row['part_number'],
                                "oem_number"=>$row['oem_number'],
                                "generic_id"=>$row['generic_id'],
                                "rate"=>$row['rate'],
                                "selling_price_1"=>$row['selling_price_1'],
                                "selling_price_2"=>$row['selling_price_2'],
                                "unit_id"=>$row['unit_id'],
                                "unit_dropdown"=>$unit_array,
                                "description"=>$row['description'],
                                "image"=>$image);
                        else
                            $list['created_list'][] = array(
                                "id"=>$row['id'],
                                "part_number"=>$row['part_number'],
                                "oem_number"=>$row['oem_number'],
                                "generic_id"=>$row['generic_id'],
                                "rate"=>$row['rate'],
                                "selling_price_1"=>$row['selling_price_1'],
                                "selling_price_2"=>$row['selling_price_2'],
                                "unit_id"=>$row['unit_id'],
                                "unit_dropdown"=>$unit_array,
                                "description"=>$row['description'],
                                "image"=>$image);
                            
                    }
                }
                if(empty($list['updated_list']))
                    $list['updated_list'] = array();
                if(empty($list['created_list']))
                    $list['created_list'] = array();
                $data = array('status' => "success", "count"=>$recordsTotal, "data"=>$list);
                header("HTTP/1.1 200 OK");
                header('Content-Type: application/json');
    	    } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $data = array('status' => "error", "error"=>"Unauthorized user"); 
            }
	    }
	    catch(Exception $e) {
            header("HTTP/1.1 404 not found");
            header('Content-Type: application/json');
            $data = array('status' => "error", "message"=>"Unexpected Server error"); 
	    }
        echo json_encode($data);

	}
    
}