<?php

/**
 * alaqsar Sales Module
 * Author  : Jisha
 * Created :  27/10/2021
 * Modified : 21/06/2022
 */
class ApiController extends Controller
{


    public $round_off = '2';

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(
                    'logout', 'error', 'Login', 'MainLogin', 'Getusers', 'GetPaymentTerms', 'GetInvoiceType', 'Getother', 'LoginSuccess','InvoiceLoginValidate','GetSalesDetails','getUserIdFromStaffid'
                ),
                'users' => array('*'),
            ),
        );
    }

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function format_currency($value)
    {
        return number_format(round((float) $value, $this->round_off), $this->round_off, '.', '');
    }

    public function convert_date($date = null)
    {

        $date_converted = date('Y-m-d');

        if ($date != null) {
            //yyyy-mm-dd
            $arr_date = explode('-', $date);
            //mm/dd/yyyy
            if (checkdate($arr_date[1], $arr_date[2], $arr_date[0])) {
                $date_converted = date('Y-m-d', strtotime(str_replace('/', '-', $date)));
            }
        }
        return $date_converted;
    }


    public function connectMainDB($company_db_name)
    {
        Yii::app()->db->setActive(false);
        if (empty($company_db_name)) {
            $company_db_name = '=blueskye_pos_dehnee_main';
        }
        Yii::app()->db->connectionString = 'mysql:host=e-sell.me;dbname=blueskye_pos_dehnee_main';
        Yii::app()->db->username = 'blueskye_dehnee';
        Yii::app()->db->password = 'Ma9C;(#=3a&P';
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
    }
    public function beforeAction($action)
    {
        /*$company_db_name = "blueskye_pos_dehnee";
        Yii::app()->db->setActive(false);
        Yii::app()->db->connectionString = 'mysql:host=localhost;dbname=' . $company_db_name;
        Yii::app()->db->tablePrefix = 'erp_';
        Yii::app()->db->setActive(true);
        return true;*/
        $this->ChangeDB();
        return true;
    }
    /**
     * User login check
     * Author  : Mereena
     * Created :  09/11/2022
     * Modified : 09/11/2022
     * 
     */
    public function actionLogin()
    {
        /*  Url: https://cumuluserp.me/dehnee/index.php?r=api/Login
            input data 
            {
            	"code": "AQSAR",
            	"username": "admin",
            	"password": "demo"
            }
        */
        try {

            $input = file_get_contents('php://input');
            $variables = json_decode($input, true);
            $code = trim($variables['code']);
            $username = trim($variables['username']);
            $password = trim($variables['password']);
            $model = new LoginForm;
            $model->company_code = $code;
            $model->username = $username;
            $model->password = $password;
            $isLogin = $model->validate() && $model->login();
            $user_id = "";
            $name = "";
            $footer="";
            $outlet_name="";
            $user = new User();
            if ($isLogin) {
                $company_id = 0;
                if(!empty($code)){
                    $company_id = (int) MasCompany::getCompanyId($code);
                }
                
                
                $condition = 'LOWER(username)="'.strtolower($username).'" AND isActive="Y" AND (level=3 || level=0)';//level 3 allow only branch head
                
                //$condition = "t.username = '" . $username . "' ";
                if($company_id > 0){
                    $condition.=' AND company_id='.$company_id;
                }
                $user = $user->find(array('condition' => $condition));
                $user->_generate_token;
                $company_id = $user->company_id;
                $modelcompany = new MasCompany();
                $modelcompany_det = $modelcompany->findBypk((int) $user->company_id);
                $company_name = $modelcompany_det->company_name;
                $billing_address = $modelcompany_det->billing_address;
                $genral_phno = $modelcompany_det->genral_phno;
                $genral_email = $modelcompany_det->genral_email;
                $genral_web = $modelcompany_det->genral_web;
                $trn_no = $modelcompany_det->trn_no;
                $logo = 'images/logo.png';
                
                $user_id = $user->id;
                $name = $user->fullname;
                $warehouse_id =  (int) $user->available_warehouses;
                $modelWarehouse = new MasInventoryWarehouse();
                $barcode="N";
                if($warehouse_id > 0){
                    $modelWarehouse = $modelWarehouse->findByPk($warehouse_id);
                    $company_name = $modelWarehouse->warehouse_outlet_name;
                    $outlet_name = $modelWarehouse->warehouse_name; 
                    $billing_address = $modelWarehouse->address;
                    $logo = 'uploads/warehouse/thumbs/'.$modelWarehouse->upload_image;
                    $footer = $modelWarehouse->footer;
                    $barcode = $modelWarehouse->bar_code_only;
                   

                }
                
                
                header("HTTP/1.1 200 OK");
                header('Content-Type: application/json');
                //  $data = array('status' => "success", "data" => ["user_id" => $user_id, "name" => $name,"_token"=>$user->token,"message"=>"User authorized"]);     
                
                $modelCustomer = new Customer();
                $modelCustomer = $modelCustomer->find(array('condition'=>'isDefault="Y"'));
                if(!empty($modelCustomer)){
                    $default_customer_id = $modelCustomer->id;
                }
                else{
                    $modelCustomer = new Customer();
                     $modelCustomer = $modelCustomer->find(array('condition'=>'isActive="Y"','order'=>'id ASC'));
                     $default_customer_id = $modelCustomer->id;
                }
                

                $data = array(
                    'status' => "success", 
                    "data" => 
                    [
                        "trn_no" => $trn_no, 
                        "genral_web" => $genral_web, 
                        "genral_email" => $genral_email, 
                        "genral_phno" => $genral_phno, 
                        "company_name" => $company_name, 
                        "outlet_name"=>$outlet_name,
                        "master_company_id" => $company_id, 
                        "billing_address" => $billing_address, 
                        "user_id" => $user_id, 
                        "warehouse_id" => $warehouse_id,
                        "default_customer_id"=>$default_customer_id,
                        "name" => $name, 
                        "_token" => $user->token, 
                        "company_logo" => $logo,
                        "footer" =>$footer,
                        "barcodenabled" => $barcode,
                        "message" => "User authorized"
                    ]
                    );
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $data['status'] = 'failed';
                $data['message'] = 'Unauthorized user';
            }
        } catch (Exception $e) {
            header("HTTP/1.1 404 not found");
            header('Content-Type: application/json');
            $data = array('status' => "error", "message" => "Unexpected Server error");
        }

        echo json_encode($data);
    }

    //changed
    public function actionGetusers()
    {
        /*$token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = MasUsers::model()->findBytoken($token);

        if ($userModel->id > 0) {*/
        $items = User::model()->findAll(array('condition' => 'is_active="Y" AND id=' . $userModel->id));
        foreach ($items as $i => $each) {
            $data[] = [
                "id" => $each->id,
                "name" => $each->full_name
            ];
        }
        header("HTTP/1.1 200 OK");
        header('Content-Type: application/json');
        /*}else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }*/
        echo json_encode($data);
    }
    /**
     * API to get all payment terms
     * Author  : Ramesh
     * Modified :  28/06/2022
     * url https://cumuluserp.me/alaqsar/index.php?r=api/GetPaymentTerms
     * input parameters HTTP_TOKEN
     */
    public function actionGetPaymentTerms()
    {
        try {
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            $userModel = User::model()->findBytoken($token);

            //if ($userModel->id > 0) {
            if (1 == 1) {
                $condition = "isActive='Y'";
                $models = MasPaymentTerm::model()->findAll(array('condition' => $condition));

                $count = MasPaymentTerm::model()->count(array('condition' => $condition));
                $list = [];
                $m = 1;
                foreach ($models as $key => $row) {
                    $list[] = [
                        "sort_id" => $m,
                        "id" => $row->id,
                        "payment_code" => $row->payment_code,
                        "no_of_days" => $row->no_of_days,
                        "payment_terms" => $row->payment_terms
                    ];
                    $m++;
                }
                $data = array('status' => "success", "count" => $count, "data" => $list, "message" => $count . " Records");
                header("HTTP/1.1 200 OK");
                header('Content-Type: application/json');
            } else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $data = array('status' => "error", "message" => "Unauthorized user");
            }
        } catch (Exception $e) {
            header("HTTP/1.1 404 not found");
            header('Content-Type: application/json');
            $data = array('status' => "error", "message" => "Unexpected Server error");
        }
        echo json_encode($data);
    }
    public function actionGetInvoiceType()
    {
        /*$token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
        $userModel = User::model()->findBytoken($token);

        if ($userModel->id > 0) {*/
        $condition = ' inv_type="sales" ';
        $models = MasInvoiceType::model()->findAll(array('condition' => $condition));
        $data = [];
        $m = 1;
        foreach ($models as $key => $row) {
            $data[] = [
                "sort_id" => $m,
                "id" => $row->id,
                "inv_name" => $row->inv_name
            ];
            $m++;
        }
        header("HTTP/1.1 200 OK");
        header('Content-Type: application/json');

        /* }else{
            header("HTTP/1.1 401 Unauthorized");
            header('Content-Type: application/json');
            $data = array('status' => "failed", "msg"=>"Unauthorized user"); 
        }*/
        echo json_encode($data);
    }

    public function actionLoginSuccess()
    {
        $input = file_get_contents('php://input');
        //error_log($input);
        $variables = json_decode($input, true);

        $user_id    = trim($variables['user_id']);
        $username   = trim($variables['name']);
        $token      = trim($variables['_token']);

        $condition = "id = " . $user_id . ' AND token="' . $token . '"';
        $arr_user = User::model()->find(array('condition' => $condition));

        if (count($arr_user) > 0) {
            $data = array('status' => "success");
        } else {
            $data = array('status' => "failed");
        }
        header("HTTP/1.1 200 OK");
        header('Content-Type: application/json');
        echo json_encode($data);
    }
    
    public function actionGetUserList() {

        try {

                $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
                //$token="2-1668073388";
                $userModel = User::model()->findBytoken($token);
                if ($userModel->id > 0) {
                    
                    $term=trim($_REQUEST['term']);

                    $condition = " level=4 AND company_id=".$userModel->company_id;//only sales man
                    
                    if (!empty($term)) {

                        $condition.= " AND (first_name  LIKE '%{$term}%' OR last_name  LIKE '%{$term}%' )";

                    }
                    
                    if($userModel->level > 0){
                        $condition.=' AND available_warehouses='.$userModel->available_warehouses;
                    }

                    $models = User::model()->findAll([

                        "condition" => $condition,"order"=>"first_name ASC"

                    ]);
                     


                    $list = [];
                     if(isset($_REQUEST['all']) && $_REQUEST['all'] == 1 ){
                                            $list[]= ["id" => "0", "user_name" => "All User"];
                                        }
                    if(!empty($models)) {

                        foreach ($models as $key => $row) {


                        $list[] = [

                            "id" => $row->id,

                            "user_name" => $row->first_name." ".$row->last_name,

                            
                        ];

                    }
                   

                        $data = array("status" => "success", "data"=>$list, "message"=>$count. "Records"); 

                    } else {

                        $data = array("status" => "success", "data"=>$list, "message"=>"Empty Records"); 

                    }

                    

                    

                } else {

                    header("HTTP/1.1 401 Unauthorized");

                    header('Content-Type: application/json');

                    $data = array('status' => "error", "message"=>"Unauthorized user"); 

                }

        }

        catch(Exception $e) {

            header("HTTP/1.1 404 not found");

            header('Content-Type: application/json');

            $data = array('status' => "error", "message"=>"Unexpected Server error"); 

	   }

        echo json_encode($data);

    }
    
    public function actionGetWarehouseList() {

        try {

                $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
                //$token="2-1668073388";
                $userModel = User::model()->findBytoken($token);
                if ($userModel->id > 0) {
                    
                     $term=trim($_REQUEST['term']);

                    $condition = " warehouse_code!='DAM'";
                    
                    if (!empty($term)) {

                        $condition.= " AND (warehouse_name  LIKE '%{$term}%' )";

                    }

                    if((int) $userModel->level>1){
                        $condition.=' AND id='.(int) $userModel->available_warehouses;
                    }
                    $models = MasInventoryWarehouse::model()->findAll([

                        "condition" => $condition,"order"=>"warehouse_name ASC"

                    ]);
                     
                    $list = [];

                    if(!empty($models)) {

                        foreach ($models as $key => $row) {

                        $list[] = [

                            "id" => $row->id,

                            "warehouse_name" => $row->warehouse_name,

                            
                        ];

                    }

                        $data = array("status" => "success", "data"=>$list, "message"=>$count. "Records"); 

                    } else {

                        $data = array("status" => "success", "data"=>$list, "message"=>"Empty Records"); 

                    }

                    

                    

                } else {

                    header("HTTP/1.1 401 Unauthorized");

                    header('Content-Type: application/json');

                    $data = array('status' => "error", "message"=>"Unauthorized user"); 

                }

        }

        catch(Exception $e) {

            header("HTTP/1.1 404 not found");

            header('Content-Type: application/json');

            $data = array('status' => "error", "message"=>"Unexpected Server error"); 

	   }

        echo json_encode($data);

    }
    
    
    public function actionInvoiceLoginValidate()
    {
         try {
             
            $input = file_get_contents('php://input');
            $variables = json_decode($input, true);

            $user_id            = trim($variables['user_id']);
            $password           = trim($variables['password']);
            $warehouse_id       = trim($variables['warehouse_id']);
            $master_company_id  = trim($variables['master_company_id']);
            
            $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
            $password = crypt($password, $salt);
            
            $modelUser = User::model()->find(array('condition'=>'id='.(int) $user_id.' AND password="'.$password.'" AND available_warehouses='.(int) $warehouse_id.' AND company_id='.$master_company_id));
            
            if(!empty($modelUser)){
                $data = array('status' => "success", "user_id"=>$user_id,"warehouse_id"=>$warehouse_id);  
            }
            else{
                $data = array('status' => "error", "message"=>"Invalid User");  
            }
            
            
         }
         catch(Exception $e) {

            header("HTTP/1.1 404 not found");

            header('Content-Type: application/json');

            $data = array('status' => "error", "message"=>"Unexpected Server error"); 

	   }

        echo json_encode($data);
        
    }
    
    public function actionGetSalesDetails(){
        try {
            
            $token = filter_var($_SERVER['HTTP_TOKEN'], FILTER_SANITIZE_STRING);
            //$token = "6-1669198907";
            $userModel = User::model()->findBytoken($token);

            if ($userModel->id > 0) {
             
                $input              = file_get_contents('php://input');
                $variables          = json_decode($input, true);
                $warehouse_id       = (int) trim($variables['warehouse_id']);
                $from_date          =  trim($variables['frm_date']);
                $end_date            =  trim($variables['to_date']);
                
                //$from_date = "2022-11-26";
                //$end_date = "2022-11-27";
                
                $modelMasInventoryWarehouse = new MasInventoryWarehouse();
                $condition = 'isActive="Y" AND warehouse_code!="DAM" AND isBaseWareHouse="N"';
                
                if ($warehouse_id > 0) {
                    $condition .= 'AND id=' . $warehouse_id;
                }
                $arr_warehouse_list = $modelMasInventoryWarehouse->findAll(array('condition' => $condition));
                
                $list = [];
                
                
                foreach ($arr_warehouse_list as $warehouse_list ) {

                    // -------------------------
                    $SQL_INV =  'SELECT SUM(total_tax_amount) AS total_tax_amount,SUM(grand_total-total_tax_amount) AS invoice_amount,SUM((((grand_total-total_tax_amount) * commission)/100)) AS commission_amount FROM `view_sales_details` WHERE  `invoice_date` >=" ' . $from_date . '"  AND `invoice_date` <= "' .$end_date.'" AND  warehouse_id = "' . $warehouse_list ->id.'"';
                   // echo $SQL_INV;
                    $arr_sales    = Yii::app()->db->createCommand($SQL_INV)->queryAll();
                    
                    /*echo '<pre>';
                    print_r($arr_sales);*/
                    
                    $total_sales   = $arr_sales[0]['invoice_amount'];
                    $total_invoice_amount   = $arr_sales[0]['invoice_amount'] - $arr_sales[0]['commission_amount'];
                    $total_tax_amount       = $arr_sales[0]['total_tax_amount'];
                    
                    // -------------------------
                
                    $SQL_CASH =  'SELECT SUM(received_amount) AS received_amount  FROM `view_sales_details` WHERE  `receipt_type`="CH" AND `invoice_date` >=" ' . $from_date . '"  AND `invoice_date` <= "' . $end_date . '" AND  warehouse_id = "' . $warehouse_list ->id.'"';
                
                    $total_cash_sales    = Yii::app()->db->createCommand($SQL_CASH)->queryScalar();
                    
                    // -------------------------
                    
                    $SQL_CARD =  'SELECT SUM(received_amount) AS received_amount  FROM `view_sales_details` WHERE  `receipt_type`="CA" AND `invoice_date` >=" ' . $from_date . '"  AND `invoice_date` <= "' . $end_date . '" AND  warehouse_id = "' . $warehouse_list ->id.'"';
                
                    $total_card_sales    = Yii::app()->db->createCommand($SQL_CARD)->queryScalar();
                    
                    // -------------------------
                    
                    // -------------------------
                    $SQL_CASH_CARD =  'SELECT SUM(received_amount) AS received_amount  FROM `view_sales_details` WHERE  `receipt_type`="CC" AND `invoice_date` >=" ' . $from_date . '"  AND `invoice_date` <= "' . $end_date . '" AND  warehouse_id = "' . $warehouse_list ->id.'"';
                
                    $total_cash_card_sales    = Yii::app()->db->createCommand($SQL_CASH_CARD)->queryScalar();
                    // -------------------------
                    
                    
                    
                      $list[] = [
                            "warehouse_name"        => $warehouse_list->warehouse_name,
                            "total_sales"           => Yii::app()->numberFormatter->formatCurrency($total_sales,""),
                            "total_vat_amount"      => Yii::app()->numberFormatter->formatCurrency($total_tax_amount,""),
                            "total_cash_sales"      => Yii::app()->numberFormatter->formatCurrency($total_cash_sales,""),
                            "total_card_sales"      => Yii::app()->numberFormatter->formatCurrency($total_card_sales,""),
                            "total_cash_card_sales" => Yii::app()->numberFormatter->formatCurrency($total_cash_card_sales,""),
                            "total_commision_amount" => Yii::app()->numberFormatter->formatCurrency($arr_sales[0]['commission_amount'],""),
                            "total_balance"  => Yii::app()->numberFormatter->formatCurrency($total_invoice_amount,""),
                            ];
                
                }
                
                $data = array('status' => "success", "items"=>$list);  
                
               
            }
            else{
                $data = array('status' => "error", "message"=>"Invalid User");  
            }
            
            
         }
         catch(Exception $e) {

            header("HTTP/1.1 404 not found");

            header('Content-Type: application/json');

            $data = array('status' => "error", "message"=>"Unexpected Server error"); 

	   }

        echo json_encode($data);
    }
    
       public function actiongetUserIdFromStaffid()
    {
         try {
             
            $input = file_get_contents('php://input');
            $variables = json_decode($input, true);

            $user_id            = trim($variables['user_id']);
            $staff_id           = trim($variables['staff_id']);
            $warehouse_id       = trim($variables['warehouse_id']);
            $master_company_id  = trim($variables['master_company_id']);
            
            $salt = '$2a$10$1qAz2wSx3eDc4rFv5tGb5t';
            $password = crypt($password, $salt);
            
            $modelUser = User::model()->find(array('condition'=>'staff_id="'.$staff_id.'" AND available_warehouses='.(int) $warehouse_id.' AND company_id='.$master_company_id));
            
            if(!empty($modelUser)){
                $user_id ='';
                if(!empty($modelUser->id)){
                  $user_id  = $modelUser->id;
                }
                $data = array('status' => "success", "user_id"=>$user_id,"warehouse_id"=>$warehouse_id);  
            }
            else{
                $data = array('status' => "error", "message"=>"Invalid User");  
            }
            
            
         }
         catch(Exception $e) {

            header("HTTP/1.1 404 not found");

            header('Content-Type: application/json');

            $data = array('status' => "error", "message"=>"Unexpected Server error"); 

	   }

        echo json_encode($data);
        
    }
    
    public function actionMainLogin()
    {
        try {

            $input = file_get_contents('php://input');
            $variables = json_decode($input, true);
            $code = trim($variables['code']);
            $username = trim($variables['username']);
            $password = trim($variables['password']);
            $model = new LoginForm;
            $model->company_code = $code;
            $model->username = $username;
            $model->password = $password;
            $isLogin = $model->validate() && $model->login();
            $user_id = "";
            $name = "";
            $user = new User();
            if ($isLogin) {
                $company_id = 0;
                if(!empty($code)){
                    $company_id = (int) MasCompany::getCompanyId($code);
                }
                
                $condition = 'LOWER(username)="'.strtolower($username).'" AND isActive="Y" AND level=0';//level 3 allow only branch head
                
                if($company_id > 0){
                    $condition.=' AND company_id='.$company_id;
                }
                $user = $user->find(array('condition' => $condition));
                $company_id = $user->company_id;
                $user_id = $user->id;
                $name = $user->fullname;
                
                header("HTTP/1.1 200 OK");
                header('Content-Type: application/json');

                $data = array(
                    'status' => "success", 
                    "data" => 
                    [
                        "user_id" => $user_id, 
                        "name" => $name, 
                    ]
                    );
            } 
            else {
                header("HTTP/1.1 401 Unauthorized");
                header('Content-Type: application/json');
                $data['status'] = 'failed';
                $data['message'] = 'Unauthorized user';
            }
        } catch (Exception $e) {
            header("HTTP/1.1 404 not found");
            header('Content-Type: application/json');
            $data = array('status' => "error", "message" => "Unexpected Server error");
        }

        echo json_encode($data);
    }
    
}
