<?php

/**
 * alaqsar Sales Module
 * Author  : Jisha
 * Created :  27/10/2021
 * Modified : 21/06/2022
 */
class ApiController extends Controller {

    public function accessRules() {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array(
                    'logout', 'error', 'Login', 'customerlogin', 'loginrefresh',
                    'customerexist'
                ),
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**
     * User Login for FM
     * Author  : Manu Varghese
     * User Login
     */
    public function actionLogin() {

        try {
            $input = file_get_contents('php://input');
            $variables = json_decode($input, true);
            $username = trim($variables['username']);
            $password = trim($variables['password']);
            $code = MasCompany::CODE;
            $model = new LoginForm();
            $model->company_code = $code;
            $model->username = $username;
            $model->password = $password;
            $user_data = [];
            $isLogin = $model->validate() && $model->login();

            $data = [];
            $user = new User();
            if ($isLogin) {
                $condition = 'LOWER(username)="' . strtolower($username) . '" AND isActive="Y"';
                $user = $user->find(array('condition' => $condition));
                $status = "";
                $message = "";

                if ($user->isActive === "Y") {
                    if (empty($user->token)) {
                        $user->get_generate_token();
                    }
                    $status = "success";
                    $message = "Login success.";
                    $user_data = [
                        "user_id" => $user->id,
                        "name" => ucwords($user->getfullname()),
                        "token" => $user->token,
                        "username" => strtolower($user->username),
                        "user_group" => ucwords($user->userGroup->group_name),
                        "technician_id" => (int) $user->technician_id,
                        "designation" => ucwords($user->designation),
                    ];
                } else {
                    $status = "error";
                    $message = "User account disabled";
                }
                $data = array(
                    'status' => $status,
                    "messsage" => $message,
                    "user_data" => $user_data
                );
            } else {
                $data['status'] = 'failed';
                $data['message'] = 'Unauthorized user';
                $data['user_data'] = $user_data;
            }
        } catch (Exception $e) {
            $data = array('status' => "error", "message" => "Unexpected Server error");
        }
        header('Content-Type: application/json');
        echo json_encode($data);
    }

    /**
     * Customer Login
     * by firebase uid or customer phone no
     */
    public function actionCustomerlogin() {
        $this->ChangeDB();
        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);
        $firebase_uid = trim($variables['firebase_uid']);
        $customer_phone_no = trim($variables['customer_phone_no']);
        $customer_phone_no = preg_replace('/[^0-9]/', '', $customer_phone_no);
        $condition = "t.customer_phone_no= '$customer_phone_no' ";
        $customer_model = new Customer();
        $customer_model = $customer_model->find(["condition" => $condition]);
        if (empty($customer_model)) {
            $data = ["status" => "error", "message" => "Not Found", "code" => "NOT_FOUND"];
            echo json_encode($data);
        } else if ($customer_model->isActive == "Y") {
            if ($customer_model->firebase_uid != $firebase_uid) {
                $customer_model->updateByPK(
                        $customer_model->id,
                        ['firebase_uid' => $firebase_uid]
                );
            }
            $unit_array = [];
            $condition = "t.customer_id = " . $customer_model->id;
            $unit = new MasBuildingUnit();
            $unit = $unit->findAll(array('condition' => $condition, 'order' => 'sort_order'));
            if (!empty($unit)) {
                foreach ($unit as $i => $each) {
                    $unit_array[] = [
                        "id" => $each->id,
                        "unit" => $each->unit_name,
                        "building" => $each->building->building_name,
                        "building_id" => $each->building_id
                    ];
                }
            }
            $data = ["status" => "success",
                "message" => "Customer login success",
                "code" => "FOUND",
                "id" => $customer_model->id,
                "token" => $customer_model->token,
                "customer_name" => $customer_model->customer_name,
                "customer_phone_no" => $customer_model->customer_phone_no,
                "customer_email_id" => $customer_model->customer_email_id,
                "unit" => $unit_array,
            ];
            echo json_encode($data);
        } else {
            $data = ["status" => "error", "message" => "Customer is not active.", "code" => "NOT_ACTIVE"];
            echo json_encode($data);
        }
    }

    /**
     * Login refresh
     *  from token
     */
    public function actionLoginrefresh() {
        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);
        $token = trim($variables['token']);
        $auth = new AppAuthentication($token);
        if ($auth->login()) {
            $data = array('status' => "success");
        } else {
            $data = array('status' => "failed");
        }
        header("HTTP/1.1 200 OK");
        header('Content-Type: application/json');
        echo json_encode($data);
    }

    public function actionCustomerexist() {
        $this->ChangeDB();
        $input = file_get_contents('php://input');
        $variables = json_decode($input, true);
        $customer_phone_no = trim($variables['customer_phone_no']);
        $customer_phone_no = preg_replace('/[^0-9]/', '', $customer_phone_no);
        $condition = "t.customer_phone_no= '$customer_phone_no' ";
        $customer_model = new Customer();
        $customer_model = $customer_model->find(["condition" => $condition]);

        if (!empty($customer_model)) {
            $data = ["status" => "success",
                "message" => "Customer found.",
                "id" => $customer_model->id,
                "token" => $customer_model->token,
                "customer_name" => $customer_model->customer_name,
                "customer_phone_no" => $customer_model->customer_phone_no,
                "customer_email_id" => $customer_model->customer_email_id,
            ];
            echo json_encode($data);
        } else {
            $data = ["status" => "error", "message" => "Customer does not exist"];
            echo json_encode($data);
        }
    }

    public function actionUnitlist() {
        $this->ChangeDB();
        $condition = ' isActive="Y" ';
        $input = file_get_contents('php://input');
        //error_log($input);
        $variables = json_decode($input, true);
        $building_id = isset($variables["building_id"]) ? $variables["building_id"] : "0";
        if (!empty($building_id)) {
            $condition .= " AND t.building_id = $building_id ";
        } else {
            $condition .= " AND t.building_id = 0 ";
        }
        $term = isset($variables["term"]) ? trim($variables["term"]) : "";
        if (!empty($term)) {
            $condition .= " AND unit_name LIKE '%$term%'";
        }
        $unit = MasBuildingUnit::model()->findAll(array('condition' => $condition, 'order' => 'sort_order'));
        if (!empty($unit)) {
            foreach ($unit as $i => $each) {
                $data[] = [
                    "id" => $each->id,
                    "unit" => $each->unit_name,
                    "building" => $each->building->building_name,
                    "is_outside_building" => $each->building->is_outside_building,
                    "latitude" => $each->latitude,
                    "longitude" => $each->longitude,
                    "address" => $each->address,
                ];
            }
        }
        $data = array('status' => "success", 'data' => $data, "message" => "");
        echo json_encode($data);
    }

    public function actionBuildingList() {
        $this->ChangeDB();
        $input = file_get_contents('php://input');
        //error_log($input);
        $variables = json_decode($input, true);
        $term = isset($variables["term"]) ? trim($variables["term"]) : "";
        $condition = ' isActive="Y" ';
        if (!empty($term)) {
            $condition .= " AND building_name LIKE '%$term%'";
        }
        $data = [];
        $unit = FmMasBuilding::model()->findAll(array('condition' => $condition));
        if (!empty($unit)) {
            foreach ($unit as $i => $each) {
                $data[] = [
                    "id" => $each->id,
                    "building" => $each->building_name,
                    "is_outside_building" => $each->is_outside_building,
                ];
            }
        }

        $data = array('status' => "success", 'data' => $data, "message" => "");
        echo json_encode($data);
    }

    public function actionOutsideBuildingList() {
        $this->ChangeDB();
        $input = file_get_contents('php://input');
        //error_log($input);
        $variables = json_decode($input, true);
        $term = isset($variables["term"]) ? trim($variables["term"]) : "";
        $condition = ' isActive="Y" AND is_outside_building="Y"';
        if (!empty($term)) {
            $condition .= " AND building_name LIKE '%$term%'";
        }
        $data = [];
        $unit = FmMasBuilding::model()->findAll(array('condition' => $condition));
        if (!empty($unit)) {
            foreach ($unit as $i => $each) {
                $data[] = [
                    "id" => $each->id,
                    "building" => $each->building_name,
                    "is_outside_building" => $each->is_outside_building,
                ];
            }
        }

        $data = array('status' => "success", 'data' => $data, "message" => "");
        echo json_encode($data);
    }

}
