<?php

class ActivityController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'GetDetails', 'Create', 'SaveActivity', 'getdeatils', 'CreateMaster', "SaveMaster",'ViewActivity'), //'SaveMeeting','Activity','CalendarCreateActivity','SaveCalendarActivity'
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {

        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionCreateMaster() {
        $model = new ProspectsActivityMaster();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create_master', array('model' => $model));
    }

    public function actionSaveMaster() {
        $model = new ProspectsActivityMaster();
        $id = (int) $_POST['ProspectsActivityMaster']['id'];
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        $model->activity = $_POST['ProspectsActivityMaster']['activity'];
        $model->colour = $_POST['ProspectsActivityMaster']['colour'];
        $model->f_colour = $_POST['ProspectsActivityMaster']['f_colour'];
        if ($model->validate()) {
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            }
        } else {
            $error = CActiveForm::validate($model, '', false);
            if ($error != '[]') {
                echo $error;
            }
        }
    }

    /**

     * This is the default 'index' action that is invoked

     * when an action is not explicitly requested by users.

     */
    public function actionIndex() {

        $this->render('index');
    }

    public function actionCreate() {
        $id = Yii::app()->request->getParam('id');
        $customer_id = Yii::app()->request->getParam('customer_id');
        $contact_id = Yii::app()->request->getParam('contact_id');
        $file_id = Yii::app()->request->getParam('file_id');
        $frm = Yii::app()->request->getParam('frm');
        $sale_purchase = Yii::app()->request->getParam('sale_purchase');
        $add_edit_type = Yii::app()->request->getParam('type');
        $model_activity = new Activity();
        if ($frm == 'P')
            $model_activity = new ActivityProspects();

        $condition = "1=1 ";

        if ($id > 0) {
            $condition .= ' AND id=' . $id;
            $model_activity = $model_activity->findByPk($id);
        }

        if ($frm != '') {
            $model_activity->added_from = $frm;
        }

        if ($customer_id > 0) {
            $condition .= ' AND customer_id=' . $customer_id;
            $model_activity->customer_id = $customer_id;
        }

        if ($file_id > 0) {
            $condition .= ' AND file_id=' . $file_id;
            $model_activity->file_id = $file_id;
        }

        if ($contact_id > 0) {
            $condition .= ' AND contact_id=' . $contact_id;
            $model_activity->contact_id = $contact_id;
        }

        $model = Activity::model()->findAll(array('condition' => $condition, 'order' => 'date_of_activity desc'));
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);

        // Starting of new changes

        $this->render('activity_new_form', array('frm' => $frm, 'model' => $model, 'model_activity' => $model_activity, 'sale_purchase' => $sale_purchase,'add_edit_type'=>$add_edit_type), false, true);

        // Ending of new changes
    }

    public function actionSaveActivity() {
        

        if (isset($_POST['ActivityProspects']))
            $_POST['Activity'] = $_POST['ActivityProspects'];

        $type = Yii::app()->request->getParam('type');

        if (isset($_POST['Activity'])) {
            if ($_POST['Activity']['added_from'] != 'P')
                $model = new Activity();
            if ($_POST['Activity']['added_from'] == 'P')
                $model = new ActivityProspects();

            //$activity_id = explode("-", $_POST['Activity']['activity_id']);
            $activity_id = $_POST['Activity']['activity_id'];


            if ((int) $_POST['Activity']['id'] > 0) {
                $model = Activity::model()->findByPk((int) $_POST['Activity']['id']);
            } else {
                $model->created_date_time = date("Y-m-d H:i:s");
                $model->created_by = Yii::app()->user->id;
            }
            $model->updated_date_time = date("Y-m-d H:i:s");
            $model->updated_by = Yii::app()->user->id;
            $model->attributes = $_POST['Activity'];
            $model_activity->added_from == $_POST['Activity']['type_of_activity'];
          
            date_default_timezone_set("Asia/Dubai");
            if ($_POST['Activity']['date_of_activity'] != '00/00/0000' && $_POST['Activity']['date_of_activity'] != '') {
                $model->date_of_activity = str_replace('/', '-', $_POST['Activity']['date_of_activity']);
                $model->date_of_activity = date("Y-m-d H:i:s", strtotime($model->date_of_activity));
            } else {
                $model->date_of_activity = date('Y-m-d H:i:s');
            }

            if ($_POST['Activity']['date_to_do'] != '00/00/0000' && $_POST['Activity']['date_to_do'] != '') {
                $model->date_to_do = str_replace('/', '-', $_POST['Activity']['date_to_do']);
                $model->date_to_do = date("Y-m-d H:i:s", strtotime($model->date_to_do));
            } else {
                $model->date_to_do = '0000-00-00 00:00:00';
            }
            $model->type = $_POST['Activity']['type'];
            if($_POST['Activity']['type']=='T'){
                $model->assigned_to = $_POST['Activity']['assigned_to'];
                $model->is_completed = $_POST['Activity']['is_completed'];
            }
            $model->activity_id = $activity_id;
            $model->crm_user_id = Yii::app()->user->id;
            $model->type_of_activity = $type;
            $model->file_id = $_POST['file'];
             
        }

        if ($model->validate()) {
           
                $model->save(false);
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
        } else {
            $error = CActiveForm::validate($model, '', false);
            if ($error != '[]') {
                echo $error;
            }
        }
    }

    public function actionGetDetails() {
        $contact = Yii::app()->request->getParam('contact');
        $customer_id = Yii::app()->request->getParam('customer');
        $sale_purchase = Yii::app()->request->getParam('sale_purchase');
        $file = Yii::app()->request->getParam('file');
        $condition = ' ';
        $condition = " AND ea.customer_id  = $customer_id";
        if ($contact > 0) {
            $condition .= ' AND ea.contact_id=' . $contact;
        }
        if ($file > 0) {
            $condition .= " AND ea.file_id=" . $file;
        }

        // Starting of new changes
        //$model = Activity::model()->findAll(array('condition' => $condition, 'order' => 'date_of_activity DESC'));
        $model = Activity::getActivityHistoryCustomer($condition);

        $tbl = '<div id="tbl"><table class="table table-hover table-bordered personal-task" id="tbl_activity_history">

        <thead>

        <tr>

        <th>No</th>

        <th>Date</th>

        <th>Notes</th>

        <th>Type</th>

        <th>Contact</th>

        <th>User</th>

        <th>Follow Up Date</th>
        
        <th>Action</th>

        </tr>

        </thead>



        <tbody>';

        $tbl .= '<input type="hidden" name="contact_id" id="contact_id" value="' . $contact . '">';

        if (!empty($model)) {

            foreach ($model as $i => $model_history) {

                $tbl .= '<tr><td>' . ($i + 1) . '</td><td>';

                if ($model_history['date_of_activity'] != '0000-00-00 00:00:00') {

                    $tbl .= date("d/m/Y h:i:s", strtotime($model_history['date_of_activity']));
                }

                $tbl .= '</td><td>' . $model_history['notes'] . '</td>';

                $tbl .= '<td>' . $model_history['activity'] . '</td>';

                $tbl .= '<td>' . $model_history['person_name'] . '</td><td>';


                if ($model_history['crm_user_id'] != '0') {

                    $tbl .= $model_history['first_name'];
                } else {

                    $tbl .= '';
                }

                $tbl .= '</td><td>';

                if ($model_history['date_to_do'] != '0000-00-00 00:00:00' && $model_history['activity_type'] == 'CALLS') {

                    $tbl .= date("d/m/Y h:i:s", strtotime($model_history['date_to_do']));
                } else {

                    $tbl .= '-';
                }

                $tbl .= '</td>
                 <td>';
                    
                    $activity_date =date("Y-m-d", strtotime($model_history['date_of_activity']));
                    if($activity_date==date('Y-m-d')){
                        $tbl .= '<button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'activity/create&id='.$model_history['id'].'&type=edit\',\'Edit Activity-'.$model_history['id'].'\',\'xl\');"><i class="fa fa-pencil"></i></button>';
                    }
                $tbl .= '</td>
                </tr>';
            }
        } else {

            $tbl .= '<tr><td colspan="8" align="center">No Result Found</td></tr>';
        }

        $tbl .= '</tbody></table></div>';

        $jsonData['status'] = 'success';

        $jsonData['tbl'] = $tbl;

        echo CJSON::encode($jsonData);

        Yii::app()->end();

        // Ending of new changes
    }

    public function actiongetdeatils() {
        $model = new ProspectsActivityMaster();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'activity',
            1 => 'activity',
            2 => 'activity',
            3 => 'activity',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        //$condition = 't.level!=0 AND t.isActive="Y" ';
        $condition = 't.isActive="Y" ';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (activity LIKE '%" . $searchString . "%' )";
        }
        /* else{
          $condition.=" AND t.level=1";
          } */

        /* */

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'activity'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            $div = '<button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'activity/CreateMaster&id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row['activity'] . '\',\'xl\')"><i class="fa fa-edit"></i></button>';
            $rowData[] = array($m,
                $row['activity'],' <div style="background-color:'.$row['colour'].';color:'.$row['colour'].';">1</div>',
                '<div style="background-color:'.$row['f_colour'].';color:'.$row['f_colour'].';">1</div>',
                $div,
            );

            $m++;
        }


        $data['data'] = $rowData;
        echo json_encode($data);
    }
    public function actionViewActivity(){
        $model = new Activity();
        $id = (int) Yii::app()->request->getParam('activity_id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->renderPartial('create_view', array('model_activity' => $model));
    }
}
