<?php

class WarehouseController extends Controller
{
    //	public function actionIndex()
//	{
//		$this->render('index');
//	}

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create', 'DeleteWarehouse', 'SaveWarehouse', 'GetWarehouseList', 'DirectAdd', 'Disable', 'UploadImage'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex()
    {
        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn['masters_menu_view']) &&
                isset(Yii::app()->user->havePermissionOn['mas_warehouse_view']) &&
                Yii::app()->user->havePermissionOn['masters_menu_view'] &&
                Yii::app()->user->havePermissionOn['mas_warehouse_view']
            )
        ) {
            $this->render('index');
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }

    public function actionGetWarehouseList()
    {
        $model = new MasInventoryWarehouse();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];

        $columns = array(
            0 => 'warehouse_name',
            2 => 'isBaseWareHouse',
        );

        // Ensure index exists
        $filterColumn = isset($columns[$_POST['order'][0]['column']]) ? $columns[$_POST['order'][0]['column']] : 'warehouse_name';
        $filterOrder = ($_POST['order'][0]['dir'] == 'desc') ? 'DESC' : 'ASC';
        $orderBy = $filterColumn . " " . $filterOrder;

        // Default condition
        $condition = 'warehouse_code!="DAM"';

        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition = "(warehouse_name LIKE '%" . $searchString . "%')";
        }

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;

        $rowData = array();
        $m = 1;

        foreach ($model as $row) {
            $div = '';
            if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_warehouse_edit"])) {
                $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'warehouse/create&id=' . $row['id'] . '\',\'Warehouse - ' . $row['warehouse_name'] . ' \',\'lg\')"><i class="fa fa-pencil"></i></button> ';
            }
            $warehouseTypes = [
                'N' => 'Normal',
                'F' => 'Fixed',
                'M' => 'Mobile',
            ];

            $rowData[] = array(
                $m,
                $row['warehouse_name'],
                '<div class="btn-wrap text-center">' . $div . '</div>',
                $row['isBaseWareHouse'],
                isset($warehouseTypes[$row['warehouse_type']]) ? $warehouseTypes[$row['warehouse_type']] : 'Unknown',
                array(
                    'id' => $row['id'],
                    'code' => $row['warehouse_name'],
                    'status' => $row->isActive
                )
            );

            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreate()
    {
        $model = new MasInventoryWarehouse();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('warehouse_form', array('model' => $model), false, true);
    }
    public function actionSaveWarehouse()
    {
        $model = new MasInventoryWarehouse();
        if (isset($_POST['MasInventoryWarehouse'])) {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');

            if ((int) @$_POST['MasInventoryWarehouse']['id'] > 0) {
                $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
                $id = (int) @$_POST['MasInventoryWarehouse']['id'];
                $model = $model->findByPk($id);
                $audit_type = 'UPDATED';
                $edit_flag = 1;
            } else {
                $audit_type = 'CREATED';
            }
            if ($_POST['MasInventoryWarehouse']['isBaseWareHouse'] == "Y") {
                MasInventoryWarehouse::model()->updateAll(array('isBaseWareHouse' => 'N'), 'isBaseWareHouse = "Y"');
            }
            $model->attributes = $_POST['MasInventoryWarehouse'];
            $model->warehouse_type = $_POST['MasInventoryWarehouse']['warehouse_type'];
            if ($model->save()) {

                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'WAREHOUSE_MASTER',
                    Yii::app()->user->id,
                    $audit_type,
                    " with name: - {$model->warehouse_name}  "
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['warehouse_form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
                    echo $error;
            }

        }
    }
    public function actionDeleteWarehouse()
    {
        $id = $_POST['id'];
        $store = Yii::app()->db->createCommand('SELECT COUNT(*) FROM crm_store WHERE default_warehouse_id = ' . $id . ' ')->queryScalar();
        $location = Yii::app()->db->createCommand('SELECT COUNT(*) FROM crm_product_location WHERE warehouse_id = ' . $id . ' ')->queryScalar();
        if ($store > 0 || $location > 0) {
            echo "fail";
        } else {
            $model = new MasInventoryWarehouse();
            $warehouse = $model->findByPk($id);
            $model->deleteByPk($id);
            // inserting to audit log
            AuditLog::saveAuditLogs(
                'WAREHOUSE_MASTER',
                Yii::app()->user->id,
                'DELETED',
                " with name: - {$warehouse->warehouse_name}  "
            );
            // end audit log
            echo "success";
        }

    }

    public function actionDirectAdd()
    {
        $from = $_POST['from'];
        $name = $_POST['name'];
        if ($name != '') {
            $modelWarehouse = new MasInventoryWarehouse;
            $modelWarehouse->warehouse_name = $name;
            if ($modelWarehouse->save()) {
                $data = MasInventoryWarehouse::getWarehouse();
                if ($from == 'inventory') {
                    $model = new ProductLocation;
                    $field_name = 'warehouse_id';
                }
                $model->$field_name = $modelWarehouse->id;
                $drop = CHtml::activedropDownList($model, $field_name, $data, array('class' => 'tooltipster', 'data-label' => 'Warehouse <span style="color:red;">*<span>'));
                $status = array("status" => "success", "drop" => $drop);
                echo CJSON::encode($status);
            } else {
                $error = CActiveForm::validate($modelWarehouse, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }


    }

    public function actionDisable()
    {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasInventoryWarehouse();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y") ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}