<?php

class TermsandconditionController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','Getlist','Save','GetTermsFromId','getTermsAndCondition', 'Disable'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    public function actionIndex() {
        if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['termsandcondition_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['termsandcondition_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
    }
    public function actionGetlist()
    {
            $model=new MasTermsAndConditions();
            $draw   = $_POST['draw'];
            $offset = $_POST['start'];
            $limit  = $_POST['length'];
            $columns = array(
                            // datatable column index  => database column name
                            1=>'t.term_name',2=>'terms'
            );
            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder  = $_POST['order'][0]['dir'];
            $orderBy      = $filterColumn." ".$filterOrder;
            // $condition = 't.isActive="Y"';
            if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
            {
                    $searchString = $_POST['search']['value'];
                    $condition ="  ( t.term_name LIKE '%".$searchString."%' OR t.terms LIKE '%".$searchString."%')";
            }
            $count = $model->count(array('condition'=>$condition));
            $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset));
            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData=array();
            $div='';
            $m=1;
            foreach ($model as $row)
            {
            //if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_termsandcondition_edit"])){
                $div='<div class="btn-wrap text-center">'
                    . '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'termsandcondition/create&id='.$row['id'].'\',\'Edit Terms and condition\',\'xl\')" title="Edit Terms and condition">'
                    . '<i class="fa fa-edit"></i></button></div>';
            //}
                $rowData[]=array($m,
                    $row['term_name'],
                    nl2br($row['terms']),
                    $row['isDefault'],
                    array('id' => $row['id'],'code'=>$row['term_name'], 'status' => $row->isActive));
                    $m++;
            }
            $data['data'] = $rowData;
            echo json_encode($data);
    }
        
    public function actionCreate()
    {
            $model=new MasTermsAndConditions();
            $id = (int) Yii::app()->request->getParam('id');

            if($id > 0)
            {
                $model=$model->findByPk($id);

            }   

            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);
            $this->render('create',array('model'=>$model));
    }
    public function actionGetTermsFromId() {
        $term_id = (int) Yii::app()->request->getParam('term_id');
        $model = MasTermsAndConditions::model()->findByPk($term_id);
        //echo $terms = nl2br($model->terms);
        echo $terms = $model->terms;
    }  
    public function actionGetTermsAndCondition() {
        $term_id = (int) Yii::app()->request->getParam('term_id');
        //$type  = $_POST['type'];
        //$model_terms  = new CompanyTermsConditions();        
        //$model_terms = $model_terms->find('type="'.$type.'"');
        //$str  = nl2br($model_terms->terms_conditions);
        //$str  = $model_terms->terms_conditions;
        
        $model = MasTermsAndConditions::model()->findByPk($term_id);             
        echo $str= nl2br($model->terms);
        
//        echo $str;
        
    }    
    public function actionSave() {
        $model = new MasTermsAndConditions();

        if (isset($_POST['MasTermsAndConditions'])) {
            if ((int) $_POST['MasTermsAndConditions']['id'] > 0) {
                $model = $model->findByPK($_POST['MasTermsAndConditions']['id']);
                $model->scenario = 'update';
                $audit_type = 'UPDATED';   
            }else{
                $audit_type = 'CREATED';
            }
            if($_POST['MasTermsAndConditions']['isDefault'] == "Y"){
                MasTermsAndConditions::model()->updateAll(array( 'isDefault' => 'N' ), 'isDefault = "Y"' );
            }
            $model->isDefault = $_POST['MasTermsAndConditions']['isDefault'];

            $model->attributes = $_POST['MasTermsAndConditions'];
            $model->terms = $_POST['MasTermsAndConditions']['terms'];

            // $model->terms = $_POST['terms_conditions'];
            
            $valid = $model->validate();
            if ($valid) {
                $model->save();
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'TERMS_AND_CONDITIONS',
                    Yii::app()->user->id,
                    $audit_type,
                    " with term name : - {$model->term_name}"
                );
                // end audit log
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {

                $error = CActiveForm::validate($model, '', false);

                if ($error != '[]')

                    echo $error;

            }
        }

    }
             public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasTermsAndConditions();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
    
}