<?php
class StockledgerController extends Controller
{
    public $layout = 'layout';
	public function accessRules() {
		return array(

				array('allow', // allow all users to perform 'index' and 'view' actions
					'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover', 'companyFieldDetails'),
					'users' => array('*'),
				),
				array('allow', // allow authenticated user to perform 'create' and 'update' actions
					'actions' => array('Index','UpdateCurrentStockwithStockValue'),
                    'expression' => '$user->isMember()',
				),
				array('deny', // deny all users
					'users' => array('*'),
				),

		);

	}
    public function filters() {
		return array('accessControl'); // perform access control for CRUD operations
	}

	public function actionUpdateCurrentStockwithStockValue(){
	    $model_store = Store::model()->findAll(array('condition'=>'1=1'));
	    $tab = '<table class="table">';
	    $tab .= '<tr><th>Partnumber</th>
	    <th>transaction_date</th>
	    <th>transaction_from</th>
	    <th>quantity</th>
	    <th>unit_factor</th>
	    <th>Cost Price</th>
	    <th>Buying Price</th>
	    <th>Current Stock</th>
	    <th>Current Value</th>
	    <tr>';
	    
	    foreach($model_store as $each_store){
	        $product_id = $each_store->id;
	        $arr_stock_ledger = StockLedger::model()->findAll(array('condition'=> 'product_id = '.(int)$product_id,'order'=>'transaction_date ASC'));
	        $cur_qty=0;
	        $cur_value=0;
	        $prev_total =0;
	        foreach($arr_stock_ledger as $each_ledger){
	            $cur_qty+=($each_ledger->quantity*$each_ledger->unit_factor);
	            if($each_ledger->transaction_from=='INVENTORY_GOODS_RECEIPT'||$each_ledger->transaction_from=='PURCHASE_QUALITY_CHECK'){
	                $updatedcost_price=($prev_total+($each_ledger->cost_price*$each_ledger->quantity*$each_ledger->unit_factor))/($cur_qty);
	            }else{ //if($each_ledger->transaction_from=='GOODS_ISSUE'||$each_ledger->transaction_from=='DEBIT_NOTE' ||$each_ledger->transaction_from=='DELIVERY_NOTE'){
	               
	            }
	            $cur_value = $updatedcost_price*$cur_qty;
	            
	            $tab .= '<tr>';
	            $tab .= '<td>'.$each_store->part_number.'</td>';
	            $tab .= '<td>'.$each_ledger->transaction_date.'</td>';
	            $tab .= '<td>'. $each_ledger->transaction_from.'</td>';
	            $tab .= '<td>'. $each_ledger->quantity.'</td>';
	            $tab .= '<td>'. $each_ledger->unit_factor.'</td>';
	            $tab .= '<td>'. number_format($each_ledger->cost_price,2).'</td>';
	            $tab .= '<td>'. number_format($each_ledger->buying_price,2).'</td>';
	            $tab .= '<td>'. $cur_qty.' , '.$each_ledger->stock_after_transaction.'</td>';
	            $tab .= '<td>'. number_format($cur_value,2).' , '.$each_ledger->stock_value_after_transaction.'</td>';
	            $tab .= '</tr>';
	            //$prev_total =$each_ledger->stock_value_after_transaction;
	            $prev_total =$cur_value;
	            
	        }
	    }
	    $tab .= '</table>';
	    echo $tab;
	    
	}
}