<?php

class SalestargetController extends Controller {

    public function accessRules() {

        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'create', 'Save'), //'SaveMeeting','Activity','CalendarCreateActivity','SaveCalendarActivity'
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {

        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    /**

     * This is the default 'index' action that is invoked

     * when an action is not explicitly requested by users.

     */
    public function actionIndex() {

        $this->render('index');
    }

    public function actionCreate() {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', $_GET);
    }

    public function actionSave() {
        $list = $_POST['BrandSalesTarget'];
        foreach ($list as $value) {
            $id = $value['id'];
            $model = BrandSalesTarget::model()->findByPk($id);
            $model->attributes = $value;
            $model->save();
        }
        echo json_encode(["status" => "success"]);
    }

}
