<?php

class SalesgroupController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','GetSalesgroupList','SaveSalesGroup','DeleteSalesgroup','DirectAdd','Disable'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['sales_master_salegroup_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['sales_master_salegroup_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
    }

    public function actionCreate()
    {
        $model=new MasSalesGroup();
        $id = (int) Yii::app()->request->getParam('id');
        $from =  Yii::app()->request->getParam('from');
        if($id>0){
            $model=$model->findByPk($id);
        }
     Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);   
    $this->render('create', array('model' => $model,'from' =>$from), false, true);
    }

    public function actionGetSalesgroupList()
        {
            
                $model=new MasSalesGroup();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'group_name',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                // $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (group_name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                      $div = '';
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["sales_master_salegroup_add_edit"])){
                        //$div .=    '<div class="btn-wrap text-center"><button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'salesgroup/create&id='.$row['id'].'\',\'Edit Sales Group\',\'lg\')"><i class="fa fa-pencil"></i></button> ';
                    }
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["sales_master_salegroup_delete"])){
                     //   $div .=  ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteSalesGroup('.$row['id'].')"><i class="fa fa-trash-o "></i></a>';
                    }
                    $row['type'] = ($row['type'] == 'S') ? 'Sales' : (($row['type'] == 'SR') ? 'Service' : '');

                    $rowData[]=array($m,
                        $row['group_name'],
                        $row['is_base_sales'],
                        $row['type'],
                        array('id' => $row['id'],'code'=>$row['group_name'], 'status' => $row->isActive));

                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
      
    }
    public function actionSaveSalesGroup()
    {
    $model = new MasSalesGroup();
        if (isset($_POST['MasSalesGroup']))
        {
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime =date('Y-m-d h:i:s');
            if ((int) @$_POST['MasSalesGroup']['id'] > 0)
            {   $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime =date('Y-m-d h:i:s');
                $id= (int) @$_POST['MasSalesGroup']['id'];
                $model=$model->findByPk($id);
                $audit_type = 'UPDATED';
            }else{
                $audit_type = 'CREATED';
            }
            if($_POST['MasSalesGroup']['is_base_sales'] == "Y"){
                MasSalesGroup::model()->updateAll(array( 'is_base_sales' => 'N' ), 'is_base_sales = "Y"' );
            }
            $model->is_base_sales = $_POST['MasSalesGroup']['is_base_sales'];
            $model->type = $_POST['MasSalesGroup']['type'];
            $model->attributes=$_POST['MasSalesGroup'];
            if($model->validate())
               
            {
                 $model->save();
                  // inserting to audit log
                  AuditLog::saveAuditLogs(
                    'SALES_GROUPS',
                    Yii::app()->user->id,
                    $audit_type,
                    " with name: - {$model->group_name}  "
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['salesgroup-form'];
                $jsonData['from'] = $_POST['from'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            }
            else
            {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
            echo $error;
            }
        }
    }
    public function actionDeleteSalesgroup()
    {
        
        $id = $_POST['id'];
        $model_o = Order::model()->findAll(array('condition' => 'sales_group = '.$id.' '));
        $model_i = Invoice::model()->findAll(array('condition' => 'sales_group = '.$id.' '));
        $model_q = Quotes::model()->findAll(array('condition' => 'sales_group = '.$id.' '));
        $model_c = Creditnote::model()->findAll(array('condition' => 'sales_group = '.$id.' '));
        if(empty($model_l) && empty($model_o) && empty($model_q) && empty($model_c)){
            $model=new MasSalesGroup();
            $del = $model->findByPk($id); // audit log changes
            $model->deleteByPk($id);
             // inserting to audit log
             AuditLog::saveAuditLogs(
                'SALES_GROUPS',
                Yii::app()->user->id,
                'DELETED',
                " with name: - {$del->group_name}  "
            );
            // end audit log
            echo "success";
        }
        else{
             echo "fail";
        }
        
    }
     public function actionDirectAdd(){
           $from = $_POST['from'];
           $name = $_POST['name'];
           if($name != ''){
               $modelSalesgroup = new MasSalesGroup;
               $modelSalesgroup->created_by = Yii::app()->user->id;
               $modelSalesgroup->created_datetime =date('Y-m-d h:i:s');   
               $modelSalesgroup->group_name = $name;
               if($modelSalesgroup->save()){
                        $data  =  MasSalesGroup::getSalesGroup();
                        if($from == 'lead'){
                            $model = new Lead;
                            $field_name = 'sales_group_id';
                        }
                        if($from == 'quote'){
                            $model = new Quotes;
                            $field_name = 'sales_group';
                        }
                        if($from == 'order'){
                            $model = new Order;
                            $field_name = 'sales_group';
                        }
                        if($from == 'invoice'){
                            $model = new Invoice;
                            $field_name = 'sales_group';
                        }
                        $model->$field_name = $modelSalesgroup->id;
                        $drop=CHtml::activedropDownList($model,$field_name, $data,  array('class' => 'tooltipster','data-label'=>'Sales Group'));  
                        $status=array("status" =>"success","drop" => $drop);    
                        echo CJSON::encode($status);
               }else{
                     $error = CActiveForm::validate($modelSalesgroup, '', false);
                        if ($error != '[]')
		               echo $error;
               }
           }
        
            
         }
        public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasSalesGroup();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}