<?php

class RfqController extends Controller {

    public $layout = 'layout';

    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout', 'Forgotpassword', 'Recover'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Create',
                    'saverfq'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters() {
        return array('accessControl'); // perform access control for CRUD operations
    }

    public function actionIndex() {
        $frm = (int) Yii::app()->request->getParam('frm');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('index', array('frm' => $frm));
    }

    public function actionCreate() {
        $lead_id = (int) Yii::app()->request->getParam('lead_id');
        $id = (int) Yii::app()->request->getParam('id');
        $model = new LeadRfq();
        $model->lead_id = $lead_id;
        if (!empty($id)) {
            $model = LeadRfq::model()->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('modelRfq' => $model));
    }

    public function actionSaverfq() {
        $modelRfq = new LeadRfq();
        if ((int) @$_POST['LeadRfq']['id'] > 0) {
            $modelRfq->id = (int) $_POST['LeadRfq']['id'];
            $modelRfq = $modelRfq->findByPK($modelRfq->id);
        } else {
            $modelRfq->created_by = Yii::app()->user->id;
            $modelRfq->created_date_time = date('Y-m-d h:i:s');
        }
        $modelRfq->updated_by = Yii::app()->user->id;
        $modelRfq->updated_date_time = date('Y-m-d h:i:s');
        $modelRfq->attributes = $_POST['LeadRfq'];
        ////////////////////Category//////////////////////////////////////////
        for ($i = 1; $i <= 7; $i++) {
            $key = "category_type{$i}";
            if (isset($_POST['LeadRfq'][$key])) {
                if (is_array($_POST['LeadRfq'][$key])) {
                    $modelRfq->$key = implode(',', $_POST['LeadRfq'][$key]);
                } else {
                    $modelRfq->$key = trim($_POST['LeadRfq'][$key]);
                }
            }
        }
        ////////////////////flight case//////////////////////////////////////////
        for ($i = 1; $i <= 8; $i++) {
            $key = "fc_type{$i}";
            if (isset($_POST['LeadRfq'][$key])) {
                if (is_array($_POST['LeadRfq'][$key])) {
                    $modelRfq->$key = implode(',', $_POST['LeadRfq'][$key]);
                } else {
                    $modelRfq->$key = trim($_POST['LeadRfq'][$key]);
                }
            }
        }
        ///////////////////////////////Crate/////////////////////////////////////
        for ($i = 1; $i <= 8; $i++) {
            $key = "cr_type{$i}";
            if (isset($_POST['LeadRfq'][$key])) {
                if (is_array($_POST['LeadRfq'][$key])) {
                    $modelRfq->$key = implode(',', $_POST['LeadRfq'][$key]);
                } else {
                    $modelRfq->$key = trim($_POST['LeadRfq'][$key]);
                }
            }
        }
        ///////////////////////////////SKB/////////////////////////////////////
        for ($i = 1; $i <= 5; $i++) {
            $key = "skb_type{$i}";
            if (isset($_POST['LeadRfq'][$key])) {
                if (is_array($_POST['LeadRfq'][$key])) {
                    $modelRfq->$key = implode(',', $_POST['LeadRfq'][$key]);
                } else {
                    $modelRfq->$key = trim($_POST['LeadRfq'][$key]);
                }
            }
        }
        ///////////////////////////////SKB/////////////////////////////////////
        for ($i = 1; $i <= 6; $i++) {
            $key = "fm_type{$i}";
            if (isset($_POST['LeadRfq'][$key])) {
                if (is_array($_POST['LeadRfq'][$key])) {
                    $modelRfq->$key = implode(',', $_POST['LeadRfq'][$key]);
                } else {
                    $modelRfq->$key = trim($_POST['LeadRfq'][$key]);
                }
            }
        }
        ///////////////////////////////Metal/////////////////////////////////////
        for ($i = 1; $i <= 4; $i++) {
            $key = "ml_type{$i}";
            if (isset($_POST['LeadRfq'][$key])) {
                if (is_array($_POST['LeadRfq'][$key])) {
                    $modelRfq->$key = implode(',', $_POST['LeadRfq'][$key]);
                } else {
                    $modelRfq->$key = trim($_POST['LeadRfq'][$key]);
                }
            }
        }
        //////////////////////////////////////////////////////////////////
        if (isset($_POST['LeadRfq']['rfq_date'])) {
            $modelRfq->rfq_date = str_replace('/', '-', $_POST['LeadRfq']['rfq_date']);
            $modelRfq->rfq_date = date("Y-m-d", strtotime($modelRfq->rfq_date));
        }
        if ($modelRfq->validate() && $modelRfq->save()) {
            echo json_encode([
                "status" => "success",
                "id" => $modelRfq->id,
                "lead_id" => $modelRfq->lead_id
                    ]
            );
        } else {
            echo json_encode($modelRfq->getErrors());
        }
    }

}
