<?php

class ReceiptsController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'Create',
                    'GetList',
                    'SaveReceipt',
                    'Delete',
                    'GetProducts',
                    'DeleteReceiptItem',
                    'DeleteReceipt',
                    'Append',
                    'AddStock',
                    'GetRow',
                    'GetFactor',
                    'Getunitdrop',
                    'PrintReceiptPDF',
                    'GetPurchaseOrderIds',
                    'ListPOCustomers',
                    'GetProductionOrderItems'
                ),
                'expression' => '$user->isMember()',
            ),
            /**copied by jisha from bouleward on 8-11-17**/
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    public function actionIndex()
    {

        if (
            Yii::app()->user->authorised_user == 1 ||
            (
                isset(Yii::app()->user->havePermissionOn['inventory_menu_view']) &&
                isset(Yii::app()->user->havePermissionOn['mov_receipt_view']) &&
                Yii::app()->user->havePermissionOn['inventory_menu_view'] &&
                Yii::app()->user->havePermissionOn['mov_receipt_view']
            )
        ) {
            $this->render('index');
        } else {
            $this->layout = false;
            $this->render('/site/unauthorised');
            Yii::app()->end(); // Prevent further execution
        }
    }

    public function actionCreate()
    {
        $model = new InventoryGoodsReceipt();
        $model_item = array(new InventoryGoodsReceiptItem());
        $id = (int) Yii::app()->request->getParam('id');
        $frm = Yii::app()->request->getParam('frm');

        if ($id > 0) {
            $model = $model->findByPk($id);
            $model_item = InventoryGoodsReceiptItem::model()->findAll(array(
                'condition' => 'goods_receipt_id= ' . $model->id
            ));
        }

        // Handling logic for Production Receipt (PRO)
        if ($frm == 'PRO') {
            $po_id = (int) Yii::app()->request->getParam('po_id');
            $modelorder = ProductionOrder::model()->findByPk($po_id);
            $model->customer_id = $modelorder->customer_id;
            $model->reference_id = $modelorder->id;
            $model->reference = $modelorder->reference;

            $picked_qty = $modelorder->quantity;

            $product = Store::model()->findByPk($modelorder->product_id);
            $model_unit_measure = UnitOfMeasurement::model()->find('product_id = "' . $product->id . '"');

            $item_per_cost = 0;
            if ($picked_qty > 0) {
                $SQL = "SELECT SUM(`quantity`*`rate`) AS total_cost FROM `erp_production_order_item` WHERE `production_order_id`=" . $po_id;
                $total_cost = (float) Yii::app()->db->createCommand($SQL)->queryScalar();
                $item_per_cost = ($total_cost / $picked_qty);
            }

            $unit_data = UnitOfMeasurement::getUnits($product->id);

            $model_item = [];
            $receipt_item = new InventoryGoodsReceiptItem();
            $receipt_item->product_id = $product->id;
            $receipt_item->product_name = $product->part_number;
            $receipt_item->description = $product->description;
            $receipt_item->picked_qty = $picked_qty;
            $receipt_item->unit = $model_unit_measure ? $model_unit_measure->unit : '';
            $receipt_item->rate = $item_per_cost;
            $receipt_item->current_cost = $product->rate;

            $model_item[] = $receipt_item;
        }

        Yii::app()->clientScript->scriptMap = array(
            '*jquery.js' => false,
            '*jquery.min.js' => false,
            'jquery.min.js' => false,
            '*jquery-ui.js' => false,
            '*jquery-ui.min.js' => false
        );

        $this->render('receipts_form', array(
            'model' => $model,
            'model_item' => $model_item,
            'model_material_stock' => isset($model_material_stock) ? $model_material_stock : null,
            'frm' => $frm
        ), false, false);
    }

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    /**copied by jisha from bouleward on 8-11-17**/
    public function actionGetList()
    {
        $model = new InventoryGoodsReceipt();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $frm = Yii::app()->request->getParam('frm');
        $columns = array(
            // datatable column index  => database column name
            0 => 'goods_receipt_date',
            1 => 'customer_id',
            2 => 'project'

        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y" AND t.stock_updated="Y"';
        if ($frm == 'PR') {
            $condition .= ' AND t.receipt_type="PR"';
        }
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " and (t.id LIKE '%" . $searchString . "%' OR  t.reference_id  LIKE '%" . $searchString . "%' OR  customer.customer_name  LIKE '%" . $searchString . "%' OR  t.service_order_id  LIKE '%" . $searchString . "%' OR  t.file_id  LIKE '%" . $searchString . "%'  OR goods_receipt_date LIKE '%" . $searchString . "%' OR project_id LIKE '%" . $searchString . "%')";
        }
        $count = $model->with('customer')->count(array('condition' => $condition));
        $model = $model->with('customer')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.id desc'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $date_d = date("d/m/Y", strtotime($row->goods_receipt_date));
            //$rowData[] = array($row['id'], $date_d, $row->customer->customer_name, $row['reference'], $row['posted']);
            $rowData[] = array(
                $row['id'], //0
                $row['reference_id'], //1
                $date_d, //2
                $row->customer->customer_name,//3 
                $row['file_id'], //4
                $row['service_order_id'],//5
                $row['posted']//6
                
            );
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
    /**copied by jisha from bouleward on 8-11-17**/
    // public function actionCreate()
    // {
    //     $model = new InventoryGoodsReceipt();
    //     $model_item = array(new InventoryGoodsReceiptItem());
    //     $id = (int) Yii::app()->request->getParam('id');
    //     $frm = Yii::app()->request->getParam('frm');
    //     if ($id > 0) {
    //         $model = $model->findByPk($id);
    //         $model_item = InventoryGoodsReceiptItem::model()->findAll(array('condition' => 'goods_receipt_id = ' . $model->id . ''));
    //     }

    //     Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
    //     $this->render('receipts_form', array('model' => $model, 'model_item' => $model_item, 'model_material_stock' => $model_material_stock,'frm'=>$frm), false, false);
    // }




    public function actionSaveReceipt()
    {
        $other = array();
        $valid = true;

        $model = new InventoryGoodsReceipt();

        if (isset($_POST['InventoryGoodsReceipt'])) {

            //aaded by priya 0n 11.9.24 check stocklockflag
            $modelCompanySettings = new MasCompanySettings();
            $condition = 'crm_company_id = ' . (int) Yii::app()->user->master_user_company_id;
            $modelCompanySettings = $modelCompanySettings->find(array('condition' => $condition));
            $stock_lock_flag = $modelCompanySettings->stock_lock_flag;
            if ($stock_lock_flag == "N") {

                $scenario = '';
                if ((int) @$_POST['InventoryGoodsReceipt']['id'] > 0) {
                    $id = (int) @$_POST['InventoryGoodsReceipt']['id'];
                    $model = $model->findByPk($id);
                    $model->updated_by = Yii::app()->user->id;
                    $model->updated_date_time = date('Y-m-d H:i:s');
                    $scenario = 'update';
                    $audit_type = 'UPDATED';
                } else {
                    $model->created_by = Yii::app()->user->id;
                    $model->created_date_time = date('Y-m-d H:i:s');
                    $scenario = 'add';
                    $audit_type = 'CREATED';
                }

                $model->attributes = $_POST['InventoryGoodsReceipt'];
                $model->receipt_type = $_POST['InventoryGoodsReceipt']['receipt_type'];
                // $model->project_classification_id = $_POST['InventoryGoodsReceipt']['project_classification_id'];
                $model->contract_id = $_POST['InventoryGoodsReceipt']['contract_id'];
                // $model->ticket_id = $_POST['InventoryGoodsReceipt']['ticket_id'];
                $model->reference_id = $_POST['InventoryGoodsReceipt']['reference_id'];
                $model->reference = $_POST['InventoryGoodsReceipt']['reference'];

                if ($_POST['InventoryGoodsReceipt']['goods_receipt_date'] != '00/00/0000') {
                    $model->goods_receipt_date = str_replace('/', '-', $_POST['InventoryGoodsReceipt']['goods_receipt_date']);
                    $model->goods_receipt_date = date("Y-m-d", strtotime($model->goods_receipt_date));
                }
                $valid = $model->validate();

                //   ---------------------AccAuditClose check------------------------------------


                $goods_receipt_datex = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['InventoryGoodsReceipt']['goods_receipt_date'])));

                $modelAccAuditClose = new AccAuditClose();
                $existing_date = strtotime($modelAccAuditClose->lastCloseddate());
                $goods_receipt_date = strtotime($goods_receipt_datex);
                if ($goods_receipt_date <= $existing_date) {
                    $valid = false;
                    $other[] = ' Given GoodsReceipt date must be Greater than Audit Close Date :- ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';
                }
                //   --------------------//-AccAuditClose check------------------------------------



                $date = date("Y-m-d H:i:s");
                if (is_array($_POST['InventoryGoodsReceiptItem'])) {

                    foreach ($_POST['InventoryGoodsReceiptItem'] as $k => $rowItem) {
                        $model_item[$k] = new InventoryGoodsReceiptItem;
                        //$storeModel = Store::model()->findBypk( (int) $rowItem['product_id'] );
                        if ($rowItem['id'] > 0) {
                            $model_item[$k] = InventoryGoodsReceiptItem::model()->findByPk($rowItem['id']);
                            $model_item[$k]->updated_by = Yii::app()->user->id;
                            $model_item[$k]->updated_date_time = $date;
                        } else {
                            $model_item[$k]->created_by = Yii::app()->user->id;
                            $model_item[$k]->created_date_time = $date;
                        }
                        $model_item[$k]->product_id = $rowItem['product_id'];
                        $model_item[$k]->product_name = $rowItem['product_name'];
                        $model_item[$k]->description = $rowItem['description'];
                        $model_item[$k]->picked_qty = $rowItem['picked_qty'];
                        $model_item[$k]->unit = $rowItem['unit'];
                        $model_item[$k]->rate = $rowItem['rate'];
                        $valid = $model_item[$k]->validate() && $valid;
                    }
                }

                if ($valid) {
                    $model->save(false);

                    // inserting to audit log
                    AuditLog::saveAuditLogs(
                        'RECEIPTS',
                        Yii::app()->user->id,
                        $audit_type,
                        " with Checkin No: - {$model->id}  "
                    );
                    // end audit log 

                    foreach ($model_item as $eachitem) {
                        // 
                        $eachitem->goods_receipt_id = $model->id;
                        $eachitem->save(false);
                    }
                    /*if($scenario=='add'){
                                $model_mail_setting=Notification::model()->find(array('condition' => 'event_id="21"'));
                                 Yii::import('application.controllers.front.MasternotificationController'); 

                                if($model_mail_setting->mail_required=='Y'){       
                                    MasternotificationController::sendmail(21,$model->id);
                                }
                                if($model_mail_setting->notification_required=='Y'){                    
                                    MasternotificationController::sendnotification(21,$model->id);
                                }
                                if($model_mail_setting->sms_required=='Y'){                    
                                    MasternotificationController::sendsms(21,$model->id);
                                }
                            }*/
                    $jsonData['status'] = 'success';
                    echo CJSON::encode($jsonData);
                } else {
                    $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                    if ($model_item[0]->product_id > 0)
                        $error2 = json_decode(CActiveForm::validateTabular($model_item, '', false), true);
                    else
                        $error2[] = "Please add atleast one line item";
                    $error = CJSON::encode(array_merge_recursive($error1, $error2, $other));
                    if ($error != '[]')
                        echo $error;
                }
            } else {
                echo CJSON::encode(array('error' => ' Transactions are already locked!'));
            }
        }
    }
    /**copied by jisha from bouleward on 8-11-17**/
    public function actionDeleteReceipt()
    {
        $id = $_POST['id'];
        $model = new InventoryGoodsReceipt();
        $model->deleteByPk($id);
        echo "success";
    }
    /**copied by jisha from bouleward on 8-11-17**/
    public function actionDeleteReceiptItem()
    {

        $id = $_POST['id'];

        $model = new InventoryGoodsReceiptItem();

        $model->deleteByPk($id);

        $jsonData['status'] = 'success';

        $jsonData['id'] = $id;

        echo CJSON::encode($jsonData);
    }

    /*jo*/
    public function actionGetunitdrop()
    {
        $row = $_POST['row_field'];
        $product = $_POST['product_id'];
        $drop = array();
        $modelOrder = new InventoryGoodsReceiptItem;
        if ($product > 0) {
            $modelOrder->unit = UnitOfMeasurement::getBaseunit($product);
            $drop['drop'] = CHtml::activedropdownlist($modelOrder, "[" . $row . "]unit", UnitOfMeasurement::getUnits($product), array('class' => 'unit go', 'onchange' => 'getFactor(this.id,this.value)'));
        }
        echo CJSON::encode($drop);
    }

    public function actionGetFactor()
    {
        $factor = 1;
        if ((int) $_POST['value'] > 0) {
            $factor = UnitOfMeasurement::getFactor($_POST['value']);
        }
        echo $factor;
    }

    public function actionPrintReceiptPDF()
    {

        //$model = new PurchasingRequisition();
        $id = Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = InventoryGoodsReceipt::model()->findByPk($id);
        }
        $mPDF1 = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.views.front.pdf.receipts_print', array('model' => $model, 'id' => $id, 'title' => $title), true));
        $mPDF1->Output("Receipts.pdf", 'I');
    }


    public function actionGetPurchaseOrderIds()
    {
        $issueType = Yii::app()->request->getParam("issue_type");
        $customer_id = Yii::app()->request->getParam("customer_id");   // <-- RECEIVED HERE



        $criteria = new CDbCriteria();

        if (empty($customer_id) || $customer_id == 0) {
            // Fetch orders where customer_id IS NULL or empty
            $criteria->addCondition('customer_id IS NULL OR customer_id = 0');
        } else {
            // Fetch orders for given customer
            $criteria->compare('customer_id', $customer_id);
        }

        $criteria->order = 'id DESC';

        $productionOrders = ProductionOrder::model()->findAll($criteria);

        // Convert into dropdown list format: id → order number
        $data = CHtml::listData(
            $productionOrders,
            "id",
            "id"    // <-- change to your actual field name
        );

        // Prepare the dropdown HTML (same as your pattern)
        $model = new InventoryGoodsReceipt();

        $drop = CHtml::activeDropDownList(
            $model,
            'reference_id',
            $data,
            [
                'empty' => 'Select Production Order',
                'data-label' => 'Prd. Ord#',
                'data-label' => 'Prd. Ord# *'
            ]
        );

        echo CJSON::encode(['drop' => $drop]);
        Yii::app()->end();
    }

    public function actionListPOCustomers()
    {
        // Fetch distinct customer IDs from ProductionOrder
        $orders = ProductionOrder::model()->with('customerDetails')->findAll(array(
            'select' => 't.customer_id',
            'group' => 't.customer_id',
            'order' => 'customerDetails.customer_name ASC',
        ));

        $data = array();

        foreach ($orders as $c) {
            if (!empty($c->customerDetails)) {
                $data[$c->customer_id] = $c->customerDetails->customer_name;
            } else {
                // If customer_id is null or relation not found, show 'None'
                $data['0'] = 'None';
            }
        }

        // Temporary model instance for dropdown
        $model = new InventoryGoodsReceipt();

        // Build dropdown
        $drop = CHtml::activeDropDownList(
            $model,
            'customer_id',
            $data,
            array(
                'data-label' => 'Customer',
                'id' => 'InventoryGoodsReceipt_customer_id',
                'prompt' => '-- Select Customer --'
            )
        );

        echo CJSON::encode(['customerDropDown' => $drop]);
        Yii::app()->end();
    }



    public function actionGetProductionOrderItems()
    {
        $productionOrderId = Yii::app()->request->getPost('production_order_id');
        $frm = Yii::app()->request->getPost('frm');

        $productionOrder = ProductionOrder::model()->findByPk($productionOrderId);

        if (!$productionOrder) {
            echo CJSON::encode([
                'status' => 'error',
                'tbl' => '<table><tr><td class="text-center">Invalid Production Order</td></tr></table>'
            ]);
            Yii::app()->end();
        }

        $productId = (int) $productionOrder->product_id;
        $productName = $productionOrder->product->part_number;
        $description = $productionOrder->description;
        $current_cost = Yii::app()->db->createCommand("
        SELECT IFNULL(rate,0)
        FROM erp_store
        WHERE id = :id
    ")->queryScalar([':id' => $productId]);

        $current_cost = number_format($current_cost, 2, '.', '');
-
        $grand_total = Yii::app()->db->createCommand("
        SELECT IFNULL(SUM(quantity * rate),0)
        FROM {{production_order_item}}
        WHERE production_order_id = :pid
    ")->queryScalar([':pid' => $productionOrderId]);

        $grand_total = number_format($grand_total, 2, '.', '');

        $item = new InventoryGoodsReceiptItem;
        $item->product_id = $productId;
        $item->product_name = $productName;
        $item->description = $description;
        $item->current_cost = $current_cost;
        $item->rate = $grand_total;


        $units = ($productId > 0) ? UnitOfMeasurement::getUnits($productId) : [];

        $tbl = '
    <table class="table table-hover table-bordered personal-task" id="details_table">
        <thead>
            <tr>
                <th>No</th>
                <th>Product</th>
                <th>Description</th>
                <th>Picked Qty</th>
                <th>Unit</th>
                <th>Current Base Unit Cost</th>
                <th>Rate/Item</th>
                <th class="text-center">
                    <a class="btn btn-sm btn-theme" href="javascript:void(0);"
                       onclick="addTableRow($(\'#details_table\'));"><i class="fa fa-plus"></i></a>
                </th>
            </tr>
        </thead>
        <tbody id="tbody_goods_receipt_item">';

        $i = 0;

        $tbl .= '<tr>';

        // 1. SERIAL NUMBER
        $tbl .= '<td><label>' . ($i + 1) . '</label></td>';

        // 2. PRODUCT NAME
        $tbl .= '<td>'
            . CHtml::activeTextField($item, "[$i]product_name", [
                'class' => 'tooltipster go',
                'data-label' => 'Product Name',
                'readonly' => true
            ])
            . CHtml::activeHiddenField($item, "[$i]product_id")
            . CHtml::activeHiddenField($item, "[$i]id")
            . '</td>';

        // 3. DESCRIPTION
        $tbl .= '<td>'
            . CHtml::activeTextArea($item, "[$i]description", [
                'class' => 'go',
                'data-label' => 'Description'
            ])
            . '</td>';

        // 4. PICKED QTY
        $tbl .= '<td>'
            . CHtml::activeTextField($item, "[$i]picked_qty", [
                'class' => 'qty go text-right',
                'onkeypress' => 'return isNumberKey(event)',
                'data-label' => 'Quantity'
            ])
            . '</td>';

        // 5. UNIT DROPDOWN
        $tbl .= '<td>'
            . CHtml::activeDropDownList($item, "[$i]unit", $units, ['class' => 'qty go'])
            . '</td>';

        // 6. CURRENT BASE UNIT COST
        $tbl .= '<td>'
            . CHtml::activeTextField($item, "[$i]current_cost", [
                'class' => 'qty go text-right',
                'readonly' => true,
                'value' => $current_cost
            ])
            . '</td>';

        // 7. RATE FIELD (GRAND TOTAL OF PRODUCTION ORDER ITEMS)
        $tbl .= '<td>'
            . CHtml::activeTextField($item, "[$i]rate", [
                'class' => 'rate go text-right',
                'readonly' => true,
                'value' => $grand_total
            ])
            . '</td>';

        // 8. REMOVE ROW BUTTON
        $tbl .= '<td class="text-center">'
            . '<a class="btn btn-sm btn-danger" href="javascript:void(0);"
            onclick="removeTableRow($(\'#details_table\'),this,this.id)">
                <i class="fa fa-times"></i>
           </a>'
            . '</td>';

        $tbl .= '</tr>';

        $tbl .= '</tbody></table>';

        echo CJSON::encode(['status' => 'success', 'tbl' => $tbl]);
        Yii::app()->end();
    }


    /*end*/
}
