<?php

class QuotationcloseController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','GetQuotationcloseList','SaveQuotationclose','Delete', 'Disable'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['masters_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['mas_quotation_close_reason_view']) &&
            Yii::app()->user->havePermissionOn['masters_menu_view'] && 
            Yii::app()->user->havePermissionOn['mas_quotation_close_reason_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->render('/site/unauthorised');
        Yii::app()->end(); // Prevent further execution
    }
    }

    public function actionCreate()
    {
        $model=new MasQuotationCloseReason();
        $id = (int) Yii::app()->request->getParam('id');
        if($id>0){
            $model=$model->findByPk($id);
        }
     Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);   
    $this->render('create', array('model' => $model), false, true);
    }

    public function actionGetQuotationcloseList()
        {
            
                $model=new MasQuotationCloseReason();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'t.id',
                   1 =>'reason',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                // $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (reason LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                
                
                foreach ($model as $row)
                {
                    $div = '';
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_quotation_close_reason_edit"])){
                        $div .=   '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'quotationclose/create&id='.$row['id'].'\',\'Edit Quotation Close\')"><i class="fa fa-pencil"></i></button> ';
                    }
                    if(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["mas_quotation_close_reason_delete"])){
                  //      $div .=  ' <a href ="#" onclick="deleteQuotationclose('.$row['id'].')"><button class="btn btn-danger btn-xs"><i class="fa fa-trash-o "></i></button></a>';
                    }
                    $rowData[]=array($m,
                        $row['reason'],
                        $row['isDefault'],
                        array('id' => $row['id'],'code'=>$row['reason'], 'status' => $row->isActive));
                    $m++;
                    
                }
//                foreach ($model as $row)
//                {
//                    $rowData[]=array($m,$row['reason'],
//              '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'quotationclose/create&id='.$row['id'].'\',\'Edit Quotation Close\')"><i class="fa fa-pencil"></i></button> '
//             .'<a href ="#" onclick="deleteQuotationclose('.$row['id'].')"><button class="btn btn-danger btn-xs"><i class="fa fa-trash-o "></i></button></a>');
//               $m++;
//                }
                $data['data'] = $rowData;
                echo json_encode($data);
      
    }
    public function actionSaveQuotationclose()
    {
    $model = new MasQuotationCloseReason();
        if (isset($_POST['MasQuotationCloseReason']))
        {
            
            if ((int) @$_POST['MasQuotationCloseReason']['id'] > 0)
            {
                $id= (int) @$_POST['MasQuotationCloseReason']['id'];
                $model=$model->findByPk($id);
                $audit_type = 'UPDATED';   
            }else{
                $audit_type = 'CREATED';
            }
            if($_POST['UnMasQuotationCloseReasonit']['isDefault'] == "Y"){
                MasQuotationCloseReason::model()->updateAll(array( 'isDefault' => 'N' ), 'isDefault = "Y"' );
            }
            $model->isDefault = $_POST['MasQuotationCloseReason']['isDefault'];
            $model->attributes=$_POST['MasQuotationCloseReason'];
            if($model->save())
            {
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'QUOTATION_CLOSE_REASONS',
                    Yii::app()->user->id,
                    $audit_type,
                    " with reason : - {$model->reason}"
                );
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['quotationclose-form'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            }
            else
            {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
            echo $error;
            }
        }
    }
    public function actionDelete()
    {
        $id = $_POST['id'];
        $model=new MasQuotationCloseReason();
        $del = $model->findByPk($id);
        $model->deleteByPk($id);
        // inserting to audit log
        AuditLog::saveAuditLogs(
            'PROBABILITIES',
            Yii::app()->user->id,
            'DELETED',
            " with reason : - {$del->reason} "
        );
        // end audit log
        echo "success";
    }
        public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasQuotationCloseReason();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}